/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.sort;

import net.sf.saxon.expr.ErrorIterator;
import net.sf.saxon.expr.LastPositionFinder;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.LookaheadIterator;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.sort.AtomicComparer;
import net.sf.saxon.sort.GenericSorter;
import net.sf.saxon.sort.SortKeyEvaluator;
import net.sf.saxon.sort.Sortable;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.AtomicValue;

public class SortedIterator
implements SequenceIterator,
LastPositionFinder,
LookaheadIterator,
Sortable {
    protected SequenceIterator base;
    protected SortKeyEvaluator sortKeyEvaluator;
    protected AtomicComparer[] comparators;
    protected int recordSize;
    protected Object[] nodeKeys;
    protected int count = -1;
    protected int position = 0;
    protected XPathContext context;
    private int hostLanguage;

    private SortedIterator() {
    }

    public SortedIterator(XPathContext xPathContext, SequenceIterator sequenceIterator, SortKeyEvaluator sortKeyEvaluator, AtomicComparer[] atomicComparerArray) {
        this.context = xPathContext.newMinorContext();
        this.context.setOriginatingConstructType(2061);
        this.context.setCurrentIterator(sequenceIterator);
        this.base = sequenceIterator;
        this.sortKeyEvaluator = sortKeyEvaluator;
        this.comparators = atomicComparerArray;
        this.recordSize = atomicComparerArray.length + 2;
    }

    public void setHostLanguage(int n) {
        this.hostLanguage = n;
    }

    public boolean hasNext() {
        if (this.position < 0) {
            return false;
        }
        if (this.count < 0) {
            if (this.base instanceof LookaheadIterator) {
                return ((LookaheadIterator)this.base).hasNext();
            }
            try {
                this.doSort();
                return this.count > 0;
            }
            catch (XPathException xPathException) {
                this.count = -1;
                this.base = new ErrorIterator(xPathException);
                return true;
            }
        }
        return this.position < this.count;
    }

    public Item next() throws XPathException {
        if (this.position < 0) {
            return null;
        }
        if (this.count < 0) {
            this.doSort();
        }
        if (this.position < this.count) {
            return (Item)this.nodeKeys[this.position++ * this.recordSize];
        }
        this.position = -1;
        return null;
    }

    public Item current() {
        if (this.position < 1) {
            return null;
        }
        return (Item)this.nodeKeys[(this.position - 1) * this.recordSize];
    }

    public int position() {
        return this.position;
    }

    public int getLastPosition() throws XPathException {
        if (this.count < 0) {
            this.doSort();
        }
        return this.count;
    }

    public SequenceIterator getAnother() throws XPathException {
        if (this.count < 0) {
            this.doSort();
        }
        SortedIterator sortedIterator = new SortedIterator();
        sortedIterator.base = this.base.getAnother();
        sortedIterator.sortKeyEvaluator = this.sortKeyEvaluator;
        sortedIterator.comparators = this.comparators;
        sortedIterator.recordSize = this.recordSize;
        sortedIterator.nodeKeys = this.nodeKeys;
        sortedIterator.count = this.count;
        sortedIterator.context = this.context;
        sortedIterator.position = 0;
        return sortedIterator;
    }

    public int getProperties() {
        return 2;
    }

    protected void buildArray() throws XPathException {
        Object[] objectArray;
        int n = (this.base.getProperties() & 2) != 0 ? ((LastPositionFinder)this.base).getLastPosition() : 100;
        this.nodeKeys = new Object[n * this.recordSize];
        this.count = 0;
        while ((objectArray = this.base.next()) != null) {
            if (this.count == n) {
                Object[] objectArray2 = new Object[(n *= 2) * this.recordSize];
                System.arraycopy(this.nodeKeys, 0, objectArray2, 0, this.count * this.recordSize);
                this.nodeKeys = objectArray2;
            }
            int n2 = this.count * this.recordSize;
            this.nodeKeys[n2] = objectArray;
            for (int i = 0; i < this.comparators.length; ++i) {
                this.nodeKeys[n2 + i + 1] = this.sortKeyEvaluator.evaluateSortKey(i, this.context);
            }
            this.nodeKeys[n2 + this.comparators.length + 1] = new Integer(this.count);
            ++this.count;
        }
        if (n * 2 < this.count || n - this.count > 2000) {
            objectArray = new Object[this.count * this.recordSize];
            System.arraycopy(this.nodeKeys, 0, objectArray, 0, this.count * this.recordSize);
            this.nodeKeys = objectArray;
        }
    }

    private void doSort() throws XPathException {
        this.buildArray();
        if (this.count < 2) {
            return;
        }
        try {
            GenericSorter.quickSort(0, this.count, this);
        }
        catch (ClassCastException classCastException) {
            DynamicError dynamicError = new DynamicError("Non-comparable types found while sorting: " + classCastException.getMessage());
            if (this.hostLanguage == 50) {
                dynamicError.setErrorCode("XTDE1030");
            } else {
                dynamicError.setErrorCode("XPTY0004");
            }
            throw dynamicError;
        }
    }

    public int compare(int n, int n2) {
        int n3 = n * this.recordSize + 1;
        int n4 = n2 * this.recordSize + 1;
        for (int i = 0; i < this.comparators.length; ++i) {
            int n5 = this.comparators[i].compareAtomicValues((AtomicValue)this.nodeKeys[n3 + i], (AtomicValue)this.nodeKeys[n4 + i]);
            if (n5 == 0) continue;
            return n5;
        }
        return (Integer)this.nodeKeys[n3 + this.comparators.length] - (Integer)this.nodeKeys[n4 + this.comparators.length];
    }

    public void swap(int n, int n2) {
        int n3 = n * this.recordSize;
        int n4 = n2 * this.recordSize;
        for (int i = 0; i < this.recordSize; ++i) {
            Object object = this.nodeKeys[n3 + i];
            this.nodeKeys[n3 + i] = this.nodeKeys[n4 + i];
            this.nodeKeys[n4 + i] = object;
        }
    }
}

