/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.instruct.NextMatch;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.XSLFallback;
import net.sf.saxon.style.XSLWithParam;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.Whitespace;

public class XSLNextMatch
extends StyleElement {
    public boolean isInstruction() {
        return true;
    }

    public boolean mayContainFallback() {
        return true;
    }

    public void prepareAttributes() throws XPathException {
        AttributeCollection attributeCollection = this.getAttributeList();
        for (int i = 0; i < attributeCollection.getLength(); ++i) {
            int n = attributeCollection.getNameCode(i);
            this.checkUnknownAttribute(n);
        }
    }

    public void validate() throws XPathException {
        NodeInfo nodeInfo;
        AxisIterator axisIterator = this.iterateAxis((byte)3);
        while ((nodeInfo = (NodeInfo)axisIterator.next()) != null) {
            if (nodeInfo instanceof XSLWithParam || nodeInfo instanceof XSLFallback) continue;
            if (nodeInfo.getNodeKind() == 3) {
                if (Whitespace.isWhite(nodeInfo.getStringValueCS())) continue;
                this.compileError("No character data is allowed within xsl:next-match", "XTSE0010");
                continue;
            }
            this.compileError("Child element " + nodeInfo.getDisplayName() + " is not allowed within xsl:next-match", "XTSE0010");
        }
    }

    public Expression compile(Executable executable) throws XPathException {
        NextMatch nextMatch = new NextMatch(this.backwardsCompatibleModeIsEnabled());
        nextMatch.setActualParameters(this.getWithParamInstructions(executable, false, nextMatch), this.getWithParamInstructions(executable, true, nextMatch));
        ExpressionTool.makeParentReferences(nextMatch);
        return nextMatch;
    }
}

