/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.trace;

import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.trace.InstructionInfo;
import net.sf.saxon.trace.TraceListener;

public class TimedTraceListener
implements TraceListener {
    public void open() {
        System.err.println("<trace time=\"" + System.currentTimeMillis() + "\">");
    }

    public void close() {
        System.err.println("<end time=\"" + System.currentTimeMillis() + "\"/></trace>");
    }

    public void enter(InstructionInfo instructionInfo, XPathContext xPathContext) {
        int n = instructionInfo.getConstructType();
        if (n == 149 || n == 181) {
            String string;
            String string2 = "<";
            string2 = string2 + (n == 149 ? "function" : "template");
            String string3 = null;
            if (instructionInfo.getObjectNameCode() != -1) {
                string3 = xPathContext.getNamePool().getDisplayName(instructionInfo.getObjectNameCode());
            } else if (instructionInfo.getProperty("name") != null) {
                string3 = instructionInfo.getProperty("name").toString();
            }
            if (string3 != null) {
                string2 = string2 + " name=\"" + string3 + "\"";
            }
            if (instructionInfo.getProperty("match") != null) {
                string2 = string2 + " match=\"" + instructionInfo.getProperty("match") + "\"";
            }
            if ((string = instructionInfo.getSystemId()) != null) {
                if (string.length() > 15) {
                    string = "*" + string.substring(string.length() - 14);
                }
                string2 = string2 + " file=\"" + string + "\"";
            }
            string2 = string2 + " line=\"" + instructionInfo.getLineNumber() + "\"";
            string2 = string2 + " time=\"" + System.currentTimeMillis() + "\"";
            string2 = string2 + ">";
            System.err.println(string2);
        }
    }

    public void leave(InstructionInfo instructionInfo) {
        int n = instructionInfo.getConstructType();
        if (n == 149 || n == 181) {
            String string = "<end time=\"" + System.currentTimeMillis() + "\"/></";
            string = string + (n == 149 ? "function>" : "template>");
            System.err.println(string);
        }
    }

    public void startCurrentItem(Item item) {
    }

    public void endCurrentItem(Item item) {
    }
}

