/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.examples.tokenizer;

import java.text.BreakIterator;
import java.text.ParsePosition;
import java.util.Locale;
import org.apache.uima.analysis_component.JCasAnnotator_ImplBase;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.examples.tokenizer.Sentence;
import org.apache.uima.examples.tokenizer.Token;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;

public class SimpleTokenAndSentenceAnnotator
extends JCasAnnotator_ImplBase {
    JCas jcas;
    String input;
    ParsePosition pp = new ParsePosition(0);
    static final BreakIterator sentenceBreak = BreakIterator.getSentenceInstance(Locale.US);
    static final BreakIterator wordBreak = BreakIterator.getWordInstance(Locale.US);
    static final Maker sentenceAnnotationMaker = new Maker(){

        @Override
        Annotation newAnnotation(JCas jcas, int start, int end) {
            return new Sentence(jcas, start, end);
        }
    };
    static final Maker tokenAnnotationMaker = new Maker(){

        @Override
        Annotation newAnnotation(JCas jcas, int start, int end) {
            return new Token(jcas, start, end);
        }
    };

    public void process(JCas aJCas) throws AnalysisEngineProcessException {
        this.jcas = aJCas;
        this.input = this.jcas.getDocumentText();
        this.makeAnnotations(sentenceAnnotationMaker, sentenceBreak);
        this.makeAnnotations(tokenAnnotationMaker, wordBreak);
    }

    void makeAnnotations(Maker m, BreakIterator b) {
        b.setText(this.input);
        int end = b.next();
        int start = b.first();
        while (end != -1) {
            boolean isWhitespace = true;
            for (int i = start; i < end; ++i) {
                if (Character.isWhitespace(this.input.charAt(i))) continue;
                isWhitespace = false;
                break;
            }
            if (!isWhitespace) {
                m.newAnnotation(this.jcas, start, end).addToIndexes();
            }
            start = end;
            end = b.next();
        }
    }

    static abstract class Maker {
        Maker() {
        }

        abstract Annotation newAnnotation(JCas var1, int var2, int var3);
    }
}

