/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.store.kahadb.disk.index;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Map;
import java.util.TreeMap;
import org.apache.activemq.store.kahadb.disk.index.HashIndex;
import org.apache.activemq.store.kahadb.disk.page.Page;
import org.apache.activemq.store.kahadb.disk.page.Transaction;
import org.apache.activemq.store.kahadb.disk.util.VariableMarshaller;

class HashBin<Key, Value> {
    private Page<HashBin<Key, Value>> page;
    private TreeMap<Key, Value> data = new TreeMap();

    HashBin() {
    }

    public int size() {
        return this.data.size();
    }

    public Value put(Key key, Value value) throws IOException {
        return this.data.put(key, value);
    }

    public Value get(Key key) throws IOException {
        return this.data.get(key);
    }

    public boolean containsKey(Key key) throws IOException {
        return this.data.containsKey(key);
    }

    public Map<Key, Value> getAll(Transaction tx) throws IOException {
        return this.data;
    }

    public Value remove(Key key) throws IOException {
        return this.data.remove(key);
    }

    public Page<HashBin<Key, Value>> getPage() {
        return this.page;
    }

    public void setPage(Page<HashBin<Key, Value>> page) {
        this.page = page;
        this.page.set(this);
    }

    public static class Marshaller<Key, Value>
    extends VariableMarshaller<HashBin<Key, Value>> {
        private final HashIndex<Key, Value> hashIndex;

        public Marshaller(HashIndex<Key, Value> index) {
            this.hashIndex = index;
        }

        @Override
        public HashBin<Key, Value> readPayload(DataInput is) throws IOException {
            HashBin bin = new HashBin();
            int size = is.readInt();
            for (int i = 0; i < size; ++i) {
                Key key = this.hashIndex.getKeyMarshaller().readPayload(is);
                Value value = this.hashIndex.getValueMarshaller().readPayload(is);
                bin.data.put(key, value);
            }
            return bin;
        }

        @Override
        public void writePayload(HashBin<Key, Value> bin, DataOutput os) throws IOException {
            os.writeInt(((HashBin)bin).data.size());
            for (Map.Entry entry : ((HashBin)bin).data.entrySet()) {
                this.hashIndex.getKeyMarshaller().writePayload(entry.getKey(), os);
                this.hashIndex.getValueMarshaller().writePayload(entry.getValue(), os);
            }
        }
    }
}

