/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.cas.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.cas.impl.TypeSystemImpl;

public class TypeImpl
implements Type,
Comparable<TypeImpl> {
    private final String name;
    private final int code;
    private final TypeSystemImpl ts;
    private boolean isFeatureFinal;
    private boolean isInheritanceFinal;

    TypeImpl(String name, int code, TypeSystemImpl ts) {
        this.name = name;
        this.code = code;
        this.ts = ts;
        this.isInheritanceFinal = false;
        this.isFeatureFinal = false;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public Type getSuperType() {
        return this.ts.ll_getTypeForCode(this.ts.ll_getParentType(this.code));
    }

    public String toString() {
        return this.getName();
    }

    @Override
    @Deprecated
    public Vector<Feature> getAppropriateFeatures() {
        return new Vector<Feature>(this.getFeatures());
    }

    @Override
    public int getNumberOfFeatures() {
        return this.ts.ll_getAppropriateFeatures(this.code).length;
    }

    public boolean isAnnotationType() {
        return false;
    }

    public TypeSystem getTypeSystem() {
        return this.ts;
    }

    public int getCode() {
        return this.code;
    }

    @Override
    public int compareTo(TypeImpl t) {
        if (this == t) {
            return 0;
        }
        return this.code < t.code ? -1 : 1;
    }

    @Override
    public Feature getFeatureByBaseName(String featureName) {
        return this.ts.getFeatureByFullName(this.name + ':' + featureName);
    }

    @Override
    public String getShortName() {
        int pos = this.name.lastIndexOf(46);
        if (pos >= 0) {
            return this.name.substring(pos + 1, this.name.length());
        }
        return this.name;
    }

    @Override
    public boolean isPrimitive() {
        return !this.getTypeSystem().getLowLevelTypeSystem().ll_isRefType(this.code);
    }

    @Override
    public boolean isFeatureFinal() {
        return this.isFeatureFinal;
    }

    @Override
    public boolean isInheritanceFinal() {
        return this.isInheritanceFinal;
    }

    void setFeatureFinal() {
        this.isFeatureFinal = true;
    }

    void setInheritanceFinal() {
        this.isInheritanceFinal = true;
    }

    @Deprecated
    public Feature getFeature(String featureName) {
        return this.getFeatureByBaseName(featureName);
    }

    @Override
    public List<Feature> getFeatures() {
        int[] feats = this.ts.ll_getAppropriateFeatures(this.code);
        ArrayList<Feature> list = new ArrayList<Feature>(feats.length);
        for (int i = 0; i < feats.length; ++i) {
            list.add(this.ts.ll_getFeatureForCode(feats[i]));
        }
        return list;
    }

    @Override
    public boolean isArray() {
        return this.ts.ll_isArrayType(this.code);
    }

    @Override
    public Type getComponentType() {
        if (!this.isArray()) {
            return null;
        }
        return this.ts.ll_getTypeForCode(this.ts.ll_getComponentType(this.code));
    }
}

