/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.caseditor.editor;

import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import org.apache.uima.caseditor.core.model.DefaultColors;
import org.eclipse.jface.preference.IPreferenceStore;

public final class AnnotationStyle {
    public static final Style DEFAULT_STYLE = Style.SQUIGGLES;
    public static final Color DEFAULT_COLOR = new Color(255, 0, 0);
    public static final int DEFAULT_LAYER = 0;
    private final String annotation;
    private final Style style;
    private final Color color;
    private final int layer;
    private final String configuration;

    public AnnotationStyle(String annotation, Style style, Color color, int layer, String configuration) {
        if (annotation == null || style == null || color == null) {
            throw new IllegalArgumentException("parameters must be not null!");
        }
        this.annotation = annotation;
        this.style = style;
        this.color = color;
        if (layer < 0) {
            throw new IllegalArgumentException("layer must be a positive or zero");
        }
        this.layer = layer;
        this.configuration = configuration;
    }

    public AnnotationStyle(String annotation, Style style, Color color, int layer) {
        this(annotation, style, color, layer, null);
    }

    public String getAnnotation() {
        return this.annotation;
    }

    public Style getStyle() {
        return this.style;
    }

    public Color getColor() {
        return this.color;
    }

    public int getLayer() {
        return this.layer;
    }

    public String getConfiguration() {
        return this.configuration;
    }

    public boolean equals(Object object) {
        boolean isEqual;
        if (object == this) {
            isEqual = true;
        } else if (object instanceof AnnotationStyle) {
            AnnotationStyle style = (AnnotationStyle)object;
            boolean isConfigEqual = this.configuration == style.configuration || this.configuration == null && this.configuration.equals(style.configuration);
            isEqual = this.annotation.equals(style.annotation) && this.style.equals((Object)style.style) && this.color.equals(style.color) && this.layer == style.layer && isConfigEqual;
        } else {
            isEqual = false;
        }
        return isEqual;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        String annotationStyle = "Type: " + this.annotation;
        annotationStyle = annotationStyle + " Style: " + this.getStyle().name();
        annotationStyle = annotationStyle + " Color: " + this.getColor().toString();
        annotationStyle = annotationStyle + " Layer: " + this.getLayer();
        annotationStyle = annotationStyle + " Config: " + this.getConfiguration();
        return annotationStyle;
    }

    private static String serializeProperties(Map<String, String> properties) {
        StringBuilder configString = new StringBuilder();
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            configString.append(entry.getKey().trim());
            configString.append("=");
            configString.append(entry.getValue().trim());
            configString.append(";");
        }
        return configString.toString();
    }

    private static Map<String, String> parseProperties(String line) {
        String[] keyValueStrings;
        HashMap<String, String> properties = new HashMap<String, String>();
        for (String keyValueString : keyValueStrings = line.split(";")) {
            String[] keyValuePair = keyValueString.split("=");
            if (keyValuePair.length != 2) continue;
            properties.put(keyValuePair[0], keyValuePair[1]);
        }
        return properties;
    }

    public static void putAnnotatationStyleToStore(IPreferenceStore store, AnnotationStyle style) {
        Color color = new Color(style.getColor().getRed(), style.getColor().getGreen(), style.getColor().getBlue());
        HashMap<String, String> styleProperties = new HashMap<String, String>();
        styleProperties.put("color", Integer.toString(color.getRGB()));
        styleProperties.put("strategy", style.getStyle().toString());
        styleProperties.put("layer", Integer.toString(style.getLayer()));
        if (style.getConfiguration() != null) {
            styleProperties.put("config", style.getConfiguration());
        }
        store.setValue(style.getAnnotation() + ".style", AnnotationStyle.serializeProperties(styleProperties));
    }

    public static AnnotationStyle getAnnotationStyleFromStore(IPreferenceStore store, String typeName) {
        String configuration;
        String colorString;
        Map<String, String> styleProperties = AnnotationStyle.parseProperties(store.getString(typeName + ".style"));
        Style style = Style.BACKGROUND;
        int index = (int)Math.round(Math.random() * (double)(DefaultColors.COLORS.length - 1));
        Color color = DefaultColors.COLORS[index];
        String styleString = styleProperties.get("strategy");
        if (styleString != null && styleString.length() != 0) {
            try {
                style = Style.valueOf(styleString);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if ((colorString = styleProperties.get("color")) != null && colorString.length() != 0) {
            try {
                int colorInteger = Integer.parseInt(colorString);
                color = new Color(colorInteger);
            }
            catch (NumberFormatException colorInteger) {
                // empty catch block
            }
        }
        int layer = 0;
        String layerString = styleProperties.get("layer");
        if (layerString != null && layerString.length() != 0) {
            try {
                layer = Integer.parseInt(layerString);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if ((configuration = styleProperties.get("config")) != null && configuration.length() != 0) {
            configuration = null;
        }
        AnnotationStyle annotationStyle = new AnnotationStyle(typeName, style, color, layer, configuration);
        if (styleProperties == null || styleProperties.isEmpty()) {
            AnnotationStyle.putAnnotatationStyleToStore(store, annotationStyle);
        }
        return annotationStyle;
    }

    public static enum Style {
        BACKGROUND,
        TEXT_COLOR,
        TOKEN,
        SQUIGGLES,
        BOX,
        UNDERLINE,
        BRACKET,
        TAG;

    }
}

