/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.jmx;

import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import java.util.Map;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;
import org.eclipse.jetty.util.HostPort;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.ShutdownThread;

public class ConnectorServer
extends AbstractLifeCycle {
    private static final Logger LOG = Log.getLogger(ConnectorServer.class);
    JMXConnectorServer _connectorServer;
    Registry _registry;

    public ConnectorServer(JMXServiceURL serviceURL, String name) throws Exception {
        this(serviceURL, null, name);
    }

    public ConnectorServer(JMXServiceURL svcUrl, Map<String, ?> environment, String name) throws Exception {
        String hostPort;
        String regHostPort;
        String urlPath = svcUrl.getURLPath();
        int idx = urlPath.indexOf("rmi://");
        if (idx > 0 && (regHostPort = this.startRegistry(hostPort = urlPath.substring(idx + 6, urlPath.indexOf(47, idx + 6)))) != null) {
            urlPath = urlPath.replace(hostPort, regHostPort);
            svcUrl = new JMXServiceURL(svcUrl.getProtocol(), svcUrl.getHost(), svcUrl.getPort(), urlPath);
        }
        MBeanServer mbeanServer = ManagementFactory.getPlatformMBeanServer();
        this._connectorServer = JMXConnectorServerFactory.newJMXConnectorServer(svcUrl, environment, mbeanServer);
        mbeanServer.registerMBean(this._connectorServer, new ObjectName(name));
    }

    @Override
    public void doStart() throws Exception {
        this._connectorServer.start();
        ShutdownThread.register(0, this);
        LOG.info("JMX Remote URL: {}", this._connectorServer.getAddress().toString());
    }

    @Override
    public void doStop() throws Exception {
        ShutdownThread.deregister(this);
        this._connectorServer.stop();
        this.stopRegistry();
    }

    private String startRegistry(String hostPath) throws Exception {
        HostPort hostPort = new HostPort(hostPath);
        String rmiHost = hostPort.getHost();
        int rmiPort = hostPort.getPort(1099);
        InetAddress hostAddress = InetAddress.getByName(rmiHost);
        if (hostAddress.isLoopbackAddress()) {
            if (rmiPort == 0) {
                ServerSocket socket = new ServerSocket(0);
                rmiPort = socket.getLocalPort();
                socket.close();
            } else {
                try {
                    LocateRegistry.getRegistry(rmiPort).list();
                    return null;
                }
                catch (Exception ex) {
                    LOG.ignore(ex);
                }
            }
            this._registry = LocateRegistry.createRegistry(rmiPort);
            Thread.sleep(1000L);
            rmiHost = HostPort.normalizeHost(InetAddress.getLocalHost().getCanonicalHostName());
            return rmiHost + ':' + Integer.toString(rmiPort);
        }
        return null;
    }

    private void stopRegistry() {
        if (this._registry != null) {
            try {
                UnicastRemoteObject.unexportObject(this._registry, true);
            }
            catch (Exception ex) {
                LOG.ignore(ex);
            }
        }
    }
}

