/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.rewrite.handler;

import java.io.IOException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.rewrite.handler.PatternRule;

public class CookiePatternRule
extends PatternRule {
    private String _name;
    private String _value;

    public CookiePatternRule() {
        this._handling = false;
        this._terminating = false;
    }

    public void setName(String name) {
        this._name = name;
    }

    public void setValue(String value) {
        this._value = value;
    }

    @Override
    public String apply(String target, HttpServletRequest request, HttpServletResponse response) throws IOException {
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!this._name.equals(cookie.getName()) || !this._value.equals(cookie.getValue())) continue;
                return target;
            }
        }
        response.addCookie(new Cookie(this._name, this._value));
        return target;
    }

    @Override
    public String toString() {
        return super.toString() + "[" + this._name + "," + this._value + "]";
    }
}

