/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.servlets.gzip;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.Deflater;

public class DeflatedOutputStream
extends FilterOutputStream {
    protected final Deflater _def;
    protected final byte[] _buf;
    protected boolean closed = false;

    public DeflatedOutputStream(OutputStream out, Deflater deflater, byte[] buffer) {
        super(out);
        this._def = deflater;
        this._buf = buffer;
    }

    @Override
    public void write(int b) throws IOException {
        byte[] buf = new byte[]{(byte)(b & 0xFF)};
        this.write(buf, 0, 1);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this._def.finished()) {
            throw new IOException("Stream already finished");
        }
        if ((off | len | off + len | b.length - (off + len)) < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        if (!this._def.finished()) {
            this._def.setInput(b, off, len);
            while (!this._def.needsInput()) {
                this.deflate();
            }
        }
    }

    private void deflate() throws IOException {
        int len = this._def.deflate(this._buf, 0, this._buf.length);
        if (len > 0) {
            this.out.write(this._buf, 0, len);
        }
    }

    public synchronized void finish() throws IOException {
        if (!this._def.finished()) {
            this._def.finish();
            while (!this._def.finished()) {
                this.deflate();
            }
        }
    }

    @Override
    public synchronized void close() throws IOException {
        if (!this.closed) {
            this.finish();
            this.out.close();
            this.closed = true;
        }
    }
}

