/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.spdy.client;

import java.io.IOException;
import java.util.Map;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.ClientConnectionFactory;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.spdy.FlowControlStrategy;
import org.eclipse.jetty.spdy.StandardCompressionFactory;
import org.eclipse.jetty.spdy.StandardSession;
import org.eclipse.jetty.spdy.api.SessionFrameListener;
import org.eclipse.jetty.spdy.client.SPDYClient;
import org.eclipse.jetty.spdy.client.SPDYConnection;
import org.eclipse.jetty.spdy.generator.Generator;
import org.eclipse.jetty.spdy.parser.Parser;
import org.eclipse.jetty.util.Promise;

public class SPDYClientConnectionFactory
implements ClientConnectionFactory {
    public static final String SPDY_CLIENT_CONTEXT_KEY = "spdy.client";
    public static final String SPDY_SESSION_LISTENER_CONTEXT_KEY = "spdy.session.listener";
    public static final String SPDY_SESSION_PROMISE_CONTEXT_KEY = "spdy.session.promise";

    @Override
    public Connection newConnection(EndPoint endPoint, Map<String, Object> context) throws IOException {
        SPDYClient client = (SPDYClient)context.get(SPDY_CLIENT_CONTEXT_KEY);
        SPDYClient.Factory factory = client.getFactory();
        ByteBufferPool byteBufferPool = factory.getByteBufferPool();
        StandardCompressionFactory compressionFactory = new StandardCompressionFactory();
        Parser parser = new Parser(compressionFactory.newDecompressor());
        Generator generator = new Generator(byteBufferPool, compressionFactory.newCompressor());
        ClientSPDYConnection connection = new ClientSPDYConnection(endPoint, byteBufferPool, parser, factory, client.isDispatchIO());
        FlowControlStrategy flowControlStrategy = client.newFlowControlStrategy();
        SessionFrameListener listener = (SessionFrameListener)context.get(SPDY_SESSION_LISTENER_CONTEXT_KEY);
        StandardSession session = new StandardSession(client.getVersion(), byteBufferPool, factory.getScheduler(), connection, endPoint, connection, 1, listener, generator, flowControlStrategy);
        session.setWindowSize(client.getInitialWindowSize());
        parser.addListener(session);
        connection.setSession(session);
        Promise promise = (Promise)context.get(SPDY_SESSION_PROMISE_CONTEXT_KEY);
        promise.succeeded(session);
        return connection;
    }

    private class ClientSPDYConnection
    extends SPDYConnection {
        private final SPDYClient.Factory factory;

        public ClientSPDYConnection(EndPoint endPoint, ByteBufferPool bufferPool, Parser parser, SPDYClient.Factory factory, boolean dispatchIO) {
            super(endPoint, bufferPool, parser, factory.getExecutor(), dispatchIO);
            this.factory = factory;
        }

        @Override
        public void onOpen() {
            super.onOpen();
            this.factory.sessionOpened(this.getSession());
        }

        @Override
        public void onClose() {
            super.onClose();
            this.factory.sessionClosed(this.getSession());
        }
    }
}

