/*
 * Decompiled with CFR 0.152.
 */
package javax.servlet;

import javax.servlet.annotation.MultipartConfig;

public class MultipartConfigElement {
    private final int fileSizeThreshold;
    private final String location;
    private final long maxFileSize;
    private final long maxRequestSize;

    public MultipartConfigElement(String location) {
        this.location = location == null ? "" : location;
        this.fileSizeThreshold = 0;
        this.maxFileSize = -1L;
        this.maxRequestSize = -1L;
    }

    public MultipartConfigElement(MultipartConfig config) {
        this.location = config.location();
        this.fileSizeThreshold = config.fileSizeThreshold();
        this.maxFileSize = config.maxFileSize();
        this.maxRequestSize = config.maxRequestSize();
    }

    public MultipartConfigElement(String location, long maxFileSize, long maxRequestSize, int fileSizeThreshold) {
        this.fileSizeThreshold = fileSizeThreshold;
        this.location = location;
        this.maxFileSize = maxFileSize;
        this.maxRequestSize = maxRequestSize;
    }

    public int getFileSizeThreshold() {
        return this.fileSizeThreshold;
    }

    public String getLocation() {
        return this.location;
    }

    public long getMaxFileSize() {
        return this.maxFileSize;
    }

    public long getMaxRequestSize() {
        return this.maxRequestSize;
    }
}

