package Units;

require Exporter;

$VERSION = 0.01;
@ISA = Exporter;
@EXPORT = qw(convert);

%factors = ( pt => 25.4/72, in => 25.4, pi => 25.4/12, mm => 1, cm => 10, 'm', 1000 );

=head1 NAME

units - a unit convertor

=head1 DESCRIPTION

converts values between  system of units

=cut

sub convert
{
    my $factor = $factors{shift @_};

    return unless defined $factor && $factor;
    
    my @result;
    foreach (@_)
    {
        /(.*?)([A-Za-z'"]+)\s*$/;
        my $result = $factor * $1 / $factors{$2};
        push @result, ($factor * $1 / $factors{$2});
    }
    
    return wantarray ? @result : $result[0];
}

1;
