NAME
    RISCOS::JPEG --perl interface to RISC OS JPEG SWIs.

SYNOPSIS
        use RISCOS::JPEG 'jpeg_info';
        ($width, $height, $xdpi, $ydpi, $bw, $no_trans, $ratio) = jpeg_info $jpeg;


DESCRIPTION
    This module provides a perl interface to RISC OS JPEG SWIs.

    jpeg_info <JPEG> [,<DPI>]
        returns an array of `($width, $height, $xdpi, $ydpi, $bw,
        $no_trans, $ratio)' for the JPEG contained in the scalar
        passed. `$width' and `$height' are in pixels, `$xdpi' and
        `$ydpi' are absolute Dots Per Inch if `$ratio' is false. If
        `$ratio' is true and *DPI* is defined then it is returned as
        the X DPI, and the returned Y DPI is at the correct ratio.
        `$bw' is true if the JPEG is greyscale, `$no_trans' is true
        if transformed plots are unavailable.

    jpeg_size <JPEG> [,<DPI>]
        returns `($width, $height)' in Draw units of the JPEG.


BUGS
    Not tested enough.

AUTHOR
    Nicholas Clark <nick@unfortu.net>

