#	Grob G103 Nasal Code
# TODO aircraft.livery.init("Aircraft/G103/Models/Liveries");


#		G-Force Meter
# Script for recording the minimum / maximum G forces seen by the

var GCurrent = props.globals.initNode("/accelerations/pilot-g", 1.0, "DOUBLE");
var GMin = props.globals.initNode("/accelerations/pilot-gmin", 1.0, "DOUBLE");
var GMax = props.globals.initNode("/accelerations/pilot-gmax", 1.0, "DOUBLE");

gmeterUpdate = func {
	var current_val = GCurrent.getDoubleValue();
	if( current_val < GMin.getDoubleValue() ){
		GMin.setDoubleValue( math.max( current_val, -6 ) );
	} elsif( current_val > GMax.getDoubleValue() ){
		GMax.setDoubleValue( math.min( current_val, 10 ) );
	}
}

var gmeterTimer = maketimer( 0.0, gmeterUpdate );
gmeterTimer.simulatedTime = 1;
gmeterTimer.start();

# Vibrating yaw string
io.include("Aircraft/Generic/soaring-instrumentation-sdk.nas");

var yawstring = YawString.new(
	on_update: update_prop("instrumentation/yawstring"));

var string_instrument = Instrument.new(
	components: [yawstring],
	enable: 1);

