
#	Magnetos

var magneto_settings = [ [ 0, 0 ], [ 1, 0 ], [ 0, 1 ], [ 1, 1 ] ];
stepMagnetos = func(change) {
	if (!change)	return;
	for( var i = 0; i <= 1; i += 1 ){
		var x = math.clamp( getprop("/controls/engines/engine["~ i ~"]/magnetos") + change, 0, 3 );
		setprop("/controls/engines/engine["~ i ~"]/magneto[0]", magneto_settings[ x ][ 0 ] );
		setprop("/controls/engines/engine["~ i ~"]/magneto[1]", magneto_settings[ x ][ 1 ] );
	}
}


#	Flaps
var flaps_cmd = 0;
var flaps_volts = props.globals.getNode("/systems/electrical/outputs/flaps", 1);
var flaps_fcs = props.globals.getNode("/controls/flight/flaps", 1);
var use_tooltip = props.globals.getNode("/sim/settings/use-flaps-tooltip", 1);

var delta_time	= props.globals.getNode("sim/time/delta-sec", 1);

var flaps_loop = func {
	if( flaps_cmd == 0 or flaps_volts.getDoubleValue() < 8 ) {
		flaps_timer.stop();
		return;
	}
	flaps_fcs.setDoubleValue( math.clamp( flaps_fcs.getDoubleValue() + flaps_cmd * 0.2 * delta_time.getDoubleValue(), 0.0, 1.0 ) );
	if( flaps_fcs.getDoubleValue() == 0.0 ){
		flaps_cmd = 0;
	}
}

var flaps_timer = maketimer( 0.0, func() { flaps_loop() } );
flaps_timer.simulatedTime = 1;

flapsDown = func ( i ){
	flaps_cmd = i;
	setprop("/controls/flight/flaps-switch", i );
	if( i != 0 ){
		flaps_timer.start();
	}
	#if( use_tooltip.getBoolValue() ){
		fgcommand( "set-tooltip", props.Node.new( {"x": getprop("/sim/startup/xsize") / 2, "y": getprop("/sim/startup/ysize") - 50, "label": "Flaps: %2d deg", "mapping": "nasal", "measure-text": "Flaps: 90 deg", "tooltip-id": "flaps_tooltip", "property": "/surface-positions/flap-pos-norm", "script": "return arg[0] * 56;" } ) );
	#}
}
