# Simulation of engine display using hardware of Kanardia HORIS by Benedikt Wolf (D-ECHO) based on

# A3XX Lower ECAM Canvas
# Joshua Davidson (Octal450)

#	References:
#		https://www.kanardia.eu/wp-content/uploads/2019/01/HorisManual.pdf

var ENG_main = nil;
var ENG_display = nil;

var instrument_prop = props.globals.initNode("instrumentation/eng/");

var THR = props.globals.getNode("controls/engines/engine[0]/throttle", 1);
var RPM = props.globals.getNode("engines/engine[0]/thruster/rpm", 1);
var POW = props.globals.getNode("fdm/jsbsim/propulsion/engine[0]/electrical-power-hp", 1);

var coord_bar = nil;

var timeout = 0.0;

var volts = props.globals.getNode( "systems/electrical/outputs/eng-instruments", 1 );

var instrument_dir = "Aircraft/Phoenix/Models/Instruments/ENG/";


var canvas_ENG_base = {
	init: func(canvas_group, file) {
		canvas.parsesvg(canvas_group, file, {'font-mapper': global.canvas.FontMapper});

		var svg_keys = me.getKeys();
		foreach (var key; svg_keys) {
			me[key] = canvas_group.getElementById(key);
		}

		coord_bar = [ me["capacity.bar"].get( "coord[0]" ), me["capacity.bar"].get( "coord[2]" ) ];

		me.page = canvas_group;

		return me;
	},
	getKeys: func() {
		return [];
	},
	update: func() {
		if ( volts.getDoubleValue() > 10 ) {
			ENG_main.page.show();
			ENG_main.update();
		} else {
			ENG_main.page.hide();
		}
	},
};

var canvas_ENG_main = {
	new: func(canvas_group, file) {
		var m = { parents: [canvas_ENG_main , canvas_ENG_base] };
		m.init(canvas_group, file);

		return m;
	},
	getKeys: func() {
		return [ "throttle.pct", "capacity.bar", "capacity.pct", "rpm.digits", "power.kW" ];
	},
	update: func() {
		me["throttle.pct"].setText( sprintf("%3d%%", 100 * THR.getDoubleValue() ) );

		var cap = phoenix.battery.charge_percent;
		me["capacity.bar"].set( "coord[2]", coord_bar[0] + ( ( coord_bar[1] - coord_bar[0] ) * ( 1 - cap ) ) );
		me["capacity.pct"].setText( sprintf("%3d%%", 100 * cap) );

		me["rpm.digits"].setText( sprintf("%4d", math.round( RPM.getDoubleValue(), 10 ) ) );

		me["power.kW"].setText( sprintf("%2d", math.round( POW.getDoubleValue() * 0.7457 ) ) ~ "kW" );
	},
};

var base_updater = maketimer( 0.02, canvas_ENG_base.update );
base_updater.simulatedTime = 1;

setlistener("sim/signals/fdm-initialized", func {
	ENG_display = canvas.new({
		"name": "ENG",
		"size": [320, 240],
		"view": [320, 240],
		"mipmapping": 1
	});
	
	ENG_display.addPlacement({"node": "ENG.display"});
	
	ENG_main = canvas_ENG_main.new( ENG_display.createGroup(), instrument_dir~"ENG.svg");
	
	base_updater.start();
});
