/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.generator.layout;

import com.sun.electric.database.prototype.ArcProto;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.technology.PrimitiveArc;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.generator.layout.LayoutLib;
import java.util.HashMap;
import java.util.Iterator;

public class Tech {
    private static String[] layerNms;
    private static int nbLay;
    private static PrimitiveArc[] layers;
    private static PrimitiveNode[] vias;
    private static HashMap viaMap;
    private static Technology tech;
    public static final PrimitiveArc pdiff;
    public static final PrimitiveArc ndiff;
    public static final PrimitiveArc p1;
    public static final PrimitiveArc m1;
    public static final PrimitiveArc m2;
    public static final PrimitiveArc m3;
    public static final PrimitiveArc m4;
    public static final PrimitiveArc m5;
    public static final PrimitiveArc m6;
    public static final PrimitiveNode ndpin;
    public static final PrimitiveNode pdpin;
    public static final PrimitiveNode p1pin;
    public static final PrimitiveNode m1pin;
    public static final PrimitiveNode m2pin;
    public static final PrimitiveNode m3pin;
    public static final PrimitiveNode m4pin;
    public static final PrimitiveNode m5pin;
    public static final PrimitiveNode m6pin;
    public static final PrimitiveNode nwm1;
    public static final PrimitiveNode pwm1;
    public static final PrimitiveNode ndm1;
    public static final PrimitiveNode pdm1;
    public static final PrimitiveNode p1m1;
    public static final PrimitiveNode m1m2;
    public static final PrimitiveNode m2m3;
    public static final PrimitiveNode m3m4;
    public static final PrimitiveNode m4m5;
    public static final PrimitiveNode m5m6;
    public static final PrimitiveNode nmos;
    public static final PrimitiveNode pmos;
    public static final PrimitiveNode nwell;
    public static final PrimitiveNode pwell;
    public static final PrimitiveNode m1Node;
    public static final PrimitiveNode m2Node;
    public static final PrimitiveNode m3Node;
    public static final PrimitiveNode m4Node;
    public static final PrimitiveNode m5Node;
    public static final PrimitiveNode m6Node;
    public static final PrimitiveNode p1Node;
    public static final PrimitiveNode pdNode;
    public static final PrimitiveNode ndNode;
    public static final PrimitiveNode pselNode;
    public static final PrimitiveNode nselNode;
    public static final PrimitiveNode essentialBounds;
    public static final PrimitiveNode facetCenter;
    public static final ArcProto universalArc;

    private static void error(boolean pred, String msg) {
        LayoutLib.error(pred, msg);
    }

    public static void setNanometersPerLambda(double nanoMeters) {
        tech.setScale(nanoMeters);
    }

    public static PrimitiveNode getViaFor(PrimitiveArc a1, PrimitiveArc a2) {
        int code = a1.hashCode() * a2.hashCode();
        return (PrimitiveNode)viaMap.get(new Integer(code));
    }

    public static ArcProto closestLayer(PortProto port, ArcProto layer) {
        int h = Tech.layerHeight(layer);
        for (int dist = 0; dist < nbLay; ++dist) {
            ArcProto lay;
            int lookUp = h + dist;
            int lookDn = h - dist;
            if (lookUp < nbLay && port.connectsTo(lay = Tech.layerAtHeight(lookUp))) {
                return lay;
            }
            if (lookDn < 0 || !port.connectsTo(lay = Tech.layerAtHeight(lookDn))) continue;
            return lay;
        }
        Tech.error(true, "port can't connect to any layer?!!");
        return null;
    }

    public static ArcProto layerAtHeight(int layHeight) {
        return layers[layHeight];
    }

    public static int layerHeight(ArcProto p) {
        for (int i = 0; i < nbLay; ++i) {
            if (layers[i] != p) continue;
            return i;
        }
        Tech.error(true, "Can't find layer: " + p);
        return -1;
    }

    public static PrimitiveNode viaAbove(ArcProto lay) {
        return Tech.viaAbove(Tech.layerHeight(lay));
    }

    public static PrimitiveNode viaAbove(int layHeight) {
        return vias[layHeight];
    }

    public static PrimitiveNode viaBelow(ArcProto lay) {
        return Tech.viaBelow(Tech.layerHeight(lay));
    }

    public static PrimitiveNode viaBelow(int layHeight) {
        return vias[layHeight - 1];
    }

    public static PrimitiveNode findNode(NodeProto.Function type, ArcProto[] arcs, Technology tech) {
        Iterator it = tech.getNodes();
        while (it.hasNext()) {
            PrimitiveNode pn = (PrimitiveNode)it.next();
            boolean found = true;
            if (pn.getFunction() != type) continue;
            for (int j = 0; j < arcs.length; ++j) {
                if (pn.connectsTo(arcs[j]) != null) continue;
                found = false;
                break;
            }
            if (!found) continue;
            return pn;
        }
        return null;
    }

    static {
        int i;
        layerNms = new String[]{"Polysilicon-1", "Metal-1", "Metal-2", "Metal-3", "Metal-4", "Metal-5", "Metal-6"};
        nbLay = layerNms.length;
        layers = new PrimitiveArc[nbLay];
        vias = new PrimitiveNode[nbLay - 1];
        viaMap = new HashMap();
        tech = Technology.findTechnology("mocmos");
        for (i = 0; i < nbLay; ++i) {
            Tech.layers[i] = tech.findArcProto(layerNms[i]);
            Tech.error(layers[i] == null, "No such layer: " + layerNms[i]);
        }
        p1 = layers[0];
        m1 = layers[1];
        m2 = layers[2];
        m3 = layers[3];
        m4 = layers[4];
        m5 = layers[5];
        m6 = layers[6];
        pdiff = tech.findArcProto("P-Active");
        ndiff = tech.findArcProto("N-Active");
        pdpin = pdiff.findOverridablePinProto();
        ndpin = ndiff.findOverridablePinProto();
        p1pin = p1.findOverridablePinProto();
        m1pin = m1.findOverridablePinProto();
        m2pin = m2.findOverridablePinProto();
        m3pin = m3.findOverridablePinProto();
        m4pin = m4.findOverridablePinProto();
        m5pin = m5.findOverridablePinProto();
        m6pin = m6.findOverridablePinProto();
        for (i = 0; i < nbLay - 1; ++i) {
            Tech.vias[i] = Tech.findNode(NodeProto.Function.CONTACT, new ArcProto[]{layers[i], layers[i + 1]}, tech);
            Tech.error(vias[i] == null, "No via for layer: " + layerNms[i]);
        }
        p1m1 = vias[0];
        m1m2 = vias[1];
        m2m3 = vias[2];
        m3m4 = vias[3];
        m4m5 = vias[4];
        m5m6 = vias[5];
        ndm1 = tech.findNodeProto("Metal-1-N-Active-Con");
        pdm1 = tech.findNodeProto("Metal-1-P-Active-Con");
        nwm1 = tech.findNodeProto("Metal-1-N-Well-Con");
        pwm1 = tech.findNodeProto("Metal-1-P-Well-Con");
        nmos = tech.findNodeProto("N-Transistor");
        pmos = tech.findNodeProto("P-Transistor");
        nwell = tech.findNodeProto("N-Well-Node");
        pwell = tech.findNodeProto("P-Well-Node");
        m1Node = tech.findNodeProto("Metal-1-Node");
        m2Node = tech.findNodeProto("Metal-2-Node");
        m3Node = tech.findNodeProto("Metal-3-Node");
        m4Node = tech.findNodeProto("Metal-4-Node");
        m5Node = tech.findNodeProto("Metal-5-Node");
        m6Node = tech.findNodeProto("Metal-6-Node");
        p1Node = tech.findNodeProto("Polysilicon-1-Node");
        pdNode = tech.findNodeProto("P-Active-Node");
        ndNode = tech.findNodeProto("N-Active-Node");
        nselNode = tech.findNodeProto("N-Select-Node");
        pselNode = tech.findNodeProto("P-Select-Node");
        Technology generic = Technology.findTechnology("generic");
        essentialBounds = generic.findNodeProto("Essential-Bounds");
        facetCenter = generic.findNodeProto("Facet-Center");
        universalArc = generic.findArcProto("Universal");
        viaMap.put(new Integer(m1.hashCode() * m2.hashCode()), m1m2);
        viaMap.put(new Integer(m2.hashCode() * m3.hashCode()), m2m3);
        viaMap.put(new Integer(m3.hashCode() * m4.hashCode()), m3m4);
        viaMap.put(new Integer(m4.hashCode() * m5.hashCode()), m4m5);
        viaMap.put(new Integer(m5.hashCode() * m6.hashCode()), m5m6);
        viaMap.put(new Integer(ndiff.hashCode() * m1.hashCode()), ndm1);
        viaMap.put(new Integer(pdiff.hashCode() * m1.hashCode()), pdm1);
        viaMap.put(new Integer(p1.hashCode() * m1.hashCode()), p1m1);
    }
}

