/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.ncc.lists;

import com.sun.electric.tool.ncc.NccGlobals;
import com.sun.electric.tool.ncc.lists.RecordList;
import com.sun.electric.tool.ncc.trees.EquivRecord;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;

public class LeafList
extends RecordList {
    public void add(EquivRecord r) {
        this.error(!r.isLeaf(), "EquivList only allows leaves");
        super.add(r);
    }

    public void sortByIncreasingSize() {
        Collections.sort(this.content, new SizeCompare());
    }

    public String sizeInfoString() {
        String max = " offspring max sizes:";
        String diff = " offspring size differences: ";
        boolean matchOK = true;
        Iterator it = this.iterator();
        while (it.hasNext()) {
            EquivRecord g = (EquivRecord)it.next();
            max = max + " " + g.maxSize();
            diff = diff + " " + g.maxSizeDiff();
            if (g.maxSizeDiff() <= 0) continue;
            matchOK = false;
        }
        if (matchOK) {
            return max;
        }
        return max + "\n" + diff + "\n WARNING: Mismatched sizes";
    }

    public LeafList selectActive(NccGlobals globals) {
        LeafList out = new LeafList();
        Iterator it = this.iterator();
        while (it.hasNext()) {
            EquivRecord er = (EquivRecord)it.next();
            if (!er.isActive()) continue;
            out.add(er);
        }
        globals.println(" selectActive found " + out.size() + " active leaf records");
        return out;
    }

    public LeafList selectRetired(NccGlobals globals) {
        LeafList out = new LeafList();
        Iterator it = this.iterator();
        while (it.hasNext()) {
            EquivRecord er = (EquivRecord)it.next();
            if (!er.isRetired()) continue;
            out.add(er);
        }
        globals.println(" selectRetired found " + out.size() + " retired leaf records");
        return out;
    }

    private static class SizeCompare
    implements Comparator {
        private SizeCompare() {
        }

        public int compare(Object o1, Object o2) {
            EquivRecord s1 = (EquivRecord)o1;
            EquivRecord s2 = (EquivRecord)o2;
            return s1.maxSize() - s2.maxSize();
        }
    }
}

