/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database;

import com.sun.electric.database.CellUsage;
import com.sun.electric.database.EObjectInputStream;
import com.sun.electric.database.ExportId;
import com.sun.electric.database.IdManager;
import com.sun.electric.database.geometry.GenMath;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.EDatabase;
import com.sun.electric.database.prototype.NodeProtoId;
import com.sun.electric.database.text.CellName;
import java.io.InvalidObjectException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Random;

public final class CellId
implements NodeProtoId,
Serializable {
    public static final CellId[] NULL_ARRAY = new CellId[0];
    public final IdManager idManager;
    public final CellName cellName;
    public final int cellIndex;
    private volatile transient CellUsage[] usagesIn = CellUsage.NULL_ARRAY;
    private volatile transient CellUsage[] hashUsagesIn = EMPTY_USAGE_HASH;
    private volatile transient CellUsage[] usagesOf = CellUsage.NULL_ARRAY;
    private volatile transient ExportId[] exportIds = ExportId.NULL_ARRAY;
    private volatile transient int[] hashExportIds = EMPTY_EXPORT_HASH;
    private volatile transient int numNodeIds = 0;
    private volatile transient int numArcIds = 0;
    private static final CellUsage[] EMPTY_USAGE_HASH = new CellUsage[]{null};
    private static final int[] EMPTY_EXPORT_HASH = new int[]{-1};

    CellId(IdManager idManager, CellName cellName, int cellIndex) {
        this.idManager = idManager;
        this.cellName = cellName;
        this.cellIndex = cellIndex;
    }

    private Object writeReplace() throws ObjectStreamException {
        return new CellIdKey(this);
    }

    private Object readResolve() throws ObjectStreamException {
        throw new InvalidObjectException("CellId");
    }

    public int numUsagesIn() {
        return this.usagesIn.length;
    }

    public CellUsage getUsageIn(int i) {
        return this.usagesIn[i];
    }

    public int numUsagesOf() {
        return this.usagesOf.length;
    }

    public CellUsage getUsageOf(int i) {
        return this.usagesOf[i];
    }

    public CellUsage getUsageIn(CellId protoId) {
        return this.getUsageIn(protoId, true);
    }

    public int numExportIds() {
        return this.exportIds.length;
    }

    public ExportId getPortId(int chronIndex) {
        return this.exportIds[chronIndex];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExportId findExportId(String externalId) {
        int[] hash = this.hashExportIds;
        ExportId[] exportIds = this.exportIds;
        int i = externalId.hashCode() & Integer.MAX_VALUE;
        i %= hash.length;
        try {
            int j = 1;
            while (hash[i] >= 0) {
                ExportId exportId = exportIds[hash[i]];
                if (exportId.externalId.equals(externalId)) {
                    return exportId;
                }
                if ((i += j) >= hash.length) {
                    i -= hash.length;
                }
                j += 2;
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            // empty catch block
        }
        CellId cellId = this;
        synchronized (cellId) {
            if (hash == this.hashExportIds && hash[i] == -1) {
                return null;
            }
            return this.findExportId(externalId);
        }
    }

    ExportId[] getExportIds() {
        return this.exportIds;
    }

    public ExportId newExportId(String suggestedId) {
        ExportId[] oldExportIds = this.exportIds;
        ExportId[] newExportIds = new ExportId[oldExportIds.length + 1];
        System.arraycopy(oldExportIds, 0, newExportIds, 0, oldExportIds.length);
        ExportId e = this.newExportId(suggestedId, newExportIds, oldExportIds.length);
        if (e == null) {
            int suffix;
            String prefix = suggestedId;
            int ind = prefix.indexOf(64);
            if (ind >= 0) {
                prefix = prefix.substring(0, ind);
            }
            Random random = new Random();
            Object s = null;
            do {
                suffix = random.nextInt() & 0x3FFFFFFF;
            } while ((e = this.newExportId(prefix + '@' + suffix, newExportIds, oldExportIds.length)) == null);
        }
        this.exportIds = newExportIds;
        return e;
    }

    synchronized void newExportIds(String[] externalIds) {
        ExportId[] oldExportIds = this.exportIds;
        ExportId[] newExportIds = new ExportId[oldExportIds.length + externalIds.length];
        System.arraycopy(oldExportIds, 0, newExportIds, 0, oldExportIds.length);
        for (int i = 0; i < externalIds.length; ++i) {
            int chronIndex = oldExportIds.length + i;
            ExportId e = this.newExportId(externalIds[i], newExportIds, chronIndex);
            if (e == null) {
                this.rehashExportIds(oldExportIds, oldExportIds.length);
                throw new IllegalArgumentException("Duplicate export id " + externalIds[i]);
            }
            newExportIds[chronIndex] = e;
        }
        this.exportIds = newExportIds;
    }

    public int newNodeId() {
        return this.numNodeIds++;
    }

    public int newArcId() {
        return this.numArcIds++;
    }

    public Cell inDatabase(EDatabase database) {
        return database.getCell(this);
    }

    public String toString() {
        String s = "CellId#" + this.cellIndex;
        Cell cell = Cell.inCurrentThread(this);
        if (cell != null) {
            s = s + "(" + cell.libDescribe() + ")";
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CellUsage getUsageIn(CellId protoId, boolean create) {
        CellUsage u;
        CellUsage[] hash = this.hashUsagesIn;
        int i = protoId.hashCode() & Integer.MAX_VALUE;
        i %= hash.length;
        int j = 1;
        while (hash[i] != null) {
            u = hash[i];
            if (u.protoId == protoId) {
                return u;
            }
            if ((i += j) >= hash.length) {
                i -= hash.length;
            }
            j += 2;
        }
        Class<CellUsage> clazz = CellUsage.class;
        synchronized (CellUsage.class) {
            if (hash == this.hashUsagesIn && hash[i] == null) {
                if (!create) {
                    // ** MonitorExit[var5_6] (shouldn't be in output)
                    return null;
                }
                if (this.usagesIn.length * 2 <= hash.length - 3) {
                    hash[i] = u = new CellUsage(this, protoId, this.usagesIn.length);
                    this.usagesIn = CellId.appendUsage(this.usagesIn, u);
                    protoId.usagesOf = CellId.appendUsage(protoId.usagesOf, u);
                    this.check();
                    // ** MonitorExit[var5_6] (shouldn't be in output)
                    return u;
                }
                this.rehashUsagesIn();
            }
            // ** MonitorExit[var5_6] (shouldn't be in output)
            return this.getUsageIn(protoId, create);
        }
    }

    private void rehashUsagesIn() {
        CellUsage[] usagesIn = this.usagesIn;
        int newSize = usagesIn.length * 2 + 3;
        if (newSize < 0) {
            throw new IndexOutOfBoundsException();
        }
        CellUsage[] newHash = new CellUsage[GenMath.primeSince(newSize)];
        for (int k = usagesIn.length - 1; k >= 0; --k) {
            CellUsage u = usagesIn[k];
            int i = u.protoId.hashCode() & Integer.MAX_VALUE;
            i %= newHash.length;
            int j = 1;
            while (newHash[i] != null) {
                if ((i += j) >= newHash.length) {
                    i -= newHash.length;
                }
                j += 2;
            }
            newHash[i] = u;
        }
        this.hashUsagesIn = newHash;
        this.check();
    }

    private ExportId newExportId(String externalId, ExportId[] newExportIds, int chronIndex) {
        if (externalId.length() == 0) {
            return null;
        }
        int[] hash = this.hashExportIds;
        int i = externalId.hashCode() & Integer.MAX_VALUE;
        i %= hash.length;
        int j = 1;
        while (hash[i] >= 0) {
            ExportId exportId = newExportIds[hash[i]];
            if (exportId.externalId.equals(externalId)) {
                return null;
            }
            if ((i += j) >= hash.length) {
                i -= hash.length;
            }
            j += 2;
        }
        if (this.exportIds.length * 2 <= hash.length - 3) {
            ExportId e;
            hash[i] = chronIndex;
            newExportIds[chronIndex] = e = new ExportId(this, chronIndex, externalId);
            return e;
        }
        this.rehashExportIds(newExportIds, chronIndex);
        return this.newExportId(externalId, newExportIds, chronIndex);
    }

    private void rehashExportIds(ExportId[] exportIds, int numExports) {
        int newSize = exportIds.length * 2 + 3;
        if (newSize < 0) {
            throw new IndexOutOfBoundsException();
        }
        int[] newHash = new int[GenMath.primeSince(newSize)];
        Arrays.fill(newHash, -1);
        int k = 0;
        while (k < numExports) {
            ExportId exportId = exportIds[k];
            int i = exportId.hashCode() & Integer.MAX_VALUE;
            i %= newHash.length;
            int j = 1;
            while (newHash[i] >= 0) {
                assert (exportIds[newHash[i]] != exportId);
                if ((i += j) >= newHash.length) {
                    i -= newHash.length;
                }
                j += 2;
            }
            newHash[i] = k++;
        }
        this.hashExportIds = newHash;
        this.check();
    }

    private static CellUsage[] appendUsage(CellUsage[] usages, CellUsage newUsage) {
        CellUsage[] newUsages = new CellUsage[usages.length + 1];
        System.arraycopy(usages, 0, newUsages, 0, usages.length);
        newUsages[usages.length] = newUsage;
        return newUsages;
    }

    void check() {
        this.checkLinked();
        CellUsage[] usagesIn = this.usagesIn;
        for (int k = 0; k < usagesIn.length; ++k) {
            CellUsage u = usagesIn[k];
            assert (u.parentId == this);
            assert (u.indexInParent == k);
            assert (u.parentId.idManager == this.idManager);
            u.protoId.checkLinked();
            u.check();
        }
        this.checkHashUsagesIn();
        this.checkHashExportIds();
        CellUsage[] usagesOf = this.usagesOf;
        for (int k = 0; k < usagesOf.length; ++k) {
            CellUsage u = usagesOf[k];
            assert (u.protoId.idManager == this.idManager);
            u.parentId.checkLinked();
            assert (u == u.parentId.usagesIn[u.indexInParent]);
        }
        ExportId[] exportIds = this.exportIds;
        for (int k = 0; k < exportIds.length; ++k) {
            ExportId e = exportIds[k];
            assert (e.parentId == this);
            assert (e.chronIndex == k);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkHashUsagesIn() {
        Class<CellUsage> clazz = CellUsage.class;
        synchronized (CellUsage.class) {
            CellUsage[] usagesIn = this.usagesIn;
            CellUsage[] hash = this.hashUsagesIn;
            // ** MonitorExit[var3_1] (shouldn't be in output)
            int count = 0;
            for (int i = 0; i < hash.length; ++i) {
                CellUsage u = hash[i];
                if (u == null) continue;
                assert (u.parentId == this);
                assert (u == usagesIn[u.indexInParent]);
                ++count;
            }
            assert (usagesIn.length == count);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkHashExportIds() {
        int[] hash;
        ExportId[] exportIds;
        CellId cellId = this;
        synchronized (cellId) {
            exportIds = this.exportIds;
            hash = this.hashExportIds;
        }
        int count = 0;
        for (int i = 0; i < hash.length; ++i) {
            int k = hash[i];
            if (k == -1) continue;
            assert (k >= 0 && k < exportIds.length);
            ++count;
        }
        assert (exportIds.length == count);
    }

    private void checkLinked() {
        assert (this == this.idManager.getCellId(this.cellIndex));
    }

    private static class CellIdKey
    extends EObjectInputStream.Key {
        private final int cellIndex;

        private CellIdKey(CellId cellId) {
            this.cellIndex = cellId.cellIndex;
        }

        protected Object readResolveInDatabase(EDatabase database) throws InvalidObjectException {
            return database.getIdManager().getCellId(this.cellIndex);
        }
    }
}

