/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database;

import com.sun.electric.database.CellBackup;
import com.sun.electric.database.CellId;
import com.sun.electric.database.CellUsage;
import com.sun.electric.database.ExportId;
import com.sun.electric.database.ImmutableArcInst;
import com.sun.electric.database.ImmutableCell;
import com.sun.electric.database.ImmutableElectricObject;
import com.sun.electric.database.ImmutableExport;
import com.sun.electric.database.ImmutableLibrary;
import com.sun.electric.database.ImmutableNodeInst;
import com.sun.electric.database.ImmutablePortInst;
import com.sun.electric.database.LibId;
import com.sun.electric.database.prototype.PortProtoId;
import com.sun.electric.database.text.ImmutableArrayList;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.PrimitivePort;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class UsageCollector {
    static final BitSet EMPTY_BITSET = new BitSet();
    private HashMap<CellId, CellUsageInfoBuilder> cellIndices = new HashMap(16, 0.5f);
    private BitSet libUsages = new BitSet();

    UsageCollector(ImmutableCell d, ImmutableArrayList<ImmutableNodeInst> nodes, ImmutableArrayList<ImmutableArcInst> arcs, ImmutableArrayList<ImmutableExport> exports) {
        for (int nodeIndex = 0; nodeIndex < nodes.size(); ++nodeIndex) {
            ImmutableNodeInst n = (ImmutableNodeInst)nodes.get(nodeIndex);
            if (n.protoId instanceof CellId) {
                this.add((CellId)n.protoId, true);
            }
            this.addVars(n);
            for (int chronIndex = 0; chronIndex < n.ports.length; ++chronIndex) {
                ImmutablePortInst pi = n.ports[chronIndex];
                if (pi == ImmutablePortInst.EMPTY) continue;
                PortProtoId pp = n.protoId.getPortId(chronIndex);
                this.add(pp);
                this.addVars(pi);
            }
        }
        for (int arcIndex = 0; arcIndex < arcs.size(); ++arcIndex) {
            ImmutableArcInst a = (ImmutableArcInst)arcs.get(arcIndex);
            this.add(a.tailPortId);
            this.add(a.headPortId);
            this.addVars(a);
        }
        for (int portIndex = 0; portIndex < exports.size(); ++portIndex) {
            ImmutableExport e = (ImmutableExport)exports.get(portIndex);
            this.add(e.originalPortId);
            this.addVars(e);
        }
        this.addVars(d);
    }

    UsageCollector(ImmutableLibrary d) {
        this.addVars(d);
    }

    private void addVars(ImmutableElectricObject d) {
        for (Variable var : d.getVars()) {
            if (!var.hasReferences()) continue;
            if (var.isArray()) {
                int n = var.getLength();
                for (int i = 0; i < n; ++i) {
                    this.addVarObj(var.getObject(i));
                }
                continue;
            }
            this.addVarObj(var.getObject());
        }
    }

    private void addVarObj(Object o) {
        if (o instanceof LibId) {
            this.add((LibId)o);
        } else if (o instanceof CellId) {
            this.add((CellId)o, false);
        } else if (o instanceof ExportId) {
            this.add((ExportId)o);
        }
    }

    private void add(PortProtoId portId) {
        if (portId instanceof PrimitivePort) {
            return;
        }
        ExportId eId = (ExportId)portId;
        this.add(eId.parentId, false).set(eId.chronIndex);
    }

    private BitSet add(CellId cellId, boolean isInstance) {
        CellUsageInfoBuilder cellCount = this.cellIndices.get(cellId);
        if (cellCount == null) {
            cellCount = new CellUsageInfoBuilder();
            this.cellIndices.put(cellId, cellCount);
        }
        if (isInstance) {
            ++cellCount.instCount;
        }
        return cellCount.usedExports;
    }

    private void add(LibId libId) {
        this.libUsages.set(libId.libIndex);
    }

    CellBackup.CellUsageInfo[] getCellUsages(CellId parentId, CellBackup.CellUsageInfo[] oldCellUsages) {
        if (this.cellIndices.isEmpty()) {
            return CellBackup.NULL_CELL_USAGE_INFO_ARRAY;
        }
        int length = 0;
        for (CellId cellId : this.cellIndices.keySet()) {
            length = Math.max(length, parentId.getUsageIn((CellId)cellId).indexInParent + 1);
        }
        Object[] newCellUsages = new CellBackup.CellUsageInfo[length];
        for (CellId cellId : this.cellIndices.keySet()) {
            CellUsage u = parentId.getUsageIn(cellId);
            int indexInParent = u.indexInParent;
            CellBackup.CellUsageInfo newC = null;
            CellUsageInfoBuilder cellCount = this.cellIndices.get(cellId);
            if (cellCount != null) {
                CellBackup.CellUsageInfo oldC = indexInParent < oldCellUsages.length ? oldCellUsages[indexInParent] : null;
                newC = oldC != null ? oldC.with(cellCount.instCount, cellCount.usedExports) : new CellBackup.CellUsageInfo(cellCount.instCount, cellCount.usedExports);
            }
            newCellUsages[indexInParent] = newC;
        }
        return Arrays.equals(newCellUsages, oldCellUsages) ? oldCellUsages : newCellUsages;
    }

    HashMap<CellId, BitSet> getExportUsages(HashMap<CellId, BitSet> oldExportUsages) {
        if (this.cellIndices == null) {
            return null;
        }
        HashMap<CellId, BitSet> newExportUsages = new HashMap<CellId, BitSet>();
        for (CellId cellId : this.cellIndices.keySet()) {
            BitSet oldSet = oldExportUsages != null ? oldExportUsages.get(cellId) : null;
            BitSet newSet = UsageCollector.bitSetWith(oldSet, this.cellIndices.get((Object)cellId).usedExports);
            newExportUsages.put(cellId, newSet);
        }
        return oldExportUsages != null && oldExportUsages.equals(newExportUsages) ? oldExportUsages : newExportUsages;
    }

    BitSet getLibUsages(BitSet oldLibUsages) {
        return UsageCollector.bitSetWith(oldLibUsages, this.libUsages);
    }

    static BitSet bitSetWith(BitSet oldBitSet, BitSet newBitSet) {
        if (newBitSet.isEmpty()) {
            return EMPTY_BITSET;
        }
        return newBitSet.equals(oldBitSet) ? oldBitSet : newBitSet;
    }

    private static class CellUsageInfoBuilder {
        int instCount;
        BitSet usedExports = new BitSet();

        private CellUsageInfoBuilder() {
        }
    }
}

