/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io.input;

import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.geometry.GenMath;
import com.sun.electric.database.geometry.Geometric;
import com.sun.electric.database.geometry.Orientation;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.hierarchy.View;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.prototype.PortCharacteristic;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Connection;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.AbstractTextDescriptor;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.Foundry;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.PrimitivePort;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Artwork;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.technology.technologies.Schematics;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.JobException;
import com.sun.electric.tool.io.IOTool;
import com.sun.electric.tool.io.input.Input;
import com.sun.electric.tool.io.output.EDIFEquiv;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.ViewChanges;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EDIF
extends Input {
    private static final double INCH = 10.0;
    private static final int SHEETWIDTH = 44;
    private static final int SHEETHEIGHT = 20;
    private static final ViewType VNULL = new ViewType("Null");
    private static final ViewType VBEHAVIOR = new ViewType("Behavior");
    private static final ViewType VDOCUMENT = new ViewType("Document");
    private static final ViewType VGRAPHIC = new ViewType("Graphic");
    private static final ViewType VLOGICMODEL = new ViewType("LogicModel");
    private static final ViewType VMASKLAYOUT = new ViewType("MaskLayout");
    private static final ViewType VNETLIST = new ViewType("Netlist");
    private static final ViewType VPCBLAYOUT = new ViewType("PCBLayout");
    private static final ViewType VSCHEMATIC = new ViewType("Schematic");
    private static final ViewType VSTRANGER = new ViewType("Stranger");
    private static final ViewType VSYMBOLIC = new ViewType("Symbolic");
    private static final ViewType VSYMBOL = new ViewType("Symbol");
    private static final GeometryType GUNKNOWN = new GeometryType();
    private static final GeometryType GRECTANGLE = new GeometryType();
    private static final GeometryType GPOLYGON = new GeometryType();
    private static final GeometryType GSHAPE = new GeometryType();
    private static final GeometryType GOPENSHAPE = new GeometryType();
    private static final GeometryType GTEXT = new GeometryType();
    private static final GeometryType GPATH = new GeometryType();
    private static final GeometryType GINSTANCE = new GeometryType();
    private static final GeometryType GCIRCLE = new GeometryType();
    private static final GeometryType GARC = new GeometryType();
    private static final GeometryType GPIN = new GeometryType();
    private static final GeometryType GNET = new GeometryType();
    private static final GeometryType GBUS = new GeometryType();
    private static final Orientation OR0 = Orientation.fromC(0, false);
    private static final Orientation OR90 = Orientation.fromC(900, false);
    private static final Orientation OR180 = Orientation.fromC(1800, false);
    private static final Orientation OR270 = Orientation.fromC(2700, false);
    private static final Orientation OMX = Orientation.fromC(2700, true);
    private static final Orientation OMY = Orientation.fromC(900, true);
    private static final Orientation OMYR90 = Orientation.fromC(0, true);
    private static final Orientation OMXR90 = Orientation.fromC(1800, true);
    private static final VendorType EVUNKNOWN = new VendorType();
    private static final VendorType EVCADENCE = new VendorType();
    private static final VendorType EVVIEWLOGIC = new VendorType();
    private int pageNumber;
    private ViewType activeView;
    private VendorType curVendor;
    private EDIFKEY curKeyword;
    private String inputBuffer;
    private int inputBufferPos;
    private boolean ignoreBlock;
    private int errorCount;
    private int warningCount;
    private Library curLibrary;
    private Technology curTechnology;
    private Cell curCell;
    private int curCellPage;
    private NodeInst curNode;
    private ArcInst curArc;
    private NodeProto curFigureGroup;
    private ArcProto curArcType;
    private NodeProto cellRefProto;
    private int cellRefProtoTechBits;
    private int cellRefProtoRotation;
    private PortProto curPort;
    private GeometryType curGeometryType;
    private List<Point2D> curPoints;
    private Orientation curOrientation;
    private PortCharacteristic curDirection;
    private int pathWidth;
    private boolean extendEnd;
    private boolean isArray;
    private int arrayXVal;
    private int arrayYVal;
    private double deltaPointXX;
    private double deltaPointXY;
    private double deltaPointYX;
    private double deltaPointYY;
    private boolean deltaPointsSet;
    private int memberXVal;
    private int memberYVal;
    private String textString;
    private int textHeight;
    private AbstractTextDescriptor.Position textJustification;
    private boolean textVisible;
    private List<Point2D> saveTextPoints;
    private int saveTextHeight;
    private AbstractTextDescriptor.Position saveTextJustification;
    private double inputScale;
    private String cellReference;
    private String cellName;
    private String portReference;
    private String portName;
    private String instanceReference;
    private String instanceName;
    private String bundleReference;
    private String bundleName;
    private String netReference;
    private String netName;
    private String propertyReference;
    private String propertyName;
    private String viewRef;
    private String cellRef;
    private String libraryRef;
    private Object propertyValue;
    private String objectName;
    private String originalName;
    private HashSet<Cell> builtCells;
    private List<NameEntry> nameEntryList;
    private NameEntry curNameEntry;
    private HashMap<String, NameEntry> cellTable;
    private EDIFPort portsListHead;
    private EDIFProperty propertiesListHead;
    private EDIFNetPort netPortListHead;
    private EDIFNetPort netPortListTail;
    private int sheetXPos;
    private int sheetYPos;
    private int inPortPos;
    private int bidirPortPos;
    private int outPortPos;
    private EDIFKEY[] keyStack = new EDIFKEY[1000];
    private int keyStackDepth;
    private EDIFEquiv equivs;
    private List<PortInst> netPortRefs;
    private PortProto defaultPort;
    private PortProto defaultIconPort;
    private PortProto defaultBusPort;
    private PortProto defaultInput;
    private PortProto defaultOutput;
    private static HashMap<String, EDIFKEY> edifKeys = new HashMap();
    private EDIFKEY KUNKNOWN = new EDIFKEY("");
    private EDIFKEY KINIT = new EDIFKEY("");
    private EDIFKEY KANNOTATE = new EDIFKEY("annotate");
    private EDIFKEY KARC = new KeyArc();
    private EDIFKEY KARRAY = new KeyArray();
    private EDIFKEY KAUTHOR = new EDIFKEY("author");
    private EDIFKEY KBOOLEAN = new EDIFKEY("boolean");
    private EDIFKEY KBOUNDINGBOX = new KeyBoundingBox();
    private EDIFKEY KCELL = new KeyCell();
    private EDIFKEY KCELLREF = new KeyCellRef();
    private EDIFKEY KCELLTYPE = new EDIFKEY("cellType");
    private EDIFKEY KCIRCLE = new KeyCircle();
    private EDIFKEY KCOLOR = new EDIFKEY("color");
    private EDIFKEY KCOMMENT = new EDIFKEY("comment");
    private EDIFKEY KCOMMENTGRAPHICS = new EDIFKEY("commentGraphics");
    private EDIFKEY KCONNECTLOCATION = new EDIFKEY("connectLocation");
    private EDIFKEY KCONTENTS = new KeyContents();
    private EDIFKEY KCORNERTYPE = new KeyCornerType();
    private EDIFKEY KCURVE = new EDIFKEY("curve");
    private EDIFKEY KDATAORIGIN = new EDIFKEY("dataOrigin");
    private EDIFKEY KDCFANOUTLOAD = new EDIFKEY("dcFanoutLoad");
    private EDIFKEY KDCMAXFANOUT = new EDIFKEY("dcMaxFanout");
    private EDIFKEY KDELTA = new KeyDelta();
    private EDIFKEY KDESIGN = new KeyDesign();
    private EDIFKEY KDESIGNATOR = new EDIFKEY("designator");
    private EDIFKEY KDIRECTION = new KeyDirection();
    private EDIFKEY KDISPLAY = new KeyDisplay();
    private EDIFKEY KDOT = new KeyDot();
    private EDIFKEY KSCALEDINTEGER = new EDIFKEY("e");
    private EDIFKEY KEDIF = new KeyEDIF();
    private EDIFKEY KEDIFLEVEL = new EDIFKEY("edifLevel");
    private EDIFKEY KEDIFVERSION = new EDIFKEY("edifVersion");
    private EDIFKEY KENDTYPE = new KeyEndType();
    private EDIFKEY KEXTERNAL = new KeyExternal();
    private EDIFKEY KFABRICATE = new KeyFabricate();
    private EDIFKEY KFALSE = new KeyFalse();
    private EDIFKEY KFIGURE = new KeyFigure();
    private EDIFKEY KFIGUREGROUP = new EDIFKEY("figureGroup");
    private EDIFKEY KFIGUREGROUPOVERRIDE = new KeyFigureGroupOverride();
    private EDIFKEY KFILLPATTERN = new EDIFKEY("fillpattern");
    private EDIFKEY KGRIDMAP = new EDIFKEY("gridMap");
    private EDIFKEY KINSTANCE = new KeyInstance();
    private EDIFKEY KINSTANCEREF = new KeyInstanceRef();
    private EDIFKEY KINTEGER = new KeyInteger();
    private EDIFKEY KINTERFACE = new KeyInterface();
    private EDIFKEY KJOINED = new EDIFKEY("joined");
    private EDIFKEY KJUSTIFY = new KeyJustify();
    private EDIFKEY KKEYWORDDISPLAY = new EDIFKEY("keywordDisplay");
    private EDIFKEY KEDIFKEYLEVEL = new EDIFKEY("keywordLevel");
    private EDIFKEY KEDIFKEYMAP = new EDIFKEY("keywordMap");
    private EDIFKEY KLIBRARY = new KeyLibrary();
    private EDIFKEY KLIBRARYREF = new LibraryRef();
    private EDIFKEY KLISTOFNETS = new EDIFKEY("listOfNets");
    private EDIFKEY KLISTOFPORTS = new EDIFKEY("listOfPorts");
    private EDIFKEY KMEMBER = new KeyMember();
    private EDIFKEY KNAME = new KeyName();
    private EDIFKEY KNET = new KeyNet();
    private EDIFKEY KNETBUNDLE = new KeyNetBundle();
    private EDIFKEY KNUMBER = new KeyNumber();
    private EDIFKEY KNUMBERDEFINITION = new EDIFKEY("numberDefinition");
    private EDIFKEY KOPENSHAPE = new KeyOpenShape();
    private EDIFKEY KORIENTATION = new KeyOrientation();
    private EDIFKEY KORIGIN = new EDIFKEY("origin");
    private EDIFKEY KOWNER = new EDIFKEY("owner");
    private EDIFKEY KPAGE = new KeyPage();
    private EDIFKEY KPAGESIZE = new EDIFKEY("pageSize");
    private EDIFKEY KPATH = new KeyPath();
    private EDIFKEY KPATHWIDTH = new KeyPathWidth();
    private EDIFKEY KPOINT = new EDIFKEY("point");
    private EDIFKEY KPOINTLIST = new EDIFKEY("pointList");
    private EDIFKEY KPOLYGON = new KeyPolygon();
    private EDIFKEY KPORT = new KeyPort();
    private EDIFKEY KPORTBUNDLE = new EDIFKEY("portBundle");
    private EDIFKEY KPORTIMPLEMENTATION = new KeyPortImplementation();
    private EDIFKEY KPORTINSTANCE = new EDIFKEY("portInstance");
    private EDIFKEY KPORTLIST = new EDIFKEY("portList");
    private EDIFKEY KPORTREF = new KeyPortRef();
    private EDIFKEY KPROGRAM = new KeyProgram();
    private EDIFKEY KPROPERTY = new KeyProperty();
    private EDIFKEY KPROPERTYDISPLAY = new EDIFKEY("propertyDisplay");
    private EDIFKEY KPT = new KeyPt();
    private EDIFKEY KRECTANGLE = new KeyRectangle();
    private EDIFKEY KRENAME = new KeyRename();
    private EDIFKEY KSCALE = new EDIFKEY("scale");
    private EDIFKEY KSCALEX = new EDIFKEY("scaleX");
    private EDIFKEY KSCALEY = new EDIFKEY("scaleY");
    private EDIFKEY KSHAPE = new EDIFKEY("shape");
    private EDIFKEY KSTATUS = new EDIFKEY("status");
    private EDIFKEY KSTRING = new KeyString();
    private EDIFKEY KSTRINGDISPLAY = new KeyStringDisplay();
    private EDIFKEY KSYMBOL = new KeySymbol();
    private EDIFKEY KTECHNOLOGY = new KeyTechnology();
    private EDIFKEY KTEXTHEIGHT = new KeyTextHeight();
    private EDIFKEY KTIMESTAMP = new EDIFKEY("timestamp");
    private EDIFKEY KTRANSFORM = new KeyTransform();
    private EDIFKEY KTRUE = new KeyTrue();
    private EDIFKEY KUNIT = new KeyUnit();
    private EDIFKEY KUSERDATA = new EDIFKEY("userData");
    private EDIFKEY KVERSION = new EDIFKEY("version");
    private EDIFKEY KVIEW = new KeyView();
    private EDIFKEY KVIEWREF = new ViewRef();
    private EDIFKEY KVIEWTYPE = new KeyViewType();
    private EDIFKEY KVISIBLE = new EDIFKEY("visible");
    private EDIFKEY KWRITTEN = new EDIFKEY("written");

    @Override
    protected boolean importALibrary(Library lib) {
        EDIFKEY.access$202(this.KARRAY, new EDIFKEY[]{this.KINSTANCE, this.KPORT, this.KNET});
        EDIFKEY.access$202(this.KAUTHOR, new EDIFKEY[]{this.KWRITTEN});
        EDIFKEY.access$202(this.KBOUNDINGBOX, new EDIFKEY[]{this.KSYMBOL, this.KCONTENTS});
        EDIFKEY.access$202(this.KCELL, new EDIFKEY[]{this.KEXTERNAL, this.KLIBRARY});
        EDIFKEY.access$202(this.KCELLREF, new EDIFKEY[]{this.KDESIGN, this.KVIEWREF, this.KINSTANCE});
        EDIFKEY.access$202(this.KCELLTYPE, new EDIFKEY[]{this.KCELL});
        EDIFKEY.access$202(this.KCONTENTS, new EDIFKEY[]{this.KVIEW});
        EDIFKEY.access$202(this.KDESIGN, new EDIFKEY[]{this.KEDIF});
        EDIFKEY.access$202(this.KDIRECTION, new EDIFKEY[]{this.KPORT});
        EDIFKEY.access$202(this.KEDIF, new EDIFKEY[]{this.KINIT});
        EDIFKEY.access$202(this.KEDIFLEVEL, new EDIFKEY[]{this.KEDIF, this.KEXTERNAL, this.KLIBRARY});
        EDIFKEY.access$202(this.KEXTERNAL, new EDIFKEY[]{this.KEDIF});
        EDIFKEY.access$202(this.KINSTANCE, new EDIFKEY[]{this.KCONTENTS, this.KPAGE, this.KPORTIMPLEMENTATION, this.KCOMMENTGRAPHICS});
        EDIFKEY.access$202(this.KINSTANCEREF, new EDIFKEY[]{this.KINSTANCEREF, this.KPORTREF});
        EDIFKEY.access$202(this.KINTERFACE, new EDIFKEY[]{this.KVIEW});
        EDIFKEY.access$202(this.KJOINED, new EDIFKEY[]{this.KINTERFACE, this.KNET});
        EDIFKEY.access$202(this.KEDIFKEYMAP, new EDIFKEY[]{this.KEDIF});
        EDIFKEY.access$202(this.KLIBRARYREF, new EDIFKEY[]{this.KCELLREF});
        EDIFKEY.access$202(this.KLISTOFNETS, new EDIFKEY[]{this.KNETBUNDLE});
        EDIFKEY.access$202(this.KNET, new EDIFKEY[]{this.KCONTENTS, this.KPAGE, this.KLISTOFNETS});
        EDIFKEY.access$202(this.KNETBUNDLE, new EDIFKEY[]{this.KCONTENTS, this.KPAGE});
        EDIFKEY.access$202(this.KNUMBERDEFINITION, new EDIFKEY[]{this.KTECHNOLOGY});
        EDIFKEY.access$202(this.KPORT, new EDIFKEY[]{this.KINTERFACE, this.KLISTOFPORTS});
        EDIFKEY.access$202(this.KSCALE, new EDIFKEY[]{this.KNUMBERDEFINITION});
        EDIFKEY.access$202(this.KSTATUS, new EDIFKEY[]{this.KCELL, this.KDESIGN, this.KEDIF, this.KEXTERNAL, this.KLIBRARY, this.KVIEW});
        EDIFKEY.access$202(this.KSYMBOL, new EDIFKEY[]{this.KINTERFACE});
        EDIFKEY.access$202(this.KTECHNOLOGY, new EDIFKEY[]{this.KEXTERNAL, this.KLIBRARY});
        EDIFKEY.access$202(this.KTIMESTAMP, new EDIFKEY[]{this.KWRITTEN});
        EDIFKEY.access$202(this.KUNIT, new EDIFKEY[]{this.KPROPERTY, this.KSCALE});
        EDIFKEY.access$202(this.KVIEW, new EDIFKEY[]{this.KPROPERTY, this.KCELL});
        EDIFKEY.access$202(this.KVIEWREF, new EDIFKEY[]{this.KINSTANCE, this.KINSTANCEREF, this.KPORTREF});
        EDIFKEY.access$202(this.KVIEWTYPE, new EDIFKEY[]{this.KVIEW});
        EDIFKEY.access$202(this.KWRITTEN, new EDIFKEY[]{this.KSTATUS});
        this.netPortListTail = null;
        this.netPortListHead = null;
        this.propertyValue = null;
        this.curPoints = new ArrayList<Point2D>();
        this.saveTextPoints = new ArrayList<Point2D>();
        this.curKeyword = this.KINIT;
        this.inputBuffer = "";
        this.inputBufferPos = 0;
        this.warningCount = 0;
        this.errorCount = 0;
        this.ignoreBlock = false;
        this.curVendor = EVUNKNOWN;
        this.builtCells = new HashSet();
        this.inputScale = IOTool.getEDIFInputScale();
        this.curLibrary = lib;
        this.curTechnology = Schematics.tech;
        this.cellTable = new HashMap();
        this.portsListHead = null;
        this.propertiesListHead = null;
        this.freeNetPorts();
        this.curCell = null;
        this.curCellPage = 0;
        this.curNode = null;
        this.curArc = null;
        this.curPort = null;
        this.curFigureGroup = null;
        this.curArcType = null;
        this.cellRefProto = null;
        this.cellReference = "";
        this.portReference = "";
        this.instanceReference = "";
        this.bundleReference = "";
        this.netReference = "";
        this.propertyReference = "";
        this.nameEntryList = new ArrayList<NameEntry>();
        this.curNameEntry = null;
        this.freePointList();
        this.textHeight = 0;
        this.textJustification = AbstractTextDescriptor.Position.DOWNRIGHT;
        this.textVisible = true;
        this.freeSavedPointList();
        this.sheetXPos = -1;
        this.sheetYPos = -1;
        this.keyStackDepth = 0;
        this.defaultPort = Schematics.tech.wirePinNode.findPortProto("wire");
        this.defaultIconPort = Schematics.tech.wirePinNode.getPort(0);
        this.defaultBusPort = Schematics.tech.busPinNode.findPortProto("bus");
        this.defaultInput = Schematics.tech.offpageNode.findPortProto("y");
        this.defaultOutput = Schematics.tech.offpageNode.findPortProto("a");
        this.equivs = new EDIFEquiv();
        this.netPortRefs = new ArrayList<PortInst>();
        try {
            this.loadEDIF();
        }
        catch (IOException e) {
            System.out.println("line " + this.lineReader.getLineNumber() + ": " + e.getMessage());
            return true;
        }
        if (this.errorCount != 0 || this.warningCount != 0) {
            System.out.println("A total of " + this.errorCount + " errors, and " + this.warningCount + " warnings encountered during load");
        }
        if (Job.getUserInterface().getCurrentCell(this.curLibrary) == null && this.curLibrary.getCells().hasNext()) {
            Job.getUserInterface().setCurrentCell(this.curLibrary, this.curLibrary.getCells().next());
        }
        return false;
    }

    private void loadEDIF() throws IOException {
        String token;
        int saveStack = -1;
        while ((token = this.getKeyword()) != null) {
            EDIFKEY key = edifKeys.get(TextUtils.canonicString(token));
            if (key == null) {
                System.out.println("Warning, line " + this.lineReader.getLineNumber() + ": unknown keyword <" + token + ">");
                ++this.warningCount;
                this.keyStack[this.keyStackDepth++] = this.curKeyword;
                this.curKeyword = this.KUNKNOWN;
                continue;
            }
            if (key.stateArray != null && this.curKeyword != this.KUNKNOWN) {
                boolean found = false;
                for (int i = 0; i < key.stateArray.length; ++i) {
                    if (key.stateArray[i] != this.curKeyword) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    System.out.println("Error, line " + this.lineReader.getLineNumber() + ": illegal state (" + this.curKeyword.name + ") for keyword <" + token + ">");
                    ++this.errorCount;
                }
            }
            this.keyStack[this.keyStackDepth++] = this.curKeyword;
            this.curKeyword = key;
            if (saveStack >= this.keyStackDepth) {
                saveStack = -1;
                this.ignoreBlock = false;
            }
            if (!this.ignoreBlock) {
                key.push();
            }
            if (!this.ignoreBlock || saveStack != -1) continue;
            saveStack = this.keyStackDepth;
        }
        if (this.curKeyword != this.KINIT) {
            System.out.println("Error, line " + this.lineReader.getLineNumber() + ": unexpected end-of-file encountered");
            ++this.errorCount;
        }
    }

    private String getKeyword() throws IOException {
        String p;
        while ((p = this.getToken('\u0000')) != null && !p.equals("(")) {
            if (p.equals(")")) {
                if (this.keyStackDepth == 0) continue;
                if (!this.ignoreBlock) {
                    this.curKeyword.pop();
                }
                if (this.keyStackDepth != 0) {
                    this.curKeyword = this.keyStack[--this.keyStackDepth];
                    continue;
                }
                this.curKeyword = this.KINIT;
                continue;
            }
            if (!TextUtils.isANumber(this.inputBuffer)) continue;
            this.processInteger(TextUtils.atoi(this.inputBuffer));
        }
        return this.getToken('\u0000');
    }

    private void processInteger(int value) {
        if (this.keyStackDepth > 0 && !this.ignoreBlock) {
            if (this.curKeyword == this.KARRAY) {
                if (this.arrayXVal == 0) {
                    this.arrayXVal = value;
                } else if (this.arrayYVal == 0) {
                    this.arrayYVal = value;
                }
            } else if (this.curKeyword == this.KMEMBER) {
                if (this.memberXVal == -1) {
                    this.memberXVal = value;
                } else if (this.memberYVal == -1) {
                    this.memberYVal = value;
                }
            }
        }
    }

    private void makeNetPort() {
        EDIFNetPort netPort = new EDIFNetPort();
        if (this.netPortListHead == null) {
            this.netPortListHead = netPort;
        } else {
            this.netPortListTail.next = netPort;
        }
        this.netPortListTail = netPort;
        netPort.next = null;
        netPort.ni = null;
        netPort.pp = null;
        netPort.member = 0;
    }

    private void freeNetPorts() {
        this.netPortListTail = null;
        this.netPortListHead = null;
    }

    private boolean positionToNextToken() throws IOException {
        while (true) {
            if (this.inputBuffer == null) {
                return true;
            }
            if (this.inputBufferPos >= this.inputBuffer.length()) {
                this.inputBuffer = this.lineReader.readLine();
                if (this.inputBuffer == null) {
                    return true;
                }
                this.inputBufferPos = 0;
                continue;
            }
            char chr = this.inputBuffer.charAt(this.inputBufferPos);
            if (chr != ' ' && chr != '\t') break;
            ++this.inputBufferPos;
        }
        return false;
    }

    private void getDelimeter(char delim) throws IOException {
        if (this.positionToNextToken()) {
            throw new IOException("Unexpected end-of-file");
        }
        char chr = this.inputBuffer.charAt(this.inputBufferPos);
        if (chr != delim) {
            throw new IOException("Illegal delimeter");
        }
        ++this.inputBufferPos;
    }

    private String getToken(char iDelim) throws IOException {
        char delim = iDelim;
        if (delim == '\u0000' && this.positionToNextToken()) {
            return null;
        }
        StringBuffer sBuf = new StringBuffer();
        char chr = this.inputBuffer.charAt(this.inputBufferPos);
        if (delim == '\u0000' && chr == '\"') {
            delim = '\"';
            sBuf.append(chr);
            ++this.inputBufferPos;
        }
        while (true) {
            if (this.inputBufferPos >= this.inputBuffer.length()) {
                this.inputBuffer = this.lineReader.readLine();
                if (this.inputBuffer == null) {
                    if (delim != '\u0000') break;
                    return sBuf.toString();
                }
                this.inputBufferPos = 0;
                continue;
            }
            if (delim == '\u0000') {
                chr = this.inputBuffer.charAt(this.inputBufferPos);
                switch (chr) {
                    case '\t': 
                    case ' ': {
                        ++this.inputBufferPos;
                        return sBuf.toString();
                    }
                    case '(': 
                    case ')': {
                        if (sBuf.length() == 0) {
                            sBuf.append(chr);
                            ++this.inputBufferPos;
                        }
                        return sBuf.toString();
                    }
                }
                sBuf.append(chr);
                ++this.inputBufferPos;
                continue;
            }
            chr = this.inputBuffer.charAt(this.inputBufferPos);
            if (chr == delim) {
                if (delim != iDelim) {
                    sBuf.append(chr);
                }
                ++this.inputBufferPos;
                return sBuf.toString();
            }
            sBuf.append(chr);
            ++this.inputBufferPos;
        }
        return null;
    }

    private void makeFigure() throws IOException {
        if (this.positionToNextToken()) {
            return;
        }
        if (this.inputBuffer.charAt(this.inputBufferPos) == '(') {
            return;
        }
        String layer = this.getToken('\u0000');
        for (NameEntry nt : this.nameEntryList) {
            if (!nt.original.equalsIgnoreCase(layer)) continue;
            this.curFigureGroup = nt.node;
            this.curArcType = nt.arc;
            this.textHeight = nt.textHeight;
            this.textJustification = nt.justification;
            this.textVisible = nt.visible;
            this.curNameEntry = nt;
            return;
        }
        NameEntry nt = new NameEntry();
        this.nameEntryList.add(nt);
        nt.original = layer;
        nt.replace = nt.original;
        this.curFigureGroup = nt.node = Artwork.tech.boxNode;
        this.curArcType = nt.arc = Schematics.tech.wire_arc;
        this.textHeight = nt.textHeight = 0;
        this.textJustification = nt.justification = AbstractTextDescriptor.Position.DOWNRIGHT;
        this.textVisible = nt.visible = true;
        this.curNameEntry = nt;
    }

    private boolean checkName() throws IOException {
        this.positionToNextToken();
        char chr = this.inputBuffer.charAt(this.inputBufferPos);
        if (chr != '(' && chr != ')') {
            String aName = this.getToken('\u0000');
            this.objectName = aName.startsWith("&") ? aName.substring(1) : aName;
            return true;
        }
        return false;
    }

    private void freePointList() {
        this.curPoints = new ArrayList<Point2D>();
    }

    private void freeSavedPointList() {
        this.saveTextPoints = new ArrayList<Point2D>();
    }

    private double getNumber() throws IOException {
        String value = this.getToken('\u0000');
        if (value == null) {
            throw new IOException("No integer value");
        }
        if (value.startsWith("(")) {
            value = this.getToken('\u0000');
            if (value == null) {
                throw new IOException("Illegal number value");
            }
            if (!value.equalsIgnoreCase("e")) {
                throw new IOException("Illegal number value");
            }
            value = this.getToken('\u0000');
            if (value == null) {
                throw new IOException("No matissa value");
            }
            double matissa = TextUtils.atof(value);
            value = this.getToken('\u0000');
            if (value == null) {
                throw new IOException("No exponent value");
            }
            double exponent = TextUtils.atof(value);
            this.getDelimeter(')');
            return matissa * Math.pow(10.0, exponent);
        }
        return TextUtils.atof(value);
    }

    private NodeInst placePin(NodeProto np, double cX, double cY, double sX, double sY, Orientation orient, Cell parent) {
        Iterator<NodeInst> it = parent.getNodes();
        while (it.hasNext()) {
            NodeInst ni = it.next();
            if (ni.getProto() != np || !ni.getOrient().equals(orient) || ni.getAnchorCenterX() != cX || ni.getAnchorCenterY() != cY) continue;
            return ni;
        }
        NodeInst ni = NodeInst.makeInstance(np, new Point2D.Double(cX, cY), sX, sY, parent, orient, null, 0);
        return ni;
    }

    private double convertTextSize(double textHeight) {
        double i = textHeight / 4.0;
        if (i >= 0.0 && i < 2.0) {
            i = 2.0;
        }
        if (i < 0.0) {
            i = 4.0;
        }
        return i;
    }

    private void makeArc(double[] x, double[] y) {
        NodeInst ni;
        GenMath.MutableDouble[] A = new GenMath.MutableDouble[2];
        GenMath.MutableDouble[] B = new GenMath.MutableDouble[2];
        GenMath.MutableDouble[] C = new GenMath.MutableDouble[2];
        for (int i = 0; i < 2; ++i) {
            A[i] = new GenMath.MutableDouble(0.0);
            B[i] = new GenMath.MutableDouble(0.0);
            C[i] = new GenMath.MutableDouble(0.0);
        }
        double px1 = (x[0] + x[1]) / 2.0;
        double py1 = (y[0] + y[1]) / 2.0;
        double px0 = px1 - (y[0] - py1);
        double py0 = py1 + (x[0] - px1);
        this.equationOfALine(px0, py0, px1, py1, A[0], B[0], C[0]);
        px1 = (x[2] + x[1]) / 2.0;
        py1 = (y[2] + y[1]) / 2.0;
        double px2 = px1 - (y[2] - py1);
        double py2 = py1 + (x[2] - px1);
        this.equationOfALine(px1, py1, px2, py2, A[1], B[1], C[1]);
        Point2D ctr = this.determineIntersection(A, B, C);
        double ixc = ctr.getX();
        double iyc = ctr.getY();
        double dx = ixc - x[0];
        double dy = iyc - y[0];
        double r = Math.sqrt(dx * dx + dy * dy);
        dx = x[0] - ixc;
        dy = y[0] - iyc;
        if (dx == 0.0 && dy == 0.0) {
            System.out.println("Domain error doing arc computation");
            return;
        }
        double a0 = Math.atan2(dy, dx) * 1800.0 / Math.PI;
        if (a0 < 0.0) {
            a0 += 3600.0;
        }
        dx = x[2] - ixc;
        dy = y[2] - iyc;
        if (dx == 0.0 && dy == 0.0) {
            System.out.println("Domain error doing arc computation");
            return;
        }
        double a2 = Math.atan2(dy, dx) * 1800.0 / Math.PI;
        if (a2 < 0.0) {
            a2 += 3600.0;
        }
        double area = x[0] * y[1] + x[1] * y[2] + x[2] * y[0] - y[0] * x[1] - y[1] * x[2] - y[2] * x[0];
        double ar = 0.0;
        double so = 0.0;
        int rot = 0;
        boolean trans = false;
        if (area > 0.0) {
            if (a2 < a0) {
                a2 += 3600.0;
            }
            ar = a2 - a0;
            rot = (int)a0;
            so = (a0 - (double)rot) * Math.PI / 1800.0;
        } else {
            if (a0 > 2700.0) {
                rot = 3600 - (int)a0 + 2700;
                so = (3600.0 - a0 + 2700.0 - (double)rot) * Math.PI / 1800.0;
            } else {
                rot = 2700 - (int)a0;
                so = (2700.0 - a0 - (double)rot) * Math.PI / 1800.0;
            }
            if (a0 < a2) {
                a0 += 3600.0;
            }
            ar = a0 - a2;
            trans = true;
        }
        double sX = r * 2.0;
        double sY = r * 2.0;
        Orientation or = Orientation.fromC(rot, trans);
        if (this.curCellPage > 0) {
            iyc += (double)(this.curCellPage - 1) * 1000.0;
        }
        if ((ni = NodeInst.makeInstance(this.curFigureGroup != null && this.curFigureGroup != Artwork.tech.boxNode ? this.curFigureGroup : Artwork.tech.circleNode, new Point2D.Double(ixc, iyc), sX, sY, this.curCell, or, null, 0)) == null) {
            System.out.println("Error, line " + this.lineReader.getLineNumber() + ": could not create arc");
            ++this.errorCount;
        } else {
            ni.setArcDegrees(so, ar * Math.PI / 1800.0);
        }
    }

    private Point2D determineIntersection(GenMath.MutableDouble[] A, GenMath.MutableDouble[] B, GenMath.MutableDouble[] C) {
        double A2B1;
        double A1B2 = A[0].doubleValue() * B[1].doubleValue();
        if (A1B2 == (A2B1 = A[1].doubleValue() * B[0].doubleValue())) {
            if (C[0].doubleValue() == C[1].doubleValue()) {
                return null;
            }
            return null;
        }
        double A1C2 = A[0].doubleValue() * C[1].doubleValue();
        double A2C1 = A[1].doubleValue() * C[0].doubleValue();
        if (A[0].doubleValue() != 0.0) {
            double Y = (A2C1 - A1C2) / (A1B2 - A2B1);
            double X = -(B[0].doubleValue() * Y + C[0].doubleValue()) / A[0].doubleValue();
            return new Point2D.Double(X, Y);
        }
        double Y = (A1C2 - A2C1) / (A2B1 - A1B2);
        double X = -(B[1].doubleValue() * Y + C[1].doubleValue()) / A[1].doubleValue();
        return new Point2D.Double(X, Y);
    }

    private void equationOfALine(double sx, double sy, double ex, double ey, GenMath.MutableDouble A, GenMath.MutableDouble B, GenMath.MutableDouble C) {
        if (sx == ex) {
            A.setValue(1.0);
            B.setValue(0.0);
            C.setValue(-ex);
        } else if (sy == ey) {
            A.setValue(0.0);
            B.setValue(1.0);
            C.setValue(-ey);
        } else {
            B.setValue(1.0);
            if (sx != 0.0) {
                C.setValue((ey * sx - sy * ex) / (ex - sx));
                A.setValue(-(C.doubleValue() + sy) / sx);
            } else {
                C.setValue((sy * ex - ey * sx) / (sx - ex));
                A.setValue(-(C.doubleValue() + ey) / ex);
            }
        }
    }

    private void nameEDIFArc(ArcInst ai) {
        if (this.isArray) {
            if (this.netReference.length() > 0) {
                ai.newVar("EDIF_name", (Object)this.netReference);
            }
            StringBuffer aName = new StringBuffer();
            for (int iX = 0; iX < this.arrayXVal; ++iX) {
                for (int iY = 0; iY < this.arrayYVal; ++iY) {
                    if (aName.length() > 0) {
                        aName.append(',');
                    }
                    if (this.arrayXVal > 1) {
                        if (this.arrayYVal > 1) {
                            aName.append(this.netName + "[" + iX + "," + iY + "]");
                            continue;
                        }
                        aName.append(this.netName + "[" + iX + "]");
                        continue;
                    }
                    aName.append(this.netName + "[" + iY + "]");
                }
            }
            ai.setName(aName.toString());
        } else {
            if (this.netReference.length() > 0) {
                ai.newVar("EDIF_name", (Object)this.netName);
            }
            if (this.netName.length() > 0) {
                ai.setName(this.netName);
            }
        }
    }

    private List<PortInst> findEDIFPort(Cell cell, double x, double y, ArcProto ap, boolean exactOnly) {
        ArrayList<PortInst> ports = new ArrayList<PortInst>();
        PortInst bestPi = null;
        Point2D.Double pt = new Point2D.Double(x, y);
        double bestDist = Double.MAX_VALUE;
        ArcInst ai = null;
        Iterator<Geometric> sea = cell.searchIterator(new Rectangle2D.Double(x, y, 0.0, 0.0));
        while (sea.hasNext()) {
            Geometric geom = sea.next();
            if (geom instanceof NodeInst) {
                NodeInst ni = (NodeInst)geom;
                Iterator<PortInst> it = ni.getPortInsts();
                while (it.hasNext()) {
                    PortInst pi = it.next();
                    Poly poly = pi.getPoly();
                    if (poly.isInside(pt)) {
                        if (!pi.getPortProto().getBasePort().connectsTo(ap)) continue;
                        ports.add(pi);
                        continue;
                    }
                    double dist = pt.distance(new Point2D.Double(poly.getCenterX(), poly.getCenterY()));
                    if (bestPi != null && !(dist < bestDist)) continue;
                    bestDist = dist;
                    bestPi = pi;
                }
                continue;
            }
            ArcInst oAi = (ArcInst)geom;
            if (oAi.getProto().getTechnology() != Schematics.tech) continue;
            ai = oAi;
        }
        if (ports.size() == 0 && bestPi != null && !exactOnly) {
            PrimitiveNode np = ap.findPinProto();
            NodeInst ni = this.placePin(np, x, y, np.getDefWidth(), np.getDefHeight(), Orientation.IDENT, cell);
            PortInst head = ni.getOnlyPortInst();
            ArcInst.makeInstance(ap, ap.getDefaultWidth(), head, bestPi);
            ports.add(head);
        }
        if (ports.size() == 0 && ai != null) {
            ArcProto nAp = ai.getProto();
            PrimitiveNode np = nAp.findPinProto();
            if (np == null) {
                return ports;
            }
            PrimitivePort pp = np.getPort(0);
            if (!pp.getBasePort().connectsTo(ap)) {
                return ports;
            }
            PortInst fPi = ai.getHeadPortInst();
            EPoint fPt = ai.getHeadLocation();
            PortInst tPi = ai.getTailPortInst();
            EPoint tPt = ai.getTailLocation();
            NodeInst ni = this.placePin(np, x, y, np.getDefWidth(), np.getDefHeight(), Orientation.IDENT, cell);
            if (ni == null) {
                System.out.println("Cannot create splitting pin");
                return ports;
            }
            PortInst pi = ni.findPortInstFromProto(pp);
            ports.add(pi);
            ArcInst ar1 = ArcInst.makeInstance(nAp, nAp.getDefaultWidth(), fPi, pi, fPt, pt, null);
            ArcInst ar2 = ArcInst.makeInstance(nAp, nAp.getDefaultWidth(), pi, tPi, pt, tPt, null);
            if (ar1 == null || ar2 == null) {
                System.out.println("Error creating the split arc parts");
                return ports;
            }
            ar1.copyPropertiesFrom(ai);
            if (ai.isHeadNegated()) {
                ar1.setHeadNegated(true);
            }
            if (ai.isTailNegated()) {
                ar2.setTailNegated(true);
            }
            ai.kill();
        }
        return ports;
    }

    private void checkBusNames(ArcInst ai, String base, HashSet<ArcInst> seenArcs) {
        String aName;
        if (ai.getProto() != Schematics.tech.bus_arc && (aName = ai.getName()).startsWith(base) && aName.length() > base.length() && TextUtils.isDigit(aName.charAt(base.length()))) {
            String newName = base + "[" + aName.substring(base.length()) + "]";
            ai.setName(newName);
        }
        seenArcs.add(ai);
        for (int i = 0; i < 2; ++i) {
            NodeInst ni = ai.getPortInst(i).getNodeInst();
            if (ni.getFunction() != PrimitiveNode.Function.PIN) continue;
            Iterator<Connection> it = ni.getConnections();
            while (it.hasNext()) {
                Connection oCon = it.next();
                ArcInst pAi = oCon.getArc();
                if (seenArcs.contains(pAi)) continue;
                this.checkBusNames(pAi, base, seenArcs);
            }
        }
    }

    private void doPoly() {
        NodeInst ni;
        double cY;
        if (this.curPoints.size() == 0) {
            return;
        }
        Point2D p0 = this.curPoints.get(0);
        double lX = p0.getX();
        double lY = p0.getY();
        double hX = lX;
        double hY = lY;
        for (int i = 1; i < this.curPoints.size(); ++i) {
            Point2D point = this.curPoints.get(i);
            if (lX > point.getX()) {
                lX = point.getX();
            }
            if (hX < point.getX()) {
                hX = point.getX();
            }
            if (lY > point.getY()) {
                lY = point.getY();
            }
            if (!(hY < point.getY())) continue;
            hY = point.getY();
        }
        NodeProto np = this.curFigureGroup;
        if (this.curFigureGroup == null || this.curFigureGroup == Artwork.tech.boxNode) {
            np = this.curKeyword == this.KPOLYGON ? Artwork.tech.closedPolygonNode : Artwork.tech.openedPolygonNode;
        }
        double sX = hX - lX;
        double sY = hY - lY;
        double cX = (hX + lX) / 2.0;
        double yPos = cY = (hY + lY) / 2.0;
        if (this.curCellPage > 0) {
            yPos += (double)(this.curCellPage - 1) * 1000.0;
        }
        if ((ni = NodeInst.makeInstance(np, new Point2D.Double(cX, yPos), sX, sY, this.curCell, this.curOrientation, null, 0)) == null) {
            System.out.println("Error, line " + this.lineReader.getLineNumber() + ": could not create polygon");
            ++this.errorCount;
        } else {
            EPoint[] trace = new EPoint[this.curPoints.size()];
            for (int i = 0; i < this.curPoints.size(); ++i) {
                Point2D point = this.curPoints.get(i);
                trace[i] = new EPoint(point.getX() - cX, point.getY() - cY);
            }
            ni.newVar(NodeInst.TRACE, (Object)trace);
        }
        this.freePointList();
    }

    private class KeyViewType
    extends EDIFKEY {
        private KeyViewType() {
            super("viewType");
        }

        protected void push() throws IOException {
            String aName = EDIF.this.getToken('\u0000');
            String view = "";
            if (aName.equalsIgnoreCase("BEHAVIOR")) {
                EDIF.this.activeView = VBEHAVIOR;
            } else if (aName.equalsIgnoreCase("DOCUMENT")) {
                EDIF.this.activeView = VDOCUMENT;
            } else if (aName.equalsIgnoreCase("GRAPHIC")) {
                EDIF.this.activeView = VGRAPHIC;
            } else if (aName.equalsIgnoreCase("LOGICMODEL")) {
                EDIF.this.activeView = VLOGICMODEL;
            } else if (aName.equalsIgnoreCase("MASKLAYOUT")) {
                EDIF.this.activeView = VMASKLAYOUT;
                view = "lay";
            } else if (aName.equalsIgnoreCase("NETLIST")) {
                EDIF.this.activeView = VNETLIST;
                view = "sch";
            } else if (aName.equalsIgnoreCase("PCBLAYOUT")) {
                EDIF.this.activeView = VPCBLAYOUT;
            } else if (aName.equalsIgnoreCase("SCHEMATIC")) {
                EDIF.this.activeView = VSCHEMATIC;
                view = "sch";
            } else if (aName.equalsIgnoreCase("STRANGER")) {
                EDIF.this.activeView = VSTRANGER;
            } else if (aName.equalsIgnoreCase("SYMBOLIC")) {
                EDIF.this.activeView = VSYMBOLIC;
            }
            if (EDIF.this.activeView == VMASKLAYOUT || EDIF.this.activeView == VGRAPHIC || EDIF.this.activeView == VNETLIST || EDIF.this.activeView == VSCHEMATIC) {
                Cell proto = null;
                Iterator<Cell> it = EDIF.this.curLibrary.getCells();
                while (it.hasNext()) {
                    Cell cell = it.next();
                    if (!cell.getName().equalsIgnoreCase(EDIF.this.cellName) || !cell.getView().getAbbreviation().equalsIgnoreCase(view)) continue;
                    proto = cell;
                    break;
                }
                if (proto == null) {
                    String cname = EDIF.this.cellName + "{" + view + "}";
                    proto = Cell.makeInstance(EDIF.this.curLibrary, cname);
                    if (proto == null) {
                        throw new IOException("Error creating cell");
                    }
                    EDIF.this.builtCells.add(proto);
                } else if (!EDIF.this.builtCells.contains(proto)) {
                    EDIF.this.ignoreBlock = true;
                }
                EDIF.this.curCell = proto;
                EDIF.this.curCellPage = 0;
            } else {
                EDIF.this.curCell = null;
            }
            NameEntry nt = new NameEntry();
            nt.original = EDIF.this.cellReference;
            nt.replace = EDIF.this.cellName;
            EDIF.this.cellTable.put(EDIF.this.cellReference, nt);
        }
    }

    private class ViewRef
    extends EDIFKEY {
        private ViewRef() {
            super("viewRef");
        }

        protected void push() throws IOException {
            EDIF.this.viewRef = EDIF.this.getToken('\u0000');
        }

        protected void pop() {
            EDIF.this.viewRef = null;
        }
    }

    private class KeyView
    extends EDIFKEY {
        private KeyView() {
            super("view");
        }

        protected void push() throws IOException {
            EDIF.this.activeView = VNULL;
        }

        protected void pop() {
            if (EDIF.this.curVendor == EVVIEWLOGIC && EDIF.this.activeView != VNETLIST) {
                HashSet seenArcs = new HashSet();
                Iterator<ArcInst> it = EDIF.this.curCell.getArcs();
                while (it.hasNext()) {
                    ArcInst ai = it.next();
                    if (seenArcs.contains(ai) || ai.getProto() != Schematics.tech.bus_arc) continue;
                    String baseName = ai.getName();
                    int openPos = baseName.indexOf(91);
                    if (openPos >= 0) {
                        baseName = baseName.substring(0, openPos);
                    }
                    EDIF.this.checkBusNames(ai, baseName, seenArcs);
                }
            }
            EDIF.this.portsListHead = null;
        }
    }

    private class KeyUnit
    extends EDIFKEY {
        private KeyUnit() {
            super("unit");
        }

        protected void push() throws IOException {
            String type = EDIF.this.getToken('\u0000');
            if (EDIF.this.keyStack[EDIF.this.keyStackDepth - 1] == EDIF.this.KSCALE && type.equalsIgnoreCase("DISTANCE")) {
                EDIF.this.inputScale = 1.0;
                EDIF.this.inputScale *= IOTool.getEDIFInputScale();
            }
        }
    }

    private class KeyTrue
    extends EDIFKEY {
        private KeyTrue() {
            super("true");
        }

        protected void push() throws IOException {
            if (EDIF.this.keyStackDepth > 1 && EDIF.this.keyStack[EDIF.this.keyStackDepth - 1] == EDIF.this.KVISIBLE) {
                EDIF.this.textVisible = true;
                if (EDIF.this.curNameEntry != null) {
                    EDIF.this.curNameEntry.visible = true;
                }
            }
        }
    }

    private class KeyTransform
    extends EDIFKEY {
        private KeyTransform() {
            super("transform");
        }

        protected void pop() {
            if (EDIF.this.keyStackDepth <= 1 || EDIF.this.keyStack[EDIF.this.keyStackDepth - 1] != EDIF.this.KINSTANCE) {
                EDIF.this.freePointList();
                return;
            }
            double instPtX = 0.0;
            double instPtY = 0.0;
            int instCount = EDIF.this.curPoints.size();
            if (instCount > 0) {
                Point2D point = (Point2D)EDIF.this.curPoints.get(0);
                instPtX = point.getX();
                instPtY = point.getY();
            }
            if (instCount == 0) {
                instCount = 1;
            }
            AffineTransform rot = EDIF.this.curOrientation.pureRotate();
            if (instCount == 1 && EDIF.this.cellRefProto != null) {
                for (int iX = 0; iX < EDIF.this.arrayXVal; ++iX) {
                    double lX = instPtX + (double)iX * EDIF.this.deltaPointXX;
                    double lY = instPtY + (double)iX * EDIF.this.deltaPointXY;
                    for (int iY = 0; iY < EDIF.this.arrayYVal; ++iY) {
                        double yPos = lY;
                        if (EDIF.this.curCellPage > 0) {
                            yPos += (double)(EDIF.this.curCellPage - 1) * 1000.0;
                        }
                        Orientation orient = EDIF.this.curOrientation.concatenate(Orientation.fromAngle(EDIF.this.cellRefProtoRotation * 10));
                        NodeInst ni = NodeInst.makeInstance(EDIF.this.cellRefProto, new Point2D.Double(lX, yPos), EDIF.this.cellRefProto.getDefWidth(), EDIF.this.cellRefProto.getDefHeight(), EDIF.this.curCell, orient, null, EDIF.this.cellRefProtoTechBits);
                        EDIF.this.curNode = ni;
                        if (ni == null) {
                            System.out.println("Error, line " + EDIF.this.lineReader.getLineNumber() + ": could not create instance");
                            EDIF.this.errorCount++;
                            iX = EDIF.this.arrayXVal;
                            iY = EDIF.this.arrayYVal;
                        } else if (EDIF.this.cellRefProto instanceof Cell && ((Cell)EDIF.this.cellRefProto).isWantExpanded()) {
                            ni.setExpanded();
                        }
                        if (EDIF.this.curGeometryType == GPIN && lX == 0.0 && lY == 0.0) {
                            PortProto ppt;
                            String pName = EDIF.this.portName;
                            int dup = 0;
                            while ((ppt = EDIF.this.curCell.findPortProto(pName)) != null) {
                                pName = EDIF.this.portName + "_" + (dup + 1);
                                ++dup;
                            }
                            iX = EDIF.this.arrayXVal;
                            iY = EDIF.this.arrayYVal;
                            PortInst pi = ni.findPortInstFromProto(EDIF.this.defaultIconPort);
                            ppt = Export.newInstance(EDIF.this.curCell, pi, pName);
                            if (ppt == null) {
                                System.out.println("Error, line " + EDIF.this.lineReader.getLineNumber() + ": could not create port <" + pName + ">");
                                EDIF.this.errorCount++;
                            } else {
                                EDIFPort ePort = EDIF.this.portsListHead;
                                while (ePort != null) {
                                    if (ePort.reference.equalsIgnoreCase(EDIF.this.portReference)) {
                                        ((Export)ppt).setCharacteristic(ePort.direction);
                                        break;
                                    }
                                    ePort = ePort.next;
                                }
                            }
                        } else if (EDIF.this.instanceReference.length() > 0) {
                            Variable.Key varKey;
                            String nodeName = EDIF.this.instanceReference;
                            if (!(EDIF.this.arrayXVal <= 1 && EDIF.this.arrayYVal <= 1 || EDIF.this.deltaPointXX == 0.0 && EDIF.this.deltaPointXY == 0.0 && EDIF.this.deltaPointYX == 0.0 && EDIF.this.deltaPointYY == 0.0)) {
                                if (EDIF.this.arrayXVal > 1) {
                                    nodeName = EDIF.this.arrayYVal > 1 ? EDIF.this.instanceReference + "[" + iX + "," + iY + "]" : EDIF.this.instanceReference + "[" + iX + "]";
                                } else if (EDIF.this.arrayYVal > 1) {
                                    nodeName = EDIF.this.instanceReference + "[" + iY + "]";
                                }
                            }
                            if (EDIF.this.arrayXVal > 1 || EDIF.this.arrayYVal > 1) {
                                String baseName = iX + ":" + (EDIF.this.deltaPointXX == 0.0 && EDIF.this.deltaPointYX == 0.0 ? EDIF.this.arrayXVal - 1 : iX) + ":" + EDIF.this.arrayXVal + " " + iY + ":" + (EDIF.this.deltaPointXY == 0.0 && EDIF.this.deltaPointYY == 0.0 ? EDIF.this.arrayYVal - 1 : iY) + ":" + EDIF.this.arrayYVal;
                                ni.newVar("EDIF_array", (Object)baseName);
                            }
                            if (EDIF.this.instanceReference.equalsIgnoreCase(EDIF.this.instanceName)) {
                                ni.setName(nodeName);
                                varKey = NodeInst.NODE_NAME;
                            } else {
                                if (iX == 0 && iY == 0) {
                                    ni.setName(EDIF.this.instanceName);
                                }
                                Variable var = ni.newVar("EDIF_name", (Object)nodeName);
                                varKey = var.getKey();
                            }
                            if (EDIF.this.saveTextPoints.size() != 0) {
                                Point2D sP0 = (Point2D)EDIF.this.saveTextPoints.get(0);
                                double xOff = sP0.getX() - ni.getTrueCenterX();
                                double yOff = sP0.getY() - ni.getTrueCenterY();
                                TextDescriptor td = ni.getTextDescriptor(varKey);
                                td = td.withRelSize(EDIF.this.convertTextSize(EDIF.this.saveTextHeight)).withPos(EDIF.this.saveTextJustification).withOff(xOff, yOff);
                                ni.setTextDescriptor(varKey, td);
                            }
                        }
                        if (EDIF.this.deltaPointYX == 0.0 && EDIF.this.deltaPointYY == 0.0) break;
                        lX += EDIF.this.deltaPointYX;
                        lY += EDIF.this.deltaPointYY;
                    }
                    if (EDIF.this.deltaPointXX == 0.0 && EDIF.this.deltaPointXY == 0.0) break;
                }
            }
            EDIF.this.freePointList();
        }
    }

    private class KeyTextHeight
    extends EDIFKEY {
        private KeyTextHeight() {
            super("textHeight");
        }

        protected void push() throws IOException {
            String val = EDIF.this.getToken('\u0000');
            EDIF.this.textHeight = (int)((double)TextUtils.atoi(val) * EDIF.this.inputScale);
            if (EDIF.this.curNameEntry != null) {
                EDIF.this.curNameEntry.textHeight = EDIF.this.textHeight;
            }
        }
    }

    private class KeyTechnology
    extends EDIFKEY {
        private KeyTechnology() {
            super("technology");
        }

        protected void pop() {
            Foundry foundry = EDIF.this.curTechnology.getSelectedFoundry();
            Iterator<Layer> it = EDIF.this.curTechnology.getLayers();
            while (it.hasNext()) {
                Layer layer = it.next();
                String gdsLayer = foundry.getGDSLayer(layer);
                if (gdsLayer == null || gdsLayer.length() == 0) continue;
                boolean found = false;
                for (NameEntry nt : EDIF.this.nameEntryList) {
                    if (!nt.replace.equalsIgnoreCase(layer.getName())) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                NameEntry nt = new NameEntry();
                nt.original = "layer_" + gdsLayer;
                nt.replace = layer.getName();
                EDIF.this.curFigureGroup = (nt.node = Artwork.tech.boxNode);
                EDIF.this.curArcType = (nt.arc = Schematics.tech.wire_arc);
                EDIF.this.textHeight = (nt.textHeight = 0);
                EDIF.this.textJustification = (nt.justification = AbstractTextDescriptor.Position.DOWNRIGHT);
                EDIF.this.textVisible = (nt.visible = true);
            }
            for (NameEntry nt : EDIF.this.nameEntryList) {
                String nodeName = nt.replace + "-node";
                PrimitiveNode np = EDIF.this.curTechnology.findNodeProto(nodeName);
                if (np == null) {
                    np = Artwork.tech.boxNode;
                }
                nt.node = np;
                nt.arc = EDIF.this.curTechnology.findArcProto(nt.replace);
            }
        }
    }

    private class KeySymbol
    extends EDIFKEY {
        private KeySymbol() {
            super("symbol");
        }

        protected void push() throws IOException {
            EDIF.this.activeView = VSYMBOL;
            Cell proto = null;
            Iterator<Cell> it = EDIF.this.curLibrary.getCells();
            while (it.hasNext()) {
                Cell cell = it.next();
                if (!cell.getName().equalsIgnoreCase(EDIF.this.cellName) || cell.getView() != View.ICON) continue;
                proto = cell;
                break;
            }
            if (proto == null) {
                String cname = EDIF.this.cellName + "{ic}";
                proto = Cell.makeInstance(EDIF.this.curLibrary, cname);
                if (proto == null) {
                    throw new IOException("Error creating cell");
                }
                proto.setWantExpanded();
                EDIF.this.builtCells.add(proto);
            } else if (!EDIF.this.builtCells.contains(proto)) {
                EDIF.this.ignoreBlock = true;
            }
            EDIF.this.curCell = proto;
            EDIF.this.curCellPage = 0;
            EDIF.this.curFigureGroup = null;
        }

        protected void pop() {
            EDIF.this.activeView = VNULL;
        }
    }

    private class KeyStringDisplay
    extends EDIFKEY {
        private KeyStringDisplay() {
            super("stringDisplay");
        }

        protected void push() throws IOException {
            EDIF.this.freePointList();
            EDIF.this.curOrientation = OR0;
            EDIF.this.textVisible = true;
            EDIF.this.textJustification = AbstractTextDescriptor.Position.DOWNRIGHT;
            EDIF.this.textHeight = 0;
            EDIF.this.getDelimeter('\"');
            EDIF.this.textString = EDIF.this.getToken('\"');
            if (EDIF.this.textString == null) {
                throw new IOException("Unexpected end-of-file");
            }
            if (EDIF.this.keyStack[EDIF.this.keyStackDepth - 1] != EDIF.this.KRENAME) {
                return;
            }
            EDIF.this.originalName = EDIF.this.textString;
            int kPtr = EDIF.this.keyStackDepth - 2;
            if (EDIF.this.keyStack[EDIF.this.keyStackDepth - 2] == EDIF.this.KARRAY) {
                kPtr = EDIF.this.keyStackDepth - 3;
            }
            if (EDIF.this.keyStack[kPtr] == EDIF.this.KCELL) {
                EDIF.this.cellName = EDIF.this.originalName;
            } else if (EDIF.this.keyStack[kPtr] == EDIF.this.KPORT) {
                EDIF.this.portName = EDIF.this.originalName;
            } else if (EDIF.this.keyStack[kPtr] == EDIF.this.KINSTANCE) {
                EDIF.this.instanceName = EDIF.this.originalName;
            } else if (EDIF.this.keyStack[kPtr] == EDIF.this.KNET) {
                EDIF.this.netName = EDIF.this.originalName;
            } else if (EDIF.this.keyStack[kPtr] == EDIF.this.KNETBUNDLE) {
                EDIF.this.bundleName = EDIF.this.originalName;
            } else if (EDIF.this.keyStack[kPtr] == EDIF.this.KPROPERTY) {
                EDIF.this.propertyName = EDIF.this.originalName;
            }
        }

        protected void pop() {
            if (EDIF.this.keyStackDepth <= 1) {
                System.out.println("Error, line " + EDIF.this.lineReader.getLineNumber() + ": bad location for \"stringDisplay\"");
                EDIF.this.errorCount++;
            } else if (EDIF.this.keyStack[EDIF.this.keyStackDepth - 1] == EDIF.this.KRENAME) {
                EDIF.this.freeSavedPointList();
                EDIF.this.textString = "";
                EDIF.this.saveTextPoints = EDIF.this.curPoints;
                EDIF.this.curPoints = new ArrayList();
                EDIF.this.saveTextHeight = EDIF.this.textHeight;
                EDIF.this.textHeight = 0;
                EDIF.this.saveTextJustification = EDIF.this.textJustification;
                EDIF.this.textJustification = AbstractTextDescriptor.Position.DOWNRIGHT;
                EDIF.this.curOrientation = OR0;
                EDIF.this.textVisible = true;
            } else if (!(EDIF.this.keyStack[EDIF.this.keyStackDepth - 1] != EDIF.this.KANNOTATE && EDIF.this.keyStack[EDIF.this.keyStackDepth - 1] != EDIF.this.KSTRING || EDIF.this.textString.startsWith("[") || EDIF.this.curPoints.size() == 0)) {
                ArcInst ai = null;
                NodeInst ni = null;
                String key = EDIF.this.propertyReference;
                Point2D p0 = (Point2D)EDIF.this.curPoints.get(0);
                double xOff = 0.0;
                double yOff = 0.0;
                if (EDIF.this.propertyReference.length() > 0 && EDIF.this.curNode != null) {
                    ni = EDIF.this.curNode;
                    xOff = p0.getX() - ni.getAnchorCenterX();
                    yOff = p0.getY() - ni.getAnchorCenterY();
                } else if (EDIF.this.propertyReference.length() > 0 && EDIF.this.curArc != null) {
                    ai = EDIF.this.curArc;
                    xOff = p0.getX() - (ai.getHeadLocation().getX() + ai.getTailLocation().getX()) / 2.0;
                    yOff = p0.getY() - (ai.getHeadLocation().getY() + ai.getTailLocation().getY()) / 2.0;
                } else {
                    double xPos = p0.getX();
                    double yPos = p0.getY();
                    if (EDIF.this.curCellPage > 0) {
                        yPos += (double)(EDIF.this.curCellPage - 1) * 1000.0;
                    }
                    ni = NodeInst.makeInstance(Generic.tech.invisiblePinNode, new Point2D.Double(xPos, yPos), 0.0, 0.0, EDIF.this.curCell);
                    key = "EDIF_annotate";
                }
                if (ni != null || ai != null) {
                    Variable.Key varKey = Variable.newKey(key);
                    double relSize = EDIF.this.convertTextSize(EDIF.this.textHeight);
                    if (ni != null) {
                        TextDescriptor td = TextDescriptor.getNodeTextDescriptor();
                        xOff = p0.getX() - ni.getAnchorCenterX();
                        yOff = p0.getY() - ni.getAnchorCenterY();
                        td = td.withDisplay(EDIF.this.textVisible).withRelSize(relSize).withPos(EDIF.this.textJustification).withOff(xOff, yOff);
                        ni.newVar(varKey, (Object)EDIF.this.textString, td);
                    } else {
                        TextDescriptor td = TextDescriptor.getArcTextDescriptor();
                        xOff = p0.getX() - (ai.getHeadLocation().getX() + ai.getTailLocation().getX()) / 2.0;
                        yOff = p0.getY() - (ai.getHeadLocation().getY() + ai.getTailLocation().getY()) / 2.0;
                        td = td.withDisplay(EDIF.this.textVisible).withRelSize(relSize).withPos(EDIF.this.textJustification).withOff(xOff, yOff);
                        ai.newVar(varKey, (Object)EDIF.this.textString, td);
                    }
                } else {
                    System.out.println("Error, line " + EDIF.this.lineReader.getLineNumber() + ": nothing to attach text to");
                    EDIF.this.errorCount++;
                }
            }
            EDIF.this.freePointList();
            EDIF.this.curNameEntry = null;
            EDIF.this.textVisible = true;
            EDIF.this.textJustification = AbstractTextDescriptor.Position.DOWNRIGHT;
            EDIF.this.textHeight = 0;
        }
    }

    private class KeyString
    extends EDIFKEY {
        private KeyString() {
            super("string");
        }

        protected void push() throws IOException {
            EDIF.this.positionToNextToken();
            char chr = EDIF.this.inputBuffer.charAt(EDIF.this.inputBufferPos);
            if (chr != '(' && chr != ')') {
                String value = EDIF.this.getToken('\u0000');
                if (value == null) {
                    throw new IOException("Unexpected end-of-file");
                }
                EDIF.this.propertyValue = value.substring(1, value.length() - 1);
            }
        }
    }

    private class KeyRename
    extends EDIFKEY {
        private KeyRename() {
            super("rename");
        }

        protected void push() throws IOException {
            String aName = EDIF.this.getToken('\u0000');
            EDIF.this.objectName = aName.startsWith("&") ? aName.substring(1) : aName;
            EDIF.this.positionToNextToken();
            char chr = EDIF.this.inputBuffer.charAt(EDIF.this.inputBufferPos);
            if (chr == '(') {
                EDIF.this.originalName = EDIF.this.objectName;
            } else {
                aName = EDIF.this.getToken('\u0000');
                EDIF.this.originalName = aName.substring(1, aName.length() - 1);
            }
            int kPtr = EDIF.this.keyStackDepth;
            if (EDIF.this.keyStack[EDIF.this.keyStackDepth - 1] == EDIF.this.KNAME) {
                kPtr = EDIF.this.keyStackDepth - 1;
            }
            kPtr = EDIF.this.keyStack[kPtr - 1] == EDIF.this.KARRAY ? (kPtr -= 2) : --kPtr;
            if (EDIF.this.keyStack[kPtr] == EDIF.this.KCELL) {
                EDIF.this.cellReference = EDIF.this.objectName;
                EDIF.this.cellName = EDIF.this.originalName;
            } else if (EDIF.this.keyStack[kPtr] == EDIF.this.KPORT) {
                EDIF.this.portReference = EDIF.this.objectName;
                EDIF.this.portName = EDIF.this.originalName;
            } else if (EDIF.this.keyStack[kPtr] == EDIF.this.KINSTANCE) {
                EDIF.this.instanceReference = EDIF.this.objectName;
                EDIF.this.instanceName = EDIF.this.originalName;
            } else if (EDIF.this.keyStack[kPtr] == EDIF.this.KNETBUNDLE) {
                EDIF.this.bundleReference = EDIF.this.objectName;
                EDIF.this.bundleName = EDIF.this.originalName;
            } else if (EDIF.this.keyStack[kPtr] == EDIF.this.KNET) {
                EDIF.this.netReference = EDIF.this.objectName;
                EDIF.this.netName = EDIF.this.originalName;
            } else if (EDIF.this.keyStack[kPtr] == EDIF.this.KPROPERTY) {
                EDIF.this.propertyReference = EDIF.this.objectName;
                EDIF.this.propertyName = EDIF.this.originalName;
            }
        }
    }

    private class KeyRectangle
    extends EDIFKEY {
        private KeyRectangle() {
            super("rectangle");
        }

        protected void push() throws IOException {
            EDIF.this.freePointList();
            EDIF.this.curOrientation = OR0;
        }

        protected void pop() {
            if (EDIF.this.keyStackDepth > 1 && (EDIF.this.keyStack[EDIF.this.keyStackDepth - 1] == EDIF.this.KPAGESIZE || EDIF.this.keyStack[EDIF.this.keyStackDepth - 1] == EDIF.this.KBOUNDINGBOX)) {
                return;
            }
            if (EDIF.this.curPoints.size() == 2) {
                NodeInst ni;
                Point2D p0 = (Point2D)EDIF.this.curPoints.get(0);
                Point2D p1 = (Point2D)EDIF.this.curPoints.get(1);
                double hX = p1.getX();
                double lX = p0.getX();
                if (p0.getX() > p1.getX()) {
                    lX = p1.getX();
                    hX = p0.getX();
                }
                double hY = p1.getY();
                double lY = p0.getY();
                if (p0.getY() > p1.getY()) {
                    lY = p1.getY();
                    hY = p0.getY();
                }
                double sX = hX - lX;
                double sY = hY - lY;
                double yPos = (lY + hY) / 2.0;
                double xPos = (lX + hX) / 2.0;
                if (EDIF.this.curCellPage > 0) {
                    yPos += (double)(EDIF.this.curCellPage - 1) * 1000.0;
                }
                if ((ni = NodeInst.makeInstance(EDIF.this.curFigureGroup != null ? EDIF.this.curFigureGroup : Artwork.tech.boxNode, new Point2D.Double(xPos, yPos), sX, sY, EDIF.this.curCell, EDIF.this.curOrientation, null, 0)) == null) {
                    System.out.println("Error, line " + EDIF.this.lineReader.getLineNumber() + ": could not create rectangle");
                    EDIF.this.errorCount++;
                } else if (EDIF.this.curFigureGroup == Artwork.tech.openedDottedPolygonNode) {
                    double cX = (p0.getX() + p1.getX()) / 2.0;
                    double cY = (p0.getY() + p1.getY()) / 2.0;
                    EPoint[] pts = new EPoint[]{new EPoint(p0.getX() - cX, p0.getY() - cY), new EPoint(p0.getX() - cX, p1.getY() - cY), new EPoint(p1.getX() - cX, p1.getY() - cY), new EPoint(p1.getX() - cX, p0.getY() - cY), new EPoint(p0.getX() - cX, p0.getY() - cY)};
                    ni.newVar(NodeInst.TRACE, (Object)pts);
                } else if (EDIF.this.curGeometryType == GPIN) {
                    PortProto ppt;
                    double cX = (lX + hX) / 2.0;
                    double cY = (lY + hY) / 2.0;
                    if (EDIF.this.curCellPage > 0) {
                        cY += (double)(EDIF.this.curCellPage - 1) * 1000.0;
                    }
                    if ((ni = EDIF.this.placePin(EDIF.this.cellRefProto, cX, cY, EDIF.this.cellRefProto.getDefWidth(), EDIF.this.cellRefProto.getDefHeight(), EDIF.this.curOrientation, EDIF.this.curCell)) == null) {
                        System.out.println("Error, line " + EDIF.this.lineReader.getLineNumber() + ": could not create pin");
                        EDIF.this.errorCount++;
                    }
                    if ((ppt = EDIF.this.curCell.findPortProto(EDIF.this.objectName)) == null) {
                        PortInst pi = ni.findPortInstFromProto(EDIF.this.defaultIconPort);
                        ppt = Export.newInstance(EDIF.this.curCell, pi, EDIF.this.objectName);
                    }
                    if (ppt == null) {
                        System.out.println("Error, line " + EDIF.this.lineReader.getLineNumber() + ": could not create port <" + EDIF.this.objectName + ">");
                        EDIF.this.errorCount++;
                    }
                }
            }
            EDIF.this.freePointList();
        }
    }

    private class KeyPt
    extends EDIFKEY {
        private KeyPt() {
            super("pt");
        }

        protected void push() throws IOException {
            String xStr = EDIF.this.getToken('\u0000');
            if (xStr == null) {
                throw new IOException("Unexpected end-of-file");
            }
            String yStr = EDIF.this.getToken('\u0000');
            if (yStr == null) {
                throw new IOException("Unexpected end-of-file");
            }
            if (EDIF.this.keyStackDepth > 1 && EDIF.this.keyStack[EDIF.this.keyStackDepth - 1] == EDIF.this.KDELTA) {
                double x = TextUtils.atof(xStr) * EDIF.this.inputScale;
                double y = TextUtils.atof(yStr) * EDIF.this.inputScale;
                if (EDIF.this.curOrientation == OR90) {
                    double s = x;
                    x = -y;
                    y = s;
                } else if (EDIF.this.curOrientation == OR180) {
                    x = -x;
                    y = -y;
                } else if (EDIF.this.curOrientation == OR270) {
                    double s = x;
                    x = y;
                    y = -s;
                } else if (EDIF.this.curOrientation == OMY) {
                    x = -x;
                } else if (EDIF.this.curOrientation == OMX) {
                    y = -y;
                } else if (EDIF.this.curOrientation == OMYR90) {
                    double s = y;
                    y = -x;
                    x = -s;
                } else if (EDIF.this.curOrientation == OMXR90) {
                    double s = x;
                    x = y;
                    y = s;
                }
                if (!EDIF.this.deltaPointsSet) {
                    EDIF.this.deltaPointXX = x;
                    EDIF.this.deltaPointXY = y;
                } else {
                    EDIF.this.deltaPointYX = x;
                    EDIF.this.deltaPointYY = y;
                }
                EDIF.this.deltaPointsSet = true;
            } else {
                Point2D.Double point = new Point2D.Double(TextUtils.atof(xStr) * EDIF.this.inputScale, TextUtils.atof(yStr) * EDIF.this.inputScale);
                EDIF.this.curPoints.add(point);
            }
        }
    }

    private class KeyProperty
    extends EDIFKEY {
        private KeyProperty() {
            super("property");
        }

        protected void push() throws IOException {
            EDIF.this.propertyReference = "";
            EDIF.this.objectName = "";
            EDIF.this.originalName = "";
            EDIF.this.propertyValue = null;
            if (EDIF.this.checkName()) {
                EDIF.this.propertyReference = EDIF.this.objectName;
                EDIF.this.propertyName = EDIF.this.objectName;
            }
        }

        protected void pop() throws IOException {
            Cell np = null;
            if (EDIF.this.keyStack[EDIF.this.keyStackDepth - 1] == EDIF.this.KINTERFACE) {
                String desiredName = EDIF.this.cellName + "{sch}";
                np = EDIF.this.curLibrary.findNodeProto(desiredName);
                if (np == null) {
                    np = Cell.makeInstance(EDIF.this.curLibrary, desiredName);
                    if (np == null) {
                        throw new IOException("Error creating cell");
                    }
                    EDIF.this.builtCells.add(np);
                    np.newVar(EDIF.this.propertyReference, EDIF.this.propertyValue);
                }
            } else if (EDIF.this.keyStack[EDIF.this.keyStackDepth - 1] == EDIF.this.KINSTANCE || EDIF.this.keyStack[EDIF.this.keyStackDepth - 1] == EDIF.this.KNET || EDIF.this.keyStack[EDIF.this.keyStackDepth - 1] == EDIF.this.KPORT) {
                EDIFProperty property = new EDIFProperty();
                property.next = EDIF.this.propertiesListHead;
                EDIF.this.propertiesListHead = property;
                property.name = "ATTR_" + EDIF.this.propertyReference;
                property.val = EDIF.this.propertyValue;
            }
            EDIF.this.propertyReference = "";
            EDIF.this.freeSavedPointList();
        }
    }

    private class KeyProgram
    extends EDIFKEY {
        private KeyProgram() {
            super("program");
        }

        protected void push() throws IOException {
            String program = EDIF.this.getToken('\u0000');
            if (program.substring(1).startsWith("VIEWlogic")) {
                EDIF.this.curVendor = EVVIEWLOGIC;
            } else if (program.substring(1).startsWith("edifout")) {
                EDIF.this.curVendor = EVCADENCE;
            }
        }
    }

    private class KeyPortRef
    extends EDIFKEY {
        private KeyPortRef() {
            super("portRef");
        }

        protected void push() throws IOException {
            EDIF.this.portReference = "";
            EDIF.this.instanceReference = "";
            if (EDIF.this.checkName()) {
                EDIF.this.portReference = EDIF.this.objectName;
            }
            EDIF.this.makeNetPort();
        }

        protected void pop() {
            NodeInst fNi = EDIF.this.curNode;
            PortProto fPp = EDIF.this.curPort;
            if (EDIF.this.portReference.length() > 0) {
                Iterator<Cell> it;
                ArcProto ap = Generic.tech.unrouted_arc;
                NodeInst ni = null;
                PortProto pp = null;
                if (EDIF.this.instanceReference.length() > 0) {
                    String nodeName = EDIF.this.instanceReference;
                    if (EDIF.this.activeView == VNETLIST) {
                        it = EDIF.this.curLibrary.getCells();
                        while (it.hasNext()) {
                            Cell cell = it.next();
                            if (!cell.getName().equalsIgnoreCase(EDIF.this.cellName)) continue;
                            Iterator<NodeInst> nIt = cell.getNodes();
                            while (nIt.hasNext()) {
                                NodeInst oNi = nIt.next();
                                Variable var = oNi.getVar("EDIF_name");
                                if (var != null && var.getPureValue(-1).equalsIgnoreCase(nodeName)) {
                                    ni = oNi;
                                    break;
                                }
                                String name = oNi.getName();
                                if (!name.equalsIgnoreCase(nodeName)) continue;
                                ni = oNi;
                                break;
                            }
                            if (ni == null) continue;
                            break;
                        }
                        if (ni == null) {
                            System.out.println("error, line " + EDIF.this.lineReader.getLineNumber() + ": could not locate netlist node (" + nodeName + ")");
                            return;
                        }
                    } else {
                        Iterator<NodeInst> nIt = EDIF.this.curCell.getNodes();
                        while (nIt.hasNext()) {
                            NodeInst oNi = nIt.next();
                            Variable var = oNi.getVar("EDIF_name");
                            if (var != null && var.getPureValue(-1).equalsIgnoreCase(nodeName)) {
                                ni = oNi;
                                break;
                            }
                            String name = oNi.getName();
                            if (!name.equalsIgnoreCase(nodeName)) continue;
                            ni = oNi;
                            break;
                        }
                        if (ni == null) {
                            System.out.println("error, line " + EDIF.this.lineReader.getLineNumber() + ": could not locate schematic node '" + nodeName + "' in " + EDIF.this.curCell);
                            return;
                        }
                        ap = !EDIF.this.isArray ? Schematics.tech.wire_arc : Schematics.tech.bus_arc;
                    }
                    if ((pp = ni.getProto().findPortProto(EDIF.this.portReference)) == null) {
                        System.out.println("error, line " + EDIF.this.lineReader.getLineNumber() + ": could not locate port (" + EDIF.this.portReference + ") on node (" + nodeName + ")");
                        return;
                    }
                    EDIF.this.curNode = ni;
                    EDIF.this.curPort = pp;
                    Cell np = ni.getParent();
                    EDIF.this.netPortRefs.add(ni.findPortInstFromProto(pp));
                    if (EDIF.this.activeView == VNETLIST && ni != null) {
                        Poly portPoly = ni.findPortInstFromProto(pp).getPoly();
                        double hX = portPoly.getCenterX();
                        double hY = portPoly.getCenterY();
                        double lX = hX;
                        double lY = hY;
                        if (pp.getCharacteristic() == PortCharacteristic.IN) {
                            lX = hX - 1.0;
                        } else if (pp.getCharacteristic() == PortCharacteristic.BIDIR) {
                            lY = hY - 1.0;
                        } else if (pp.getCharacteristic() == PortCharacteristic.OUT) {
                            lX = hX + 1.0;
                        }
                        ArcProto lAp = Schematics.tech.bus_arc;
                        PortProto lPp = EDIF.this.defaultBusPort;
                        NodeInst lNi = null;
                        if (EDIF.this.isArray) {
                            lNi = EDIF.this.placePin(Schematics.tech.busPinNode, (lX + hX) / 2.0, (lY + hY) / 2.0, hX - lX, hY - lY, Orientation.IDENT, np);
                            if (lNi == null) {
                                System.out.println("error, line " + EDIF.this.lineReader.getLineNumber() + ": could not create bus pin");
                                return;
                            }
                        } else {
                            lNi = EDIF.this.placePin(Schematics.tech.wirePinNode, (lX + hX) / 2.0, (lY + hY) / 2.0, hX - lX, hY - lY, Orientation.IDENT, np);
                            if (lNi == null) {
                                System.out.println("error, line " + EDIF.this.lineReader.getLineNumber() + ": could not create wire pin");
                                return;
                            }
                            lPp = EDIF.this.defaultPort;
                            lAp = Schematics.tech.wire_arc;
                        }
                        PortInst head = lNi.findPortInstFromProto(lPp);
                        PortInst tail = ni.findPortInstFromProto(pp);
                        EDIF.this.curArc = ArcInst.makeInstance(lAp, lAp.getDefaultWidth(), head, tail);
                        if (EDIF.this.curArc == null) {
                            System.out.println("error, line " + EDIF.this.lineReader.getLineNumber() + ": could not create auto-path");
                        } else {
                            EDIF.this.nameEDIFArc(EDIF.this.curArc);
                        }
                    }
                } else {
                    Cell np = null;
                    it = EDIF.this.curLibrary.getCells();
                    while (it.hasNext()) {
                        Cell cell = it.next();
                        if (!cell.getName().equalsIgnoreCase(EDIF.this.cellName) || cell.getView() != View.SCHEMATIC) continue;
                        np = cell;
                        break;
                    }
                    if (np == null) {
                        System.out.println("error, line " + EDIF.this.lineReader.getLineNumber() + ": could not locate top level schematic");
                        return;
                    }
                    pp = np.findPortProto(EDIF.this.portReference);
                    if (pp == null) {
                        if (EDIF.this.originalName.length() > 0) {
                            pp = np.findPortProto(EDIF.this.originalName);
                        }
                        if (pp == null) {
                            System.out.println("error, line " + EDIF.this.lineReader.getLineNumber() + ": could not locate port '" + EDIF.this.portReference + "'");
                            return;
                        }
                    }
                    fNi = ((Export)pp).getOriginalPort().getNodeInst();
                    fPp = ((Export)pp).getOriginalPort().getPortProto();
                    Poly portPoly = fNi.findPortInstFromProto(fPp).getPoly();
                    double lX = portPoly.getCenterX();
                    double lY = portPoly.getCenterY();
                    if (pp.getCharacteristic() == PortCharacteristic.IN) {
                        lX = 10.0;
                    } else if (pp.getCharacteristic() == PortCharacteristic.BIDIR) {
                        lY = 40.0;
                    } else if (pp.getCharacteristic() == PortCharacteristic.OUT) {
                        lX = 50.0;
                    }
                    if (EDIF.this.isArray) {
                        ni = EDIF.this.placePin(Schematics.tech.busPinNode, lX, lY, Schematics.tech.busPinNode.getDefWidth(), Schematics.tech.busPinNode.getDefHeight(), Orientation.IDENT, np);
                        if (ni == null) {
                            System.out.println("error, line " + EDIF.this.lineReader.getLineNumber() + ": could not create bus pin");
                            return;
                        }
                        pp = EDIF.this.defaultBusPort;
                    } else {
                        ni = EDIF.this.placePin(Schematics.tech.wirePinNode, lX, lY, Schematics.tech.wirePinNode.getDefWidth(), Schematics.tech.wirePinNode.getDefHeight(), Orientation.IDENT, np);
                        if (ni == null) {
                            System.out.println("error, line " + EDIF.this.lineReader.getLineNumber() + ": could not create wire pin");
                            return;
                        }
                        pp = EDIF.this.defaultPort;
                    }
                    ap = !EDIF.this.isArray ? Schematics.tech.wire_arc : Schematics.tech.bus_arc;
                }
                if (fNi != null && fPp != null) {
                    if (fNi.getParent() != ni.getParent()) {
                        System.out.println("error, line " + EDIF.this.lineReader.getLineNumber() + ": could not create path (arc) between " + fNi.getParent() + " and " + ni.getParent());
                    } else {
                        Poly fPortPoly = fNi.findPortInstFromProto(fPp).getPoly();
                        double lX = fPortPoly.getCenterX();
                        double lY = fPortPoly.getCenterY();
                        Poly portPoly = ni.findPortInstFromProto(pp).getPoly();
                        double hX = portPoly.getCenterX();
                        double hY = portPoly.getCenterY();
                        EDIF.this.curArc = null;
                        double dist = 0.0;
                        PortInst head = fNi.findPortInstFromProto(fPp);
                        Point2D.Double headPt = new Point2D.Double(lX, lY);
                        PortInst tail = ni.findPortInstFromProto(pp);
                        Point2D.Double tailPt = new Point2D.Double(hX, hY);
                        if (lX != hX || lY != hY) {
                            dist = headPt.distance(tailPt);
                        }
                        if (dist <= 1.0) {
                            EDIF.this.curArc = ArcInst.makeInstance(ap, ap.getDefaultWidth(), head, tail, headPt, tailPt, null);
                            if (EDIF.this.curArc == null) {
                                System.out.println("error, line " + EDIF.this.lineReader.getLineNumber() + ": could not create path (arc) among cells");
                            }
                        } else if (EDIF.this.activeView == VNETLIST) {
                            EDIF.this.curArc = ArcInst.makeInstance(ap, ap.getDefaultWidth(), head, tail, headPt, tailPt, null);
                            if (EDIF.this.curArc == null) {
                                System.out.println("error, line " + EDIF.this.lineReader.getLineNumber() + ": could not create auto-path in portRef");
                            }
                        }
                        if (EDIF.this.curArc != null) {
                            EDIF.this.nameEDIFArc(EDIF.this.curArc);
                        }
                    }
                }
            }
        }
    }

    private class KeyPortImplementation
    extends EDIFKEY {
        private KeyPortImplementation() {
            super("portImplementation");
        }

        protected void push() throws IOException {
            EDIF.this.freePointList();
            EDIF.this.cellRefProto = Schematics.tech.wirePinNode;
            EDIF.this.curGeometryType = GPIN;
            EDIF.this.curOrientation = OR0;
            EDIF.this.isArray = false;
            EDIF.this.arrayXVal = (EDIF.this.arrayYVal = 1);
            EDIF.this.objectName = "";
            EDIF.this.originalName = "";
            EDIF.this.checkName();
        }

        protected void pop() {
            EDIF.this.curGeometryType = GUNKNOWN;
        }
    }

    private class KeyPort
    extends EDIFKEY {
        private KeyPort() {
            super("port");
        }

        protected void push() throws IOException {
            EDIF.this.objectName = "";
            EDIF.this.originalName = "";
            EDIF.this.curDirection = PortCharacteristic.IN;
            EDIF.this.portReference = "";
            EDIF.this.isArray = false;
            EDIF.this.arrayXVal = (EDIF.this.arrayYVal = 1);
            if (EDIF.this.checkName()) {
                EDIF.this.portReference = EDIF.this.objectName;
                EDIF.this.portName = EDIF.this.objectName;
            }
        }

        protected void pop() {
            NodeInst ni;
            EDIFPort port = new EDIFPort();
            port.next = EDIF.this.portsListHead;
            EDIF.this.portsListHead = port;
            port.reference = EDIF.this.portReference;
            port.name = EDIF.this.portName;
            port.direction = EDIF.this.curDirection;
            double cX = 0.0;
            double cY = 0.0;
            PortProto fPp = EDIF.this.defaultInput;
            if (EDIF.this.portsListHead.direction == PortCharacteristic.IN) {
                cY = EDIF.this.inPortPos;
                EDIF.this.inPortPos = (int)((double)EDIF.this.inPortPos + 10.0);
            } else if (EDIF.this.portsListHead.direction == PortCharacteristic.BIDIR) {
                cX = 30.0;
                cY = EDIF.this.bidirPortPos;
                EDIF.this.bidirPortPos = (int)((double)EDIF.this.bidirPortPos + 10.0);
            } else if (EDIF.this.portsListHead.direction == PortCharacteristic.OUT) {
                cX = 60.0;
                cY = EDIF.this.bidirPortPos;
                EDIF.this.bidirPortPos = (int)((double)EDIF.this.bidirPortPos + 10.0);
                fPp = EDIF.this.defaultOutput;
            }
            double psX = Schematics.tech.offpageNode.getDefWidth();
            double psY = Schematics.tech.offpageNode.getDefHeight();
            if (EDIF.this.curCellPage > 0) {
                cY += (double)(EDIF.this.curCellPage - 1) * 1000.0;
            }
            if ((ni = NodeInst.makeInstance(Schematics.tech.offpageNode, new Point2D.Double(cX, cY), psX, psY, EDIF.this.curCell)) == null) {
                System.out.println("Error, line " + EDIF.this.lineReader.getLineNumber() + ": could not create external port");
                EDIF.this.errorCount++;
                return;
            }
            PortInst pi = ni.findPortInstFromProto(fPp);
            Export ppt = Export.newInstance(EDIF.this.curCell, pi, EDIF.this.portsListHead.name);
            if (ppt == null) {
                System.out.println("Error, line " + EDIF.this.lineReader.getLineNumber() + ": could not create port <" + EDIF.this.portsListHead.name + ">");
                EDIF.this.errorCount++;
            } else {
                ppt.setCharacteristic(EDIF.this.portsListHead.direction);
            }
            EDIF.this.portReference = "";
            EDIFProperty property = EDIF.this.propertiesListHead;
            while (property != null) {
                ppt.newVar(property.name, property.val);
                property = property.next;
            }
            EDIF.this.propertiesListHead = null;
        }
    }

    private class KeyPolygon
    extends EDIFKEY {
        private KeyPolygon() {
            super("polygon");
        }

        protected void push() throws IOException {
            EDIF.this.freePointList();
            EDIF.this.curOrientation = OR0;
        }

        protected void pop() {
            EDIF.this.doPoly();
        }
    }

    private class KeyPathWidth
    extends EDIFKEY {
        private KeyPathWidth() {
            super("pathWidth");
        }

        protected void push() throws IOException {
            String width = EDIF.this.getToken('\u0000');
            EDIF.this.pathWidth = TextUtils.atoi(width);
        }
    }

    private class KeyPath
    extends EDIFKEY {
        private KeyPath() {
            super("path");
        }

        protected void push() throws IOException {
            EDIF.this.freePointList();
            EDIF.this.curOrientation = OR0;
            EDIF.this.pathWidth = 0;
        }

        protected void pop() {
            if (EDIF.this.pathWidth == 0 && EDIF.this.curGeometryType != GNET && EDIF.this.curGeometryType != GBUS) {
                EDIF.this.doPoly();
                return;
            }
            List<PortInst> fList = new ArrayList();
            PrimitiveNode np = Schematics.tech.wirePinNode;
            if (EDIF.this.curGeometryType == GBUS || EDIF.this.isArray) {
                np = Schematics.tech.busPinNode;
            }
            for (int i = 0; i < EDIF.this.curPoints.size() - 1; ++i) {
                NodeInst ni;
                Point2D fPoint = (Point2D)EDIF.this.curPoints.get(i);
                Point2D tPoint = (Point2D)EDIF.this.curPoints.get(i + 1);
                double fX = fPoint.getX();
                double fY = fPoint.getY();
                double tX = tPoint.getX();
                double tY = tPoint.getY();
                if (EDIF.this.curCellPage > 0) {
                    fY += (double)(EDIF.this.curCellPage - 1) * 1000.0;
                    tY += (double)(EDIF.this.curCellPage - 1) * 1000.0;
                }
                if (EDIF.this.curGeometryType == GNET || EDIF.this.curGeometryType == GBUS) {
                    List tList;
                    if (fList.size() == 0) {
                        NodeInst ni2;
                        fList = EDIF.this.findEDIFPort(EDIF.this.curCell, fX, fY, Schematics.tech.wire_arc, true);
                        if (fList.size() == 0) {
                            for (PortInst pi : EDIF.this.netPortRefs) {
                                EDIFEquiv.NodeEquivalence ne = EDIF.this.equivs.getNodeEquivalence(pi.getNodeInst());
                                if (ne == null) continue;
                                Point2D curPoint = new Point2D.Double(fX, fY);
                                String orientation = com.sun.electric.tool.io.output.EDIF.getOrientation(pi.getNodeInst(), 0);
                                String port = ne.getPortEquivElec((String)pi.getPortProto().getName()).getExtPort().name;
                                curPoint = EDIF.this.equivs.translatePortConnection(curPoint, ne.externalLib, ne.externalCell, ne.externalView, port, orientation);
                                if (curPoint.getX() == fX && curPoint.getY() == fY || (fList = EDIF.this.findEDIFPort(EDIF.this.curCell, curPoint.getX(), curPoint.getY(), Schematics.tech.wire_arc, true)).size() == 0) continue;
                                fX = curPoint.getX();
                                fY = curPoint.getY();
                            }
                        }
                        if (fList.size() == 0 && (ni2 = EDIF.this.placePin(np, fX, fY, np.getDefWidth(), np.getDefHeight(), Orientation.IDENT, EDIF.this.curCell)) != null) {
                            fList.add(ni2.getOnlyPortInst());
                        }
                    }
                    if ((tList = EDIF.this.findEDIFPort(EDIF.this.curCell, tX, tY, Schematics.tech.wire_arc, true)).size() == 0) {
                        for (PortInst pi : EDIF.this.netPortRefs) {
                            EDIFEquiv.NodeEquivalence ne = EDIF.this.equivs.getNodeEquivalence(pi.getNodeInst());
                            if (ne == null) continue;
                            Point2D curPoint = new Point2D.Double(tX, tY);
                            String orientation = com.sun.electric.tool.io.output.EDIF.getOrientation(pi.getNodeInst(), 0);
                            String port = ne.getPortEquivElec((String)pi.getPortProto().getName()).getExtPort().name;
                            curPoint = EDIF.this.equivs.translatePortConnection(curPoint, ne.externalLib, ne.externalCell, ne.externalView, port, orientation);
                            if (curPoint.getX() == tX && curPoint.getY() == tY || (tList = EDIF.this.findEDIFPort(EDIF.this.curCell, curPoint.getX(), curPoint.getY(), Schematics.tech.wire_arc, true)).size() == 0) continue;
                            tX = curPoint.getX();
                            tY = curPoint.getY();
                        }
                    }
                    if (tList.size() == 0) {
                        NodeInst ni3;
                        if (EDIF.this.curCellPage > 0) {
                            tY += (double)(EDIF.this.curCellPage - 1) * 1000.0;
                        }
                        if ((ni3 = EDIF.this.placePin(np, tX, tY, np.getDefWidth(), np.getDefHeight(), Orientation.IDENT, EDIF.this.curCell)) != null) {
                            tList.add(ni3.getOnlyPortInst());
                        }
                    }
                    if (fList.size() == 0 || tList.size() == 0) {
                        System.out.println("Error, line " + EDIF.this.lineReader.getLineNumber() + ": could not create path");
                        EDIF.this.errorCount++;
                        continue;
                    }
                    ArcInst ai = null;
                    PortInst fPi = null;
                    PortInst tPi = null;
                    for (int count = 0; count < fList.size() || count < tList.size(); ++count) {
                        PortProto pp;
                        Variable var;
                        NodeInst ni4;
                        boolean fbus = false;
                        boolean tbus = false;
                        if (count < fList.size()) {
                            fPi = (PortInst)fList.get(count);
                            ni4 = fPi.getNodeInst();
                            var = ni4.getVar("EDIF_array");
                            if (var != null) {
                                fbus = true;
                            } else {
                                pp = fPi.getPortProto();
                                if (pp.getName().endsWith("]")) {
                                    fbus = true;
                                }
                            }
                        }
                        if (count < tList.size()) {
                            tPi = (PortInst)tList.get(count);
                            ni4 = tPi.getNodeInst();
                            var = ni4.getVar("EDIF_array");
                            if (var != null) {
                                tbus = true;
                            } else {
                                pp = tPi.getPortProto();
                                if (pp.getName().endsWith("]")) {
                                    tbus = true;
                                }
                            }
                        }
                        ArcProto ap = Schematics.tech.wire_arc;
                        if ((fPi.getPortProto() == EDIF.this.defaultBusPort || fbus) && (tPi.getPortProto() == EDIF.this.defaultBusPort || tbus)) {
                            ap = Schematics.tech.bus_arc;
                        }
                        if ((ai = ArcInst.makeInstance(ap, ap.getDefaultWidth(), fPi, tPi, new Point2D.Double(fX, fY), new Point2D.Double(tX, tY), null)) == null) {
                            System.out.println("Error, line " + EDIF.this.lineReader.getLineNumber() + ": could not create path (arc)");
                            EDIF.this.errorCount++;
                            continue;
                        }
                        if (EDIF.this.curGeometryType == GNET && i == 0) {
                            if (EDIF.this.netReference.length() > 0) {
                                ai.newVar("EDIF_name", (Object)EDIF.this.netReference);
                            }
                            if (EDIF.this.netName.length() <= 0) continue;
                            ai.setName(EDIF.this.netName);
                            continue;
                        }
                        if (EDIF.this.curGeometryType != GBUS || i != 0) continue;
                        if (EDIF.this.bundleReference.length() > 0) {
                            ai.newVar("EDIF_name", (Object)EDIF.this.bundleReference);
                        }
                        if (EDIF.this.bundleName.length() <= 0) continue;
                        ai.setName(EDIF.this.bundleName);
                    }
                    if (ai != null) {
                        EDIF.this.curArc = ai;
                    }
                    fList = tList;
                    continue;
                }
                double lX = fX;
                double lY = fY;
                double hX = lX;
                double hY = lY;
                if (lX > tX) {
                    lX = tX;
                }
                if (hX < tX) {
                    hX = tX;
                }
                if (lY > tY) {
                    lY = tY;
                }
                if (hY < tY) {
                    hY = tY;
                }
                if (lY == hY || EDIF.this.extendEnd) {
                    lY -= (double)(EDIF.this.pathWidth / 2);
                    hY += (double)(EDIF.this.pathWidth / 2);
                }
                if (lX == hX || EDIF.this.extendEnd) {
                    lX -= (double)(EDIF.this.pathWidth / 2);
                    hX += (double)(EDIF.this.pathWidth / 2);
                }
                double cY = (lY + hY) / 2.0;
                double cX = (lX + hX) / 2.0;
                if (EDIF.this.curCellPage > 0) {
                    cY += (double)(EDIF.this.curCellPage - 1) * 1000.0;
                }
                if ((ni = EDIF.this.placePin(EDIF.this.curFigureGroup, cX, cY, hX - lX, hY - lY, EDIF.this.curOrientation, EDIF.this.curCell)) != null) continue;
                System.out.println("Error, line " + EDIF.this.lineReader.getLineNumber() + ": could not create path");
                EDIF.this.errorCount++;
            }
            EDIF.this.freePointList();
        }
    }

    private class KeyPage
    extends EDIFKEY {
        private KeyPage() {
            super("page");
        }

        protected void push() throws IOException {
            EDIF.this.checkName();
            EDIF.this.curCellPage = ++EDIF.this.pageNumber;
            Cell proto = null;
            Iterator<Cell> it = EDIF.this.curLibrary.getCells();
            while (it.hasNext()) {
                Cell cell = it.next();
                if (!cell.getName().equalsIgnoreCase(EDIF.this.cellName) || cell.getView() != View.SCHEMATIC) continue;
                proto = cell;
                break;
            }
            if (proto == null) {
                String cname = EDIF.this.cellName + "{sch}";
                proto = Cell.makeInstance(EDIF.this.curLibrary, cname);
                if (proto == null) {
                    throw new IOException("Error creating cell");
                }
                proto.setMultiPage(true);
                proto.newVar(User.FRAME_SIZE, (Object)"d");
                EDIF.this.builtCells.add(proto);
            } else if (!EDIF.this.builtCells.contains(proto)) {
                EDIF.this.ignoreBlock = true;
            }
            EDIF.this.curCell = proto;
        }

        protected void pop() {
            EDIF.this.activeView = VNULL;
        }
    }

    private class KeyOrientation
    extends EDIFKEY {
        private KeyOrientation() {
            super("orientation");
        }

        protected void push() throws IOException {
            String orient = EDIF.this.getToken('\u0000');
            if (orient.equalsIgnoreCase("R0")) {
                EDIF.this.curOrientation = OR0;
            } else if (orient.equalsIgnoreCase("R90")) {
                EDIF.this.curOrientation = OR90;
            } else if (orient.equalsIgnoreCase("R180")) {
                EDIF.this.curOrientation = OR180;
            } else if (orient.equalsIgnoreCase("R270")) {
                EDIF.this.curOrientation = OR270;
            } else if (orient.equalsIgnoreCase("MY")) {
                EDIF.this.curOrientation = OMY;
            } else if (orient.equalsIgnoreCase("MX")) {
                EDIF.this.curOrientation = OMX;
            } else if (orient.equalsIgnoreCase("MYR90")) {
                EDIF.this.curOrientation = OMYR90;
            } else if (orient.equalsIgnoreCase("MXR90")) {
                EDIF.this.curOrientation = OMXR90;
            } else {
                System.out.println("Warning, line " + EDIF.this.lineReader.getLineNumber() + ": unknown orientation value <" + orient + ">");
                EDIF.this.warningCount++;
            }
        }
    }

    private class KeyOpenShape
    extends EDIFKEY {
        private KeyOpenShape() {
            super("openShape");
        }

        protected void push() throws IOException {
            EDIF.this.freePointList();
            EDIF.this.curOrientation = OR0;
        }

        protected void pop() {
            EDIF.this.doPoly();
        }
    }

    private class KeyNumber
    extends EDIFKEY {
        private KeyNumber() {
            super("number");
        }

        protected void push() throws IOException {
            EDIF.this.propertyValue = new Double(EDIF.this.getNumber());
        }
    }

    private class KeyNetBundle
    extends EDIFKEY {
        private KeyNetBundle() {
            super("netBundle");
        }

        protected void push() throws IOException {
            EDIF.this.curGeometryType = GBUS;
            EDIF.this.bundleReference = "";
            EDIF.this.objectName = "";
            EDIF.this.originalName = "";
            EDIF.this.isArray = false;
            if (EDIF.this.checkName()) {
                EDIF.this.bundleReference = EDIF.this.objectName;
                EDIF.this.bundleName = EDIF.this.objectName;
            }
        }

        protected void pop() {
            EDIF.this.bundleReference = "";
            EDIF.this.curArc = null;
            EDIF.this.curGeometryType = GUNKNOWN;
            EDIF.this.freeSavedPointList();
        }
    }

    private class KeyNet
    extends EDIFKEY {
        private KeyNet() {
            super("net");
        }

        protected void push() throws IOException {
            EDIF.this.netReference = "";
            EDIF.this.objectName = "";
            EDIF.this.originalName = "";
            EDIF.this.curArc = null;
            EDIF.this.curNode = null;
            EDIF.this.curPort = null;
            EDIF.this.freeNetPorts();
            EDIF.this.isArray = false;
            EDIF.this.arrayXVal = (EDIF.this.arrayYVal = 1);
            if (EDIF.this.keyStack[EDIF.this.keyStackDepth - 2] != EDIF.this.KNETBUNDLE) {
                EDIF.this.curGeometryType = GNET;
            }
            if (EDIF.this.checkName()) {
                EDIF.this.netReference = EDIF.this.objectName;
                EDIF.this.netName = EDIF.this.objectName;
            }
        }

        protected void pop() {
            EDIFProperty property = EDIF.this.propertiesListHead;
            while (property != null) {
                if (EDIF.this.curArc != null) {
                    EDIF.this.curArc.newVar(property.name, property.val);
                }
                property = property.next;
            }
            EDIF.this.propertiesListHead = null;
            EDIF.this.netReference = "";
            EDIF.this.curArc = null;
            if (EDIF.this.curGeometryType != GBUS) {
                EDIF.this.curGeometryType = GUNKNOWN;
            }
            EDIF.this.freeSavedPointList();
            EDIF.this.netPortRefs.clear();
        }
    }

    private class KeyName
    extends EDIFKEY {
        private KeyName() {
            super("name");
        }

        protected void push() throws IOException {
            int kPtr = EDIF.this.keyStackDepth - 1;
            if (EDIF.this.keyStack[EDIF.this.keyStackDepth - 1] == EDIF.this.KARRAY || EDIF.this.keyStack[EDIF.this.keyStackDepth - 1] == EDIF.this.KMEMBER) {
                kPtr = EDIF.this.keyStackDepth - 2;
            }
            if (EDIF.this.checkName()) {
                if (EDIF.this.keyStack[kPtr] == EDIF.this.KCELL) {
                    EDIF.this.cellReference = EDIF.this.objectName;
                    EDIF.this.cellName = EDIF.this.objectName;
                } else if (EDIF.this.keyStack[kPtr] == EDIF.this.KPORTIMPLEMENTATION || EDIF.this.keyStack[kPtr] == EDIF.this.KPORT) {
                    EDIF.this.portName = EDIF.this.objectName;
                    EDIF.this.portReference = EDIF.this.objectName;
                } else if (EDIF.this.keyStack[kPtr] == EDIF.this.KPORTREF) {
                    EDIF.this.portReference = EDIF.this.objectName;
                } else if (EDIF.this.keyStack[kPtr] == EDIF.this.KINSTANCE) {
                    EDIF.this.instanceName = EDIF.this.objectName;
                    EDIF.this.instanceReference = EDIF.this.objectName;
                } else if (EDIF.this.keyStack[kPtr] == EDIF.this.KINSTANCEREF) {
                    EDIF.this.instanceReference = EDIF.this.objectName;
                } else if (EDIF.this.keyStack[kPtr] == EDIF.this.KNET) {
                    EDIF.this.netReference = EDIF.this.objectName;
                    EDIF.this.netName = EDIF.this.objectName;
                } else if (EDIF.this.keyStack[kPtr] == EDIF.this.KPROPERTY) {
                    EDIF.this.propertyReference = EDIF.this.objectName;
                    EDIF.this.propertyName = EDIF.this.objectName;
                }
                EDIF.this.freePointList();
                EDIF.this.curOrientation = OR0;
                EDIF.this.textVisible = true;
                EDIF.this.textJustification = AbstractTextDescriptor.Position.DOWNRIGHT;
                EDIF.this.textHeight = 0;
                EDIF.this.textString = EDIF.this.objectName;
            }
        }

        protected void pop() {
            EDIF.this.freeSavedPointList();
            EDIF.this.textString = "";
            EDIF.this.saveTextPoints = EDIF.this.curPoints;
            EDIF.this.curPoints = new ArrayList();
            EDIF.this.saveTextHeight = EDIF.this.textHeight;
            EDIF.this.textHeight = 0;
            EDIF.this.saveTextJustification = EDIF.this.textJustification;
            EDIF.this.textJustification = AbstractTextDescriptor.Position.DOWNRIGHT;
            EDIF.this.curOrientation = OR0;
            EDIF.this.textVisible = true;
        }
    }

    private class KeyMember
    extends EDIFKEY {
        private KeyMember() {
            super("member");
        }

        protected void push() throws IOException {
            EDIF.this.memberXVal = -1;
            EDIF.this.memberYVal = -1;
            if (EDIF.this.checkName()) {
                if (EDIF.this.keyStack[EDIF.this.keyStackDepth - 1] == EDIF.this.KPORTREF) {
                    EDIF.this.portReference = EDIF.this.objectName;
                } else if (EDIF.this.keyStack[EDIF.this.keyStackDepth - 1] == EDIF.this.KINSTANCEREF) {
                    EDIF.this.instanceReference = EDIF.this.objectName;
                }
            }
        }

        protected void pop() {
            if (EDIF.this.memberXVal != -1) {
                String baseName = "[" + EDIF.this.memberXVal + "]";
                if (EDIF.this.memberYVal != -1) {
                    baseName = "[" + EDIF.this.memberXVal + "," + EDIF.this.memberYVal + "]";
                }
                if (EDIF.this.keyStack[EDIF.this.keyStackDepth - 1] == EDIF.this.KINSTANCEREF) {
                    EDIF.this.instanceReference = baseName;
                } else if (EDIF.this.keyStack[EDIF.this.keyStackDepth - 1] == EDIF.this.KPORTREF) {
                    EDIF.this.portReference = baseName;
                }
            }
        }
    }

    private class LibraryRef
    extends EDIFKEY {
        private LibraryRef() {
            super("libraryRef");
        }

        protected void push() throws IOException {
            EDIF.this.libraryRef = EDIF.this.getToken('\u0000');
        }
    }

    private class KeyLibrary
    extends EDIFKEY {
        private KeyLibrary() {
            super("library");
        }

        protected void push() throws IOException {
            String aName = EDIF.this.getToken('\u0000');
        }
    }

    private class KeyJustify
    extends EDIFKEY {
        private KeyJustify() {
            super("justify");
        }

        protected void push() throws IOException {
            String val = EDIF.this.getToken('\u0000');
            if (val.equalsIgnoreCase("UPPERLEFT")) {
                EDIF.this.textJustification = AbstractTextDescriptor.Position.DOWNRIGHT;
            } else if (val.equalsIgnoreCase("UPPERCENTER")) {
                EDIF.this.textJustification = AbstractTextDescriptor.Position.DOWN;
            } else if (val.equalsIgnoreCase("UPPERRIGHT")) {
                EDIF.this.textJustification = AbstractTextDescriptor.Position.DOWNLEFT;
            } else if (val.equalsIgnoreCase("CENTERLEFT")) {
                EDIF.this.textJustification = AbstractTextDescriptor.Position.RIGHT;
            } else if (val.equalsIgnoreCase("CENTERCENTER")) {
                EDIF.this.textJustification = AbstractTextDescriptor.Position.CENT;
            } else if (val.equalsIgnoreCase("CENTERRIGHT")) {
                EDIF.this.textJustification = AbstractTextDescriptor.Position.LEFT;
            } else if (val.equalsIgnoreCase("LOWERLEFT")) {
                EDIF.this.textJustification = AbstractTextDescriptor.Position.UPRIGHT;
            } else if (val.equalsIgnoreCase("LOWERCENTER")) {
                EDIF.this.textJustification = AbstractTextDescriptor.Position.UP;
            } else if (val.equalsIgnoreCase("LOWERRIGHT")) {
                EDIF.this.textJustification = AbstractTextDescriptor.Position.UPLEFT;
            } else {
                System.out.println("Warning, line " + EDIF.this.lineReader.getLineNumber() + ": unknown keyword <" + val + ">");
                EDIF.this.warningCount++;
                return;
            }
            if (EDIF.this.curNameEntry != null) {
                EDIF.this.curNameEntry.justification = EDIF.this.textJustification;
            }
        }
    }

    private class KeyInterface
    extends EDIFKEY {
        private KeyInterface() {
            super("interface");
        }

        protected void push() throws IOException {
            Cell np = null;
            Iterator<Cell> it = EDIF.this.curLibrary.getCells();
            while (it.hasNext()) {
                Cell cell = it.next();
                if (!cell.getName().equals(EDIF.this.cellName) || cell.getView() != View.SCHEMATIC) continue;
                np = cell;
                break;
            }
            if (np == null) {
                String nodeName = EDIF.this.cellName + "{sch}";
                EDIF.this.curCell = Cell.makeInstance(EDIF.this.curLibrary, nodeName);
                if (EDIF.this.curCell == null) {
                    throw new IOException("Error creating cell");
                }
                EDIF.this.builtCells.add(EDIF.this.curCell);
            } else {
                EDIF.this.curCell = np;
            }
            EDIF.this.curCellPage = 0;
            EDIF.this.inPortPos = (EDIF.this.bidirPortPos = (EDIF.this.outPortPos = 0));
        }

        protected void pop() {
            if (EDIF.this.activeView == VNETLIST) {
                Cell nnp = null;
                try {
                    double leadLength = User.getIconGenLeadLength();
                    double leadSpacing = User.getIconGenLeadSpacing();
                    boolean reverseIconExportOrder = User.isIconGenReverseExportOrder();
                    boolean drawBody = User.isIconGenDrawBody();
                    boolean drawLeads = User.isIconGenDrawLeads();
                    boolean placeCellCenter = User.isPlaceCellCenter();
                    int exportTech = User.getIconGenExportTech();
                    int exportStyle = User.getIconGenExportStyle();
                    int exportLocation = User.getIconGenExportLocation();
                    int inputSide = User.getIconGenInputSide();
                    int outputSide = User.getIconGenOutputSide();
                    int bidirSide = User.getIconGenBidirSide();
                    int pwrSide = User.getIconGenPowerSide();
                    int gndSide = User.getIconGenGroundSide();
                    int clkSide = User.getIconGenClockSide();
                    nnp = ViewChanges.makeIconForCell(EDIF.this.curCell, leadLength, leadSpacing, reverseIconExportOrder, drawBody, drawLeads, placeCellCenter, exportTech, exportStyle, exportLocation, inputSide, outputSide, bidirSide, pwrSide, gndSide, clkSide);
                }
                catch (JobException jobException) {
                    // empty catch block
                }
                if (nnp == null) {
                    System.out.println("Error, line " + EDIF.this.lineReader.getLineNumber() + ": could not create icon <" + EDIF.this.curCell.describe(true) + ">");
                    EDIF.this.errorCount++;
                }
            }
        }
    }

    private class KeyInteger
    extends EDIFKEY {
        private KeyInteger() {
            super("integer");
        }

        protected void push() throws IOException {
            String value = EDIF.this.getToken('\u0000');
            EDIF.this.propertyValue = new Integer(TextUtils.atoi(value));
        }
    }

    private class KeyInstanceRef
    extends EDIFKEY {
        private KeyInstanceRef() {
            super("instanceRef");
        }

        protected void push() throws IOException {
            EDIF.this.instanceReference = "";
            if (EDIF.this.checkName()) {
                EDIF.this.instanceReference = EDIF.this.objectName;
            }
        }
    }

    private class KeyInstance
    extends EDIFKEY {
        private int sheetOffset;

        private KeyInstance() {
            super("instance");
            this.sheetOffset = 0;
        }

        protected void push() throws IOException {
            EDIF.this.freePointList();
            EDIF.this.cellRefProto = null;
            EDIF.this.curGeometryType = GINSTANCE;
            EDIF.this.curOrientation = OR0;
            EDIF.this.isArray = false;
            EDIF.this.arrayXVal = (EDIF.this.arrayYVal = 1);
            EDIF.this.objectName = "";
            EDIF.this.originalName = "";
            EDIF.this.instanceReference = "";
            EDIF.this.curNode = null;
            if (EDIF.this.checkName()) {
                EDIF.this.instanceReference = EDIF.this.objectName;
                EDIF.this.instanceName = EDIF.this.objectName;
            }
        }

        protected void pop() throws IOException {
            if (EDIF.this.activeView == VNETLIST) {
                block0: for (int iX = 0; iX < EDIF.this.arrayXVal; ++iX) {
                    for (int iY = 0; iY < EDIF.this.arrayYVal; ++iY) {
                        double width = EDIF.this.cellRefProto.getDefWidth();
                        double height = EDIF.this.cellRefProto.getDefHeight();
                        width = (width + 10.0 - 1.0) / 10.0;
                        height = (height + 10.0 - 1.0) / 10.0;
                        if (EDIF.this.sheetXPos != -1 && (double)EDIF.this.sheetYPos + (height + 1.0) >= 20.0) {
                            EDIF.this.sheetYPos = 1;
                            if ((EDIF.this.sheetXPos += this.sheetOffset) >= 44) {
                                EDIF.this.sheetXPos = (EDIF.this.sheetYPos = -1);
                            } else {
                                this.sheetOffset = 2;
                            }
                        }
                        if (EDIF.this.sheetXPos == -1) {
                            EDIF.this.curCellPage = ++EDIF.this.pageNumber;
                            String nodeName = EDIF.this.cellName + "{sch}";
                            if (EDIF.this.curCellPage == 1) {
                                EDIF.this.curCell = Cell.makeInstance(EDIF.this.curLibrary, nodeName);
                                if (EDIF.this.curCell == null) {
                                    throw new IOException("Error creating cell");
                                }
                                EDIF.this.builtCells.add(EDIF.this.curCell);
                                EDIF.this.curCell.setMultiPage(true);
                                EDIF.this.curCell.newVar(User.FRAME_SIZE, (Object)"d");
                            } else {
                                EDIF.this.curCell = EDIF.this.curLibrary.findNodeProto(nodeName);
                                if (EDIF.this.curCell == null) {
                                    throw new IOException("Error finding cell");
                                }
                            }
                            EDIF.this.sheetXPos = (EDIF.this.sheetYPos = 1);
                            this.sheetOffset = 2;
                        }
                        double cX = (double)(EDIF.this.sheetXPos - 22) * 10.0;
                        double cY = (double)(EDIF.this.sheetYPos - 10) * 10.0;
                        if (EDIF.this.curCellPage > 0) {
                            cY += (double)(EDIF.this.curCellPage - 1) * 1000.0;
                        }
                        Orientation orient = EDIF.this.curOrientation.concatenate(Orientation.fromAngle(EDIF.this.cellRefProtoRotation * 10));
                        NodeInst ni = NodeInst.makeInstance(EDIF.this.cellRefProto, new Point2D.Double(cX, cY), EDIF.this.cellRefProto.getDefWidth(), EDIF.this.cellRefProto.getDefHeight(), EDIF.this.curCell, orient, null, EDIF.this.cellRefProtoTechBits);
                        EDIF.this.curNode = ni;
                        if (ni == null) {
                            System.out.println("Error, line " + EDIF.this.lineReader.getLineNumber() + ": could not create instance");
                            EDIF.this.errorCount++;
                            continue block0;
                        }
                        if (EDIF.this.cellRefProto instanceof Cell && ((Cell)EDIF.this.cellRefProto).isWantExpanded()) {
                            ni.setExpanded();
                        }
                        if (width + 2.0 > (double)this.sheetOffset) {
                            this.sheetOffset = (int)width + 2;
                        }
                        if ((EDIF.this.sheetYPos = (int)((double)EDIF.this.sheetYPos + (height + 1.0))) >= 20) {
                            EDIF.this.sheetYPos = 1;
                            if ((EDIF.this.sheetXPos += this.sheetOffset) >= 44) {
                                EDIF.this.sheetXPos = (EDIF.this.sheetYPos = -1);
                            } else {
                                this.sheetOffset = 2;
                            }
                        }
                        if (EDIF.this.instanceReference.length() <= 0) continue;
                        String nodeName = EDIF.this.instanceReference;
                        if (!(EDIF.this.arrayXVal <= 1 && EDIF.this.arrayYVal <= 1 || EDIF.this.deltaPointXX == 0.0 && EDIF.this.deltaPointXY == 0.0 && EDIF.this.deltaPointYX == 0.0 && EDIF.this.deltaPointYY == 0.0)) {
                            if (EDIF.this.arrayXVal > 1) {
                                nodeName = EDIF.this.arrayYVal > 1 ? EDIF.this.instanceReference + "[" + iX + "," + iY + "]" : EDIF.this.instanceReference + "[" + iX + "]";
                            } else if (EDIF.this.arrayYVal > 1) {
                                nodeName = EDIF.this.instanceReference + "[" + iY + "]";
                            }
                        }
                        if (EDIF.this.arrayXVal > 1 || EDIF.this.arrayYVal > 1) {
                            String baseName = iX + ":" + (EDIF.this.deltaPointXX == 0.0 && EDIF.this.deltaPointYX == 0.0 ? EDIF.this.arrayXVal - 1 : iX) + ":" + EDIF.this.arrayXVal + " " + iY + ":" + (EDIF.this.deltaPointXY == 0.0 && EDIF.this.deltaPointYY == 0.0 ? EDIF.this.arrayYVal - 1 : iY) + ":" + EDIF.this.arrayYVal;
                            ni.newVar("EDIF_array", (Object)baseName);
                        }
                        if (EDIF.this.instanceReference.equalsIgnoreCase(EDIF.this.instanceName)) {
                            ni.setName(nodeName);
                            continue;
                        }
                        if (iX == 0 && iY == 0) {
                            ni.setName(EDIF.this.instanceName);
                        }
                        ni.newVar("EDIF_name", (Object)nodeName);
                    }
                }
            }
            EDIFProperty property = EDIF.this.propertiesListHead;
            while (property != null) {
                if (EDIF.this.curNode != null) {
                    EDIFEquiv.VariableEquivalence ve;
                    String varName = property.name;
                    Object varValue = property.val;
                    String varNameLookup = varName;
                    if (varNameLookup.startsWith("ATTR_")) {
                        varNameLookup = varNameLookup.substring(5);
                    }
                    if ((ve = EDIF.this.equivs.getExternalVariableEquivalence(varNameLookup)) != null) {
                        String varValueString;
                        varName = ve.elecVarName;
                        if (ve.appendElecOutput.length() > 0 && (varValueString = varValue.toString()).endsWith(ve.appendElecOutput)) {
                            varValue = varValueString.substring(0, varValueString.length() - ve.appendElecOutput.length());
                        }
                        if (ve.scale != 1.0) {
                            varValueString = varValue.toString();
                            double newValue = TextUtils.atof(varValueString) / ve.scale;
                            varValue = Double.toString(newValue);
                        }
                    }
                    TextDescriptor td = TextDescriptor.getNodeTextDescriptor().withDisplay(ve != null);
                    EDIF.this.curNode.newVar(Variable.newKey(varName), varValue, td);
                }
                property = property.next;
            }
            EDIF.this.propertiesListHead = null;
            EDIF.this.instanceReference = "";
            EDIF.this.curNode = null;
            EDIF.this.freeSavedPointList();
        }
    }

    private class KeyFigureGroupOverride
    extends EDIFKEY {
        private KeyFigureGroupOverride() {
            super("figureGroupOverride");
        }

        protected void push() throws IOException {
            String layer = EDIF.this.getToken('\u0000');
            for (NameEntry nt : EDIF.this.nameEntryList) {
                if (nt == null || !nt.original.equalsIgnoreCase(layer)) continue;
                EDIF.this.curFigureGroup = nt.node;
                EDIF.this.curArcType = nt.arc;
                EDIF.this.textHeight = nt.textHeight;
                EDIF.this.textJustification = nt.justification;
                EDIF.this.textVisible = nt.visible;
                return;
            }
            NameEntry nt = new NameEntry();
            EDIF.this.nameEntryList.add(nt);
            nt.original = layer;
            nt.replace = nt.original;
            EDIF.this.curFigureGroup = (nt.node = Artwork.tech.boxNode);
            EDIF.this.curArcType = (nt.arc = Schematics.tech.wire_arc);
            EDIF.this.textHeight = (nt.textHeight = 0);
            EDIF.this.textJustification = (nt.justification = AbstractTextDescriptor.Position.DOWNRIGHT);
            EDIF.this.textVisible = (nt.visible = true);
        }
    }

    private class KeyFigure
    extends EDIFKEY {
        private KeyFigure() {
            super("figure");
        }

        protected void push() throws IOException {
            EDIF.this.makeFigure();
        }

        protected void pop() {
            EDIF.this.curNameEntry = null;
            EDIF.this.textVisible = true;
            EDIF.this.textJustification = AbstractTextDescriptor.Position.DOWNRIGHT;
            EDIF.this.textHeight = 0;
        }
    }

    private class KeyFalse
    extends EDIFKEY {
        private KeyFalse() {
            super("false");
        }

        protected void push() throws IOException {
            if (EDIF.this.keyStackDepth > 1 && EDIF.this.keyStack[EDIF.this.keyStackDepth - 1] == EDIF.this.KVISIBLE) {
                EDIF.this.textVisible = false;
                if (EDIF.this.curNameEntry != null) {
                    EDIF.this.curNameEntry.visible = false;
                }
            }
        }
    }

    private class KeyFabricate
    extends EDIFKEY {
        private KeyFabricate() {
            super("fabricate");
        }

        protected void push() throws IOException {
            NameEntry nt = new NameEntry();
            EDIF.this.nameEntryList.add(nt);
            nt.original = EDIF.this.getToken('\u0000');
            nt.replace = EDIF.this.getToken('\u0000');
            nt.textHeight = 0;
            nt.justification = AbstractTextDescriptor.Position.DOWNRIGHT;
            nt.visible = true;
        }
    }

    private class KeyExternal
    extends EDIFKEY {
        private KeyExternal() {
            super("external");
        }

        protected void push() throws IOException {
            String aName = EDIF.this.getToken('\u0000');
        }
    }

    private class KeyEndType
    extends EDIFKEY {
        private KeyEndType() {
            super("endType");
        }

        protected void push() throws IOException {
            String type = EDIF.this.getToken('\u0000');
            if (type.equalsIgnoreCase("EXTEND")) {
                EDIF.this.extendEnd = true;
            }
        }
    }

    private class KeyEDIF
    extends EDIFKEY {
        private KeyEDIF() {
            super("edif");
        }

        protected void pop() {
            EDIF.this.freeNetPorts();
        }
    }

    private class KeyDot
    extends EDIFKEY {
        private KeyDot() {
            super("dot");
        }

        protected void push() throws IOException {
            EDIF.this.freePointList();
            EDIF.this.curOrientation = OR0;
        }

        protected void pop() {
            if (EDIF.this.curGeometryType == GPIN) {
                EDIFPort ePort = null;
                EDIFPort e = EDIF.this.portsListHead;
                while (e != null) {
                    if (e.reference.equalsIgnoreCase(EDIF.this.objectName)) {
                        ePort = e;
                        break;
                    }
                    e = e.next;
                }
                if (ePort != null) {
                    PortProto ppt;
                    NodeInst ni;
                    Point2D p0 = (Point2D)EDIF.this.curPoints.get(0);
                    double xPos = p0.getX();
                    double yPos = p0.getY();
                    if (EDIF.this.curCellPage > 0) {
                        yPos += (double)(EDIF.this.curCellPage - 1) * 1000.0;
                    }
                    if ((ni = EDIF.this.placePin(EDIF.this.cellRefProto, xPos, yPos, EDIF.this.cellRefProto.getDefWidth(), EDIF.this.cellRefProto.getDefHeight(), EDIF.this.curOrientation, EDIF.this.curCell)) == null) {
                        System.out.println("Error, line " + EDIF.this.lineReader.getLineNumber() + ": could not create pin");
                        EDIF.this.errorCount++;
                    }
                    String pName = ePort.name;
                    int dup = 0;
                    while ((ppt = EDIF.this.curCell.findPortProto(pName)) != null) {
                        pName = ePort.name + "_" + (dup + 1);
                        ++dup;
                    }
                    PortInst pi = ni.findPortInstFromProto(EDIF.this.defaultIconPort);
                    ppt = Export.newInstance(EDIF.this.curCell, pi, pName);
                    if (ppt == null) {
                        System.out.println("Error, line " + EDIF.this.lineReader.getLineNumber() + ": could not create port <" + pName + ">");
                        EDIF.this.errorCount++;
                    } else {
                        ((Export)ppt).setCharacteristic(ePort.direction);
                    }
                }
            } else {
                NodeInst ni;
                Point2D p0 = (Point2D)EDIF.this.curPoints.get(0);
                double xPos = p0.getX();
                double yPos = p0.getY();
                if (EDIF.this.curCellPage > 0) {
                    yPos += (double)(EDIF.this.curCellPage - 1) * 1000.0;
                }
                if ((ni = NodeInst.makeInstance(EDIF.this.curFigureGroup != null ? EDIF.this.curFigureGroup : Artwork.tech.boxNode, new Point2D.Double(xPos, yPos), 0.0, 0.0, EDIF.this.curCell)) == null) {
                    System.out.println("Error, line " + EDIF.this.lineReader.getLineNumber() + ": could not create rectangle");
                    EDIF.this.errorCount++;
                }
            }
            EDIF.this.freePointList();
        }
    }

    private class KeyDisplay
    extends EDIFKEY {
        private KeyDisplay() {
            super("display");
        }

        protected void push() throws IOException {
            EDIF.this.makeFigure();
        }
    }

    private class KeyDirection
    extends EDIFKEY {
        private KeyDirection() {
            super("direction");
        }

        protected void push() throws IOException {
            String aName = EDIF.this.getToken('\u0000');
            if (aName.equalsIgnoreCase("INPUT")) {
                EDIF.this.curDirection = PortCharacteristic.IN;
            } else if (aName.equalsIgnoreCase("INOUT")) {
                EDIF.this.curDirection = PortCharacteristic.BIDIR;
            } else if (aName.equalsIgnoreCase("OUTPUT")) {
                EDIF.this.curDirection = PortCharacteristic.OUT;
            }
        }
    }

    private class KeyDesign
    extends EDIFKEY {
        private KeyDesign() {
            super("design");
        }

        protected void push() throws IOException {
            String aName = EDIF.this.getToken('\u0000');
        }

        protected void pop() {
            if (EDIF.this.cellRefProto != null) {
                Job.getUserInterface().setCurrentCell(EDIF.this.curLibrary, (Cell)EDIF.this.cellRefProto);
            }
        }
    }

    private class KeyDelta
    extends EDIFKEY {
        private KeyDelta() {
            super("delta");
        }

        protected void push() throws IOException {
            EDIF.this.deltaPointXX = (EDIF.this.deltaPointXY = 0.0);
            EDIF.this.deltaPointYX = (EDIF.this.deltaPointYY = 0.0);
            EDIF.this.deltaPointsSet = false;
        }
    }

    private class KeyCornerType
    extends EDIFKEY {
        private KeyCornerType() {
            super("cornerType");
        }

        protected void push() throws IOException {
            EDIF.this.getToken('\u0000');
        }
    }

    private class KeyContents
    extends EDIFKEY {
        private KeyContents() {
            super("contents");
        }
    }

    private class KeyCircle
    extends EDIFKEY {
        private KeyCircle() {
            super("circle");
        }

        protected void push() throws IOException {
            EDIF.this.freePointList();
            EDIF.this.curOrientation = OR0;
        }

        protected void pop() {
            if (EDIF.this.curPoints.size() == 2) {
                NodeInst ni;
                Point2D p0 = (Point2D)EDIF.this.curPoints.get(0);
                Point2D p1 = (Point2D)EDIF.this.curPoints.get(1);
                double lX = Math.min(p0.getX(), p1.getX());
                double hX = Math.max(p0.getX(), p1.getX());
                double lY = Math.min(p0.getY(), p1.getY());
                double hY = Math.max(p0.getY(), p1.getY());
                if (lX == hX) {
                    lX -= (hY - lY) / 2.0;
                    hX += (hY - lY) / 2.0;
                } else {
                    lY -= (hX - lX) / 2.0;
                    hY += (hX - lX) / 2.0;
                }
                double sX = hX - lX;
                double sY = hY - lY;
                double cX = (hX + lX) / 2.0;
                double cY = (hY + lY) / 2.0;
                if (EDIF.this.curCellPage > 0) {
                    cY += (double)(EDIF.this.curCellPage - 1) * 1000.0;
                }
                if ((ni = NodeInst.makeInstance(Artwork.tech.circleNode, new Point2D.Double(cX, cY), sX, sY, EDIF.this.curCell, EDIF.this.curOrientation, null, 0)) == null) {
                    System.out.println("Error, line " + EDIF.this.lineReader.getLineNumber() + ": could not create circle");
                    EDIF.this.errorCount++;
                }
            }
            EDIF.this.freePointList();
        }
    }

    private class KeyCellRef
    extends EDIFKEY {
        private KeyCellRef() {
            super("cellRef");
        }

        protected void push() throws IOException {
            EDIF.this.cellRef = EDIF.this.getToken('\u0000');
        }

        protected void pop() {
            String aName = EDIF.this.cellRef;
            EDIF.this.cellRefProtoTechBits = 0;
            EDIF.this.cellRefProtoRotation = 0;
            String view = "lay";
            if (EDIF.this.activeView != VMASKLAYOUT) {
                view = EDIF.this.keyStack[EDIF.this.keyStackDepth - 1] == EDIF.this.KDESIGN ? "p1" : "ic";
            }
            if (EDIF.this.curVendor == EVVIEWLOGIC && aName.equalsIgnoreCase("SPLITTER")) {
                EDIF.this.cellRefProto = null;
                return;
            }
            EDIFEquiv.NodeEquivalence ne = EDIF.this.equivs.getNodeEquivalence(EDIF.this.libraryRef, EDIF.this.cellRef, EDIF.this.viewRef);
            if (ne != null && ne.np != null) {
                Technology tech;
                EDIF.this.cellRefProto = ne.np;
                EDIF.this.cellRefProtoTechBits = 0;
                EDIF.this.cellRefProtoRotation = ne.rotation;
                if (EDIF.this.cellRefProto instanceof PrimitiveNode && (tech = EDIF.this.cellRefProto.getTechnology()) instanceof Schematics) {
                    EDIF.this.cellRefProtoTechBits = Schematics.getPrimitiveFunctionBits(ne.function);
                }
                return;
            }
            NameEntry nt = (NameEntry)EDIF.this.cellTable.get(aName);
            if (nt != null) {
                aName = nt.replace;
            } else {
                System.out.println("could not find cellRef <" + aName + ">");
            }
            Cell proto = null;
            Iterator<Cell> it = EDIF.this.curLibrary.getCells();
            while (it.hasNext()) {
                Cell cell = it.next();
                if (!cell.getName().equalsIgnoreCase(aName) || !cell.getView().getAbbreviation().equalsIgnoreCase(view)) continue;
                proto = cell;
                break;
            }
            if (proto == null) {
                if (view.length() > 0) {
                    aName = aName + "{" + view + "}";
                }
                if ((proto = Cell.makeInstance(EDIF.this.curLibrary, aName)) == null) {
                    System.out.println("Error, cannot create cell " + aName + " in library " + EDIF.this.curLibrary);
                }
                EDIF.this.builtCells.add(proto);
            }
            EDIF.this.cellRefProto = proto;
        }
    }

    private class KeyCell
    extends EDIFKEY {
        private KeyCell() {
            super("cell");
        }

        protected void push() throws IOException {
            EDIF.this.activeView = VNULL;
            EDIF.this.objectName = "";
            EDIF.this.originalName = "";
            EDIF.this.pageNumber = 0;
            EDIF.this.sheetXPos = (EDIF.this.sheetYPos = -1);
            if (EDIF.this.checkName()) {
                EDIF.this.cellReference = EDIF.this.objectName;
                EDIF.this.cellName = EDIF.this.objectName;
            }
        }
    }

    private class KeyBoundingBox
    extends EDIFKEY {
        private KeyBoundingBox() {
            super("boundingBox");
        }

        protected void push() throws IOException {
            EDIF.this.curFigureGroup = Artwork.tech.openedDottedPolygonNode;
        }

        protected void pop() {
            EDIF.this.curFigureGroup = null;
        }
    }

    private class KeyArray
    extends EDIFKEY {
        private KeyArray() {
            super("array");
        }

        protected void push() throws IOException {
            EDIF.this.isArray = true;
            EDIF.this.arrayXVal = (EDIF.this.arrayYVal = 0);
            EDIF.this.deltaPointXX = (EDIF.this.deltaPointXY = 0.0);
            EDIF.this.deltaPointYX = (EDIF.this.deltaPointYY = 0.0);
            EDIF.this.deltaPointsSet = false;
            if (EDIF.this.checkName()) {
                if (EDIF.this.keyStack[EDIF.this.keyStackDepth - 1] == EDIF.this.KCELL) {
                    EDIF.this.cellReference = EDIF.this.objectName;
                    EDIF.this.cellName = EDIF.this.objectName;
                } else if (EDIF.this.keyStack[EDIF.this.keyStackDepth - 1] == EDIF.this.KPORT) {
                    EDIF.this.portName = EDIF.this.objectName;
                    EDIF.this.portReference = EDIF.this.objectName;
                } else if (EDIF.this.keyStack[EDIF.this.keyStackDepth - 1] == EDIF.this.KINSTANCE) {
                    EDIF.this.instanceName = EDIF.this.objectName;
                    EDIF.this.instanceReference = EDIF.this.objectName;
                } else if (EDIF.this.keyStack[EDIF.this.keyStackDepth - 1] == EDIF.this.KNET) {
                    EDIF.this.netReference = EDIF.this.objectName;
                    EDIF.this.netName = EDIF.this.objectName;
                } else if (EDIF.this.keyStack[EDIF.this.keyStackDepth - 1] == EDIF.this.KPROPERTY) {
                    EDIF.this.propertyReference = EDIF.this.objectName;
                    EDIF.this.propertyName = EDIF.this.objectName;
                }
            }
        }

        protected void pop() {
            if (EDIF.this.arrayXVal == 0) {
                EDIF.this.arrayXVal = 1;
            }
            if (EDIF.this.arrayYVal == 0) {
                EDIF.this.arrayYVal = 1;
            }
        }
    }

    private class KeyArc
    extends EDIFKEY {
        private KeyArc() {
            super("arc");
        }

        protected void pop() {
            if (EDIF.this.curPoints.size() >= 3) {
                double[] x = new double[3];
                double[] y = new double[3];
                Point2D p0 = (Point2D)EDIF.this.curPoints.get(0);
                Point2D p1 = (Point2D)EDIF.this.curPoints.get(1);
                Point2D p2 = (Point2D)EDIF.this.curPoints.get(2);
                x[0] = p0.getX();
                y[0] = p0.getY();
                x[1] = p1.getX();
                y[1] = p1.getY();
                x[2] = p2.getX();
                y[2] = p2.getY();
                EDIF.this.makeArc(x, y);
            }
            EDIF.this.freePointList();
        }
    }

    private class EDIFKEY {
        private String name;
        private EDIFKEY[] stateArray;

        private EDIFKEY(String name) {
            this.name = name;
            edifKeys.put(TextUtils.canonicString(name), this);
        }

        protected void push() throws IOException {
        }

        protected void pop() throws IOException {
        }

        static /* synthetic */ EDIFKEY[] access$202(EDIFKEY x0, EDIFKEY[] x1) {
            x0.stateArray = x1;
            return x1;
        }
    }

    private static class EDIFProperty {
        private String name;
        private Object val;
        private EDIFProperty next;

        private EDIFProperty() {
        }
    }

    private static class VendorType {
        private VendorType() {
        }
    }

    private static class EDIFNetPort {
        private NodeInst ni;
        private PortProto pp;
        private int member;
        private EDIFNetPort next;

        private EDIFNetPort() {
        }
    }

    private static class EDIFPort {
        private String name;
        private String reference;
        private PortCharacteristic direction;
        private EDIFPort next;

        private EDIFPort() {
        }
    }

    private static class GeometryType {
        private GeometryType() {
        }
    }

    private static class ViewType {
        private String name;

        ViewType(String name) {
            this.name = name;
        }

        public String toString() {
            return "VIEWTYPE " + this.name;
        }
    }

    private static class NameEntry {
        private String original;
        private String replace;
        private NodeProto node;
        private ArcProto arc;
        private int textHeight;
        private AbstractTextDescriptor.Position justification;
        private boolean visible;

        private NameEntry() {
        }
    }
}

