/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs;

import com.sun.electric.database.text.Pref;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.JobException;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.dialogs.EDialog;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OptionReconcile
extends EDialog {
    private HashMap<JRadioButton, Pref.Meaning> changedOptions;
    private ArrayList<AbstractButton> currentSettings;
    private JButton ignoreLibraryOptions;
    private JButton ok;
    private JLabel optionHeader;
    private JScrollPane optionPane;
    private JButton useLibraryOptions;

    public OptionReconcile(Frame parent, boolean modal, List<Pref.Meaning> optionsThatChanged, String libname) {
        super(parent, modal);
        this.initComponents();
        this.getRootPane().setDefaultButton(this.ok);
        this.changedOptions = new HashMap();
        this.currentSettings = new ArrayList();
        JPanel optionBox = new JPanel();
        optionBox.setLayout(new GridBagLayout());
        this.optionPane.setViewportView(optionBox);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 0.2;
        gbc.weighty = 0.0;
        gbc.anchor = 17;
        gbc.fill = 0;
        gbc.insets = new Insets(4, 4, 4, 4);
        optionBox.add((Component)new JLabel("SETTING"), gbc);
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 0.2;
        gbc.weighty = 0.0;
        gbc.anchor = 17;
        gbc.fill = 0;
        gbc.insets = new Insets(4, 4, 4, 4);
        optionBox.add((Component)new JLabel("CURRENT VALUE"), gbc);
        gbc.gridx = 3;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 0.2;
        gbc.weighty = 0.0;
        gbc.anchor = 17;
        gbc.fill = 0;
        gbc.insets = new Insets(4, 4, 4, 4);
        optionBox.add((Component)new JLabel("LIBRARY VALUE"), gbc);
        gbc.gridx = 4;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 0.2;
        gbc.weighty = 0.0;
        gbc.anchor = 17;
        gbc.fill = 0;
        gbc.insets = new Insets(4, 4, 4, 4);
        optionBox.add((Component)new JLabel("SETTING LOCATION"), gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 5;
        gbc.gridheight = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 10;
        gbc.fill = 2;
        optionBox.add((Component)new JSeparator(), gbc);
        int rowNumber = 2;
        for (Pref.Meaning meaning : optionsThatChanged) {
            Pref pref = meaning.getPref();
            Object obj = meaning.getDesiredValue();
            if (obj.equals(pref.getValue())) continue;
            String oldValue = null;
            String newValue = null;
            switch (pref.getType()) {
                case BOOLEAN: {
                    oldValue = (Integer)pref.getValue() == 0 ? "OFF" : "ON";
                    newValue = (Integer)obj == 0 ? "OFF" : "ON";
                    break;
                }
                case INTEGER: {
                    int oldIntValue = (Integer)pref.getValue();
                    int newIntValue = (Integer)obj;
                    String[] trueMeaning = meaning.getTrueMeaning();
                    if (trueMeaning != null) {
                        oldValue = trueMeaning[oldIntValue];
                        newValue = trueMeaning[newIntValue];
                        break;
                    }
                    oldValue = Integer.toString(oldIntValue);
                    newValue = Integer.toString(newIntValue);
                    break;
                }
                case DOUBLE: {
                    oldValue = Double.toString((Double)pref.getValue());
                    if (obj instanceof Double) {
                        newValue = Double.toString((Double)obj);
                        break;
                    }
                    if (obj instanceof Float) {
                        newValue = Float.toString(((Float)obj).floatValue());
                        break;
                    }
                    System.out.println("HEY! setting " + pref.getPrefName() + " should have Double/Float but instead has value " + obj);
                    break;
                }
                case STRING: {
                    oldValue = pref.getValue().toString();
                    newValue = obj.toString();
                }
            }
            gbc.gridx = 1;
            gbc.gridy = rowNumber;
            gbc.gridwidth = 1;
            gbc.gridheight = 1;
            gbc.weightx = 0.2;
            gbc.weighty = 0.0;
            gbc.anchor = 17;
            gbc.fill = 0;
            optionBox.add((Component)new JLabel(meaning.getDescription()), gbc);
            gbc.gridx = 2;
            gbc.gridy = rowNumber;
            gbc.gridwidth = 1;
            gbc.gridheight = 1;
            gbc.weightx = 0.2;
            gbc.weighty = 0.0;
            gbc.anchor = 17;
            gbc.fill = 0;
            JRadioButton curValue = new JRadioButton(oldValue, false);
            this.currentSettings.add(curValue);
            optionBox.add((Component)curValue, gbc);
            gbc.gridx = 3;
            gbc.gridy = rowNumber;
            gbc.gridwidth = 1;
            gbc.gridheight = 1;
            gbc.weightx = 0.2;
            gbc.weighty = 0.0;
            gbc.anchor = 17;
            gbc.fill = 0;
            JRadioButton libValue = new JRadioButton(newValue, true);
            this.changedOptions.put(libValue, meaning);
            optionBox.add((Component)libValue, gbc);
            ButtonGroup group = new ButtonGroup();
            group.add(curValue);
            group.add(libValue);
            gbc.gridx = 4;
            gbc.gridy = rowNumber++;
            gbc.gridwidth = 1;
            gbc.gridheight = 1;
            gbc.weightx = 0.2;
            gbc.weighty = 0.0;
            gbc.anchor = 17;
            gbc.fill = 0;
            optionBox.add((Component)new JLabel(meaning.getLocation()), gbc);
        }
        this.optionHeader.setText("Library \"" + libname + "\" wants to use the following project settings which differ from the current project settings");
        this.pack();
        this.finishInitialization();
    }

    public void termDialog() {
        new DoReconciliation(this.changedOptions);
    }

    private void initComponents() {
        this.ok = new JButton();
        this.optionPane = new JScrollPane();
        this.optionHeader = new JLabel();
        this.ignoreLibraryOptions = new JButton();
        this.useLibraryOptions = new JButton();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Project Setting Reconciliation");
        this.setName("");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                OptionReconcile.this.closeDialog(evt);
            }
        });
        this.ok.setText("Use Above Settings");
        this.ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                OptionReconcile.this.ok(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.ok, gridBagConstraints);
        this.optionPane.setMinimumSize(new Dimension(500, 150));
        this.optionPane.setPreferredSize(new Dimension(650, 150));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.optionPane, gridBagConstraints);
        this.optionHeader.setText("The new Project Settings are different from the current Project Settings:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.optionHeader, gridBagConstraints);
        this.ignoreLibraryOptions.setText("Use All Current Settings");
        this.ignoreLibraryOptions.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                OptionReconcile.this.ignoreLibraryOptionsActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.ignoreLibraryOptions, gridBagConstraints);
        this.useLibraryOptions.setText("Use All New Settings");
        this.useLibraryOptions.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                OptionReconcile.this.useLibraryOptionsActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.useLibraryOptions, gridBagConstraints);
        this.pack();
    }

    private void useLibraryOptionsActionPerformed(ActionEvent evt) {
        for (JRadioButton b : this.changedOptions.keySet()) {
            b.setSelected(true);
        }
        this.ok(null);
    }

    private void ignoreLibraryOptionsActionPerformed(ActionEvent evt) {
        for (AbstractButton b : this.currentSettings) {
            b.setSelected(true);
        }
        this.ok(null);
    }

    private void ok(ActionEvent evt) {
        this.termDialog();
        this.closeDialog(null);
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private void updateButtonState() {
        boolean ignoreAllLibOptionsEnabled = false;
        boolean useAllLibOptionsEnabled = false;
        for (AbstractButton b : this.currentSettings) {
            if (b.isSelected()) {
                useAllLibOptionsEnabled = true;
            }
            if (b.isSelected()) continue;
            ignoreAllLibOptionsEnabled = true;
        }
        this.useLibraryOptions.setEnabled(useAllLibOptionsEnabled);
        this.ignoreLibraryOptions.setEnabled(ignoreAllLibOptionsEnabled);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DoReconciliation
    extends Job {
        private DoReconciliation(HashMap<JRadioButton, Pref.Meaning> changedOptions) {
            super("Reconcile Project Settings", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            ArrayList<Pref.Meaning> meaningsToReconcile = new ArrayList<Pref.Meaning>();
            for (JRadioButton cb : changedOptions.keySet()) {
                if (!cb.isSelected()) continue;
                Pref.Meaning meaning = changedOptions.get(cb);
                meaningsToReconcile.add(meaning);
            }
            Pref.finishPrefReconcilation(meaningsToReconcile);
            this.startJob();
        }

        @Override
        public boolean doIt() throws JobException {
            return true;
        }
    }
}

