/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs.options;

import com.sun.electric.database.text.Pref;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.dialogs.options.PreferencePanel;
import com.sun.electric.tool.user.ui.EditWindow;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;

public class DisplayControlTab
extends PreferencePanel {
    private boolean resetAllOpacity = false;
    private JTextField alphaBlendingOvercolorLimit;
    private ButtonGroup displayAlgorithm;
    private JPanel general;
    private JTextField generalGreekCellLimit;
    private JTextField generalGreekLimit;
    private JComboBox generalPanningDistance;
    private JCheckBox generalShowCursorCoordinates;
    private JCheckBox generalUseGreekImages;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JSeparator jSeparator1;
    private JRadioButton layerDisplay;
    private JTextField patternScaleLimit;
    private JRadioButton pixelDisplay;
    private JButton resetOpacity;
    private JCheckBox sideBarOnRight;
    private JRadioButton vectorDisplay;

    public DisplayControlTab(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
    }

    public JPanel getPanel() {
        return this.general;
    }

    public String getName() {
        return "Display Control";
    }

    public void init() {
        this.generalShowCursorCoordinates.setSelected(User.isShowHierarchicalCursorCoordinates());
        this.sideBarOnRight.setSelected(User.isSideBarOnRight());
        this.generalPanningDistance.addItem("Small");
        this.generalPanningDistance.addItem("Medium");
        this.generalPanningDistance.addItem("Large");
        this.generalPanningDistance.setSelectedIndex(User.getPanningDistance());
        int da = User.getDisplayAlgorithm();
        switch (da) {
            case 0: {
                this.pixelDisplay.setSelected(true);
                break;
            }
            case 1: {
                this.vectorDisplay.setSelected(true);
                break;
            }
            case 2: {
                this.layerDisplay.setSelected(true);
            }
        }
        this.generalUseGreekImages.setSelected(User.isUseCellGreekingImages());
        this.generalGreekLimit.setText(Double.toString(User.getGreekSizeLimit()));
        this.generalGreekCellLimit.setText(Double.toString(User.getGreekCellSizeLimit() * 100.0));
        this.patternScaleLimit.setText(Double.toString(User.getPatternedScaleLimit()));
        this.alphaBlendingOvercolorLimit.setText(Double.toString(User.getAlphaBlendingOvercolorLimit()));
    }

    public void term() {
        double currDouble;
        int currInt;
        boolean currBoolean = this.generalShowCursorCoordinates.isSelected();
        if (currBoolean != User.isShowHierarchicalCursorCoordinates()) {
            User.setShowHierarchicalCursorCoordinates(currBoolean);
        }
        if ((currBoolean = this.sideBarOnRight.isSelected()) != User.isSideBarOnRight()) {
            User.setSideBarOnRight(currBoolean);
        }
        if ((currInt = this.generalPanningDistance.getSelectedIndex()) != User.getPanningDistance()) {
            User.setPanningDistance(currInt);
        }
        if (this.pixelDisplay.isSelected()) {
            currInt = 0;
        } else if (this.vectorDisplay.isSelected()) {
            currInt = 1;
        } else if (this.layerDisplay.isSelected()) {
            currInt = 2;
        }
        if (currInt != User.getDisplayAlgorithm()) {
            User.setDisplayAlgorithm(currInt);
            EditWindow.displayAlgorithmChanged();
        }
        if ((currBoolean = this.generalUseGreekImages.isSelected()) != User.isUseCellGreekingImages()) {
            User.setUseCellGreekingImages(currBoolean);
        }
        if ((currDouble = TextUtils.atof(this.generalGreekLimit.getText())) != User.getGreekSizeLimit()) {
            User.setGreekSizeLimit(currDouble);
        }
        if ((currDouble = TextUtils.atof(this.generalGreekCellLimit.getText()) / 100.0) != User.getGreekCellSizeLimit()) {
            User.setGreekCellSizeLimit(currDouble);
        }
        if ((currDouble = TextUtils.atof(this.patternScaleLimit.getText())) != User.getPatternedScaleLimit()) {
            User.setPatternedScaleLimit(currDouble);
        }
        if ((currDouble = TextUtils.atof(this.alphaBlendingOvercolorLimit.getText())) != User.getAlphaBlendingOvercolorLimit()) {
            User.setAlphaBlendingOvercolorLimit(currDouble);
        }
        if (this.resetAllOpacity) {
            Pref.delayPrefFlushing();
            Iterator<Technology> it = Technology.getTechnologies();
            while (it.hasNext()) {
                Technology tech = it.next();
                EditWindow.setDefaultOpacity(tech);
            }
            Pref.resumePrefFlushing();
        }
    }

    private void initComponents() {
        this.displayAlgorithm = new ButtonGroup();
        this.general = new JPanel();
        this.generalShowCursorCoordinates = new JCheckBox();
        this.sideBarOnRight = new JCheckBox();
        this.jLabel1 = new JLabel();
        this.generalPanningDistance = new JComboBox();
        this.generalUseGreekImages = new JCheckBox();
        this.jLabel4 = new JLabel();
        this.jLabel6 = new JLabel();
        this.generalGreekCellLimit = new JTextField();
        this.generalGreekLimit = new JTextField();
        this.jLabel5 = new JLabel();
        this.jLabel7 = new JLabel();
        this.pixelDisplay = new JRadioButton();
        this.jSeparator1 = new JSeparator();
        this.vectorDisplay = new JRadioButton();
        this.layerDisplay = new JRadioButton();
        this.jLabel8 = new JLabel();
        this.patternScaleLimit = new JTextField();
        this.jLabel2 = new JLabel();
        this.alphaBlendingOvercolorLimit = new JTextField();
        this.resetOpacity = new JButton();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Edit Options");
        this.setName("");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                DisplayControlTab.this.closeDialog(evt);
            }
        });
        this.general.setLayout(new GridBagLayout());
        this.generalShowCursorCoordinates.setText("Show hierarchical cursor coordinates in status bar");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.general.add((Component)this.generalShowCursorCoordinates, gridBagConstraints);
        this.sideBarOnRight.setText("Side Bar defaults to the right side");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.general.add((Component)this.sideBarOnRight, gridBagConstraints);
        this.jLabel1.setText("Panning distance:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.general.add((Component)this.jLabel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.general.add((Component)this.generalPanningDistance, gridBagConstraints);
        this.generalUseGreekImages.setText("Use cell images when simplifying");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 30, 2, 4);
        this.general.add((Component)this.generalUseGreekImages, gridBagConstraints);
        this.jLabel4.setText("Simplify objects smaller than:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 30, 2, 4);
        this.general.add((Component)this.jLabel4, gridBagConstraints);
        this.jLabel6.setText("Do not simplify cells greater than:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 30, 4, 4);
        this.general.add((Component)this.jLabel6, gridBagConstraints);
        this.generalGreekCellLimit.setColumns(5);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 4, 4, 4);
        this.general.add((Component)this.generalGreekCellLimit, gridBagConstraints);
        this.generalGreekLimit.setColumns(5);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.general.add((Component)this.generalGreekLimit, gridBagConstraints);
        this.jLabel5.setText("pixels");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.general.add((Component)this.jLabel5, gridBagConstraints);
        this.jLabel7.setText("percent of screen");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 4, 4);
        this.general.add((Component)this.jLabel7, gridBagConstraints);
        this.displayAlgorithm.add(this.pixelDisplay);
        this.pixelDisplay.setText("Pixel Display Algorithm (old)");
        this.pixelDisplay.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.pixelDisplay.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.general.add((Component)this.pixelDisplay, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.general.add((Component)this.jSeparator1, gridBagConstraints);
        this.displayAlgorithm.add(this.vectorDisplay);
        this.vectorDisplay.setText("Vector Display Algorithm (new)");
        this.vectorDisplay.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.vectorDisplay.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.general.add((Component)this.vectorDisplay, gridBagConstraints);
        this.displayAlgorithm.add(this.layerDisplay);
        this.layerDisplay.setText("Layer Display Algorithm (experimental)");
        this.layerDisplay.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.layerDisplay.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.general.add((Component)this.layerDisplay, gridBagConstraints);
        this.jLabel8.setText("Pattern scale limit");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 30, 2, 4);
        this.general.add((Component)this.jLabel8, gridBagConstraints);
        this.patternScaleLimit.setColumns(5);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.general.add((Component)this.patternScaleLimit, gridBagConstraints);
        this.jLabel2.setText("Alpha blending overcolor limit");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 30, 2, 4);
        this.general.add((Component)this.jLabel2, gridBagConstraints);
        this.alphaBlendingOvercolorLimit.setColumns(5);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.general.add((Component)this.alphaBlendingOvercolorLimit, gridBagConstraints);
        this.resetOpacity.setText("Reset all Layer Opacity Values");
        this.resetOpacity.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DisplayControlTab.this.resetOpacityActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 30, 4, 4);
        this.general.add((Component)this.resetOpacity, gridBagConstraints);
        this.getContentPane().add((Component)this.general, new GridBagConstraints());
        this.pack();
    }

    private void resetOpacityActionPerformed(ActionEvent evt) {
        this.resetAllOpacity = true;
        this.resetOpacity.setEnabled(false);
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }
}

