/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database;

import com.sun.electric.database.CellBackup;
import com.sun.electric.database.CellId;
import com.sun.electric.database.ExportId;
import com.sun.electric.database.ImmutableExport;
import com.sun.electric.database.LibId;
import com.sun.electric.database.Snapshot;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;

public class IdMapper
implements Serializable {
    private final HashMap<LibId, LibId> libIdMap = new HashMap();
    private final HashMap<CellId, CellId> cellIdMap = new HashMap();
    private final HashMap<ExportId, ExportId> exportIdMap = new HashMap();

    public static IdMapper renameLibrary(Snapshot snapshot, LibId oldLibId, LibId newLibId) {
        IdMapper idMapper = new IdMapper();
        idMapper.libIdMap.put(oldLibId, newLibId);
        for (CellBackup cellBackup : snapshot.cellBackups) {
            if (cellBackup == null || cellBackup.d.getLibId() != oldLibId) continue;
            CellId newCellId = newLibId.newCellId(cellBackup.d.cellId.cellName);
            idMapper.moveCell(cellBackup, newCellId);
        }
        return idMapper;
    }

    public static IdMapper renameCell(Snapshot snapshot, CellId oldCellId, CellId newCellId) {
        IdMapper idMapper = new IdMapper();
        CellBackup cellBackup = snapshot.getCell(oldCellId);
        idMapper.moveCell(cellBackup, newCellId);
        return idMapper;
    }

    public static IdMapper consolidateExportIds(Snapshot snapshot) {
        IdMapper idMapper = new IdMapper();
        for (CellBackup cellBackup : snapshot.cellBackups) {
            if (cellBackup == null) continue;
            CellId cellId = cellBackup.d.cellId;
            for (ImmutableExport e : cellBackup.exports) {
                if (e.name.toString().equals(e.exportId.externalId)) continue;
                idMapper.exportIdMap.put(e.exportId, cellId.newExportId(e.name.toString()));
            }
        }
        return idMapper;
    }

    public void moveCell(CellBackup cellBackup, CellId newCellId) {
        CellId oldCellId = cellBackup.d.cellId;
        this.cellIdMap.put(oldCellId, newCellId);
    }

    public LibId get(LibId key) {
        LibId value = this.libIdMap.get(key);
        return value != null ? value : key;
    }

    public CellId get(CellId key) {
        CellId value = this.cellIdMap.get(key);
        return value != null ? value : key;
    }

    public ExportId get(ExportId key) {
        ExportId newExportId = this.exportIdMap.get(key);
        if (newExportId != null) {
            return newExportId;
        }
        CellId newParentId = this.cellIdMap.get(key.parentId);
        return newParentId != null ? newParentId.newExportId(key.externalId) : key;
    }

    public Collection<CellId> getNewCellIds() {
        return this.cellIdMap.values();
    }
}

