/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.menus;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.View;
import com.sun.electric.tool.user.ViewChanges;
import com.sun.electric.tool.user.dialogs.ViewControl;
import com.sun.electric.tool.user.menus.EMenu;
import com.sun.electric.tool.user.menus.EMenuItem;
import com.sun.electric.tool.user.menus.ToolMenu;
import com.sun.electric.tool.user.ui.TopLevel;
import com.sun.electric.tool.user.ui.WindowFrame;
import java.awt.Frame;
import java.util.List;
import javax.swing.JOptionPane;

public class ViewMenu {
    static EMenu makeMenu() {
        return new EMenu("_View", new EMenuItem("View _Control..."){

            @Override
            public void run() {
                ViewMenu.viewControlCommand();
            }
        }, new EMenuItem("Chan_ge Cell's View..."){

            @Override
            public void run() {
                ViewMenu.changeViewCommand();
            }
        }, EMenuItem.SEPARATOR, new EMenuItem("Edit La_yout View"){

            @Override
            public void run() {
                ViewMenu.editLayoutViewCommand();
            }
        }, new EMenuItem("Edit Schema_tic View"){

            @Override
            public void run() {
                ViewMenu.editSchematicViewCommand();
            }
        }, new EMenuItem("Edit Ic_on View"){

            @Override
            public void run() {
                ViewMenu.editIconViewCommand();
            }
        }, new EMenuItem("Edit V_HDL View"){

            @Override
            public void run() {
                ViewMenu.editVHDLViewCommand();
            }
        }, new EMenuItem("Edit Document_ation View"){

            @Override
            public void run() {
                ViewMenu.editDocViewCommand();
            }
        }, new EMenuItem("Edit S_keleton View"){

            @Override
            public void run() {
                ViewMenu.editSkeletonViewCommand();
            }
        }, new EMenuItem("Edit Other Vie_w..."){

            @Override
            public void run() {
                ViewMenu.editOtherViewCommand();
            }
        }, EMenuItem.SEPARATOR, new EMenuItem("Make _Icon View"){

            @Override
            public void run() {
                ViewChanges.makeIconViewCommand();
            }
        }, new EMenuItem("Make _Schematic View"){

            @Override
            public void run() {
                ViewChanges.makeSchematicView();
            }
        }, new EMenuItem("Make Alternate Layo_ut View..."){

            @Override
            public void run() {
                ViewChanges.makeLayoutView();
            }
        }, new EMenuItem("Make Ske_leton View"){

            @Override
            public void run() {
                ViewChanges.makeSkeletonViewCommand();
            }
        }, new EMenuItem("Make _VHDL View"){

            @Override
            public void run() {
                ToolMenu.makeVHDL();
            }
        });
    }

    public static void viewControlCommand() {
        ViewControl dialog = new ViewControl((Frame)TopLevel.getCurrentJFrame(), true);
        dialog.setVisible(true);
    }

    public static void changeViewCommand() {
        Cell cell = WindowFrame.getCurrentCell();
        if (cell == null) {
            return;
        }
        List<View> views = View.getOrderedViews();
        Object[] viewNames = new String[views.size()];
        for (int i = 0; i < views.size(); ++i) {
            viewNames[i] = views.get(i).getFullName();
        }
        Object newName = JOptionPane.showInputDialog(TopLevel.getCurrentJFrame(), "New view for this cell", "Choose alternate view", 3, null, viewNames, cell.getView().getFullName());
        if (newName == null) {
            return;
        }
        String newViewName = (String)newName;
        View newView = View.findView(newViewName);
        if (newView != null && newView != cell.getView()) {
            ViewChanges.changeCellView(cell, newView);
        }
    }

    public static void editLayoutViewCommand() {
        Cell curCell = WindowFrame.needCurCell();
        if (curCell == null) {
            return;
        }
        Cell layoutView = curCell.otherView(View.LAYOUT);
        if (layoutView == null) {
            System.out.println("There is no layout view of " + curCell);
        } else {
            WindowFrame.createEditWindow(layoutView);
        }
    }

    public static void editSchematicViewCommand() {
        Cell curCell = WindowFrame.needCurCell();
        if (curCell == null) {
            return;
        }
        Cell schematicView = curCell.otherView(View.SCHEMATIC);
        if (schematicView == null) {
            System.out.println("There is no schematic view of " + curCell);
        } else {
            WindowFrame.createEditWindow(schematicView);
        }
    }

    public static void editIconViewCommand() {
        Cell curCell = WindowFrame.needCurCell();
        if (curCell == null) {
            return;
        }
        Cell iconView = curCell.otherView(View.ICON);
        if (iconView == null) {
            System.out.println("There is no icon view of " + curCell);
        } else {
            WindowFrame.createEditWindow(iconView);
        }
    }

    public static void editVHDLViewCommand() {
        Cell curCell = WindowFrame.needCurCell();
        if (curCell == null) {
            return;
        }
        Cell vhdlView = curCell.otherView(View.VHDL);
        if (vhdlView == null) {
            System.out.println("There is no VHDL view of " + curCell);
        } else {
            WindowFrame.createEditWindow(vhdlView);
        }
    }

    public static void editDocViewCommand() {
        Cell curCell = WindowFrame.needCurCell();
        if (curCell == null) {
            return;
        }
        Cell docView = curCell.otherView(View.DOC);
        if (docView == null) {
            System.out.println("There is no documentation view of " + curCell);
        } else {
            WindowFrame.createEditWindow(docView);
        }
    }

    public static void editSkeletonViewCommand() {
        Cell curCell = WindowFrame.needCurCell();
        if (curCell == null) {
            return;
        }
        Cell skelView = curCell.otherView(View.LAYOUTSKEL);
        if (skelView == null) {
            System.out.println("There is no skeleton view of " + curCell);
        } else {
            WindowFrame.createEditWindow(skelView);
        }
    }

    public static void editOtherViewCommand() {
        Cell curCell = WindowFrame.needCurCell();
        if (curCell == null) {
            return;
        }
        List<View> views = View.getOrderedViews();
        Object[] viewNames = new String[views.size()];
        for (int i = 0; i < views.size(); ++i) {
            viewNames[i] = views.get(i).getFullName();
        }
        Object newName = JOptionPane.showInputDialog(TopLevel.getCurrentJFrame(), "Which associated view do you want to see?", "Choose alternate view", 3, null, viewNames, curCell.getView().getFullName());
        if (newName == null) {
            return;
        }
        String newViewName = (String)newName;
        View newView = View.findView(newViewName);
        Cell otherView = curCell.otherView(newView);
        if (otherView == null) {
            System.out.println("There is no " + newViewName + " view of " + curCell);
        } else {
            WindowFrame.createEditWindow(otherView);
        }
    }
}

