/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.technology;

import com.sun.electric.database.geometry.DBMath;
import com.sun.electric.database.geometry.ERectangle;
import com.sun.electric.database.geometry.GenMath;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.technology.AbstractShapeBuilder;
import com.sun.electric.technology.Layer;
import java.awt.geom.Rectangle2D;

public class BoundsBuilder
extends AbstractShapeBuilder {
    private int intMinX;
    private int intMinY;
    private int intMaxX;
    private int intMaxY;
    private double doubleMinX;
    private double doubleMinY;
    private double doubleMaxX;
    private double doubleMaxY;
    private boolean hasIntBounds;
    private boolean hasDoubleBounds;

    public BoundsBuilder(AbstractShapeBuilder.Shrinkage shrinkage) {
        this.setShrinkage(shrinkage);
        this.clear();
    }

    public void clear() {
        this.hasDoubleBounds = false;
        this.hasIntBounds = false;
    }

    public ERectangle makeBounds() {
        if (!this.hasDoubleBounds) {
            if (!this.hasIntBounds) {
                return null;
            }
            int iw = this.intMaxX - this.intMinX;
            int ih = this.intMaxY - this.intMinY;
            return ERectangle.fromGrid(this.intMinX, this.intMinY, iw >= 0 ? (long)iw : (long)this.intMaxX - (long)this.intMinX, ih >= 0 ? (long)ih : (long)this.intMaxY - (long)this.intMinY);
        }
        if (this.hasIntBounds) {
            if ((double)this.intMinX < this.doubleMinX) {
                this.doubleMinX = this.intMinX;
            }
            if ((double)this.intMinY < this.doubleMinY) {
                this.doubleMinY = this.intMinY;
            }
            if ((double)this.intMaxX > this.doubleMaxX) {
                this.doubleMaxX = this.intMaxX;
            }
            if ((double)this.intMaxY > this.doubleMaxY) {
                this.doubleMaxY = this.intMaxY;
            }
            this.hasIntBounds = false;
        }
        long longMinX = GenMath.floorLong(this.doubleMinX);
        long longMaxX = GenMath.ceilLong(this.doubleMaxX);
        long longMinY = GenMath.floorLong(this.doubleMinY);
        long longMaxY = GenMath.ceilLong(this.doubleMaxY);
        return ERectangle.fromGrid(longMinX, longMinY, longMaxX - longMinX, longMaxY - longMinY);
    }

    public boolean makeBounds(Rectangle2D.Double visBounds) {
        double h;
        double w;
        double y;
        double x;
        if (!this.hasDoubleBounds) {
            assert (this.hasIntBounds);
            x = this.intMinX;
            y = this.intMinY;
            int iw = this.intMaxX - this.intMinX;
            w = iw >= 0 ? (double)iw : (double)((long)this.intMaxX - (long)this.intMinX);
            int ih = this.intMaxY - this.intMinY;
            h = ih >= 0 ? (double)ih : (double)((long)this.intMaxY - (long)this.intMinY);
        } else {
            if (this.hasIntBounds) {
                if ((double)this.intMinX < this.doubleMinX) {
                    this.doubleMinX = this.intMinX;
                }
                if ((double)this.intMinY < this.doubleMinY) {
                    this.doubleMinY = this.intMinY;
                }
                if ((double)this.intMaxX > this.doubleMaxX) {
                    this.doubleMaxX = this.intMaxX;
                }
                if ((double)this.intMaxY > this.doubleMaxY) {
                    this.doubleMaxY = this.intMaxY;
                }
                this.hasIntBounds = false;
            }
            x = GenMath.floorLong(this.doubleMinX);
            y = GenMath.floorLong(this.doubleMinY);
            w = (double)GenMath.ceilLong(this.doubleMaxX) - x;
            h = (double)GenMath.ceilLong(this.doubleMaxY) - y;
        }
        x = DBMath.gridToLambda(x);
        y = DBMath.gridToLambda(y);
        w = DBMath.gridToLambda(w);
        h = DBMath.gridToLambda(h);
        if (x == visBounds.getX() && y == visBounds.getY() && w == visBounds.getWidth() && h == visBounds.getHeight()) {
            return false;
        }
        visBounds.setRect(x, y, w, h);
        return true;
    }

    public void addDoublePoly(int numPoints, Poly.Type style, Layer layer) {
        if (!this.hasDoubleBounds) {
            assert (numPoints > 0);
            this.doubleMinX = this.doubleMaxX = this.doubleCoords[0];
            this.doubleMinY = this.doubleMaxY = this.doubleCoords[1];
            this.hasDoubleBounds = true;
        }
        for (int i = 0; i < numPoints; ++i) {
            double x = this.doubleCoords[i * 2];
            double y = this.doubleCoords[i * 2 + 1];
            if (x < this.doubleMinX) {
                this.doubleMinX = x;
            }
            if (x > this.doubleMaxX) {
                this.doubleMaxX = x;
            }
            if (y < this.doubleMinY) {
                this.doubleMinY = y;
            }
            if (!(y > this.doubleMaxY)) continue;
            this.doubleMaxY = y;
        }
    }

    public void addIntLine(int[] coords, Poly.Type style, Layer layer) {
        int y2;
        int y1;
        int x1 = coords[0];
        int x2 = coords[2];
        if (x1 > x2) {
            coords[0] = x2;
            coords[2] = x1;
        }
        if ((y1 = coords[1]) > (y2 = coords[3])) {
            coords[1] = y2;
            coords[3] = y1;
        }
        this.addIntBox(coords, layer);
    }

    public void addIntBox(int[] coords, Layer layer) {
        if (!this.hasIntBounds) {
            this.intMinX = coords[0];
            this.intMinY = coords[1];
            this.intMaxX = coords[2];
            this.intMaxY = coords[3];
            this.hasIntBounds = true;
        } else {
            if (coords[0] < this.intMinX) {
                this.intMinX = coords[0];
            }
            if (coords[2] > this.intMaxX) {
                this.intMaxX = coords[2];
            }
            if (coords[1] < this.intMinY) {
                this.intMinY = coords[1];
            }
            if (coords[3] > this.intMaxY) {
                this.intMaxY = coords[3];
            }
        }
    }
}

