/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.placement.simulatedAnnealing1.metrics;

import com.sun.electric.tool.placement.PlacementFrame;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BBMetric {
    private double currentScore;
    private List<PlacementFrame.PlacementNetwork> allNetworks;

    public BBMetric(List<PlacementFrame.PlacementNetwork> allNetworks) {
        this.allNetworks = allNetworks;
    }

    public double getScore() {
        this.currentScore = 0.0;
        for (int i = 0; i < this.allNetworks.size(); ++i) {
            PlacementFrame.PlacementNetwork n = this.allNetworks.get(i);
            this.currentScore += this.calculateBoundingBoxScore(n);
        }
        return this.currentScore;
    }

    protected double calculateBoundingBoxScore(PlacementFrame.PlacementNetwork n) {
        List<PlacementFrame.PlacementPort> l = n.getPortsOnNet();
        if (l.size() == 0) {
            return 0.0;
        }
        double xMin = Double.MAX_VALUE;
        double xMax = -1.7976931348623157E308;
        double yMin = Double.MAX_VALUE;
        double yMax = -1.7976931348623157E308;
        for (PlacementFrame.PlacementPort p : l) {
            PlacementFrame.PlacementNode originalPlacementNode = p.getPlacementNode();
            double movedX = 0.0;
            double movedY = 0.0;
            double x = movedX + originalPlacementNode.getPlacementX();
            double y = movedY + originalPlacementNode.getPlacementY();
            if (x < xMin) {
                xMin = x;
            }
            if (x > xMax) {
                xMax = x;
            }
            if (y < yMin) {
                yMin = y;
            }
            if (!(y > yMax)) continue;
            yMax = y;
        }
        double score = xMax - xMin + (yMax - yMin);
        return score;
    }
}

