/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.util.concurrent.utils;

import com.sun.electric.tool.util.concurrent.utils.BlockedRange;
import com.sun.electric.tool.util.concurrent.utils.ConcurrentCollectionFactory;
import com.sun.electric.tool.util.concurrent.utils.Range;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlockedRange2D
extends BlockedRange<BlockedRange2D> {
    private Range col;
    private Range row;
    private Integer currentCol = null;
    private Integer currentRow = null;

    public BlockedRange2D(int startRow, int endRow, int stepRow, int startCol, int endCol, int stepCol) {
        this.col = new Range(startCol, endCol, stepCol);
        this.row = new Range(startRow, endRow, stepRow);
    }

    public Range col() {
        return this.col;
    }

    public Range row() {
        return this.row;
    }

    @Override
    public List<BlockedRange2D> splitBlockedRange(int step) {
        if (this.currentRow != null && this.currentRow >= this.row.end()) {
            return null;
        }
        ArrayList<BlockedRange2D> result2 = ConcurrentCollectionFactory.createArrayList();
        for (int i = 0; i < step; ++i) {
            if (this.currentRow == null) {
                this.currentRow = this.row.start();
            }
            if (this.currentCol == null) {
                this.currentCol = this.col.start();
            }
            if (this.currentCol >= this.col.end()) {
                this.currentCol = this.col.start();
                this.currentRow = this.currentRow + this.row.step();
                if (this.currentRow >= this.row.end()) {
                    return result2;
                }
            }
            result2.add(new BlockedRange2D(this.currentRow, Math.min(this.currentRow + this.row.step(), this.row.end()), this.row.step(), this.currentCol, Math.min(this.currentCol + this.col.step(), this.col.end()), this.col.step()));
            this.currentCol = this.currentCol + this.col.step();
        }
        return result2;
    }

    @Override
    public BlockedRange2D createInstance(int number2, int total) {
        int size2 = this.row.end() - this.row.start();
        int split = size2 / total;
        BlockedRange2D result2 = new BlockedRange2D(number2 * split, number2 + 1 == total ? this.row.end() : (number2 + 1) * split, this.row.step(), this.col.start(), this.col.end(), this.col.step());
        return result2;
    }
}

