/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.logicaleffort;

import com.sun.electric.database.geometry.ERectangle;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.HierarchyEnumerator;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.hierarchy.Nodable;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.JobException;
import com.sun.electric.tool.logicaleffort.LESizer;
import com.sun.electric.tool.logicaleffort.LETool;
import com.sun.electric.tool.user.ErrorLogger;
import java.awt.geom.Point2D;
import java.awt.geom.RectangularShape;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;

public abstract class LENetlister
extends HierarchyEnumerator.Visitor {
    static final Netlist.ShortResistors SHORT_RESISTORS = Netlist.ShortResistors.ALL;
    public static final Variable.Key ATTR_su = Variable.newKey("ATTR_su");
    public static final Variable.Key ATTR_le = Variable.newKey("ATTR_le");
    public static final Variable.Key ATTR_wire_ratio = Variable.newKey("ATTR_wire_ratio");
    public static final Variable.Key ATTR_epsilon = Variable.newKey("ATTR_epsilon");
    public static final Variable.Key ATTR_max_iter = Variable.newKey("ATTR_max_iter");
    public static final Variable.Key ATTR_gate_cap = Variable.newKey("ATTR_gate_cap");
    public static final Variable.Key ATTR_alpha = Variable.newKey("ATTR_alpha");
    public static final Variable.Key ATTR_diffn = Variable.newKey("ATTR_diffn");
    public static final Variable.Key ATTR_diffp = Variable.newKey("ATTR_diffp");
    public static final Variable.Key ATTR_keeper_ratio = Variable.newKey("ATTR_keeper_ratio");
    public static final Variable.Key ATTR_x1inverter_nwidth = Variable.newKey("ATTR_x1inverter_nwidth");
    public static final Variable.Key ATTR_x1inverter_pwidth = Variable.newKey("ATTR_x1inverter_pwidth");
    public static final Variable.Key ATTR_x1inverter_length = Variable.newKey("ATTR_x1inverter_length");
    public static final Variable.Key ATTR_LEGATE = Variable.newKey("ATTR_LEGATE");
    public static final Variable.Key ATTR_LEKEEPER = Variable.newKey("ATTR_LEKEEPER");
    public static final Variable.Key ATTR_LEWIRE = Variable.newKey("ATTR_LEWIRE");
    public static final Variable.Key ATTR_LEIGNORE = Variable.newKey("ATTR_LEIGNORE");
    public static final Variable.Key ATTR_LESETTINGS = Variable.newKey("ATTR_LESETTINGS");
    public static final Variable.Key ATTR_LEPARALLGRP = Variable.newKey("ATTR_LEPARALLGRP");
    public static final Variable.Key ATTR_L = Variable.newKey("ATTR_L");
    public static final Variable.Key ATTR_LEWIRECAP = Variable.newKey("ATTR_LEWIRECAP");
    Technology layoutTech;

    LENetlister(Technology layoutTech) {
        this.layoutTech = layoutTech;
    }

    public abstract boolean netlist(Cell var1, VarContext var2, boolean var3);

    public abstract void done();

    public abstract boolean size(LESizer.Alg var1);

    public abstract ErrorLogger getErrorLogger();

    public abstract void nullErrorLogger();

    public abstract NetlisterConstants getConstants();

    public abstract void getSizes(List<Float> var1, List<String> var2, List<NodeInst> var3, List<VarContext> var4);

    public abstract void printStatistics();

    public abstract boolean printResults(Nodable var1, VarContext var2);

    public abstract float getTotalLESize();

    protected NetlisterConstants getSettings(Cell cell) {
        if (!LETool.isUseLocalSettings()) {
            return null;
        }
        Iterator<NodeInst> instIt = cell.getNodes();
        while (instIt.hasNext()) {
            NodeInst ni = instIt.next();
            if (ni.isIconOfParent() || !ni.isCellInstance() || ni.getParameterOrVariable(ATTR_LESETTINGS) == null) continue;
            Technology tech = cell.getTechnology();
            if (cell.isSchematic()) {
                tech = this.layoutTech;
            }
            float su = (float)LETool.getGlobalFanout();
            float epsilon = (float)LETool.getConvergenceEpsilon();
            int maxIterations = LETool.getMaxIterations();
            float gateCap = (float)tech.getGateCapacitance();
            float wireRatio = (float)tech.getWireRatio();
            float alpha = (float)tech.getDiffAlpha();
            float keeperRatio = (float)LETool.getKeeperRatio();
            float x1inverter_nwidth = (float)LETool.getX1InverterNWidth();
            float x1inverter_pwidth = (float)LETool.getX1InverterPWidth();
            float x1inverter_length = (float)LETool.getX1InverterLength();
            VarContext context = VarContext.globalContext;
            Variable var = ni.getParameterOrVariable(ATTR_su);
            if (var != null) {
                su = VarContext.objectToFloat(context.evalVar(var), su);
            }
            if ((var = ni.getParameterOrVariable(ATTR_wire_ratio)) != null) {
                wireRatio = VarContext.objectToFloat(context.evalVar(var), wireRatio);
            }
            if ((var = ni.getParameterOrVariable(ATTR_epsilon)) != null) {
                epsilon = VarContext.objectToFloat(context.evalVar(var), epsilon);
            }
            if ((var = ni.getParameterOrVariable(ATTR_max_iter)) != null) {
                maxIterations = VarContext.objectToInt(context.evalVar(var), maxIterations);
            }
            if ((var = ni.getParameterOrVariable(ATTR_gate_cap)) != null) {
                gateCap = VarContext.objectToFloat(context.evalVar(var), gateCap);
            }
            if ((var = ni.getParameterOrVariable(ATTR_alpha)) != null) {
                alpha = VarContext.objectToFloat(context.evalVar(var), alpha);
            }
            if ((var = ni.getParameterOrVariable(ATTR_keeper_ratio)) != null) {
                keeperRatio = VarContext.objectToFloat(context.evalVar(var), keeperRatio);
            }
            if ((var = ni.getParameterOrVariable(ATTR_x1inverter_nwidth)) != null) {
                x1inverter_nwidth = VarContext.objectToFloat(context.evalVar(var), x1inverter_nwidth);
            }
            if ((var = ni.getParameterOrVariable(ATTR_x1inverter_pwidth)) != null) {
                x1inverter_pwidth = VarContext.objectToFloat(context.evalVar(var), x1inverter_pwidth);
            }
            if ((var = ni.getParameterOrVariable(ATTR_x1inverter_length)) != null) {
                x1inverter_length = VarContext.objectToFloat(context.evalVar(var), x1inverter_length);
            }
            return new NetlisterConstants(su, wireRatio, epsilon, maxIterations, gateCap, alpha, keeperRatio, x1inverter_nwidth, x1inverter_pwidth, x1inverter_length);
        }
        return null;
    }

    protected boolean isSettingsConflict(NetlisterConstants current, Cell topLevelCell, VarContext context, Cell localCell) {
        assert (current != null);
        NetlisterConstants local = this.getSettings(localCell);
        if (local == null) {
            return false;
        }
        if (!current.equals(local)) {
            System.out.println("Error: Global settings from " + topLevelCell + " do not match global settings from \"" + context.getInstPath("/") + ": " + localCell.noLibDescribe() + "\" in (" + localCell.getLibrary().getName() + ")");
            System.out.println("       Global settings are by definition global, and differences may indicate an inconsistency in your design.");
            System.out.println("       Note that step-up, \"su\", can be made local by defining a \"su\" parameter on an instance.");
            System.out.println("\tglobal/parent vs local:");
            if (current.su != local.su) {
                System.out.println("su:\t" + current.su + " vs " + local.su);
            }
            if (current.wireRatio != local.wireRatio) {
                System.out.println("wireRatio:\t" + current.wireRatio + " vs " + local.wireRatio);
            }
            if (current.epsilon != local.epsilon) {
                System.out.println("epsilon:\t" + current.epsilon + " vs " + local.epsilon);
            }
            if (current.maxIterations != local.maxIterations) {
                System.out.println("maxIterations:\t" + current.maxIterations + " vs " + local.maxIterations);
            }
            if (current.gateCap != local.gateCap) {
                System.out.println("gateCap:\t" + current.gateCap + " vs " + local.gateCap);
            }
            if (current.alpha != local.alpha) {
                System.out.println("alpha:\t" + current.alpha + " vs " + local.alpha);
            }
            if (current.keeperRatio != local.keeperRatio) {
                System.out.println("keeperRatio:\t" + current.keeperRatio + " vs " + local.keeperRatio);
            }
            if (current.x1inverter_nwidth != local.x1inverter_nwidth) {
                System.out.println("x=1 inverter nwidth:\t" + current.x1inverter_nwidth + " vs " + local.x1inverter_nwidth);
            }
            if (current.x1inverter_pwidth != local.x1inverter_pwidth) {
                System.out.println("x=1 inverter pwidth:\t" + current.x1inverter_pwidth + " vs " + local.x1inverter_pwidth);
            }
            if (current.x1inverter_length != local.x1inverter_length) {
                System.out.println("x=1 inverter length:\t" + current.x1inverter_length + " vs " + local.x1inverter_length);
            }
            Job.getUserInterface().showErrorMessage("Conflicting global parameter settings were found, please see message window for details", "Settings Conflict Found!!");
            return true;
        }
        return false;
    }

    protected boolean saveSettings(NetlisterConstants constants, Cell cell) {
        if (this.getSettings(cell) != null) {
            return false;
        }
        Cell settings = null;
        Iterator<Library> it = Library.getLibraries();
        while (it.hasNext()) {
            Library lib = it.next();
            Iterator<Cell> it2 = lib.getCells();
            while (it2.hasNext()) {
                Cell c = it2.next();
                if (c.getParameterOrVariable(ATTR_LESETTINGS) == null) continue;
                settings = c;
                break;
            }
            if (settings == null) continue;
            break;
        }
        if (settings == null) {
            System.out.println("Could not find LESETTINGS cell in order to save settings to " + cell);
            return false;
        }
        System.out.println("Creating new LESETTINGS box on " + cell + " from User Preferences because none found. Logical effort requires this box");
        SaveSettings job = new SaveSettings(cell, settings, constants);
        return true;
    }

    protected static class LECellInfo
    extends HierarchyEnumerator.CellInfo {
        private float mFactor;
        private float cellsu;
        private NetlisterConstants localSettings;

        protected LECellInfo() {
        }

        protected void leInit(NetlisterConstants constants) {
            HierarchyEnumerator.CellInfo parent = this.getParentInfo();
            this.mFactor = parent == null ? 1.0f : ((LECellInfo)parent).getMFactor();
            this.cellsu = parent == null ? constants.su : ((LECellInfo)parent).getSU();
            Nodable ni = this.getContext().getNodable();
            if (ni != null) {
                float su;
                Variable suvar;
                Object mval;
                Variable mvar = LETool.getMFactor(ni);
                if (mvar != null && (mval = this.getContext().evalVar(mvar, null)) != null) {
                    this.mFactor *= VarContext.objectToFloat(mval, 1.0f);
                }
                if ((suvar = ni.getParameterOrVariable(ATTR_su)) != null && (su = VarContext.objectToFloat(this.getContext().evalVar(suvar, null), -1.0f)) != -1.0f) {
                    this.cellsu = su;
                }
            }
            this.localSettings = new NetlisterConstants(this.cellsu, constants.wireRatio, constants.epsilon, constants.maxIterations, constants.gateCap, constants.alpha, constants.keeperRatio, constants.x1inverter_nwidth, constants.x1inverter_pwidth, constants.x1inverter_length);
        }

        protected float getMFactor() {
            return this.mFactor;
        }

        protected float getSU() {
            return this.cellsu;
        }

        protected NetlisterConstants getSettings() {
            return this.localSettings;
        }
    }

    private static class SaveSettings
    extends Job {
        private Cell cell;
        private Cell settings;
        private NetlisterConstants constants;

        public SaveSettings(Cell cell, Cell settings, NetlisterConstants constants) {
            super("Clear LE Sizes", LETool.getLETool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.cell = cell;
            this.settings = settings;
            this.constants = constants;
            this.startJob();
        }

        @Override
        public boolean doIt() throws JobException {
            NodeInst ni;
            ERectangle bounds = this.cell.getBounds();
            int x2 = (int)((RectangularShape)bounds).getMaxX();
            int y = (int)bounds.getMinY();
            Cell temp = this.settings.iconView();
            if (temp != null) {
                this.settings = temp;
            }
            if ((ni = NodeInst.makeInstance(this.settings, new Point2D.Double(x2, y), this.settings.getDefWidth(), this.settings.getDefHeight(), this.cell)) == null) {
                System.out.println("Could not make instance of LESETTINGS in " + this.cell + " to save settings.");
                return false;
            }
            ni.updateVar(ATTR_su, new Float(this.constants.su));
            ni.updateVar(ATTR_wire_ratio, new Float(this.constants.wireRatio));
            ni.updateVar(ATTR_epsilon, new Float(this.constants.epsilon));
            ni.updateVar(ATTR_max_iter, new Integer(this.constants.maxIterations));
            ni.updateVar(ATTR_gate_cap, new Float(this.constants.gateCap));
            ni.updateVar(ATTR_alpha, new Float(this.constants.alpha));
            ni.updateVar(ATTR_keeper_ratio, new Float(this.constants.keeperRatio));
            ni.updateVar(ATTR_x1inverter_nwidth, new Float(this.constants.x1inverter_nwidth));
            ni.updateVar(ATTR_x1inverter_pwidth, new Float(this.constants.x1inverter_pwidth));
            ni.updateVar(ATTR_x1inverter_length, new Float(this.constants.x1inverter_length));
            return true;
        }
    }

    public static class NetlisterConstants
    implements Serializable {
        public final float su;
        public final float wireRatio;
        public final float epsilon;
        public final int maxIterations;
        public final float gateCap;
        public final float alpha;
        public final float keeperRatio;
        public final float x1inverter_nwidth;
        public final float x1inverter_pwidth;
        public final float x1inverter_length;

        public NetlisterConstants(float su, float wireRatio, float epsilon, int maxIterations, float gateCap, float alpha, float keeperRatio, float x1inverter_nwidth, float x1inverter_pwidth, float x1inverter_length) {
            this.su = su;
            this.wireRatio = wireRatio;
            this.epsilon = epsilon;
            this.maxIterations = maxIterations;
            this.gateCap = gateCap;
            this.alpha = alpha;
            this.keeperRatio = keeperRatio;
            this.x1inverter_nwidth = x1inverter_nwidth;
            this.x1inverter_pwidth = x1inverter_pwidth;
            this.x1inverter_length = x1inverter_length;
        }

        public NetlisterConstants(Technology layoutTech) {
            this.su = (float)LETool.getGlobalFanout();
            this.epsilon = (float)LETool.getConvergenceEpsilon();
            this.maxIterations = LETool.getMaxIterations();
            this.gateCap = (float)layoutTech.getGateCapacitance();
            this.wireRatio = (float)layoutTech.getWireRatio();
            this.alpha = (float)layoutTech.getDiffAlpha();
            this.keeperRatio = (float)LETool.getKeeperRatio();
            this.x1inverter_nwidth = (float)LETool.getX1InverterNWidth();
            this.x1inverter_pwidth = (float)LETool.getX1InverterPWidth();
            this.x1inverter_length = (float)LETool.getX1InverterLength();
        }

        public boolean equals(NetlisterConstants other) {
            if (this.su != other.su) {
                return false;
            }
            if (this.wireRatio != other.wireRatio) {
                return false;
            }
            if (this.epsilon != other.epsilon) {
                return false;
            }
            if (this.maxIterations != other.maxIterations) {
                return false;
            }
            if (this.gateCap != other.gateCap) {
                return false;
            }
            if (this.alpha != other.alpha) {
                return false;
            }
            if (this.keeperRatio != other.keeperRatio) {
                return false;
            }
            if (this.x1inverter_nwidth != other.x1inverter_nwidth) {
                return false;
            }
            if (this.x1inverter_pwidth != other.x1inverter_pwidth) {
                return false;
            }
            return this.x1inverter_length == other.x1inverter_length;
        }
    }
}

