/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.routing.experimentalAStar1;

import com.sun.electric.tool.routing.experimentalAStar1.Path;
import java.util.List;
import java.util.Vector;

public class Net {
    private static final int NET_ID_OFFSET = 10000;
    private int netID;
    private List<Path> paths = new Vector<Path>();
    private int length = -1;
    public boolean[] pathDone;

    public Net(int netID) {
        this.netID = netID;
        assert (netID + 10000 > 0);
    }

    public void initialize() {
        int n = this.paths.size();
        this.pathDone = new boolean[n];
    }

    public int getNetID() {
        return this.netID + 10000;
    }

    public int getElectricNetID() {
        return this.netID;
    }

    public List<Path> getPaths() {
        return this.paths;
    }

    public int getLengthEstimate() {
        if (this.length == -1) {
            int len = 0;
            for (Path p : this.paths) {
                len += p.getLengthEstimate();
            }
            this.length = len;
        }
        return this.length;
    }

    public int getRoutableLengthEstimate() {
        int len = 0;
        for (Path p : this.paths) {
            if (!p.pathDone || p.pathUnroutable) continue;
            len += p.getLengthEstimate();
        }
        return len;
    }

    public int getOverlapSum(Net other) {
        int sum2 = 0;
        for (Path path : this.paths) {
            for (Path otherPath : other.paths) {
                sum2 += path.getOverlapAmount(otherPath);
            }
        }
        return sum2;
    }
}

