/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.bytecode.Type;
import gnu.expr.Keyword;
import gnu.mapping.CallContext;
import gnu.mapping.MethodProc;
import gnu.mapping.WrongType;

public class GenericProc
extends MethodProc {
    MethodProc[] methods;
    int count;
    int minArgs;
    int maxArgs;

    public GenericProc(String string) {
        this.setName(string);
    }

    public GenericProc() {
    }

    public int numArgs() {
        return this.minArgs | this.maxArgs << 12;
    }

    public void add(MethodProc methodProc) {
        MethodProc methodProc2;
        int n;
        if (this.methods == null) {
            this.methods = new MethodProc[8];
        } else if (this.count >= this.methods.length) {
            MethodProc[] methodProcArray = new MethodProc[2 * this.methods.length];
            System.arraycopy(this.methods, 0, methodProcArray, 0, this.count);
            this.methods = methodProcArray;
        }
        for (n = 0; n < this.count && (methodProc2 = MethodProc.mostSpecific(methodProc, this.methods[n])) != methodProc; ++n) {
        }
        if (n < this.count) {
            System.arraycopy(this.methods, n, this.methods, n + 1, this.count - n);
        }
        this.methods[n] = methodProc;
        ++this.count;
        int n2 = methodProc.minArgs();
        if (n2 < this.minArgs) {
            this.minArgs = n2;
        }
        if ((n2 = methodProc.maxArgs()) == -1 || n2 > this.maxArgs) {
            this.maxArgs = n2;
        }
    }

    public Object applyN(Object[] objectArray) throws Throwable {
        GenericProc.checkArgCount(this, objectArray.length);
        CallContext callContext = CallContext.getInstance();
        for (int i = 0; i < this.count; ++i) {
            MethodProc methodProc = this.methods[i];
            if (methodProc.match(callContext, objectArray) != 0) continue;
            return methodProc.applyV(callContext);
        }
        throw new WrongType(this, -1, null);
    }

    public int isApplicable(Type[] typeArray) {
        int n = -1;
        int n2 = this.count;
        while (--n2 >= 0) {
            MethodProc methodProc = this.methods[n2];
            int n3 = methodProc.isApplicable(typeArray);
            if (n3 == 1) {
                return 1;
            }
            if (n3 != 0) continue;
            n = 0;
        }
        return n;
    }

    public int match(CallContext callContext, Object[] objectArray) {
        if (this.count == 1) {
            return this.methods[0].match(callContext, objectArray);
        }
        for (int i = 0; i < this.count; ++i) {
            MethodProc methodProc = this.methods[i];
            int n = methodProc.match(callContext, objectArray);
            if (n != 0) continue;
            callContext.ivalue1 = i;
            return 0;
        }
        return -1;
    }

    public Object applyV(CallContext callContext) throws Throwable {
        return this.methods[callContext.ivalue1].applyV(callContext);
    }

    public final void setProperties(Object[] objectArray) {
        int n = objectArray.length;
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            Object object2 = objectArray[i];
            if (object2 instanceof Keyword) {
                String string = ((Keyword)object2).getName();
                Object object3 = objectArray[++i];
                if (string == "name") {
                    this.setName(object3.toString());
                    continue;
                }
                if (string == "method") {
                    this.add((MethodProc)object3);
                    continue;
                }
                this.setProperty(string, object3);
                continue;
            }
            this.add((MethodProc)object2);
        }
    }

    public static GenericProc make(Object[] objectArray) {
        GenericProc genericProc = new GenericProc();
        genericProc.setProperties(objectArray);
        return genericProc;
    }
}

