/*
 * Decompiled with CFR 0.152.
 */
package gnu.bytecode;

import gnu.bytecode.Access;
import gnu.bytecode.Attribute;
import gnu.bytecode.ClassType;
import gnu.bytecode.ClassTypeWriter;
import gnu.bytecode.ConstantPool;
import gnu.bytecode.CpoolClass;
import gnu.bytecode.CpoolEntry;
import gnu.bytecode.CpoolUtf8;
import java.io.DataOutputStream;
import java.io.IOException;

public class InnerClassesAttr
extends Attribute {
    short count;
    short[] data;

    public InnerClassesAttr(ClassType classType) {
        super("InnerClasses");
        this.addToFrontOf(classType);
    }

    public InnerClassesAttr(short[] sArray, ClassType classType) {
        this(classType);
        this.count = (short)(sArray.length >> 2);
        this.data = sArray;
    }

    public int getLength() {
        return 2 + 8 * this.count;
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeShort(this.count);
        for (int i = 0; i < this.count; ++i) {
            dataOutputStream.writeShort(this.data[4 * i]);
            dataOutputStream.writeShort(this.data[4 * i + 1]);
            dataOutputStream.writeShort(this.data[4 * i + 2]);
            dataOutputStream.writeShort(this.data[4 * i + 3]);
        }
    }

    public void print(ClassTypeWriter classTypeWriter) {
        ClassType classType = (ClassType)this.container;
        ConstantPool constantPool = classType.getConstants();
        classTypeWriter.print("Attribute \"");
        classTypeWriter.print(this.getName());
        classTypeWriter.print("\", length:");
        classTypeWriter.print(this.getLength());
        classTypeWriter.print(", count: ");
        classTypeWriter.println(this.count);
        for (int i = 0; i < this.count; ++i) {
            classTypeWriter.print("  ");
            int n = this.data[4 * i] & 0xFFFF;
            CpoolEntry cpoolEntry = constantPool.getForced(n, 7);
            classTypeWriter.print(((CpoolClass)cpoolEntry).getStringName());
            classTypeWriter.print("; ");
            n = this.data[4 * i + 1] & 0xFFFF;
            if (n != 0) {
                classTypeWriter.print("Member of ");
                cpoolEntry = constantPool.getForced(n, 7);
                classTypeWriter.print(((CpoolClass)cpoolEntry).getStringName());
            }
            classTypeWriter.print("; ");
            n = this.data[4 * i + 2] & 0xFFFF;
            if (n != 0) {
                cpoolEntry = constantPool.getForced(n, 1);
                classTypeWriter.print(((CpoolUtf8)cpoolEntry).string);
            } else {
                classTypeWriter.print("(Anonymous)");
            }
            classTypeWriter.print(";");
            classTypeWriter.print(Access.toString(this.data[4 * i + 3] & 0xFFFF, 'C'));
            classTypeWriter.println();
        }
    }
}

