/*
 * Decompiled with CFR 0.152.
 */
package gnu.bytecode;

import gnu.bytecode.CodeAttr;
import gnu.bytecode.Label;
import gnu.bytecode.Type;
import gnu.bytecode.VarEnumerator;
import gnu.bytecode.Variable;

public class Scope {
    Scope parent;
    Scope nextSibling;
    Scope firstChild;
    Scope lastChild;
    boolean preserved;
    Label start;
    Label end;
    Variable vars;
    Variable last_var;

    public Scope() {
    }

    public Scope(Label label, Label label2) {
        this.start = label;
        this.end = label2;
    }

    public final Variable firstVar() {
        return this.vars;
    }

    public VarEnumerator allVars() {
        return new VarEnumerator(this);
    }

    public void linkChild(Scope scope) {
        this.parent = scope;
        if (scope == null) {
            return;
        }
        if (scope.lastChild == null) {
            scope.firstChild = this;
        } else {
            scope.lastChild.nextSibling = this;
        }
        scope.lastChild = this;
    }

    public Variable addVariable(CodeAttr codeAttr, Type type, String string) {
        Variable variable = new Variable(string, type);
        this.addVariable(codeAttr, variable);
        return variable;
    }

    public void addVariable(Variable variable) {
        if (this.last_var == null) {
            this.vars = variable;
        } else {
            this.last_var.next = variable;
        }
        this.last_var = variable;
        variable.scope = this;
    }

    public void addVariableAfter(Variable variable, Variable variable2) {
        if (variable == null) {
            variable2.next = this.vars;
            this.vars = variable2;
        } else {
            variable2.next = variable.next;
            variable.next = variable2;
        }
        if (this.last_var == variable) {
            this.last_var = variable2;
        }
        if (variable2.next == variable2) {
            throw new Error("cycle");
        }
        variable2.scope = this;
    }

    public void addVariable(CodeAttr codeAttr, Variable variable) {
        this.addVariable(variable);
        if (variable.isSimple() && codeAttr != null) {
            variable.allocateLocal(codeAttr);
        }
    }

    public Variable getVariable(int n) {
        Variable variable = this.vars;
        while (--n >= 0) {
            variable = variable.next;
        }
        return variable;
    }

    static boolean equals(byte[] byArray, byte[] byArray2) {
        if (byArray.length != byArray2.length) {
            return false;
        }
        if (byArray == byArray2) {
            return true;
        }
        int n = byArray.length;
        while (--n >= 0) {
            if (byArray[n] == byArray2[n]) continue;
            return false;
        }
        return true;
    }

    public void setStartPC(CodeAttr codeAttr) {
        this.start = codeAttr.getLabel();
    }

    public Variable lookup(String string) {
        Variable variable = this.vars;
        while (variable != null) {
            if (string.equals(variable.name)) {
                return variable;
            }
            variable = variable.next;
        }
        return null;
    }

    void freeLocals(CodeAttr codeAttr) {
        if (this.preserved) {
            return;
        }
        Object object2 = this.vars;
        while (object2 != null) {
            if (((Variable)object2).isSimple() && !((Variable)object2).dead()) {
                ((Variable)object2).freeLocal(codeAttr);
            }
            object2 = ((Variable)object2).next;
        }
        object2 = this.firstChild;
        while (object2 != null) {
            if (((Scope)object2).preserved) {
                ((Scope)object2).preserved = false;
                ((Scope)object2).freeLocals(codeAttr);
            }
            object2 = ((Scope)object2).nextSibling;
        }
    }
}

