/*
 * Decompiled with CFR 0.152.
 */
package gnu.mapping;

import gnu.mapping.Environment;
import gnu.mapping.EnvironmentKey;
import gnu.mapping.EnvironmentMappings;
import gnu.mapping.IndirectableLocation;
import gnu.mapping.InheritingEnvironment;
import gnu.mapping.Location;
import gnu.mapping.LocationEnumeration;
import gnu.mapping.NamedLocation;
import gnu.mapping.PlainLocation;
import gnu.mapping.SharedLocation;
import gnu.mapping.Symbol;
import gnu.mapping.ThreadLocation;
import gnu.mapping.UnboundLocationException;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import java.lang.ref.ReferenceQueue;
import java.util.Set;

public class SimpleEnvironment
extends Environment {
    NamedLocation[] table;
    int log2Size = 4;
    private int mask;
    int num_bindings;
    int currentTimestamp;
    ReferenceQueue queue = new ReferenceQueue();
    NamedLocation sharedTail;

    public int size() {
        return this.num_bindings;
    }

    public static Location getCurrentLocation(String string) {
        return SimpleEnvironment.getCurrent().getLocation(string, true);
    }

    public static Object lookup_global(Symbol symbol) throws UnboundLocationException {
        Location location2 = SimpleEnvironment.getCurrent().lookup(symbol);
        if (location2 == null) {
            throw new UnboundLocationException(symbol);
        }
        return location2.get();
    }

    public SimpleEnvironment() {
        this(64);
    }

    public SimpleEnvironment(String string) {
        this();
        this.setName(string);
    }

    public SimpleEnvironment(int n) {
        while (n > 1 << this.log2Size) {
            ++this.log2Size;
        }
        n = 1 << this.log2Size;
        this.table = new NamedLocation[n];
        this.mask = n - 1;
        this.sharedTail = new PlainLocation(null, null, this);
    }

    public NamedLocation lookup(Symbol symbol, Object object2, int n) {
        return this.lookupDirect(symbol, object2, n);
    }

    public NamedLocation lookupDirect(Symbol symbol, Object object2, int n) {
        int n2 = n & this.mask;
        NamedLocation namedLocation = this.table[n2];
        while (namedLocation != null) {
            if (namedLocation.matches(symbol, object2)) {
                return namedLocation;
            }
            namedLocation = namedLocation.next;
        }
        return null;
    }

    public synchronized NamedLocation getLocation(Symbol symbol, Object object2, int n, boolean bl) {
        NamedLocation namedLocation = this.lookup(symbol, object2, n);
        if (namedLocation != null) {
            return namedLocation;
        }
        if (!bl) {
            return null;
        }
        return this.addUnboundLocation(symbol, object2, n);
    }

    protected NamedLocation addUnboundLocation(Symbol symbol, Object object2, int n) {
        int n2 = n & this.mask;
        NamedLocation namedLocation = this.newEntry(symbol, object2, n2);
        namedLocation.base = null;
        namedLocation.value = Location.UNBOUND;
        return namedLocation;
    }

    public void put(Symbol symbol, Object object2, Object object3) {
        boolean bl = (this.flags & 4) != 0;
        NamedLocation namedLocation = this.getLocation(symbol, object2, bl);
        if (namedLocation == null) {
            throw new UnboundLocationException(symbol);
        }
        if (((Location)namedLocation).isConstant()) {
            throw new IllegalStateException("attempt to modify read-only location: " + symbol + " in " + this + " loc:" + namedLocation);
        }
        namedLocation.set(object3);
    }

    NamedLocation newLocation(Symbol symbol, Object object2) {
        if ((this.flags & 8) != 0) {
            return new SharedLocation(symbol, object2, this.currentTimestamp);
        }
        return new PlainLocation(symbol, object2);
    }

    NamedLocation newEntry(Symbol symbol, Object object2, int n) {
        NamedLocation namedLocation = this.newLocation(symbol, object2);
        NamedLocation namedLocation2 = this.table[n];
        namedLocation.next = namedLocation2 == null ? this.sharedTail : namedLocation2;
        this.table[n] = namedLocation;
        ++this.num_bindings;
        if (this.num_bindings >= this.table.length) {
            this.rehash();
        }
        return namedLocation;
    }

    public NamedLocation define(Symbol symbol, Object object2, int n, Object object3) {
        NamedLocation namedLocation;
        int n2 = n & this.mask;
        NamedLocation namedLocation2 = namedLocation = this.table[n2];
        while (true) {
            if (namedLocation2 == null) {
                namedLocation2 = this.newEntry(symbol, object2, n2);
                namedLocation2.set(object3);
                return namedLocation2;
            }
            if (namedLocation2.matches(symbol, object2)) {
                if (!(!namedLocation2.isBound() ? this.getCanRedefine() : this.getCanDefine())) {
                    this.redefineError(symbol, object2, namedLocation2);
                }
                namedLocation2.base = null;
                namedLocation2.value = object3;
                return namedLocation2;
            }
            namedLocation2 = namedLocation2.next;
        }
    }

    public void define(Symbol symbol, Object object2, Object object3) {
        int n = symbol.hashCode() ^ System.identityHashCode(object2);
        this.define(symbol, object2, n, object3);
    }

    protected void redefineError(Symbol symbol, Object object2, Location location2) {
        throw new IllegalStateException("prohibited define/redefine of " + symbol + " in " + this);
    }

    public NamedLocation addLocation(Symbol symbol, Object object2, Location location2) {
        return this.addLocation(symbol, object2, symbol.hashCode() ^ System.identityHashCode(object2), location2);
    }

    NamedLocation addLocation(Symbol symbol, Object object2, int n, Location location2) {
        boolean bl;
        NamedLocation namedLocation;
        if (location2 instanceof ThreadLocation && ((ThreadLocation)location2).property == object2) {
            location2 = ((ThreadLocation)location2).getLocation();
        }
        if (location2 == (namedLocation = this.lookupDirect(symbol, object2, n))) {
            return namedLocation;
        }
        boolean bl2 = bl = namedLocation != null;
        if (!bl) {
            namedLocation = this.addUnboundLocation(symbol, object2, n);
        }
        if ((this.flags & 3) != 3) {
            if (bl) {
                bl = namedLocation.isBound();
            }
            if (bl ? (this.flags & 2) == 0 : (this.flags & 1) != 0 || location2.isBound()) {
                // empty if block
            }
            this.redefineError(symbol, object2, namedLocation);
        }
        namedLocation.base = (this.flags & 0x20) != 0 ? ((SimpleEnvironment)((InheritingEnvironment)this).getParent(0)).addLocation(symbol, object2, n, location2) : location2;
        namedLocation.value = IndirectableLocation.INDIRECT_FLUIDS;
        return namedLocation;
    }

    void rehash() {
        NamedLocation[] namedLocationArray = this.table;
        int n = namedLocationArray.length;
        int n2 = 2 * n;
        NamedLocation[] namedLocationArray2 = new NamedLocation[n2];
        int n3 = n2 - 1;
        int n4 = n;
        while (--n4 >= 0) {
            NamedLocation namedLocation = namedLocationArray[n4];
            while (namedLocation != null && namedLocation != this.sharedTail) {
                NamedLocation namedLocation2 = namedLocation.next;
                Symbol symbol = namedLocation.name;
                Object object2 = namedLocation.property;
                int n5 = symbol.hashCode() ^ System.identityHashCode(object2);
                int n6 = n5 & n3;
                NamedLocation namedLocation3 = namedLocationArray2[n6];
                if (namedLocation3 == null) {
                    namedLocation3 = this.sharedTail;
                }
                namedLocation.next = namedLocation3;
                namedLocationArray2[n6] = namedLocation;
                namedLocation = namedLocation2;
            }
        }
        this.table = namedLocationArray2;
        ++this.log2Size;
        this.mask = n3;
    }

    public Location unlink(Symbol symbol, Object object2, int n) {
        int n2 = n & this.mask;
        NamedLocation namedLocation = null;
        NamedLocation namedLocation2 = this.table[n2];
        while (namedLocation2 != null) {
            NamedLocation namedLocation3 = namedLocation2.next;
            if (namedLocation2.matches(symbol, object2)) {
                if (!this.getCanRedefine()) {
                    this.redefineError(symbol, object2, namedLocation2);
                }
                if (namedLocation == null) {
                    this.table[n2] = namedLocation3;
                } else {
                    namedLocation.next = namedLocation2;
                }
                --this.num_bindings;
                return namedLocation2;
            }
            namedLocation = namedLocation2;
            namedLocation2 = namedLocation3;
        }
        return null;
    }

    public Object remove(EnvironmentKey environmentKey) {
        Symbol symbol = environmentKey.getKeySymbol();
        Object object2 = environmentKey.getKeyProperty();
        int n = (symbol.hashCode() ^ System.identityHashCode(object2)) & this.mask;
        NamedLocation namedLocation = null;
        NamedLocation namedLocation2 = this.table[n];
        while (namedLocation2 != null) {
            NamedLocation namedLocation3 = namedLocation2.next;
            if (namedLocation2.matches(symbol, object2)) {
                Object object3 = namedLocation2.get(null);
                if (namedLocation == null) {
                    this.table[n] = namedLocation3;
                } else {
                    namedLocation.next = namedLocation2;
                }
                --this.num_bindings;
                if (namedLocation2 instanceof IndirectableLocation) {
                    namedLocation2.undefine();
                }
                return object3;
            }
            namedLocation = namedLocation2;
            namedLocation2 = namedLocation3;
        }
        return null;
    }

    public LocationEnumeration enumerateLocations() {
        LocationEnumeration locationEnumeration = new LocationEnumeration(this.table, 1 << this.log2Size);
        locationEnumeration.env = this;
        return locationEnumeration;
    }

    public LocationEnumeration enumerateAllLocations() {
        return this.enumerateLocations();
    }

    protected boolean hasMoreElements(LocationEnumeration locationEnumeration) {
        while (true) {
            if (locationEnumeration.curLoc == null) {
                if (--locationEnumeration.index < 0) {
                    return false;
                }
                locationEnumeration.curLoc = locationEnumeration.bindings[locationEnumeration.index];
                if (locationEnumeration.curLoc == null) continue;
            }
            if (locationEnumeration.curLoc.name != null) break;
            locationEnumeration.curLoc = locationEnumeration.curLoc.next;
        }
        return true;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(this.getSymbol());
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.setSymbol(objectInput.readObject());
    }

    public Object readResolve() throws ObjectStreamException {
        String string = this.getName();
        Environment environment = (Environment)envTable.get(string);
        if (environment != null) {
            return environment;
        }
        envTable.put(string, this);
        return this;
    }

    public Set entrySet() {
        return new EnvironmentMappings(this);
    }

    public String toStringVerbose() {
        StringBuffer stringBuffer = new StringBuffer();
        this.toStringBase(stringBuffer);
        return "#<environment " + this.getName() + " num:" + this.num_bindings + " ts:" + this.currentTimestamp + stringBuffer + '>';
    }

    protected void toStringBase(StringBuffer stringBuffer) {
    }
}

