/*
 * Decompiled with CFR 0.152.
 */
package gnu.text;

import gnu.text.ReportFormat;
import java.io.IOException;
import java.io.Writer;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParsePosition;

public class CompoundFormat
extends ReportFormat {
    protected int length;
    protected Format[] formats;

    public CompoundFormat(Format[] formatArray, int n) {
        this.formats = formatArray;
        this.length = n;
    }

    public CompoundFormat(Format[] formatArray) {
        this.formats = formatArray;
        this.length = formatArray.length;
    }

    public int format(Object[] objectArray, int n, Writer writer, FieldPosition fieldPosition) throws IOException {
        for (int i = 0; i < this.length; ++i) {
            Format format = this.formats[i];
            if (format instanceof ReportFormat) {
                if ((n = ((ReportFormat)format).format(objectArray, n, writer, fieldPosition)) >= 0) continue;
                return n;
            }
            if (n >= objectArray.length) {
                writer.write("#<missing format argument>");
                continue;
            }
            StringBuffer stringBuffer = new StringBuffer();
            format.format(objectArray[n], stringBuffer, fieldPosition);
            writer.write(stringBuffer.toString());
            ++n;
        }
        return n;
    }

    public final int format(Object[] objectArray, int n, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        for (int i = 0; i < this.length; ++i) {
            Format format = this.formats[i];
            if (format instanceof ReportFormat) {
                if ((n = ((ReportFormat)format).format(objectArray, n, stringBuffer, fieldPosition)) >= 0) continue;
                return n;
            }
            format.format(objectArray[n], stringBuffer, fieldPosition);
            ++n;
        }
        return n;
    }

    public Object parseObject(String string, ParsePosition parsePosition) {
        throw new Error("CompoundFormat.parseObject - not implemented");
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("CompoundFormat[");
        for (int i = 0; i < this.length; ++i) {
            if (i > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(this.formats[i]);
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

