/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.bytecode.ArrayType;
import gnu.bytecode.ClassType;
import gnu.bytecode.CodeAttr;
import gnu.bytecode.PrimType;
import gnu.bytecode.Type;
import gnu.expr.Compilation;
import gnu.expr.Target;
import gnu.kawa.reflect.OccurrenceType;
import gnu.mapping.Values;

public class StackTarget
extends Target {
    Type type;

    public StackTarget(Type type) {
        this.type = type;
    }

    public Type getType() {
        return this.type;
    }

    public static Target getInstance(Type type) {
        return type.isVoid() ? Target.Ignore : (type == Type.pointer_type ? Target.pushObject : new StackTarget(type));
    }

    protected boolean compileFromStack0(Compilation compilation, Type type) {
        return StackTarget.compileFromStack0(compilation, type, this.type);
    }

    static boolean compileFromStack0(Compilation compilation, Type type, Type type2) {
        if (type2 == type) {
            return true;
        }
        CodeAttr codeAttr = compilation.getCode();
        if (type.isVoid()) {
            compilation.compileConstant(Values.empty);
            type = Type.pointer_type;
        } else if (type instanceof PrimType && type2 instanceof PrimType) {
            codeAttr.emitConvert(type, type2);
            return true;
        }
        if (type instanceof ArrayType) {
            if (type2 == Type.pointer_type || "java.lang.Cloneable".equals(type2.getName())) {
                return true;
            }
        } else {
            type.emitCoerceToObject(codeAttr);
            type = codeAttr.topType();
        }
        return !CodeAttr.castNeeded(type, type2);
    }

    public static void convert(Compilation compilation, Type type, Type type2) {
        if (!StackTarget.compileFromStack0(compilation, type, type2)) {
            StackTarget.emitCoerceFromObject(type2, compilation);
        }
    }

    protected static void emitCoerceFromObject(Type type, Compilation compilation) {
        CodeAttr codeAttr = compilation.getCode();
        if (type instanceof OccurrenceType) {
            compilation.compileConstant(type, Target.pushObject);
            codeAttr.emitSwap();
            codeAttr.emitInvokeVirtual(ClassType.make("gnu.bytecode.Type").getDeclaredMethod("coerceFromObject", 1));
        } else {
            compilation.usedClass(type);
            type.emitCoerceFromObject(codeAttr);
        }
    }

    public void compileFromStack(Compilation compilation, Type type) {
        if (!this.compileFromStack0(compilation, type)) {
            StackTarget.emitCoerceFromObject(this.type, compilation);
        }
    }
}

