/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.filters2.text.magento;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.omegat.filters2.AbstractFilter;
import org.omegat.filters2.FilterContext;
import org.omegat.filters2.Instance;
import org.omegat.util.LinebreakPreservingReader;
import org.omegat.util.NullBufferedWriter;
import org.omegat.util.OStrings;
import org.omegat.util.StringUtil;

public class MagentoFilter
extends AbstractFilter {
    protected Map<String, String> align;

    @Override
    public String getFileFormatName() {
        return OStrings.getString("MAGENTOFILTER_FILTER_NAME");
    }

    @Override
    public boolean isSourceEncodingVariable() {
        return true;
    }

    @Override
    public boolean isTargetEncodingVariable() {
        return false;
    }

    @Override
    public Instance[] getDefaultInstances() {
        return new Instance[]{new Instance("*.csv", null, "UTF-8")};
    }

    @Override
    public void processFile(BufferedReader reader, BufferedWriter outfile, FilterContext fc) throws IOException {
        Object line;
        LinebreakPreservingReader lbpr = new LinebreakPreservingReader(reader);
        Pattern splitter = Pattern.compile(",(?=(?:[^\"]*\"[^\"]*\")*(?![^\"]*\"))");
        while ((line = lbpr.readLine()) != null) {
            String contLine;
            while (!((String)line).endsWith("\"") && (contLine = lbpr.readLine()) != null) {
                line = (String)line + lbpr.getLinebreak() + contLine;
            }
            String trimmed = ((String)line).trim();
            if (trimmed.isEmpty()) {
                outfile.write((String)line + lbpr.getLinebreak());
                continue;
            }
            String[] result = splitter.split(trimmed);
            if (result.length < 2) {
                outfile.write((String)line + lbpr.getLinebreak());
                continue;
            }
            String key = result[0];
            String value = result[1];
            key = key.substring(1, key.length() - 1);
            value = value.substring(1, value.length() - 1);
            outfile.write("\"" + key + "\",\"");
            String trans = this.process(key, value);
            outfile.write(trans + "\"");
            outfile.write(lbpr.getLinebreak());
        }
        lbpr.close();
    }

    @Override
    protected void alignFile(BufferedReader sourceFile, BufferedReader translatedFile, FilterContext fc) throws Exception {
        HashMap<String, String> source = new HashMap<String, String>();
        HashMap<String, String> translated = new HashMap<String, String>();
        this.align = source;
        this.processFile(sourceFile, new NullBufferedWriter(), fc);
        this.align = translated;
        this.processFile(translatedFile, new NullBufferedWriter(), fc);
        for (Map.Entry en : source.entrySet()) {
            String tr = (String)translated.get(en.getKey());
            if (StringUtil.isEmpty(tr)) continue;
            this.entryAlignCallback.addTranslation((String)en.getKey(), (String)en.getValue(), tr, false, null, this);
        }
    }

    private String process(String key, String value) {
        if (this.entryParseCallback != null) {
            this.entryParseCallback.addEntry(key, value, null, false, null, this);
            return value;
        }
        if (this.entryTranslateCallback != null) {
            String trans = this.entryTranslateCallback.getTranslation(key, value);
            return trans != null ? trans : value;
        }
        if (this.entryAlignCallback != null) {
            this.align.put(key, value);
        }
        return value;
    }
}

