/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.snapshot;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzt;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameEntity;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.snapshot.SnapshotMetadata;
import com.google.android.gms.games.snapshot.SnapshotMetadataEntityCreator;
import com.google.android.gms.internal.zzlc;

public final class SnapshotMetadataEntity
implements SafeParcelable,
SnapshotMetadata {
    public static final Parcelable.Creator<SnapshotMetadataEntity> CREATOR = new SnapshotMetadataEntityCreator();
    private final int zzCY;
    private final GameEntity zzaud;
    private final PlayerEntity zzavs;
    private final String zzapg;
    private final Uri zzavp;
    private final String zzavt;
    private final String zzadv;
    private final String zzakM;
    private final long zzavu;
    private final long zzavv;
    private final float zzavw;
    private final String zzavx;
    private final boolean zzavy;
    private final long zzavz;

    public SnapshotMetadataEntity(SnapshotMetadata snapshotMetadata) {
        this.zzCY = 5;
        this.zzaud = new GameEntity(snapshotMetadata.getGame());
        this.zzavs = new PlayerEntity(snapshotMetadata.getOwner());
        this.zzapg = snapshotMetadata.getSnapshotId();
        this.zzavp = snapshotMetadata.getCoverImageUri();
        this.zzavt = snapshotMetadata.getCoverImageUrl();
        this.zzavw = snapshotMetadata.getCoverImageAspectRatio();
        this.zzadv = snapshotMetadata.getTitle();
        this.zzakM = snapshotMetadata.getDescription();
        this.zzavu = snapshotMetadata.getLastModifiedTimestamp();
        this.zzavv = snapshotMetadata.getPlayedTime();
        this.zzavx = snapshotMetadata.getUniqueName();
        this.zzavy = snapshotMetadata.hasChangePending();
        this.zzavz = snapshotMetadata.getProgressValue();
    }

    SnapshotMetadataEntity(int versionCode, GameEntity game, PlayerEntity owner, String snapshotId, Uri coverImageUri, String coverImageUrl, String title, String description, long lastModifiedTimestamp, long playedTime, float coverImageAspectRatio, String uniqueName, boolean changePending, long progressValue) {
        this.zzCY = versionCode;
        this.zzaud = game;
        this.zzavs = owner;
        this.zzapg = snapshotId;
        this.zzavp = coverImageUri;
        this.zzavt = coverImageUrl;
        this.zzavw = coverImageAspectRatio;
        this.zzadv = title;
        this.zzakM = description;
        this.zzavu = lastModifiedTimestamp;
        this.zzavv = playedTime;
        this.zzavx = uniqueName;
        this.zzavy = changePending;
        this.zzavz = progressValue;
    }

    public int getVersionCode() {
        return this.zzCY;
    }

    @Override
    public Game getGame() {
        return this.zzaud;
    }

    @Override
    public Player getOwner() {
        return this.zzavs;
    }

    @Override
    public String getSnapshotId() {
        return this.zzapg;
    }

    @Override
    public Uri getCoverImageUri() {
        return this.zzavp;
    }

    @Override
    public String getCoverImageUrl() {
        return this.zzavt;
    }

    @Override
    public float getCoverImageAspectRatio() {
        return this.zzavw;
    }

    @Override
    public String getUniqueName() {
        return this.zzavx;
    }

    @Override
    public String getTitle() {
        return this.zzadv;
    }

    @Override
    public String getDescription() {
        return this.zzakM;
    }

    @Override
    public void getDescription(CharArrayBuffer dataOut) {
        zzlc.zzb(this.zzakM, dataOut);
    }

    @Override
    public long getLastModifiedTimestamp() {
        return this.zzavu;
    }

    @Override
    public long getPlayedTime() {
        return this.zzavv;
    }

    @Override
    public boolean hasChangePending() {
        return this.zzavy;
    }

    @Override
    public long getProgressValue() {
        return this.zzavz;
    }

    @Override
    public SnapshotMetadata freeze() {
        return this;
    }

    @Override
    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return SnapshotMetadataEntity.zza(this);
    }

    static int zza(SnapshotMetadata snapshotMetadata) {
        return zzt.hashCode(snapshotMetadata.getGame(), snapshotMetadata.getOwner(), snapshotMetadata.getSnapshotId(), snapshotMetadata.getCoverImageUri(), Float.valueOf(snapshotMetadata.getCoverImageAspectRatio()), snapshotMetadata.getTitle(), snapshotMetadata.getDescription(), snapshotMetadata.getLastModifiedTimestamp(), snapshotMetadata.getPlayedTime(), snapshotMetadata.getUniqueName(), snapshotMetadata.hasChangePending(), snapshotMetadata.getProgressValue());
    }

    public boolean equals(Object obj) {
        return SnapshotMetadataEntity.zza(this, obj);
    }

    static boolean zza(SnapshotMetadata snapshotMetadata, Object object) {
        if (!(object instanceof SnapshotMetadata)) {
            return false;
        }
        if (snapshotMetadata == object) {
            return true;
        }
        SnapshotMetadata snapshotMetadata2 = (SnapshotMetadata)object;
        return zzt.equal(snapshotMetadata2.getGame(), snapshotMetadata.getGame()) && zzt.equal(snapshotMetadata2.getOwner(), snapshotMetadata.getOwner()) && zzt.equal(snapshotMetadata2.getSnapshotId(), snapshotMetadata.getSnapshotId()) && zzt.equal(snapshotMetadata2.getCoverImageUri(), snapshotMetadata.getCoverImageUri()) && zzt.equal(Float.valueOf(snapshotMetadata2.getCoverImageAspectRatio()), Float.valueOf(snapshotMetadata.getCoverImageAspectRatio())) && zzt.equal(snapshotMetadata2.getTitle(), snapshotMetadata.getTitle()) && zzt.equal(snapshotMetadata2.getDescription(), snapshotMetadata.getDescription()) && zzt.equal(snapshotMetadata2.getLastModifiedTimestamp(), snapshotMetadata.getLastModifiedTimestamp()) && zzt.equal(snapshotMetadata2.getPlayedTime(), snapshotMetadata.getPlayedTime()) && zzt.equal(snapshotMetadata2.getUniqueName(), snapshotMetadata.getUniqueName()) && zzt.equal(snapshotMetadata2.hasChangePending(), snapshotMetadata.hasChangePending()) && zzt.equal(snapshotMetadata2.getProgressValue(), snapshotMetadata.getProgressValue());
    }

    public String toString() {
        return SnapshotMetadataEntity.zzb(this);
    }

    static String zzb(SnapshotMetadata snapshotMetadata) {
        return zzt.zzt(snapshotMetadata).zzg("Game", snapshotMetadata.getGame()).zzg("Owner", snapshotMetadata.getOwner()).zzg("SnapshotId", snapshotMetadata.getSnapshotId()).zzg("CoverImageUri", snapshotMetadata.getCoverImageUri()).zzg("CoverImageUrl", snapshotMetadata.getCoverImageUrl()).zzg("CoverImageAspectRatio", Float.valueOf(snapshotMetadata.getCoverImageAspectRatio())).zzg("Description", snapshotMetadata.getDescription()).zzg("LastModifiedTimestamp", snapshotMetadata.getLastModifiedTimestamp()).zzg("PlayedTime", snapshotMetadata.getPlayedTime()).zzg("UniqueName", snapshotMetadata.getUniqueName()).zzg("ChangePending", snapshotMetadata.hasChangePending()).zzg("ProgressValue", snapshotMetadata.getProgressValue()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        SnapshotMetadataEntityCreator.zza(this, out, flags);
    }
}

