/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzu;
import com.google.android.gms.location.Geofence;
import com.google.android.gms.location.internal.ParcelableGeofence;
import com.google.android.gms.location.zza;
import java.util.ArrayList;
import java.util.List;

public class GeofencingRequest
implements SafeParcelable {
    public static final int INITIAL_TRIGGER_ENTER = 1;
    public static final int INITIAL_TRIGGER_EXIT = 2;
    public static final int INITIAL_TRIGGER_DWELL = 4;
    public static final Parcelable.Creator<GeofencingRequest> CREATOR = new zza();
    private final int zzCY;
    private final List<ParcelableGeofence> zzaxJ;
    private final int zzaxK;

    GeofencingRequest(int version, List<ParcelableGeofence> geofences, int initialTrigger) {
        this.zzCY = version;
        this.zzaxJ = geofences;
        this.zzaxK = initialTrigger;
    }

    private GeofencingRequest(List<ParcelableGeofence> geofences, int initialTrigger) {
        this(1, geofences, initialTrigger);
    }

    public int getVersionCode() {
        return this.zzCY;
    }

    public List<ParcelableGeofence> zzun() {
        return this.zzaxJ;
    }

    public List<Geofence> getGeofences() {
        ArrayList<Geofence> arrayList = new ArrayList<Geofence>();
        arrayList.addAll(this.zzaxJ);
        return arrayList;
    }

    public int getInitialTrigger() {
        return this.zzaxK;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        zza.zza(this, dest, flags);
    }

    public static final class Builder {
        private final List<ParcelableGeofence> zzaxJ = new ArrayList<ParcelableGeofence>();
        private int zzaxK = 5;

        public Builder addGeofence(Geofence geofence) {
            zzu.zzb(geofence, (Object)"geofence can't be null.");
            zzu.zzb(geofence instanceof ParcelableGeofence, (Object)"Geofence must be created using Geofence.Builder.");
            this.zzaxJ.add((ParcelableGeofence)geofence);
            return this;
        }

        public Builder addGeofences(List<Geofence> geofences) {
            if (geofences == null || geofences.isEmpty()) {
                return this;
            }
            for (Geofence geofence : geofences) {
                if (geofence == null) continue;
                this.addGeofence(geofence);
            }
            return this;
        }

        public Builder setInitialTrigger(int initialTrigger) {
            this.zzaxK = Builder.zzgr(initialTrigger);
            return this;
        }

        public static int zzgr(int n) {
            return n & 7;
        }

        public GeofencingRequest build() {
            zzu.zzb(!this.zzaxJ.isEmpty(), (Object)"No geofence has been added to this request.");
            return new GeofencingRequest(this.zzaxJ, this.zzaxK);
        }
    }
}

