/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import com.google.android.gms.cast.MediaInfo;
import com.google.android.gms.cast.internal.zzf;
import com.google.android.gms.common.internal.zzt;
import com.google.android.gms.internal.zzlh;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class MediaQueueItem {
    public static final int INVALID_ITEM_ID = 0;
    public static final double DEFAULT_PLAYBACK_DURATION = Double.POSITIVE_INFINITY;
    private MediaInfo zzRS;
    private int zzRT = 0;
    private boolean zzRU = true;
    private double zzRV;
    private double zzRW = Double.POSITIVE_INFINITY;
    private double zzRX;
    private long[] zzRY;
    private JSONObject zzRJ;

    private MediaQueueItem(MediaInfo media) throws IllegalArgumentException {
        if (media == null) {
            throw new IllegalArgumentException("media cannot be null.");
        }
        this.zzRS = media;
    }

    MediaQueueItem(JSONObject json) throws JSONException {
        this.zzg(json);
    }

    private MediaQueueItem(MediaQueueItem item) throws IllegalArgumentException {
        this.zzRS = item.getMedia();
        if (this.zzRS == null) {
            throw new IllegalArgumentException("media cannot be null.");
        }
        this.zzRT = item.getItemId();
        this.zzRU = item.getAutoplay();
        this.zzRV = item.getStartTime();
        this.zzRW = item.zzlr();
        this.zzRX = item.getPreloadTime();
        this.zzRY = item.getActiveTrackIds();
        this.zzRJ = item.getCustomData();
    }

    public boolean zzg(JSONObject jSONObject) throws JSONException {
        double d;
        double d2;
        double d3;
        int n;
        boolean bl = false;
        if (jSONObject.has("media")) {
            this.zzRS = new MediaInfo(jSONObject.getJSONObject("media"));
            bl = true;
        }
        if (jSONObject.has("itemId") && this.zzRT != (n = jSONObject.getInt("itemId"))) {
            this.zzRT = n;
            bl = true;
        }
        if (jSONObject.has("autoplay") && this.zzRU != (n = (int)(jSONObject.getBoolean("autoplay") ? 1 : 0))) {
            this.zzRU = n;
            bl = true;
        }
        if (jSONObject.has("startTime") && Math.abs((d3 = jSONObject.getDouble("startTime")) - this.zzRV) > 1.0E-7) {
            this.zzRV = d3;
            bl = true;
        }
        if (jSONObject.has("playbackDuration") && Math.abs((d2 = jSONObject.getDouble("playbackDuration")) - this.zzRW) > 1.0E-7) {
            this.zzRW = d2;
            bl = true;
        }
        if (jSONObject.has("preloadTime") && Math.abs((d = jSONObject.getDouble("preloadTime")) - this.zzRX) > 1.0E-7) {
            this.zzRX = d;
            bl = true;
        }
        boolean bl2 = false;
        long[] lArray = null;
        if (jSONObject.has("activeTrackIds")) {
            int n2;
            JSONArray jSONArray = jSONObject.getJSONArray("activeTrackIds");
            int n3 = jSONArray.length();
            lArray = new long[n3];
            for (n2 = 0; n2 < n3; ++n2) {
                lArray[n2] = jSONArray.getLong(n2);
            }
            if (this.zzRY == null) {
                bl2 = true;
            } else if (this.zzRY.length != n3) {
                bl2 = true;
            } else {
                for (n2 = 0; n2 < n3; ++n2) {
                    if (this.zzRY[n2] == lArray[n2]) continue;
                    bl2 = true;
                    break;
                }
            }
        }
        if (bl2) {
            this.zzRY = lArray;
            bl = true;
        }
        if (jSONObject.has("customData")) {
            this.zzRJ = jSONObject.getJSONObject("customData");
            bl = true;
        }
        return bl;
    }

    public MediaInfo getMedia() {
        return this.zzRS;
    }

    public int getItemId() {
        return this.zzRT;
    }

    void zzaC(int n) {
        this.zzRT = n;
    }

    public boolean getAutoplay() {
        return this.zzRU;
    }

    void zzP(boolean bl) {
        this.zzRU = bl;
    }

    public double getStartTime() {
        return this.zzRV;
    }

    void zzb(double d) throws IllegalArgumentException {
        if (Double.isNaN(d) || d < 0.0) {
            throw new IllegalArgumentException("startTime cannot be negative or NaN.");
        }
        this.zzRV = d;
    }

    public double zzlr() {
        return this.zzRW;
    }

    public double getPreloadTime() {
        return this.zzRX;
    }

    void zzc(double d) throws IllegalArgumentException {
        if (Double.isNaN(d) || d < 0.0) {
            throw new IllegalArgumentException("preloadTime cannot be negative or NaN.");
        }
        this.zzRX = d;
    }

    public long[] getActiveTrackIds() {
        return this.zzRY;
    }

    void zza(long[] lArray) {
        this.zzRY = lArray;
    }

    public JSONObject getCustomData() {
        return this.zzRJ;
    }

    void setCustomData(JSONObject customData) {
        this.zzRJ = customData;
    }

    void zzlq() throws IllegalArgumentException {
        if (this.zzRS == null) {
            throw new IllegalArgumentException("media cannot be null.");
        }
        if (Double.isNaN(this.zzRV) || this.zzRV < 0.0) {
            throw new IllegalArgumentException("startTime cannot be negative or NaN.");
        }
        if (Double.isNaN(this.zzRW)) {
            throw new IllegalArgumentException("playbackDuration cannot be NaN.");
        }
        if (Double.isNaN(this.zzRX) || this.zzRX < 0.0) {
            throw new IllegalArgumentException("preloadTime cannot be negative or Nan.");
        }
    }

    public JSONObject toJson() {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("media", (Object)this.zzRS.toJson());
            if (this.zzRT != 0) {
                jSONObject.put("itemId", this.zzRT);
            }
            jSONObject.put("autoplay", this.zzRU);
            jSONObject.put("startTime", this.zzRV);
            if (this.zzRW != Double.POSITIVE_INFINITY) {
                jSONObject.put("playbackDuration", this.zzRW);
            }
            jSONObject.put("preloadTime", this.zzRX);
            if (this.zzRY != null && this.zzRY.length > 0) {
                JSONArray jSONArray = new JSONArray();
                for (long l : this.zzRY) {
                    jSONArray.put(l);
                }
                jSONObject.put("activeTrackIds", (Object)jSONArray);
            }
            if (this.zzRJ != null) {
                jSONObject.put("customData", (Object)this.zzRJ);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return jSONObject;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MediaQueueItem)) {
            return false;
        }
        MediaQueueItem mediaQueueItem = (MediaQueueItem)other;
        if (this.zzRJ == null != (mediaQueueItem.zzRJ == null)) {
            return false;
        }
        if (this.zzRJ != null && mediaQueueItem.zzRJ != null && !zzlh.zzd(this.zzRJ, mediaQueueItem.zzRJ)) {
            return false;
        }
        return zzf.zza(this.zzRS, mediaQueueItem.zzRS) && this.zzRT == mediaQueueItem.zzRT && this.zzRU == mediaQueueItem.zzRU && this.zzRV == mediaQueueItem.zzRV && this.zzRW == mediaQueueItem.zzRW && this.zzRX == mediaQueueItem.zzRX && zzf.zza(this.zzRY, mediaQueueItem.zzRY);
    }

    public int hashCode() {
        return zzt.hashCode(this.zzRS, this.zzRT, this.zzRU, this.zzRV, this.zzRW, this.zzRX, this.zzRY, String.valueOf(this.zzRJ));
    }

    public static class Builder {
        private final MediaQueueItem zzRZ;

        public Builder(MediaInfo media) throws IllegalArgumentException {
            this.zzRZ = new MediaQueueItem(media);
        }

        public Builder(JSONObject json) throws JSONException {
            this.zzRZ = new MediaQueueItem(json);
        }

        public Builder(MediaQueueItem item) throws IllegalArgumentException {
            this.zzRZ = new MediaQueueItem(item);
        }

        public Builder clearItemId() {
            this.zzRZ.zzaC(0);
            return this;
        }

        public Builder setAutoplay(boolean autoplay) {
            this.zzRZ.zzP(autoplay);
            return this;
        }

        public Builder setStartTime(double startTime) throws IllegalArgumentException {
            this.zzRZ.zzb(startTime);
            return this;
        }

        public Builder setPreloadTime(double preloadTime) throws IllegalArgumentException {
            this.zzRZ.zzc(preloadTime);
            return this;
        }

        public Builder setActiveTrackIds(long[] activeTrackIds) {
            this.zzRZ.zza(activeTrackIds);
            return this;
        }

        public Builder setCustomData(JSONObject customData) {
            this.zzRZ.setCustomData(customData);
            return this;
        }

        public MediaQueueItem build() {
            this.zzRZ.zzlq();
            return this.zzRZ;
        }
    }
}

