}  pHP4                                                                                                                    }            
UTF-8 SAMPLER
        $                                

    Frank da Cruz
    The Kermit Project
    New York City
    fdc@kermitproject.org

    Last update: Fri Feb 15 06:28:28 2019 

[ PEACE ] [ Poetry ] [ I Can Eat Glass ] [ Pangrams ] [ HTML Features ] [ Credits, Tools, Commentary ]

UTF-8 is an ASCII-preserving encoding method for Unicode (ISO 10646), the Universal Character Set (UCS). The UCS encodes most of the world's writing systems in a single character set, allowing you to mix languages and scripts within a document without needing any tricks for switching character sets. This web page is encoded directly in UTF-8.

As shown HERE, Columbia University's Kermit 95 terminal emulation software can display UTF-8 plain text in Windows 95, 98, ME, NT, XP, Vista, or Windows 7/8/10 when using a monospace Unicode font like Andale Mono WT J or Everson Mono Terminal, or the lesser populated Courier New, Lucida Console, or Andale Mono. C-Kermit can handle it too, if you have a Unicode display. As many languages as are representable in your font can be seen on the screen at the same time.

This, however, is a Web page, which started out as a kind of stress test for UTF-8 support in Web browsers, which was spotty when this page was first created in the 1990s but which has become standard in all modern browsers. The problem now is mainly the fonts and the browser's (or font's) support for the nonzero Unicode planes (as in, e.g., the Braille and Gothic examples below). And to some extent the rendition of combining sequences, right-to-left rendition (Arabic, Hebrew), and so on. CLICK HERE for a survey of Unicode fonts for Windows.

The subtitle above shows currency symbols of many lands. If they don't appear as blobs, we're off to a good start!
Poetry
From the Anglo-Saxon Rune Poem (Rune version):

    ǻ렱ֻڳ
    ˳֪֪תֻڳڢޫڪ
    렩ޱϾީϪ

From Laamon's Brut (The Chronicles of England, Middle English, West Midlands, ca.1190):

    An preost wes on leoden, Laamon was ihoten
    He wes Leovenaes sone -- lie him be Drihten.
    He wonede at Ernlee at elen are chirechen,
    Uppen Sevarne stae, sel ar him uhte,
    Onfest Radestone, er he bock radde. 

(The third letter in the author's name is Yogh, missing from many fonts; CLICK HERE for another Middle English sample with some explanation of letters and encoding).

From the Tagelied of Wolfram von Eschenbach (Middle High German):

    Sne klwen durh die wolken sint geslagen,
    er stget f mit grzer kraft,
    ich sih in grwen tgelch als er wil tagen,
    den tac, der im geselleschaft
    erwenden wil, dem werden man,
    den ich mit sorgen n verliez.
    ich bringe in hinnen, ob ich kan.
    sn vil manegiu tugent michz leisten hiez.

Some lines of Odysseus Elytis (Greek):

    Monotonic:

        
      ǹ    .
    Ƿ        .

       
      
     Polytonic:

    t    t
    x  ǹx v  r  I.
    Ƿ  !   v  r  I.

     x x  
     H 

The first stanza of Pushkin's Bronze Horseman (Russian):

    0 15@53C ?CABK==KE 2>;=
    !B>O; >=, 4C< 25;8:8E ?>;=,
     240;L 3;O45;. @54 =8< H8@>:>
     5:0 =5A;0AO; 154=K9 GQ;=
    > =59 AB@5<8;AO >48=>:>.
    > <H8ABK<, B>?:8< 15@530<
    '5@=5;8 871K 745AL 8 B0<,
    @8NB C1>3>3> GCE>=F0;
     ;5A, =5254><K9 ;CG0<
     BC<0=5 A?@OB0==>3> A>;=F0,
    @C3>< HC<5;.

`ota Rustaveli's Vepxis T#qaosani, #!Th, The Knight in the Tiger's Skin (Georgian):

       

     ,     , ,   ,   ;    ,    ,       . 

Tamil poetry of Subramaniya Bharathiyar: Ͱ  (1882-1921):

    ͤ ʴ ͮʴ ˲  ͕ ˮ,
     ͕, Ȥͤ ͚͚ʲ ͮ Ɵ͟,
     Ʃ ʣ͟ ͕ ͨͤ ͱ? ʲͲ!
    Ǯ ˚ Ʋ ͵ Ưͤ ǣ͟. 

Kannada poetry by Kuvempu   Ͳ 

     Ͳ  ƨͨ æ
    ͯ  ͯ

    ͣ   ...
    ͣ   
        °
    ͯ  ͯ ||  Ͳ || 

I Can Eat Glass
And from the sublime to the ridiculous, here is a certain phrase in an assortment of languages:

    Sanskrit: > 6M(K.M/$M$A.M d (K*9?(8M$? .>.M e
    Sanskrit (standard transcription): kcaC [aknomyattum; nopahinasti mm.
    Classical Greek: U ֽ {  T  q.
    Greek (monotonic):   Ƭ      .
    Greek (polytonic):  p Ƭ  p v p  .
    Etruscan: (NEEDED)
    Latin: Vitrum edere possum; mihi non nocet.
    Old French: Je puis mangier del voirre. Ne me nuit.
    French: Je peux manger du verre, a ne me fait pas mal.
    Provenal / Occitan: Pdi manjar de veire, me nafrari pas.
    Qubcois: J'peux manger d'la vitre, a m'fa pas mal.
    Walloon: Dji pou magn do vre, oula m' freut nn m.
    Champenois: (NEEDED)
    Lorrain: (NEEDED)
    Picard: Ch'peux mingi du verre, cha m'fo mie n'ma.
    Corsican/Corsu: (NEEDED)
    Jrriais: (NEEDED)
    Kreyl Ayisyen (Hait): Mwen kap manje v, li pa blese'm.
    Basque: Kristala jan dezaket, ez dit minik ematen.
    Catalan / Catal: Puc menjar vidre, que no em fa mal.
    Spanish: Puedo comer vidrio, no me hace dao.
    Aragons: Puedo minchar beire, no me'n fa mal .
    Arans: (NEEDED)
    Mallorqun: (NEEDED)
    Galician: Eu podo xantar cristais e non cortarme.
    European Portuguese: Posso comer vidro, no me faz mal.
    Brazilian Portuguese (8): Posso comer vidro, no me machuca.
    Caboverdiano/Kabuverdianu (Cape Verde): M' pod cum vidru, ca ta magu-m'.
    Papiamentu: Ami por kome glas anto e no ta hasimi dao.
    Italian: Posso mangiare il vetro e non mi fa male.
    Milanese: Sn bn de magn el vder, el me fa minga mal.
    Roman: Me posso magna' er vetro, e nun me fa male.
    Napoletano: M' pozz magna' o'vetr, e nun m' fa mal.
    Venetian: Mi posso magnare el vetro, no'l me fa mae.
    Zeneise (Genovese): Psso mangi o veddro e o no me f m.
    Sicilian: Puotsu mangiari u vitru, nun mi fa mali.
    Campinadese (Sardinia): (NEEDED)
    Lugudorese (Sardinia): (NEEDED)
    Romansch (Grischun): Jau sai mangiar vaider, senza che quai fa donn a mai.
    Romany / Tsigane: (NEEDED)
    Romanian: Pot s mnnc sticl i ea nu m rnete.
    Esperanto: Mi povas mani vitron, i ne damaas min.
    Pictish: (NEEDED)
    Breton: (NEEDED)
    Cornish: M a yl dybry gwder hag f ny wra ow ankenya.
    Welsh: Dw i'n gallu bwyta gwydr, 'dyw e ddim yn gwneud dolur i mi.
    Manx Gaelic: Foddym gee glonney agh cha jean eh gortaghey mee.
    Old Irish (Ogham): 
    Old Irish (Latin): Coniccim ithi nglano. Nmgna.
    Irish: Is fidir liom gloinne a ithe. N dhanann s dochar ar bith dom.
    Ulster Gaelic: Ithim-sa gloine agus n miste damh .
    Scottish Gaelic: S urrainn dhomh gloinne ithe; cha ghoirtich i mi.
    Anglo-Saxon (Runes): רڨ֩Ϫ멾֪
    Anglo-Saxon (Latin): Ic mg gls eotan ond hit ne hearmia me.
    Middle English: Ich canne glas eten and hit hirti me nout.
    English: I can eat glass and it doesn't hurt me.
    English (IPA): [aj kn it glQs nd jt dPz nRt h\t mi] (Received Pronunciation)
    English (Braille): 
 	    
  % 

    Jamaican: Mi kian niam glas han i neba hot mi.
    Lalland Scots / Doric: Ah can eat gless, it disnae hurt us.
    Glaswegian: (NEEDED)
    Gothic (4):  < 0 2  2 ; 4 C  9 D 0 =,  = 9  < 9 C  E ?  = 3 0 =  1 B 9 2 2 9 8.
    Old Norse (Runes): ִ    ֱ ؾ     ˨
    Old Norse (Latin): Ek get eti gler n ess a vera sr.
    Norsk / Norwegian (Nynorsk): Eg kan eta glas utan  skada meg.
    Norsk / Norwegian (Bokml): Jeg kan spise glass uten  skade meg.
    Froyskt / Faroese: Eg kann eta glas, skaaleysur.
    slenska / Icelandic: g get eti gler n ess a meia mig.
    Svenska / Swedish: Jag kan ta glas utan att skada mig.
    Dansk / Danish: Jeg kan spise glas, det gr ikke ondt p mig.
    Snderjysk:  ka e glass uhen at det go m naue.
    Frysk / Frisian: Ik kin gls ite, it docht me net sear.
    Nederlands / Dutch: Ik kan glas eten, het doet m3 geen kwaad.
    Kirchradsj/Bchesserplat: Iech ken glaas se, mer 't deet miech jing pieng.
    Afrikaans: Ek kan glas eet, maar dit doen my nie skade nie.
    Ltzebuergescht / Luxemburgish: Ech kan Glas iessen, daat deet mir nt wei.
    Deutsch / German: Ich kann Glas essen, ohne mir zu schaden.
    Ruhrdeutsch: Ich kann Glas verkasematuckeln, ohne dattet mich wat jucken tut.
    Langenfelder Platt: Isch kann Jlaas kimmeln, uuhne datt mich datt weh dd.
    Lausitzer Mundart ("Lusatian"): Ich koann Gloos assn und doas dudd merr ni wii.
    Odenwlderisch: Iech konn glaasch voschbachteln ohne dass es mir ebbs daun doun dud.
    Schsisch / Saxon: 'sch kann Glos essn, ohne dass'sch mer wehtue.
    Pflzisch: Isch konn Glass fresse ohne dasses mer ebbes ausmache dud.
    Schwbisch / Swabian: I k Glas frssa, ond des macht mr nix!
    Deutsch (Voralberg): I ka glas eassa, ohne dass mar weh tuat.
    Bayrisch / Bavarian: I koh Glos esa, und es duard ma ned wei.
    Allemannisch: I kaun Gloos essen, es tuat ma ned weh.
    Schwyzerdtsch (Zrich): Ich chan Glaas sse, das schadt mir nd.
    Schwyzerdtsch (Luzern): Ech cha Gls sse, das schadt mer ned.
    Plautdietsch: (NEEDED)
    Hungarian: Meg tudom enni az veget, nem lesz tQle bajom.
    Suomi / Finnish: Voin syd lasia, se ei vahingoita minua.
    Sami (Northern): Shtn borrat lsa, dat ii leat bv

as.
    Erzian: >= O@A0= AC;8:04>, 4K 7KO= M9ABM=7M 0 C;8.
    Northern Karelian: Mie voin syvv lasie ta minla ei ole kipie.
    Southern Karelian: Min voin syvv st'oklua dai minule ei ole kibie.
    Vepsian: (NEEDED)
    Votian: (NEEDED)
    Livonian: (NEEDED)
    Estonian: Ma vin klaasi sa, see ei tee mulle midagi.
    Latvian: Es varu st stiklu, tas man nekait.
    Lithuanian: Aa galiu valgyti stikl ir jis mans ne~eid~ia
    Old Prussian: (NEEDED)
    Sorbian (Wendish): (NEEDED)
    Czech: Mohu jst sklo, neubl~ mi.
    Slovak: M~em jese sklo. Nezran ma.
    Polska / Polish: Mog je[ szkBo i mi nie szkodzi.
    Slovenian: Lahko jem steklo, ne da bi mi akodovalo.
    Bosnian, Croatian, Montenegrin and Serbian (Latin): Ja mogu jesti staklo, i to mi ne ateti.
    Bosnian, Montenegrin and Serbian (Cyrillic): 0 <>3C X5AB8 AB0:;>, 8 B> <8 =5 HB5B8.
    Macedonian: >60< 40 X040< AB0:;>, 0 =5 <5 HB5B0.
    Russian: / <>3C 5ABL AB5:;>, >=> <=5 =5 2@548B.
    Belarusian (Cyrillic): / <03C 5AFV H:;>, O=> <=5 =5 H:>47VFL.
    Belarusian (Lacinka): Ja mahu je[ci akBo, jano mne ne akodzi.
    Ukrainian: / <>6C WAB8 A:;>, V 2>=> <5=V =5 70H:>48BL.
    Bulgarian: >30 40 O< ABJ:;>, B> =5 <8 2@548.
    Georgian:     .
    Armenian: ?vat azaok xel  kvnk avpavck} yhve
    Albanian: Un mund t ha qelq dhe nuk m gjen gj.
    Turkish: Cam yiyebilirim, bana zarar1 dokunmaz.
    Turkish (Ottoman): ,'E JJG (DH1E (' 611I 7HBHFE2
    Tatar: ;0< 40 10@, ?KO;0, <<0 1C @0=8B <8=5.
    Uzbek / Ozbekcha: (Roman): Men shisha yeyishim mumkin, ammo u menga zarar keltirmaydi.
    Uzbek / 715:G0 (Cyrillic): 5= H8H0 598H8< <C<:8=, 0<<> C <5=30 70@0@ :5;B8@<0948.
    Bangla / Bengali:   Ǥ ,   ˨ ͷ  d
    Marathi: .@ > >
 6$K, .2> $G &A$ (>9@.
    Kannada:   ,  ͨ 
    Hindi: .H > > 8$> 9B 0 .AG 	88G K K (9@ *9A$@.
    Malayalam: (?MM M2>8M $?(M(>. $F(M(F 5G&(?*M*?M?2M2.
    Tamil:  ͣ ͪǩ,  ͕  ǟ .
    Telugu: (G(A >A $?(2(A .0?/A 2> G8?(> (>A .? ,M,&? 2G&A
    Sinhalese:  ӯԻ Ѹ КҺ. ұ   ϱҺ ү .
    Urdu(3): E̺ 'F ' 3*' H 'H1 E, *DA F̺ H* 
    Pashto(3): 2G 4J4G .HD 4E G:G E' FG .HHJ
    Farsi / Persian(3): .EF E *H'FE (/HFP '-3'3 /1/ 4J4G (.H1E
    Arabic(3): #F' B'/1 9DI #CD 'D2,', H G0' D' J$DEFJ.
    Aramaic: (NEEDED)
    Maltese: Nista' niekol il-'!ie! u ma jag'milli xejn.
    Hebrew(3):        .
    Yiddish(3):    и      .
    Judeo-Arabic: (NEEDED)
    Ladino: (NEEDED)
    Gݼz: (NEEDED)
    Amharic: (NEEDED)
    Twi: Metumi awe tumpan, \ny\ me hwee.
    Hausa (Latin): Ina iya taunar gilashi kuma in gama lafiya.
    Hausa (Ajami) (2): %PF' %PIN *NHFN1 :PDN'4P COEN %PF :NEN' DN'APIN'
    Yoruba(4): Mo l je) dg, k n pa m lra.
    Lingala: Nakoki koliya biteni bya milungi, ekosala ngai mabe t[.
    (Ki)Swahili: Naweza kula bilauri na sikunyui.
    Malay: Saya boleh makan kaca dan ia tidak mencederakan saya.
    Tagalog: Kaya kong kumain nang bubog at hindi ako masaktan.
    Chamorro: Sia yo' chumocho krestat, ti ha na'lalamen yo'.
    Fijian: Au rawa ni kana iloilo, ia au sega ni vakacacani kina.
    Javanese: Aku isa mangan beling tanpa lara.
    Burmese (Unicode 4.0):  9991,9J 999 9 9,8/-9
9K N 91,97 -/- 99/ 9-,K (9)
    Burmese (Unicode 5.0):  ;=:1,:  ;=: >:,8-/::K N:8 <1,:7 --/ :>/>-+K (9)
    Vietnamese (quc ng): Ti c th n thy tinh m khng hi g.
    Vietnamese (nm) (4):  L   4 v Y z L  
    Khmer: ҉Ƣƀ҅˔ ęҘҠ
    Lao: ɍɧĔȡĔëɂɍ.
    Thai: 	14#0DI AH!1D!H3C+I	1@G
    Mongolian (Cyrillic): 8 H8; 84M9 G04=0, =0404 E>@B>9 18H
    Mongolian (Classic) (5): *" 0"/" "3!6& 4"3 (   ( 3$7 ,#$7 3 " *"0"
    Dzongkha: (NEEDED)
    Nepali: . > >( 8MB 0 .2> G9? (@ 9A(M
(M d
    Tibetan: dzcf|_SfDSBrXbzQ

    Chinese: 
$S
    Chinese (Traditional): 

    Taiwanese(6): Ga -tng chia
h po-l, m b tio
h-siong.
    Japanese: o鹒y~Y]odQ~[
    Korean:   | 9D  .  D JD
    Bislama: Mi save kakae glas, hemi no save katem mi.
    Hawaiian: Hiki iau ke ai i ke aniani; aole nM l au e eha.
    Marquesan: E koana e kai i te karahi, mea , ae hauhau.
    Inuktitut (10): 
Ս F-Lo KqfPǅP
    Chinook Jargon: Naika mYkmYk kakshYt labutay, pi weyk ukuk munk-sik nay.
    Navajo: Tss yishgo bnshghah d doo shiB neezgai da.
    Cherokee (and Cree, Chickasaw, Cree, Micmac, Ojibwa, Lakota, Nhuatl, Quechua, Aymara, and other American languages): (NEEDED)
    Garifuna: (NEEDED)
    Gullah: (NEEDED)
    Lojban: mi kakne le nu citka le blaci .iku'i le se go'i na xrani mi
    Nrdicg: LjSr ye caudran crne  jor cran. 

(Additions, corrections, completions, gratefuly accepted.)

For testing purposes, some of these are repeated in a monospace font . . .

    Euro Symbol: .
    Greek:   Ƭ      .
    slenska / Icelandic: g get eti gler n ess a meia mig.
    Polish: Mog je[ szkBo, i mi nie szkodzi.
    Romanian: Pot s mnnc sticl i ea nu m rnete.
    Ukrainian: / <>6C WAB8 H:;>, 9 2>=> <5=V =5 ?>H:>48BL.
    Armenian: ?vat azaok xel  kvnk avpavck} yhve
    Georgian:     .
    Hindi: .H > > 8$> 9B, .AG 	8 8G K *@!> (9@ 9K$@.
    Hebrew(2):        .
    Yiddish(2):    и      .
    Arabic(2): #F' B'/1 9DI #CD 'D2,', H G0' D' J$DEFJ.
    Japanese: o鹒y~Y]odQ~[
    Thai: 	14#0DI AH!1D!H3C+I	1@G 

Notes:

    The "I can eat glass" phrase and initial translations (about 30 of them) were borrowed from Ethan Mollick's I Can Eat Glass page (which disappeared on or about June 2004) and converted to UTF-8. Since Ethan's original page is gone, I should mention that his purpose was to offer travelers a phrase they could use in any country that would command a certain kind of respect, or at least get attention. See Credits for the many additional contributions since then. When submitting new entries, the word "hurt" (if you have a choice) is used in the sense of "cause harm", "do damage", or "bother", rather than "inflict pain" or "make sad". In this vein Otto Stolz comments (as do others further down; personally I think it's better for the purpose of this page to have extra entries and/or to show a greater repertoire of characters than it is to enforce a strict interpretation of the word "hurt"!):

        This is the meaning I have translated to the Swabian dialect. However, I just have noticed that most of the German variants translate the "inflict pain" meaning. The German example should read:

            "Ich kann Glas essen ohne mir zu schaden." 

        rather than:

            "Ich kann Glas essen, ohne mir weh zu tun." 

        (The comma fell victim to the 1996 orthographic reform, cf. http://www.ids-mannheim.de/reform/e3-1.html#P76.

        You may wish to contact the contributors of the following translations to correct them:

            Ltzebuergescht / Luxemburgish: Ech kan Glas iessen, daat deet mir nt wei.
            Lausitzer Mundart ("Lusatian"): Ich koann Gloos assn und doas dudd merr ni wii.
            Schsisch / Saxon: 'sch kann Glos essn, ohne dass'sch mer wehtue.
            Bayrisch / Bavarian: I koh Glos esa, und es duard ma ned wei.
            Allemannisch: I kaun Gloos essen, es tuat ma ned weh.
            Schwyzerdtsch: Ich chan Glaas sse, das tuet mir nd weeh. 

        In contrast, I deem the following translations *alright*:

            Ruhrdeutsch: Ich kann Glas verkasematuckeln, ohne dattet mich wat jucken tut.
            Pflzisch: Isch konn Glass fresse ohne dasses mer ebbes ausmache dud.
            Schwbisch / Swabian: I k Glas frssa, ond des macht mr nix! 

        (However, you could remove the commas, on account of http://www.ids-mannheim.de/reform/e3-1.html#P76 and http://www.ids-mannheim.de/reform/e3-1.html#P72, respectively.)

        I guess, also these examples translate the wrong sense of "hurt", though I do not know these languages well enough to assert them definitely:

            Nederlands / Dutch: Ik kan glas eten; het doet m3 geen p3n. (This one has been changed)
            Kirchradsj/Bchesserplat: Iech ken glaas se, mer 't deet miech jing pieng. 

        In the Romanic languages, the variations on "fa male" (it) are probably wrong, whilst the variations on "hace dao" (es) and "damaas" (Esperanto) are probably correct; "nocet" (la) is definitely right.

        The northern Germanic variants of "skada" are probably right, as are the Slavic variants of "akodi/H:>48" (se); however the Slavic variants of " boli" (hv) are probably wrong, as "bolena" means "pain/ache", IIRC. 

    That was from July 2004. In December 2007, Otto writes again:

        Hello Frank, in days of yore, I had written:
        > "Ich kann Glas essen ohne mir zu schaden."
        > (The comma fell victim to the 1996 orthographic reform,

        cf. http://www.ids-mannheim.de/reform/e3-1.html#P76.

        The latest revision (2006) of the official German orthography has revived the comma around infinitive clauses commencing with ohne, or 5 other conjunctions, or depending from a noun or from an announcing demonstrative (http://www.ids-mannheim.de/reform/regeln2006.pdf, 75). So, it's again: Ich kann Glas essen, ohne mir zu schaden.

        Best wishes,
             Otto Stolz 

    The numbering of the samples is arbitrary, done only to keep track of how many there are, and can change any time a new entry is added. The arrangement is also arbitrary but with some attempt to group related examples together. Note: All languages not listed are wanted, not just the ones that say (NEEDED).

    Correct right-to-left display of these languages depends on the capabilities of your browser. The period should appear on the left. In the monospace Yiddish example, the Yiddish digraphs should occupy one character cell.

    Yoruba: The third word is Latin letter small 'j' followed by small 'e' with U+0329, Combining Vertical Line Below. This displays correctly only if your Unicode font includes the U+0329 glyph and your browser supports combining diacritical marks. The Lingala and Indic examples also include combining sequences.

    Includes Unicode 3.1 (or later) characters beyond Plane 0.

    The Classic Mongolian example should be vertical, top-to-bottom and left-to-right. But such display is almost impossible. Also no font yet exists which provides the proper ligatures and positional variants for the characters of this script, which works somewhat like Arabic.

    Taiwanese is also known as Holo or Hoklo, and is related to Southern Min dialects such as Amoy. Contributed by Henry H. Tan-Tenn, who comments, "The above is the romanized version, in a script current among Taiwanese Christians since the mid-19th century. It was invented by British missionaries and saw use in hundreds of published works, mostly of a religious nature. Most Taiwanese did not know Chinese characters then, or at least not well enough to read. More to the point, though, a written standard using Chinese characters has never developed, so a significant minority of words are represented with different candidate characters, depending on one's personal preference or etymological theory. In this sentence, for example, "-tng", "chia
h", "m" and "b" are problematic using Chinese characters. "Ga" (I/me) and "po-l" (glass) are as written in other Sinitic languages (e.g. Mandarin, Hakka)."

    Wagner Amaral of Pinese & Amaral Associados notes that the Brazilian Portuguese sentence for "I can eat glass" should be identical to the Portuguese one, as the word "machuca" means "inflict pain", or rather "injuries". The words "faz mal" would more correctly translate as "cause harm".

    Burmese: In English the first person pronoun "I" stands for both genders, male and female. In Burmese (except in the central part of Burma) kyundaw ( 9991,9) for male and kyanma ( 999) for female. Using here a fully-compliant Unicode Burmese font -- sadly one and only one Padauk Graphite font exists -- rendering using graphite engine. Unicode 4.0 or older standard did not have some medial and vowel character; the second example has them.

    From Louise Hope, 22 November 2010:  I decided to have a go at an Inuktitut rendering, mainly in hopes of shaming someone who actually knows the language into coming up with something better. Meanwhile, try this:

    
Ս F-Lo KqfPǅP
    aliguq nirijaraangakku suranngittunnaqtunga

    Loosely: I am able not to hurt myself whenever I eat glass.

    aliguq >> glass (uninflected because it is the patient of a transitive verb in an ergative language)
    nirijaraangakku >> "I eat him/her/it" in Frequentative mood (all one verb with inflectional ending, no affixes whatsoever)
    suranngittunnaqtunga >> suraq (do permanent harm) + nngit (verb-negator) + tunnaq (ability) + tunga (intransitive ending, making the verb passive or reflexive)

    See above about someone who knows the language, et cetera.

    Script trivia: the syllable q is a single unicode character representing the two elements  (syllable-final n) and  (syllable ngi). I think they just did it that way because it looks tidier than the expected Џ. If your operating system didn't come with Euphemia (all-purpose UCAS font), you can download Pigiarniq. It comes with a jolly little inuksuk   that the Unicode Consortium is trying to make into a squatter.

The Quick Brown Fox... Pangrams
The "I can eat glass" sentences do not necessarily show off the orthography of each language to best advantage. In many alphabetic written languages it is possible to include all (or most) letters (or "special" characters) in a single (often nonsense) pangram. These were traditionally used in typewriter instruction; now they are useful for stress-testing computer fonts and keyboard input methods. Here are a few examples (SEND MORE):

    English: The quick brown fox jumps over the lazy dog.
    Jamaican: Chruu, a kwik di kwik brong fox a jomp huova di liezi daag de, yu no siit?
    Irish: "An fuil do ro ag buala  aitos an !r a Aeall lena Wg ada  al do leasa k?" "D'uascail osa rAac na hi!e Beannaike pr ava agus aiA."
    Dutch: Pa's w3ze lynx bezag vroom het fikse aquaduct.
    German: Falsches ben von Xylophonmusik qult jeden greren Zwerg. (1)
    German: Im finteren Jagdchlo am offenen Felsquellwaer patzte der affig-flatterhafte kauzig-hfliche Bcker ber einem verifften kniffligen C-Xylophon. (2)
    Norwegian: Blbrsyltety ("blueberry jam", includes every extra letter used in Norwegian).
    Swedish: Flygande bckasiner ska strax hwila p mjuka tuvor.
    Icelandic: Svr grt an v lpan var nt.
    Finnish: (5) Trkylempijvongahdus (This is a perfect pangram, every letter appears only once. Translating it is an art on its own, but I'll say "rude lover's yelp". :-D)
    Finnish: (5) Albert osti fagotin ja trytti puhkuvan melodian. (Albert bought a bassoon and hooted an impressive melody.)
    Finnish: (5) On sangen hauskaa, ett polkupyr on maanteiden jokapivinen ilmi. (It's pleasantly amusing, that the bicycle is an everyday sight on the roads.)
    Polish: Pchn w t Bdz je|a lub osiem skrzyD fig.
    Czech: PYlia ~lueou
k koH pl belsk dy.
    Slovak: Star kH na hUbe knh ~uje tako povdnut ru~e, na st:pe sa ate> u
 kvkae nov du o ~ivote.
    Slovenian: `erif bo za doma
o vajo spet kuhal ~gance.
    Greek (monotonic):   ǿƸ ų
    Greek (polytonic):  t ǿƸ ų
    Russian: !J5HL 65 5IQ MB8E <O3:8E D@0=FC7A:8E 1C;>: 40 2K?59 G0N.
    Russian:  G0I0E N30 68;-1K; F8B@CA? 0, => D0;LH82K9 M:75<?;O@! QJ.
    Bulgarian: J;B0B0 4N;O 15H5 I0AB;820, G5 ?CEJB, :>9B> FJD=0, 70<@J7=0 :0B> 3L>=.
    Sami (Northern): Vuol Ruoga geggiid leat mKga luosa ja 
uov~~a.
    Hungarian: rvztqrQ tkrfrgp.
    Spanish: El pingino Wenceslao hizo kilmetros bajo exhaustiva lluvia y fro, aoraba a su querido cachorro.
    Spanish: Vol cigea que jams cruz Pars, exhibe flor de kiwi y atn.
    Portuguese: O prximo vo  noite sobre o Atlntico, pe freqentemente o nico mdico. (3)
    French: Les nafs githales htifs pondant  Nol o il gle sont srs d'tre dus en voyant leurs drles d'Sufs abms.
    Esperanto: E%o]ano 	iu5amde.
    Hebrew:          .
    Japanese (Hiragana):

        Dok{xi al
        L_^ dmj
        FnJO~ QuSHf
        BUMX r[Z (4) 

Notes:

    Other phrases commonly used in Germany include: "Ein wackerer Bayer vertilgt ja bequem zwo Pfund Kalbshaxe" and, more recently, "Franz jagt im komplett verwahrlosten Taxi quer durch Bayern", but both lack umlauts and esszet. Previously, going for the shortest sentence that has all the umlauts and special characters, I had "Gre aus Brenhfe (und echtringen)!" Acute accents are not used in native German words, so I was surprised to discover "echtringen" in the Deutsche Bundespost Postleitzahlenbuch:

        Click for full-size image (2.8MB) 

    It's a small village in eastern Lower Saxony. The "oe" in this case turns out to be the Lower Saxon "lengthening e" (Dehnungs-e), which makes the previous vowel long (used in a number of Lower Saxon place names such as Soest and Itzehoe), not the "e" that indicates umlaut of the preceding vowel. Many thanks to the echtringen-Namenschreibungsuntersuchungskomitee (Alex Bochannek, Manfred Erren, Asmus Freytag, Christoph Pper, plus Werner Lemberg who serves as echtringen-Namenschreibungsuntersuchungskomiteerechtschreibungsprfer) for their relentless pursuit of the facts in this case. Conclusion: the accent almost certainly does not belong on this (or any other native German) word, but neither can it be dismissed as dirt on the page. To add to the mystery, it has been reported that other copies of the same edition of the PLZB do not show the accent! UPDATE (March 2006): David Krings was intrigued enough by this report to contact the mayor of Ebstorf, of which Oechtringen is a borough, who responded:

        Sehr geehrter Mr. Krings,
        wenn Oechtringen irgendwo mit einem Akzent auf dem O geschrieben wurde, dann kann das nur ein Fehldruck sein. Die offizielle Schreibweise lautet jedenfalls Oechtringen.
        Mit freundlichen Grssen
        Der Samtgemeindebrgermeister
        i.A. Lothar Jessel 

    From Karl Pentzlin (Kochel am See, Bavaria, Germany): "This German phrase is suited for display by a Fraktur (broken letter) font. It contains: all common three-letter ligatures: ffi ffl fft and all two-letter ligatures required by the Duden for Fraktur typesetting: ch ck ff fi fl ft ll ch i  t tz (all in a manner such they are not part of a three-letter ligature), one example of f-l where German typesetting rules prohibit ligating (marked by a ZWNJ), and all German letters a...z, ,,,,  [long s] (all in a manner such that they are not part of a two-letter Fraktur ligature)." Otto Stolz notes that "'Schlo' is now spelled 'Schloss', in contrast to 'grer' (example 4) which has kept its ''. Fraktur has been banned from general use, in 1942, and long-s () has ceased to be used with Antiqua (Roman) even earlier (the latest Antiqua- I have seen is from 1913, but then I am no expert, so there may well be a later instance." Later Otto confirms the latter theory, "Now I've run across a book Deutsche Rechtschreibung (edited by Lutz Mackensen) from 1954 (my reprint is from 1956) that has kept the Antiqua- in its dictionary part (but neither in the preface nor in the appendix)."

    Diaeresis is not used in Iberian Portuguese. Also this pangram is missing a-tilde () so it's a pnpangram.

    From Yurio Miyazawa: "This poetry contains all the sounds in the Japanese language and used to be the first thing for children to learn in their Japanese class. The Hiragana version is particularly neat because it covers every character in the phonetic Hiragana character set." Yurio also sent the Kanji version:

        roxi cl
        L^ 8j
        	neq Hf
        EM"X Tr[Z 

    Finnish pangrams from Mikko Ristil. 

Accented Cyrillic:

(This section contributed by Vladimir Marinov.)

In Bulgarian it is desirable, customary, or in some cases required to write accents over vowels. Unfortunately, no computer character sets contain the full repertoire of accented Cyrillic letters. With Unicode, however, it is possible to combine any Cyrillic letter with any combining accent. The appearance of the result depends on the font and the rendering engine. Here are two examples.

    ">9 284O 1O;0B0 :>A0 ?> 3;020B0 8 8 :>A0 =0 @0<>B> 8, 8 @5G5 40 8 @5G5: "0@0B0 ?> ?0@8 >B ?0@0B0, =5 I0 ?0@8!", => A8 ?><8A;8: "%59, ?><8A;8 A8!  8 @5:0, 0 5 A:>G8;0 2 B078 @5:0, :>OB> I5H5 40 B5G5, 0 =5 B5G5."

    > ?JBO ?JBC20B :N@48 8 N3>A;02O=8. 

HTML Features
Here is the Russian alphabet (uppercase only) coded in three different ways, which should look identical:

     !"#$%&'()*+,-./   (Literal UTF-8)
     !"#$%&'()*+,-./   (Decimal numeric character reference)
     !"#$%&'()*+,-./   (Hexadecimal numeric character reference) 

In another test, we use HTML language tags to distinguish Bulgarian, Russian, and Serbian, which have different italic forms for lowercase 1, 3, 4, ?, and/or B:

    Bulgarian:    [ 134?B ]    [ 134?B ]    >30 40 O< ABJ:;> 8 =5 <5 1>;8.
    Russian:  [ 134?B ]    [ 134?B ]    / <>3C 5ABL AB5:;>, MB> <=5 =5 2@548B.
    Serbian:  [ 134?B ]    [ 134?B ]    >3C X5AB8 AB0:;> 0 40 <8 =5 H:>48.

Credits, Tools, and Commentary

Credits:
    The "I can eat glass" phrase and the initial collection of translations: Ethan Mollick. Transcription / conversion to UTF-8: Frank da Cruz. Albanian: Sindi Keesan. Afrikaans: Johan Fourie, Kevin Poalses. Anglo Saxon: Frank da Cruz. Arabic: Najib Tounsi. Armenian: Vae Kundak1. Belarusian: Alexey Chernyak, Patricia Clausnitzer. Bengali: Somnath Purkayastha, Deepayan Sarkar. Bislama: Dan McGarry. Bosnian: Dmitrij D. Czarkoff. Braille: Frank da Cruz. Bulgarian: Sindi Keesan, Guentcho Skordev, Vladimir Marinov. Burmese: "cetanapa", Sithu Thwin. Cabo Verde Creole: Cludio Alexandre Duarte. Cataln: Jordi Bancells. Chinese: Jack Soo, Wong Pui Lam. Chinook Jargon: David Robertson. Cornish: Chris Stephens. Croatian: Dmitrij D. Czarkoff, Marjan Bae. Czech: Stanislav Pecha, Radovan Garabk, Toma Mal. Danish: Morten Due Jorgensen. Dutch: Peter Gotink. Pim Blokland, Rob Daniel, Rob de Wit. Erzian: Jack Rueter. Esperanto: Franko Luin, Radovan Garabk. Estonian: Meelis Roos. Faroese: Jn Gaasedal. Farsi/Persian: Payam Elahi. Fijian: Paul Cannon. Finnish: Sampsa Toivanen, Mikko Ristil. French: Luc Carissimo, Anne Colin du Terrail, Sean M. Burke, Theo Morelli. Galician: Laura Probaos. Georgian: Giorgi Lebanidze. German: Christoph Pper, Otto Stolz, Karl Pentzlin, David Krings, Frank da Cruz, Peter Keel (Seegras), Elias Glantschnig. Gothic: Aurlien Coudurier. Greek: Ariel Glenn, Constantine Stathopoulos, Siva Nataraja, Christos Georgiou. Hebrew: Jonathan Rosenne, Tal Barnea. Hausa: Malami Buba, Tom Gewecke. Hawaiian: na Hauoli Motta, Anela de Rego, Kaliko Trapp. Hindi: Shirish Kalele, Nitin Dahra. Hungarian: Andrs Rcz, Mark Holczhammer. Icelandic: Andrs Magnsson, Sveinn Baldursson. International Phonetic Alphabet (IPA): Siva Nataraja / Vincent Ramos. Inuktitut: Louise Hope. Irish: Michael Everson, Marion Gunn, James Kass, Curtis Clark. Italian: Thomas De Bellis. Jamaican: Stephen J. Cherin. Japanese: Makoto Takahashi, Yurio Miyazawa. Kannada: Sridhar R N, Alok G. Singh. Karelian: Aleksandr Semakov. Khmer: Tola Sann. Kirchradsj: Roger Stoffers. Kreyl: Sean M. Burke. Korean: Jungshik Shin. Langenfelder Platt: David Krings. Lao: Tola Sann. Ltzebuergescht: Stefaan Eeckels. Lingala: Denis Moyogo Jacquerye (Nkta ya KTngT mbal ) (Nkta ya KTngT mbal). Lithuanian: Gediminas Grigas. Lojban: Edward Cherlin. Lusatian: Ronald Schaffhirt. Macedonian: Sindi Keesan. Malay: Zarina Mustapha. Malayalam: Anil Matthews, Bobby Jacob. Maltese: Kenneth Joseph Vella. Manx: anna  Brdaigh. Marathi: Shirish Kalele. Marquesan: Kaliko Trapp. Middle English: Frank da Cruz. Milanese: Marco Cimarosti. Mongolian: Tom Gewecke. Montenegran: Dmitrij D. Czarkoff. Napoletano: Diego Quintano. Navajo: Tom Gewecke. Nrdicg: Ylyan Rott. Nepali: Ujjwol Lamichhane, Rabi Tripathi. Norwegian: Herman Ranes, Hvard Kvlen. Odenwlderisch: Alexander He. Old Irish: Michael Everson. Old Norse: Andrs Magnsson. Papiamentu: Bianca and Denise Zanardi. Pashto: N.R. Liwal. Pflzisch: Dr. Johannes Sander. Picard: Philippe Mennecier. Polish: Juliusz Chroboczek, PaweB Przeradowski, Wlodzislaw Kostecki. Portuguese: "Cludio" Alexandre Duarte, Bianca and Denise Zanardi, Pedro Palhoto Matos, Wagner Amaral. Qubcois: Laurent Detillieux. Roman: Pierpaolo Bernardi. Romanian: Juliusz Chroboczek, Ionel Mugurel. Romansch: Alexandre Suter. Ruhrdeutsch: "Timwi". Russian: Alexey Chernyak, Serge Nesterovitch. Sami: Anne Colin du Terrail, Luc Carissimo. Sanskrit: Siva Nataraja / Vincent Ramos. Schsisch: Andr Mller. Schwbisch: Otto Stolz. Scots: Jonathan Riddell. Serbian: Dmitrij D. Czarkoff, Sindi Keesan, Ranko Narancic, Boris Daljevic, Szilvia Csorba, O. Dag. Sinhalese: Abdul-Ahad (ASM). Slovak: G. Adam Stanislav, Radovan Garabk. Slovenian: Albert Kolar, Primo~ Gabrijel
i
. Spanish: Aleida Morel, Laura Probaos, Ricardo Cancho Niemietz. Swahili: Ronald Schaffhirt. Swedish: Christian Rose, Bengt Larsson. Taiwanese: Henry H. Tan-Tenn. Tagalog: Jim Soliven. Tamil: Vasee Vaseeharan, Vetrivel P. Tatar: Timur. Telugu: Arjuna Rao Chavala. Tibetan: D. Germano, Tom Gewecke. Thai: Alan Wood's wife. Turkish: Vae Kundak1, Tom Gewecke, Merlign Olnon. Ukrainian: Michael Zajac, Oleg Podsadny. Ulster Gaelic: Ciarn  Duibhn. Uzbek: Daniyar Nurgaliev. Urdu: Mustafa Ali. Vietnamese: Dixon Au, [James]  B Phc \ / . Walloon: Pablo Saratxaga. Welsh: Geiriadur Prifysgol Cymru (Andrew). Yiddish: Mark David. Zeneise: Angelo Pavese.

Tools Used to Create This Web Page:
    The UTF8-aware Kermit 95 terminal emulator on Windows, to a Unix host with the EMACS text editor. Kermit 95 displays UTF-8 and also allows keyboard entry of arbitrary Unicode BMP characters as 4 hex digits, as shown HERE. Hex codes for Unicode values can be found through the Unicode Consortium Character Code Charts index. When submissions arrive by email encoded in some other character set (Latin-1, Latin-2, KOI, various PC code pages, JEUC, etc), I use the TRANSLATE command of C-Kermit on a Unix host (e.g. Linux or NetBSD) to convert the character set to UTF-8 (I could also use Kermit 95 for this; it has the same TRANSLATE command). That's it -- no "Web authoring" tools, no locales, no "smart" anything. It's just plain text, nothing more. Editing in UTF-8 was rather tedious in times past but as as of about version 23 or so, EMACS handles Unicode pretty well and works well with Kermit 95 with its terminal character-set set to utf8.

Commentary:
    Date: Wed, 27 Feb 2002 13:21:59 +0100
    From: "Bruno DEDOMINICIS" <b.dedominicis@cite-sciences.fr>
    Subject: Je peux manger du verre, cela ne me fait pas mal.

    I just found out your website and it makes me feel like proposing an interpretation of the choice of this peculiar phrase.

    Glass is transparent and can hurt as everyone knows. The relation between people and civilisations is sometimes effusional and more often rude. The concept of breaking frontiers through globalization, in a way, is also an attempt to deny any difference. Isn't "transparency" the flag of modernity? Nothing should be hidden any more, authority is obsolete, and the new powers are supposed to reign through loving and smiling and no more through coercion...

    Eating glass without pain sounds like a very nice metaphor of this attempt. That is, frontiers should become glass transparent first, and be denied by incorporating them. On the reverse, it shows that through globalization, frontiers undergo a process of displacement, that is, when they are not any more speakable, they become repressed from the speech and are therefore incorporated and might become painful symptoms, as for example what happens when one tries to eat glass.

    The frontiers that used to separate bodies one from another tend to divide bodies from within and make them suffer.... The chosen phrase then appears as a denial of the symptom that might result from the destitution of traditional frontiers.

    Best,
    Bruno De Dominicis, Paris, France 

Other Unicode pages onsite:

    Frank's Compulsive Guide to Postal Addresses (especially the Index)
    Peace in All Languages
    Kermit 95 :;V5=B0 SSH (Kermit 95 SSH Client documentation in Belarusian)
    Representing Middle English on the Web with UTF-8
    The Kermit Bibliography (in UTF-8)
    Interchange of Non-English Computer Text (UTF-8 math and box-drawing)
    Unicode Table (in UTF-8) 

Unicode samplers and resources offsite: Checked 15 February 2019

    Confusables (every silver lining has a cloud).
    Michael Everson's Bibliography of Typography and Scripts
    I don't know, I only work here
    Anyone can be provincial!
    Example Unicode Usage for Business Applications
    UTF-8 and Unicode FAQ for Unix/Linux 

[ Kermit 95 ] [ K95 Screen Shots ] [ C-Kermit ] [ Kermit Home ] [ Display Problems? ] [ The Unicode Consortium ]
UTF-8 Sampler / The Kermit Project / Columbia University / kermit@kermitproject.org
 