10 PRINT "PROGRAM FILE 151: USER-DEFINED FUNCTIONS."
20 PRINT "    ANSI STANDARD 16.2, 16.4, 7.2, 7.4"
30 PRINT
40 PRINT "THIS PROGRAM TESTS VARIOUS KINDS OF USER-DEFINED FUNCTIONS."
50 PRINT "NUMERIC EXPRESSIONS ARE USED IN TWO NEW CONTEXTS: BOTH AS"
55 PRINT "THE FUNCTION DEFINITION, AND ALSO AS ARGUMENTS IN THE"
60 PRINT "FUNCTION INVOCATIONS."
65 PRINT
70 PRINT "SECTION 151.1: THE EXPRESSION IN THE DEFINITION USING ONLY"
80 PRINT "        THE PARAMETER OF THE PARAMETER-LIST."
90 PRINT
100 PRINT "                               BEGIN TEST."
110 PRINT
120 DEF FNA(X)=X*X
130 DEF FNB(Y)=Y*Y*Y
140 LET A=5
150 LET B=4
160 LET C=3
170 LET E=0
180 LET X=FNA(12)
190 LET Y=FNA(A)
200 LET Z=FNA(2*A^3+4*B+C)
210 LET W=FNA(FNB(2)+B^3)
220 LET F=1
230 IF X=144 THEN 250
240 GOSUB 350
250 LET F=2
260 IF Y=25 THEN 280
270 GOSUB 350
280 LET F=3
285 LET C9=Z-72361
290 IF ABS(C9) < .1 THEN 310
300 GOSUB 350
310 LET F=4
315 LET C9=W-5184
320 IF ABS(C9) < .1 THEN 490
330 GOSUB 350
340 GOTO 490
350 REM SUBROUTINE TO PRINT ERROR MESSAGE
355 LET E=1
357 LET B$=""
360 ON F GOTO 370,390,410,430
370 LET A$="A CONSTANT"
380 GOTO 440
390 LET A$="A VARIABLE"
400 GOTO 440
410 LET A$="CONSTANTS AND"
415 LET B$=" VARIABLES"
420 GOTO 440
430 LET A$="ANOTHER FUNCTION"
440 PRINT "FUNCTION FAILED TO EXECUTE PROPERLY WHEN THE EXPRESSION"
450 PRINT "IN THE ARGUMENT-LIST FOR THE FUNCTION REFERENCE USED"
460 PRINT A$;B$;"."
470 PRINT
480 RETURN
490 IF E=0 THEN 520
500 PRINT "*** TEST FAILED. NOTE THE ABOVE REASONS  ***"
510 GOTO 530
520 PRINT "***  TEST PASSED  ***"
530 PRINT
540 PRINT "                                END TEST."
550 PRINT
560 PRINT "SECTION 151.2: THE EXPRESSION IN THE DEFINITION USING THE"
570 PRINT "        PARAMETER OF THE PARAMETER-LIST AND OTHER VARIABLES."
590 PRINT
600 PRINT "                               BEGIN TEST."
610 PRINT
620 DEF FNC(A)=A*A-B+C
630 LET B=-15
640 LET C=-35
650 LET X=FNC(13)
660 IF X=149 THEN 690
670 PRINT "***  TEST FAILED  ***"
680 GOTO 700
690 PRINT "***  TEST PASSED  ***"
700 PRINT
710 PRINT "                                END TEST."
720 PRINT
730 PRINT "SECTION 151.3: THE EXPRESSION IN THE DEFINITION USING THE"
740 PRINT "        PARAMETER OF THE PARAMETER-LIST AND CONSTANTS."
760 PRINT
770 PRINT "                              BEGIN TEST."
780 PRINT
790 DEF FND(Y)=Y^4-16
800 LET A=4
810 LET B=2
820 LET Y=FND(A^3-3*A^2*B+3*A*B^2-B^3)
825 LET C9=Y-4080
830 IF ABS(C9) < .1 THEN 860
840 PRINT "***  TEST FAILED  ***"
850 GOTO 870
860 PRINT "***  TEST PASSED  ***"
870 PRINT
880 PRINT "                                END TEST."
890 PRINT
900 PRINT "SECTION 151.4: THE EXPRESSION IN THE DEFINITION USING THE"
910 PRINT "        PARAMETER OF THE PARAMETER-LIST AND A REFERENCE"
920 PRINT "        TO ANOTHER FUNCTION."
930 PRINT
940 PRINT "                               BEGIN TEST."
950 PRINT
960 DEF FNE(Z)=Z^2-4
970 DEF FNF(Z)=Z*X+FNE(A^2+B)
980 LET A=9
990 LET B=19
1000 LET X=3
1010 LET Y=2
1020 LET Z=FNF(X^3-3*X^2*Y+3*X*Y^2-Y^3)
1025 LET C9=Z-9999
1030 IF ABS(C9) < .1 THEN 1060
1040 PRINT "***  TEST FAILED  ***"
1050 GOTO 1070
1060 PRINT "***  TEST PASSED  ***"
1070 PRINT
1080 PRINT "                                END TEST."
1090 PRINT
1100 PRINT "SECTION 151.5: THE EXPRESSION IN THE DEFINITION HAS A"
1110 PRINT "        CONSTANT VALUE."
1120 PRINT
1130 PRINT "                               BEGIN TEST."
1140 PRINT
1150 DEF FNM=123
1160 DEF FNN(D)=3*37
1170 LET A=FNM
1180 LET B=FNN(FNM+A)
1190 IF A<>123 THEN 1300
1200 IF B<>111 THEN 1300
1210 PRINT "***  TEST PASSED  ***"
1220 GOTO 1310
1300 PRINT "***  TEST FAILED  ***"
1310 PRINT
1320 PRINT "                                END TEST."
1330 PRINT
1500 PRINT "SECTION 151.6: THE PARAMETER OF A USER-DEFINED"
1510 PRINT "        FUNCTION IS LOCAL TO THE EXPRESSION OF THE"
1520 PRINT "        DEFINITION AND OTHER VARIABLES ARE GLOBAL."
1530 PRINT
1540 PRINT "                               BEGIN TEST."
1550 PRINT
1560 LET X=1
1570 LET Y=2
1580 LET Z=3
1590 LET P1=-100
1600 LET Q1=-100
1610 DEF FNG(P1)=3+P1+X
1620 DEF FNH(P1)=7+X+Y+P1+FNG(30.E-1+P1)+FNG(P1)+FNG(Y)
1630 LET X=4
1640 LET Y=5
1650 LET Z=6
1660 LET P1=7
1670 LET Q1=8
1680 DEF FNI(Q1)=Z+Q1*10.
1690 LET A=FNH(Q1+3)+FNG(10)+FNI(Q1+4)
1700 IF X<>4 THEN 1790
1710 IF Y<>5 THEN 1790
1720 IF Z<>6 THEN 1790
1730 IF P1<>7 THEN 1790
1740 IF Q1<>8 THEN 1790
1750 LET C=221-A
1760 IF ABS(C)>.01 THEN 1790
1770 PRINT "***  TEST PASSED  ***"
1780 GOTO 1800
1790 PRINT "***  TEST FAILED  ***"
1800 PRINT
1810 PRINT "                                END TEST."
1820 PRINT
1830 PRINT "SECTION 151.7: FULL GENERAL USE OF USER-DEFINED FUNCTIONS"
1840 PRINT "        IN NUMERIC EXPRESSIONS."
1850 PRINT
1860 PRINT "                               BEGIN TEST."
1870 PRINT
1880 DEF FNT=3
1890 DEF FNU(D)=100
1900 LET X=4
1910 LET Y=5
1920 LET Z=6
1930 LET Q1=8
1940 LET A=FNI(FNT)
1950 LET A=A/(FNG(FNH(Q1+FNT)/(FNI(Q1+4)-FNU(1E38))+FNG(FNG(-10)))-2)
1960 LET C9=A-3
1970 IF ABS(C9) < .01 THEN 2000
1980 PRINT "***  TEST FAILED  ***"
1990 GOTO 2010
2000 PRINT "***  TEST PASSED  ***"
2010 PRINT
2020 PRINT "                                 END TEST."
2030 PRINT
2040 PRINT "END PROGRAM 151."
2050 END
