REM ------------------------------------------------------------
REM   PURPOSE: TEST THE PARAMETER RANGE CHECKS
REM    AUTHOR: HOWARD WULF, AF5NE
REM GENERATED: 02/21/2015 14:08:22
REM  FILENAME: F_EXP_X_N.BAS
REM    SYNTAX: N  = EXP( X )
REM  UNIQUEID: F_EXP_X_N
REM  FUNCTION: EXP
REM 
REM	VARIABLE	DESCRIPTION
REM	I	CURRENT  TESTCASE NUMBER
REM	E	EXPECTED ERROR FLAG
REM	F	ACTUAL   ERROR FLAG
REM	R	EXPECTED FUNCTION RESULT
REM	N	ACTUAL   FUNCTION RESULT
REM	X	ACTUAL   FUNCTION PARAMETER
REM 
RESTORE 2000
REM GET TESTCASE #
READ  I
WHILE I > 0
REM GET TESTCASE DATA
READ  E, R, X
REM DISPLAY TESTCASE DATA
PRINT "TESTCASE #";I,"E=";E,"R=";R, "X=";X
REM EXECUTE TESTCASE
N =  0 
S$ = ""
ON ERROR GOTO 9000
F = 0
999 N  = EXP( X )
ERROR 0
REM DISPLAY TESTCASE RESULTS
PRINT ,"F=";F,"N=";N
REM VERIFY EXPECTED ERROR
IF E <> F THEN
  PRINT "*** TEST FAILED, EXCEPTION MISMATCH ***"
  STOP
END IF
REM VERIFY EXPECTED RESULT
IF R > 0 THEN
  LET RMIN = 0.99 * R
  IF R > MAXNUM / 1.012 THEN
    LET RMAX = MAXNUM
  ELSE
    LET RMAX = 1.01 * R
  END IF
END IF
IF R < 0 THEN
  IF R < - MAXNUM / 1.012 THEN
    LET RMIN = -MAXNUM
  ELSE
    LET RMIN = 1.01 * R
  END IF
  LET RMAX = 0.99 * R
END IF
IF R = 0 THEN
  LET RMIN = -.01
  LET RMAX = +.01
END IF
IF N < RMIN THEN
  PRINT "*** TEST FAILED, RESULT MISMATCH ***"
  STOP
END IF
IF N > RMAX THEN
  PRINT "*** TEST FAILED, RESULT MISMATCH ***"
  STOP
END IF
PRINT "*** TEST PASSED ***"
REM GET NEXT TESTCASE #
READ  I
WEND
PRINT "*** ALL TESTS PASSED ***"
GOTO 9999
1999 REM TESTCASE, EXPECTED ERROR, EXPECTED RESULT, PARAMETERS...
DATA  1 ,  0 ,  1 ,  0 
DATA  2 ,  0 ,  2.71828 ,  1 
DATA  3 ,  0 ,  .367879 , -1 
DATA  4 ,  0 ,  1.49182 ,  .4 
DATA  5 ,  0 ,  .67032 , -.4 
DATA  6 ,  0 ,  1.82212 ,  .6 
DATA  7 ,  0 ,  .548812 , -.6 
DATA  8 ,  0 ,  2.04549E+110 ,  254 
DATA  9 ,  0 ,  5.56023E+110 ,  255 
DATA  10 ,  0 ,  1.51143E+111 ,  256 
DATA  11 ,  1 ,  1.79769E+308 ,  32000 
DATA  12 ,  0 ,  .796738 , -.227229 
DATA  13 ,  0 ,  .787291 , -.239157 
DATA  14 ,  0 ,  .807683 , -.213586 
DATA  15 ,  0 ,  1.3161 ,  .274675 
DATA  16 ,  0 ,  1.18503 ,  .169766 
DATA  17 ,  0 ,  1.37543 ,  .318766 
DATA  18 ,  0 ,  1.02088 ,  2.06658E-2 
DATA  19 ,  0 ,  1.20714 ,  .188257 
DATA  20 ,  0 ,  .757648 , -.277537 
DATA  21 ,  0 ,  .617978 , -.481303 
DATA  22 ,  0 ,  1.54583 ,  .43556 
DATA  23 ,  0 ,  .809798 , -.210971 
DATA  24 ,  0 ,  .634311 , -.455216 
DATA  25 ,  0 ,  6.8187E-49 , -110.907 
DATA  26 ,  0 ,  7.50576E+45 ,  105.632 
DATA  27 ,  0 ,  2.19955E-50 , -114.341 
DATA  28 ,  0 ,  4.41276E+47 ,  109.706 
DATA  29 ,  0 ,  2.65515E+47 ,  109.198 
DATA  30 ,  0 ,  1.97714E+37 ,  85.8773 
DATA  31 ,  0 ,  4.53766E-26 , -58.3548 
DATA  32 ,  0 ,  7.45346E+12 ,  29.6397 
DATA  33 ,  0 ,  8.70663E-48 , -108.36 
DATA  34 ,  0 ,  6.26129E-21 , -46.5199 
DATA  35 ,  0 ,  7.3663E+48 ,  112.521 
DATA  36 ,  0 ,  5.29087E+19 ,  45.4151 
DATA  37 ,  0 ,  8.31317E+43 ,  101.129 
DATA  38 ,  0 ,  1.77698E+28 ,  65.0473 
DATA  39 ,  0 ,  1.04803E+21 ,  48.4012 
DATA  40 ,  0 ,  1.29303E+53 ,  122.294 
DATA  41 ,  0 ,  4.28546E-25 , -56.1094 
DATA  42 ,  0 ,  2.58574E-53 , -121.087 
DATA  43 ,  0 ,  2.2764E-54 , -123.517 
DATA  44 ,  0 ,  3.97911E-43 , -97.6301 
DATA  45 ,  0 ,  1.60365E-28 , -64.0001 
DATA  46 ,  0 ,  6.97422E-12 , -25.6888 
DATA  47 ,  0 ,  2.67805E+6 ,  14.8006 
DATA  48 ,  0 ,  2.95086E-27 , -61.0877 
DATA  49 ,  0 ,  1.14668E-29 , -66.6381 
DATA  50 ,  0 ,  0 , -5476.5 
DATA  51 ,  0 ,  0 , -21210.3 
DATA  52 ,  0 ,  0 , -28757.2 
DATA  53 ,  0 ,  0 , -28732.2 
DATA  54 ,  1 ,  1.79769E+308 ,  12730.3 
DATA  55 ,  0 ,  0 , -1830.69 
DATA  56 ,  1 ,  1.79769E+308 ,  5486.39 
DATA  57 ,  1 ,  1.79769E+308 ,  22405.9 
DATA  58 ,  1 ,  1.79769E+308 ,  30809.8 
DATA  59 ,  0 ,  0 , -28930.6 
DATA  60 ,  0 ,  0 , -6014.53 
DATA  61 ,  1 ,  1.79769E+308 ,  17414.6 
DATA  62 ,  0 ,  0 , -10538.3 
DATA  63 ,  0 ,  0 , -17536.3 
DATA  64 ,  0 ,  0 , -8856.62 
DATA  65 ,  0 ,  0 , -5140.12 
DATA  66 ,  0 ,  0 , -8595.31 
DATA  67 ,  0 ,  0 , -3382.87 
DATA  68 ,  0 ,  0 , -5002.07 
DATA  69 ,  0 ,  0 , -5800.72 
DATA  70 ,  1 ,  1.79769E+308 ,  29686.4 
DATA  71 ,  1 ,  1.79769E+308 ,  2571. 
DATA  72 ,  1 ,  1.79769E+308 ,  31091. 
DATA  73 ,  1 ,  1.79769E+308 ,  14819. 
DATA  74 ,  1 ,  1.79769E+308 ,  3790.9 
DATA  75 ,  0 ,  0 , -4.2981E+9 
DATA  76 ,  0 ,  0 , -7.05453E+8 
DATA  77 ,  0 ,  0 , -3.10179E+9 
DATA  78 ,  0 ,  0 , -4.86159E+9 
DATA  79 ,  0 ,  0 , -8.62908E+8 
DATA  80 ,  0 ,  0 , -3.4101E+9 
DATA  81 ,  1 ,  1.79769E+308 ,  3.3889E+9 
DATA  82 ,  1 ,  1.79769E+308 ,  2.49826E+9 
DATA  83 ,  1 ,  1.79769E+308 ,  2.3491E+9 
DATA  84 ,  1 ,  1.79769E+308 ,  1.94745E+8 
DATA  85 ,  1 ,  1.79769E+308 ,  2.02475E+9 
DATA  86 ,  0 ,  0 , -2.26748E+9 
DATA  87 ,  0 ,  0 , -2.10587E+9 
DATA  88 ,  1 ,  1.79769E+308 ,  4.23585E+9 
DATA  89 ,  0 ,  0 , -2.66524E+9 
DATA  90 ,  1 ,  1.79769E+308 ,  4.01052E+9 
DATA  91 ,  0 ,  0 , -4.87912E+9 
DATA  92 ,  1 ,  1.79769E+308 ,  1.77556E+9 
DATA  93 ,  1 ,  1.79769E+308 ,  2.87705E+8 
DATA  94 ,  1 ,  1.79769E+308 ,  1.99977E+8 
DATA  95 ,  0 ,  0 , -3.39941E+9 
DATA  96 ,  0 ,  0 , -3.49119E+9 
DATA  97 ,  0 ,  0 , -2.86324E+9 
DATA  98 ,  1 ,  1.79769E+308 ,  4.20418E+9 
DATA  99 ,  0 ,  0 , -3.1518E+9 
DATA  100 ,  1 ,  1.79769E+308 ,  4.60615E+9 
DATA 0
9000 REM ERROR HANDLER
IF ERL = 999 THEN
  F = ABS(SGN(ERR))
  RESUME NEXT
END IF
PRINT "*** UNEXPECTED ERROR ON LINE ";ERL;" ***"
9999 END
