/*
 * Decompiled with CFR 0.152.
 */
package org.igoweb.igoweb.client.swing;

import java.awt.Component;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import org.igoweb.igoweb.Config;
import org.igoweb.igoweb.client.CRoom;
import org.igoweb.igoweb.client.Client;
import org.igoweb.igoweb.shared.GameSummary;
import org.igoweb.igoweb.shared.User;
import org.igoweb.util.CacheMap;
import org.igoweb.util.Defs;
import org.igoweb.util.Emitter;
import org.igoweb.util.Event;
import org.igoweb.util.EventListener;
import org.igoweb.util.swing.AFrame;
import org.igoweb.util.swing.MsgOut;
import org.igoweb.util.swing.WindowList;

public abstract class GuiClientUtil {
    private static Object KEY = new Object();
    private static final int EVENT_BASE = 65536;
    public static final int AVATAR_READY_EVENT = 65536;
    public static final int EVENT_LIMIT = 65537;
    public final WindowList windowList;
    protected final Client client;
    private static final CacheMap<String, Object> userPics = new CacheMap();

    protected GuiClientUtil(Client newClient, String windowListTitle) {
        newClient.objects.put(KEY, this);
        this.windowList = new WindowList(windowListTitle);
        this.windowList.setEnabled(false);
        this.client = newClient;
    }

    public static MsgOut messageReceived(Event event, Component parent) {
        return GuiClientUtil.messageReceived((String)event.arg, event.type, parent);
    }

    public static MsgOut messageReceived(String msg, int type, Component parent) {
        int mType = -1;
        String mTitle = null;
        switch (type) {
            case 12: {
                mType = 1;
                mTitle = Defs.getString(-903340709);
                break;
            }
            case 13: {
                mType = 2;
                mTitle = Defs.getString(-903340547);
                break;
            }
            case 14: {
                mType = 0;
                mTitle = Defs.getString(1436228515);
            }
        }
        return new MsgOut(mTitle, msg, mType, parent);
    }

    public static void addToWindowList(Client client, JFrame window) {
        GuiClientUtil.get((Client)client).windowList.add(window);
    }

    public static GuiClientUtil get(Client client) {
        return (GuiClientUtil)client.objects.get(KEY);
    }

    public void getUserPic(User user, Toolkit toolkit, EventListener listener) {
        PicHandler picHandler = null;
        Object result = userPics.get(user.name);
        if (result == null) {
            picHandler = new PicHandler(toolkit, user);
            userPics.put(user.name, picHandler);
            picHandler.addListener(listener);
            this.client.requestAvatarData(user.name, picHandler);
        } else if (result instanceof PicHandler) {
            ((PicHandler)result).addListener(listener);
        } else {
            listener.handleEvent(new Event(user, 65536, result));
        }
    }

    public void download(AFrame parent, String path, String fileName) {
        throw new UnsupportedOperationException();
    }

    public void save(Component parent, GameSummary<?> gameSummary, Object gameData) {
        throw new UnsupportedOperationException();
    }

    public abstract AFrame createPrefsWindow(AFrame var1);

    public void uploadFile(CRoom room, AFrame parent, boolean isPrivate) {
        throw new UnsupportedOperationException();
    }

    public JMenuItem createUploadPicMenuItem(final AFrame clientWin) {
        JMenuItem result = new JMenuItem(Defs.getString(-903340662));
        result.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                new MsgOut(Defs.getString(1436228515), Defs.getString(-903340787, Config.get("webHost")), 0, (Component)clientWin);
            }
        });
        return result;
    }

    public void showLoadWarnings(String warnings, Component source) {
        throw new UnsupportedOperationException();
    }

    public boolean isRecordSupported() {
        return false;
    }

    protected abstract void buildChallengeWindow(Client var1, CRoom var2, JComponent var3);

    protected abstract AFrame buildAutomatchWindow(Client var1, JComponent var2);

    protected void sendAutomatchCreate(JComponent mainWin) {
        this.client.sendAutomatchCreate(this.client.getAutomatchPrefs());
    }

    private static class PicHandler
    extends Emitter
    implements EventListener {
        private Toolkit toolkit;
        private User user;

        public PicHandler(Toolkit tk, User user) {
            this.toolkit = tk;
            this.user = user;
        }

        @Override
        public void handleEvent(Event event) {
            byte[] data = (byte[])event.arg;
            Image img = data == null || data[0] == 71 && data[1] == 73 && data[2] == 70 ? new BufferedImage(141, 200, 1) : this.toolkit.createImage((byte[])event.arg);
            userPics.put(this.user.name, img);
            this.emit(new Event(this.user, 65536, img));
        }
    }
}

