// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.31.0
// 	protoc        v4.23.2
// source: google/cloud/billing/budgets/v1beta1/budget_model.proto

package budgetspb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	date "google.golang.org/genproto/googleapis/type/date"
	money "google.golang.org/genproto/googleapis/type/money"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	structpb "google.golang.org/protobuf/types/known/structpb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// A `CalendarPeriod` represents the abstract concept of a time period that
// has a canonical start. Grammatically, "the start of the current
// `CalendarPeriod`". All calendar times begin at 12 AM US and Canadian
// Pacific Time (UTC-8).
type CalendarPeriod int32

const (
	// Calendar period is unset. This is the default if the budget is for a
	// custom time period (CustomPeriod).
	CalendarPeriod_CALENDAR_PERIOD_UNSPECIFIED CalendarPeriod = 0
	// A month. Month starts on the first day of each month, such as January 1,
	// February 1, March 1, and so on.
	CalendarPeriod_MONTH CalendarPeriod = 1
	// A quarter. Quarters start on dates January 1, April 1, July 1, and October
	// 1 of each year.
	CalendarPeriod_QUARTER CalendarPeriod = 2
	// A year. Year starts on January 1.
	CalendarPeriod_YEAR CalendarPeriod = 3
)

// Enum value maps for CalendarPeriod.
var (
	CalendarPeriod_name = map[int32]string{
		0: "CALENDAR_PERIOD_UNSPECIFIED",
		1: "MONTH",
		2: "QUARTER",
		3: "YEAR",
	}
	CalendarPeriod_value = map[string]int32{
		"CALENDAR_PERIOD_UNSPECIFIED": 0,
		"MONTH":                       1,
		"QUARTER":                     2,
		"YEAR":                        3,
	}
)

func (x CalendarPeriod) Enum() *CalendarPeriod {
	p := new(CalendarPeriod)
	*p = x
	return p
}

func (x CalendarPeriod) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (CalendarPeriod) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_billing_budgets_v1beta1_budget_model_proto_enumTypes[0].Descriptor()
}

func (CalendarPeriod) Type() protoreflect.EnumType {
	return &file_google_cloud_billing_budgets_v1beta1_budget_model_proto_enumTypes[0]
}

func (x CalendarPeriod) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use CalendarPeriod.Descriptor instead.
func (CalendarPeriod) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_billing_budgets_v1beta1_budget_model_proto_rawDescGZIP(), []int{0}
}

// The type of basis used to determine if spend has passed the threshold.
type ThresholdRule_Basis int32

const (
	// Unspecified threshold basis.
	ThresholdRule_BASIS_UNSPECIFIED ThresholdRule_Basis = 0
	// Use current spend as the basis for comparison against the threshold.
	ThresholdRule_CURRENT_SPEND ThresholdRule_Basis = 1
	// Use forecasted spend for the period as the basis for comparison against
	// the threshold.
	// FORECASTED_SPEND can only be set when the budget's time period is a
	// [Filter.calendar_period][google.cloud.billing.budgets.v1beta1.Filter.calendar_period].
	// It cannot be set in combination with
	// [Filter.custom_period][google.cloud.billing.budgets.v1beta1.Filter.custom_period].
	ThresholdRule_FORECASTED_SPEND ThresholdRule_Basis = 2
)

// Enum value maps for ThresholdRule_Basis.
var (
	ThresholdRule_Basis_name = map[int32]string{
		0: "BASIS_UNSPECIFIED",
		1: "CURRENT_SPEND",
		2: "FORECASTED_SPEND",
	}
	ThresholdRule_Basis_value = map[string]int32{
		"BASIS_UNSPECIFIED": 0,
		"CURRENT_SPEND":     1,
		"FORECASTED_SPEND":  2,
	}
)

func (x ThresholdRule_Basis) Enum() *ThresholdRule_Basis {
	p := new(ThresholdRule_Basis)
	*p = x
	return p
}

func (x ThresholdRule_Basis) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ThresholdRule_Basis) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_billing_budgets_v1beta1_budget_model_proto_enumTypes[1].Descriptor()
}

func (ThresholdRule_Basis) Type() protoreflect.EnumType {
	return &file_google_cloud_billing_budgets_v1beta1_budget_model_proto_enumTypes[1]
}

func (x ThresholdRule_Basis) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ThresholdRule_Basis.Descriptor instead.
func (ThresholdRule_Basis) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_billing_budgets_v1beta1_budget_model_proto_rawDescGZIP(), []int{3, 0}
}

// Specifies how credits are applied when determining the spend for
// threshold calculations. Budgets track the total cost minus any applicable
// selected credits.
// [See the documentation for a list of credit
// types](https://cloud.google.com/billing/docs/how-to/export-data-bigquery-tables#credits-type).
type Filter_CreditTypesTreatment int32

const (
	Filter_CREDIT_TYPES_TREATMENT_UNSPECIFIED Filter_CreditTypesTreatment = 0
	// All types of credit are subtracted from the gross cost to determine the
	// spend for threshold calculations.
	Filter_INCLUDE_ALL_CREDITS Filter_CreditTypesTreatment = 1
	// All types of credit are added to the net cost to determine the spend for
	// threshold calculations.
	Filter_EXCLUDE_ALL_CREDITS Filter_CreditTypesTreatment = 2
	// [Credit
	// types](https://cloud.google.com/billing/docs/how-to/export-data-bigquery-tables#credits-type)
	// specified in the credit_types field are subtracted from the
	// gross cost to determine the spend for threshold calculations.
	Filter_INCLUDE_SPECIFIED_CREDITS Filter_CreditTypesTreatment = 3
)

// Enum value maps for Filter_CreditTypesTreatment.
var (
	Filter_CreditTypesTreatment_name = map[int32]string{
		0: "CREDIT_TYPES_TREATMENT_UNSPECIFIED",
		1: "INCLUDE_ALL_CREDITS",
		2: "EXCLUDE_ALL_CREDITS",
		3: "INCLUDE_SPECIFIED_CREDITS",
	}
	Filter_CreditTypesTreatment_value = map[string]int32{
		"CREDIT_TYPES_TREATMENT_UNSPECIFIED": 0,
		"INCLUDE_ALL_CREDITS":                1,
		"EXCLUDE_ALL_CREDITS":                2,
		"INCLUDE_SPECIFIED_CREDITS":          3,
	}
)

func (x Filter_CreditTypesTreatment) Enum() *Filter_CreditTypesTreatment {
	p := new(Filter_CreditTypesTreatment)
	*p = x
	return p
}

func (x Filter_CreditTypesTreatment) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Filter_CreditTypesTreatment) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_billing_budgets_v1beta1_budget_model_proto_enumTypes[2].Descriptor()
}

func (Filter_CreditTypesTreatment) Type() protoreflect.EnumType {
	return &file_google_cloud_billing_budgets_v1beta1_budget_model_proto_enumTypes[2]
}

func (x Filter_CreditTypesTreatment) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Filter_CreditTypesTreatment.Descriptor instead.
func (Filter_CreditTypesTreatment) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_billing_budgets_v1beta1_budget_model_proto_rawDescGZIP(), []int{5, 0}
}

// A budget is a plan that describes what you expect to spend on Cloud
// projects, plus the rules to execute as spend is tracked against that plan,
// (for example, send an alert when 90% of the target spend is met).
// The budget time period is configurable, with options such as month (default),
// quarter, year, or custom time period.
type Budget struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Resource name of the budget.
	// The resource name implies the scope of a budget. Values are of the form
	// `billingAccounts/{billingAccountId}/budgets/{budgetId}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// User data for display name in UI.
	// Validation: <= 60 chars.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Optional. Filters that define which resources are used to compute the
	// actual spend against the budget amount, such as projects, services, and the
	// budget's time period, as well as other filters.
	BudgetFilter *Filter `protobuf:"bytes,3,opt,name=budget_filter,json=budgetFilter,proto3" json:"budget_filter,omitempty"`
	// Required. Budgeted amount.
	Amount *BudgetAmount `protobuf:"bytes,4,opt,name=amount,proto3" json:"amount,omitempty"`
	// Optional. Rules that trigger alerts (notifications of thresholds
	// being crossed) when spend exceeds the specified percentages of the budget.
	//
	// Optional for `pubsubTopic` notifications.
	//
	// Required if using email notifications.
	ThresholdRules []*ThresholdRule `protobuf:"bytes,5,rep,name=threshold_rules,json=thresholdRules,proto3" json:"threshold_rules,omitempty"`
	// Optional. Rules to apply to notifications sent based on budget spend and
	// thresholds.
	AllUpdatesRule *AllUpdatesRule `protobuf:"bytes,6,opt,name=all_updates_rule,json=allUpdatesRule,proto3" json:"all_updates_rule,omitempty"`
	// Optional. Etag to validate that the object is unchanged for a
	// read-modify-write operation.
	// An empty etag will cause an update to overwrite other changes.
	Etag string `protobuf:"bytes,7,opt,name=etag,proto3" json:"etag,omitempty"`
}

func (x *Budget) Reset() {
	*x = Budget{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_billing_budgets_v1beta1_budget_model_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Budget) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Budget) ProtoMessage() {}

func (x *Budget) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_billing_budgets_v1beta1_budget_model_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Budget.ProtoReflect.Descriptor instead.
func (*Budget) Descriptor() ([]byte, []int) {
	return file_google_cloud_billing_budgets_v1beta1_budget_model_proto_rawDescGZIP(), []int{0}
}

func (x *Budget) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Budget) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *Budget) GetBudgetFilter() *Filter {
	if x != nil {
		return x.BudgetFilter
	}
	return nil
}

func (x *Budget) GetAmount() *BudgetAmount {
	if x != nil {
		return x.Amount
	}
	return nil
}

func (x *Budget) GetThresholdRules() []*ThresholdRule {
	if x != nil {
		return x.ThresholdRules
	}
	return nil
}

func (x *Budget) GetAllUpdatesRule() *AllUpdatesRule {
	if x != nil {
		return x.AllUpdatesRule
	}
	return nil
}

func (x *Budget) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

// The budgeted amount for each usage period.
type BudgetAmount struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Specification for what amount to use as the budget.
	//
	// Types that are assignable to BudgetAmount:
	//	*BudgetAmount_SpecifiedAmount
	//	*BudgetAmount_LastPeriodAmount
	BudgetAmount isBudgetAmount_BudgetAmount `protobuf_oneof:"budget_amount"`
}

func (x *BudgetAmount) Reset() {
	*x = BudgetAmount{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_billing_budgets_v1beta1_budget_model_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BudgetAmount) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BudgetAmount) ProtoMessage() {}

func (x *BudgetAmount) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_billing_budgets_v1beta1_budget_model_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BudgetAmount.ProtoReflect.Descriptor instead.
func (*BudgetAmount) Descriptor() ([]byte, []int) {
	return file_google_cloud_billing_budgets_v1beta1_budget_model_proto_rawDescGZIP(), []int{1}
}

func (m *BudgetAmount) GetBudgetAmount() isBudgetAmount_BudgetAmount {
	if m != nil {
		return m.BudgetAmount
	}
	return nil
}

func (x *BudgetAmount) GetSpecifiedAmount() *money.Money {
	if x, ok := x.GetBudgetAmount().(*BudgetAmount_SpecifiedAmount); ok {
		return x.SpecifiedAmount
	}
	return nil
}

func (x *BudgetAmount) GetLastPeriodAmount() *LastPeriodAmount {
	if x, ok := x.GetBudgetAmount().(*BudgetAmount_LastPeriodAmount); ok {
		return x.LastPeriodAmount
	}
	return nil
}

type isBudgetAmount_BudgetAmount interface {
	isBudgetAmount_BudgetAmount()
}

type BudgetAmount_SpecifiedAmount struct {
	// A specified amount to use as the budget.
	// `currency_code` is optional. If specified when creating a budget, it must
	// match the currency of the billing account. If specified when updating a
	// budget, it must match the currency_code of the existing budget.
	// The `currency_code` is provided on output.
	SpecifiedAmount *money.Money `protobuf:"bytes,1,opt,name=specified_amount,json=specifiedAmount,proto3,oneof"`
}

type BudgetAmount_LastPeriodAmount struct {
	// Use the last period's actual spend as the budget for the present period.
	// LastPeriodAmount can only be set when the budget's time period is a
	// [Filter.calendar_period][google.cloud.billing.budgets.v1beta1.Filter.calendar_period].
	// It cannot be set in combination with
	// [Filter.custom_period][google.cloud.billing.budgets.v1beta1.Filter.custom_period].
	LastPeriodAmount *LastPeriodAmount `protobuf:"bytes,2,opt,name=last_period_amount,json=lastPeriodAmount,proto3,oneof"`
}

func (*BudgetAmount_SpecifiedAmount) isBudgetAmount_BudgetAmount() {}

func (*BudgetAmount_LastPeriodAmount) isBudgetAmount_BudgetAmount() {}

// Describes a budget amount targeted to the last
// [Filter.calendar_period][google.cloud.billing.budgets.v1beta1.Filter.calendar_period]
// spend. At this time, the amount is automatically 100% of the last calendar
// period's spend; that is, there are no other options yet.
// Future configuration options will be described here (for example, configuring
// a percentage of last period's spend).
// LastPeriodAmount cannot be set for a budget configured with
// a
// [Filter.custom_period][google.cloud.billing.budgets.v1beta1.Filter.custom_period].
type LastPeriodAmount struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *LastPeriodAmount) Reset() {
	*x = LastPeriodAmount{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_billing_budgets_v1beta1_budget_model_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LastPeriodAmount) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LastPeriodAmount) ProtoMessage() {}

func (x *LastPeriodAmount) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_billing_budgets_v1beta1_budget_model_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LastPeriodAmount.ProtoReflect.Descriptor instead.
func (*LastPeriodAmount) Descriptor() ([]byte, []int) {
	return file_google_cloud_billing_budgets_v1beta1_budget_model_proto_rawDescGZIP(), []int{2}
}

// ThresholdRule contains the definition of a threshold. Threshold rules define
// the triggering events used to generate a budget notification email. When a
// threshold is crossed (spend exceeds the specified percentages of the
// budget), budget alert emails are sent to the email recipients you specify
// in the
// [NotificationsRule](#notificationsrule).
//
// Threshold rules also affect the fields included in the
// [JSON data
// object](https://cloud.google.com/billing/docs/how-to/budgets-programmatic-notifications#notification_format)
// sent to a Pub/Sub topic.
//
// Threshold rules are _required_ if using email notifications.
//
// Threshold rules are _optional_ if only setting a
// [`pubsubTopic` NotificationsRule](#NotificationsRule),
// unless you want your JSON data object to include data about the thresholds
// you set.
//
// For more information, see
// [set budget threshold rules and
// actions](https://cloud.google.com/billing/docs/how-to/budgets#budget-actions).
type ThresholdRule struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Send an alert when this threshold is exceeded.
	// This is a 1.0-based percentage, so 0.5 = 50%.
	// Validation: non-negative number.
	ThresholdPercent float64 `protobuf:"fixed64,1,opt,name=threshold_percent,json=thresholdPercent,proto3" json:"threshold_percent,omitempty"`
	// Optional. The type of basis used to determine if spend has passed the
	// threshold. Behavior defaults to CURRENT_SPEND if not set.
	SpendBasis ThresholdRule_Basis `protobuf:"varint,2,opt,name=spend_basis,json=spendBasis,proto3,enum=google.cloud.billing.budgets.v1beta1.ThresholdRule_Basis" json:"spend_basis,omitempty"`
}

func (x *ThresholdRule) Reset() {
	*x = ThresholdRule{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_billing_budgets_v1beta1_budget_model_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ThresholdRule) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ThresholdRule) ProtoMessage() {}

func (x *ThresholdRule) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_billing_budgets_v1beta1_budget_model_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ThresholdRule.ProtoReflect.Descriptor instead.
func (*ThresholdRule) Descriptor() ([]byte, []int) {
	return file_google_cloud_billing_budgets_v1beta1_budget_model_proto_rawDescGZIP(), []int{3}
}

func (x *ThresholdRule) GetThresholdPercent() float64 {
	if x != nil {
		return x.ThresholdPercent
	}
	return 0
}

func (x *ThresholdRule) GetSpendBasis() ThresholdRule_Basis {
	if x != nil {
		return x.SpendBasis
	}
	return ThresholdRule_BASIS_UNSPECIFIED
}

// AllUpdatesRule defines notifications that are sent based on budget spend
// and thresholds.
type AllUpdatesRule struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The name of the Pub/Sub topic where budget related messages will
	// be published, in the form `projects/{project_id}/topics/{topic_id}`.
	// Updates are sent at regular intervals to the topic. The topic needs to be
	// created before the budget is created; see
	// https://cloud.google.com/billing/docs/how-to/budgets-programmatic-notifications
	// for more details.
	// Caller is expected to have
	// `pubsub.topics.setIamPolicy` permission on the topic when it's set for a
	// budget, otherwise, the API call will fail with PERMISSION_DENIED. See
	// https://cloud.google.com/billing/docs/how-to/budgets-programmatic-notifications#permissions_required_for_this_task
	// for more details on Pub/Sub roles and permissions.
	PubsubTopic string `protobuf:"bytes,1,opt,name=pubsub_topic,json=pubsubTopic,proto3" json:"pubsub_topic,omitempty"`
	// Optional. Required when
	// [AllUpdatesRule.pubsub_topic][google.cloud.billing.budgets.v1beta1.AllUpdatesRule.pubsub_topic]
	// is set. The schema version of the notification sent to
	// [AllUpdatesRule.pubsub_topic][google.cloud.billing.budgets.v1beta1.AllUpdatesRule.pubsub_topic].
	// Only "1.0" is accepted. It represents the JSON schema as defined in
	// https://cloud.google.com/billing/docs/how-to/budgets-programmatic-notifications#notification_format.
	SchemaVersion string `protobuf:"bytes,2,opt,name=schema_version,json=schemaVersion,proto3" json:"schema_version,omitempty"`
	// Optional. Targets to send notifications to when a threshold is exceeded.
	// This is in addition to default recipients who have billing account IAM
	// roles. The value is the full REST resource name of a monitoring
	// notification channel with the form
	// `projects/{project_id}/notificationChannels/{channel_id}`. A maximum of 5
	// channels are allowed. See
	// https://cloud.google.com/billing/docs/how-to/budgets-notification-recipients
	// for more details.
	MonitoringNotificationChannels []string `protobuf:"bytes,3,rep,name=monitoring_notification_channels,json=monitoringNotificationChannels,proto3" json:"monitoring_notification_channels,omitempty"`
	// Optional. When set to true, disables default notifications sent when a
	// threshold is exceeded. Default notifications are sent to those with Billing
	// Account Administrator and Billing Account User IAM roles for the target
	// account.
	DisableDefaultIamRecipients bool `protobuf:"varint,4,opt,name=disable_default_iam_recipients,json=disableDefaultIamRecipients,proto3" json:"disable_default_iam_recipients,omitempty"`
	// Optional. When set to true, and when the budget has a single project
	// configured, notifications will be sent to project level recipients of that
	// project. This field will be ignored if the budget has multiple or no
	// project configured.
	//
	// Currently, project level recipients are the users with `Owner` role on a
	// cloud project.
	EnableProjectLevelRecipients bool `protobuf:"varint,5,opt,name=enable_project_level_recipients,json=enableProjectLevelRecipients,proto3" json:"enable_project_level_recipients,omitempty"`
}

func (x *AllUpdatesRule) Reset() {
	*x = AllUpdatesRule{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_billing_budgets_v1beta1_budget_model_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AllUpdatesRule) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AllUpdatesRule) ProtoMessage() {}

func (x *AllUpdatesRule) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_billing_budgets_v1beta1_budget_model_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AllUpdatesRule.ProtoReflect.Descriptor instead.
func (*AllUpdatesRule) Descriptor() ([]byte, []int) {
	return file_google_cloud_billing_budgets_v1beta1_budget_model_proto_rawDescGZIP(), []int{4}
}

func (x *AllUpdatesRule) GetPubsubTopic() string {
	if x != nil {
		return x.PubsubTopic
	}
	return ""
}

func (x *AllUpdatesRule) GetSchemaVersion() string {
	if x != nil {
		return x.SchemaVersion
	}
	return ""
}

func (x *AllUpdatesRule) GetMonitoringNotificationChannels() []string {
	if x != nil {
		return x.MonitoringNotificationChannels
	}
	return nil
}

func (x *AllUpdatesRule) GetDisableDefaultIamRecipients() bool {
	if x != nil {
		return x.DisableDefaultIamRecipients
	}
	return false
}

func (x *AllUpdatesRule) GetEnableProjectLevelRecipients() bool {
	if x != nil {
		return x.EnableProjectLevelRecipients
	}
	return false
}

// A filter for a budget, limiting the scope of the cost to calculate.
type Filter struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. A set of projects of the form `projects/{project}`,
	// specifying that usage from only this set of projects should be
	// included in the budget. If omitted, the report will include all usage for
	// the billing account, regardless of which project the usage occurred on.
	Projects []string `protobuf:"bytes,1,rep,name=projects,proto3" json:"projects,omitempty"`
	// Optional. A set of folder and organization names of the form
	// `folders/{folderId}` or `organizations/{organizationId}`, specifying that
	// usage from only this set of folders and organizations should be included in
	// the budget. If omitted, the budget includes all usage that the billing
	// account pays for. If the folder or organization contains projects that are
	// paid for by a different Cloud Billing account, the budget *doesn't* apply
	// to those projects.
	ResourceAncestors []string `protobuf:"bytes,2,rep,name=resource_ancestors,json=resourceAncestors,proto3" json:"resource_ancestors,omitempty"`
	// Optional. If
	// [Filter.credit_types_treatment][google.cloud.billing.budgets.v1beta1.Filter.credit_types_treatment]
	// is INCLUDE_SPECIFIED_CREDITS, this is a list of credit types to be
	// subtracted from gross cost to determine the spend for threshold
	// calculations. See [a list of acceptable credit type
	// values](https://cloud.google.com/billing/docs/how-to/export-data-bigquery-tables#credits-type).
	//
	// If
	// [Filter.credit_types_treatment][google.cloud.billing.budgets.v1beta1.Filter.credit_types_treatment]
	// is **not** INCLUDE_SPECIFIED_CREDITS, this field must be empty.
	CreditTypes []string `protobuf:"bytes,7,rep,name=credit_types,json=creditTypes,proto3" json:"credit_types,omitempty"`
	// Optional. If not set, default behavior is `INCLUDE_ALL_CREDITS`.
	CreditTypesTreatment Filter_CreditTypesTreatment `protobuf:"varint,4,opt,name=credit_types_treatment,json=creditTypesTreatment,proto3,enum=google.cloud.billing.budgets.v1beta1.Filter_CreditTypesTreatment" json:"credit_types_treatment,omitempty"`
	// Optional. A set of services of the form `services/{service_id}`,
	// specifying that usage from only this set of services should be
	// included in the budget. If omitted, the report will include usage for
	// all the services.
	// The service names are available through the Catalog API:
	// https://cloud.google.com/billing/v1/how-tos/catalog-api.
	Services []string `protobuf:"bytes,3,rep,name=services,proto3" json:"services,omitempty"`
	// Optional. A set of subaccounts of the form `billingAccounts/{account_id}`,
	// specifying that usage from only this set of subaccounts should be included
	// in the budget. If a subaccount is set to the name of the parent account,
	// usage from the parent account will be included. If omitted, the
	// report will include usage from the parent account and all
	// subaccounts, if they exist.
	Subaccounts []string `protobuf:"bytes,5,rep,name=subaccounts,proto3" json:"subaccounts,omitempty"`
	// Optional. A single label and value pair specifying that usage from only
	// this set of labeled resources should be included in the budget. If omitted,
	// the report will include all labeled and unlabeled usage.
	//
	// An object containing a single `"key": value` pair. Example: `{ "name":
	// "wrench" }`.
	//
	//  _Currently, multiple entries or multiple values per entry are not
	//  allowed._
	Labels map[string]*structpb.ListValue `protobuf:"bytes,6,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Multiple options to choose the budget's time period, specifying that only
	// usage that occurs during this time period should be included in the budget.
	// If not set, the <code>usage_period</code> defaults to CalendarPeriod.MONTH.
	//
	// Types that are assignable to UsagePeriod:
	//	*Filter_CalendarPeriod
	//	*Filter_CustomPeriod
	UsagePeriod isFilter_UsagePeriod `protobuf_oneof:"usage_period"`
}

func (x *Filter) Reset() {
	*x = Filter{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_billing_budgets_v1beta1_budget_model_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Filter) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Filter) ProtoMessage() {}

func (x *Filter) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_billing_budgets_v1beta1_budget_model_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Filter.ProtoReflect.Descriptor instead.
func (*Filter) Descriptor() ([]byte, []int) {
	return file_google_cloud_billing_budgets_v1beta1_budget_model_proto_rawDescGZIP(), []int{5}
}

func (x *Filter) GetProjects() []string {
	if x != nil {
		return x.Projects
	}
	return nil
}

func (x *Filter) GetResourceAncestors() []string {
	if x != nil {
		return x.ResourceAncestors
	}
	return nil
}

func (x *Filter) GetCreditTypes() []string {
	if x != nil {
		return x.CreditTypes
	}
	return nil
}

func (x *Filter) GetCreditTypesTreatment() Filter_CreditTypesTreatment {
	if x != nil {
		return x.CreditTypesTreatment
	}
	return Filter_CREDIT_TYPES_TREATMENT_UNSPECIFIED
}

func (x *Filter) GetServices() []string {
	if x != nil {
		return x.Services
	}
	return nil
}

func (x *Filter) GetSubaccounts() []string {
	if x != nil {
		return x.Subaccounts
	}
	return nil
}

func (x *Filter) GetLabels() map[string]*structpb.ListValue {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (m *Filter) GetUsagePeriod() isFilter_UsagePeriod {
	if m != nil {
		return m.UsagePeriod
	}
	return nil
}

func (x *Filter) GetCalendarPeriod() CalendarPeriod {
	if x, ok := x.GetUsagePeriod().(*Filter_CalendarPeriod); ok {
		return x.CalendarPeriod
	}
	return CalendarPeriod_CALENDAR_PERIOD_UNSPECIFIED
}

func (x *Filter) GetCustomPeriod() *CustomPeriod {
	if x, ok := x.GetUsagePeriod().(*Filter_CustomPeriod); ok {
		return x.CustomPeriod
	}
	return nil
}

type isFilter_UsagePeriod interface {
	isFilter_UsagePeriod()
}

type Filter_CalendarPeriod struct {
	// Optional. Specifies to track usage for recurring calendar period.
	// For example, assume that CalendarPeriod.QUARTER is set. The budget will
	// track usage from April 1 to June 30, when the current calendar month is
	// April, May, June. After that, it will track usage from July 1 to
	// September 30 when the current calendar month is July, August, September,
	// so on.
	CalendarPeriod CalendarPeriod `protobuf:"varint,8,opt,name=calendar_period,json=calendarPeriod,proto3,enum=google.cloud.billing.budgets.v1beta1.CalendarPeriod,oneof"`
}

type Filter_CustomPeriod struct {
	// Optional. Specifies to track usage from any start date (required) to any
	// end date (optional). This time period is static, it does not recur.
	CustomPeriod *CustomPeriod `protobuf:"bytes,9,opt,name=custom_period,json=customPeriod,proto3,oneof"`
}

func (*Filter_CalendarPeriod) isFilter_UsagePeriod() {}

func (*Filter_CustomPeriod) isFilter_UsagePeriod() {}

// All date times begin at 12 AM US and Canadian Pacific Time (UTC-8).
type CustomPeriod struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The start date must be after January 1, 2017.
	StartDate *date.Date `protobuf:"bytes,1,opt,name=start_date,json=startDate,proto3" json:"start_date,omitempty"`
	// Optional. The end date of the time period. Budgets with elapsed end date
	// won't be processed. If unset, specifies to track all usage incurred since
	// the start_date.
	EndDate *date.Date `protobuf:"bytes,2,opt,name=end_date,json=endDate,proto3" json:"end_date,omitempty"`
}

func (x *CustomPeriod) Reset() {
	*x = CustomPeriod{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_billing_budgets_v1beta1_budget_model_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CustomPeriod) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CustomPeriod) ProtoMessage() {}

func (x *CustomPeriod) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_billing_budgets_v1beta1_budget_model_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CustomPeriod.ProtoReflect.Descriptor instead.
func (*CustomPeriod) Descriptor() ([]byte, []int) {
	return file_google_cloud_billing_budgets_v1beta1_budget_model_proto_rawDescGZIP(), []int{6}
}

func (x *CustomPeriod) GetStartDate() *date.Date {
	if x != nil {
		return x.StartDate
	}
	return nil
}

func (x *CustomPeriod) GetEndDate() *date.Date {
	if x != nil {
		return x.EndDate
	}
	return nil
}

var File_google_cloud_billing_budgets_v1beta1_budget_model_proto protoreflect.FileDescriptor

var file_google_cloud_billing_budgets_v1beta1_budget_model_proto_rawDesc = []byte{
	0x0a, 0x37, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x62,
	0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x2f, 0x62, 0x75, 0x64, 0x67, 0x65, 0x74, 0x73, 0x2f, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x62, 0x75, 0x64, 0x67, 0x65, 0x74, 0x5f, 0x6d, 0x6f,
	0x64, 0x65, 0x6c, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x24, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x2e,
	0x62, 0x75, 0x64, 0x67, 0x65, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x1a,
	0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c,
	0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1c, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x73, 0x74, 0x72,
	0x75, 0x63, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x16, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x2f, 0x64, 0x61, 0x74, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x2f, 0x6d,
	0x6f, 0x6e, 0x65, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xad, 0x04, 0x0a, 0x06, 0x42,
	0x75, 0x64, 0x67, 0x65, 0x74, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x21,
	0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d,
	0x65, 0x12, 0x56, 0x0a, 0x0d, 0x62, 0x75, 0x64, 0x67, 0x65, 0x74, 0x5f, 0x66, 0x69, 0x6c, 0x74,
	0x65, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x2e,
	0x62, 0x75, 0x64, 0x67, 0x65, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x62, 0x75, 0x64,
	0x67, 0x65, 0x74, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x4f, 0x0a, 0x06, 0x61, 0x6d, 0x6f,
	0x75, 0x6e, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67,
	0x2e, 0x62, 0x75, 0x64, 0x67, 0x65, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x42, 0x75, 0x64, 0x67, 0x65, 0x74, 0x41, 0x6d, 0x6f, 0x75, 0x6e, 0x74, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x06, 0x61, 0x6d, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x61, 0x0a, 0x0f, 0x74, 0x68,
	0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64, 0x5f, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x18, 0x05, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x62, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x2e, 0x62, 0x75, 0x64, 0x67, 0x65,
	0x74, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x54, 0x68, 0x72, 0x65, 0x73,
	0x68, 0x6f, 0x6c, 0x64, 0x52, 0x75, 0x6c, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0e, 0x74,
	0x68, 0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64, 0x52, 0x75, 0x6c, 0x65, 0x73, 0x12, 0x63, 0x0a,
	0x10, 0x61, 0x6c, 0x6c, 0x5f, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x73, 0x5f, 0x72, 0x75, 0x6c,
	0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x2e, 0x62,
	0x75, 0x64, 0x67, 0x65, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x41,
	0x6c, 0x6c, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x73, 0x52, 0x75, 0x6c, 0x65, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x0e, 0x61, 0x6c, 0x6c, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x73, 0x52, 0x75,
	0x6c, 0x65, 0x12, 0x17, 0x0a, 0x04, 0x65, 0x74, 0x61, 0x67, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x04, 0x65, 0x74, 0x61, 0x67, 0x3a, 0x5d, 0xea, 0x41, 0x5a,
	0x0a, 0x24, 0x62, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x62, 0x75, 0x64, 0x67, 0x65, 0x74, 0x73,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x42, 0x75, 0x64, 0x67, 0x65, 0x74, 0x12, 0x32, 0x62, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x41,
	0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x7b, 0x62, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67,
	0x5f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x7d, 0x2f, 0x62, 0x75, 0x64, 0x67, 0x65, 0x74,
	0x73, 0x2f, 0x7b, 0x62, 0x75, 0x64, 0x67, 0x65, 0x74, 0x7d, 0x22, 0xc8, 0x01, 0x0a, 0x0c, 0x42,
	0x75, 0x64, 0x67, 0x65, 0x74, 0x41, 0x6d, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x3f, 0x0a, 0x10, 0x73,
	0x70, 0x65, 0x63, 0x69, 0x66, 0x69, 0x65, 0x64, 0x5f, 0x61, 0x6d, 0x6f, 0x75, 0x6e, 0x74, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74,
	0x79, 0x70, 0x65, 0x2e, 0x4d, 0x6f, 0x6e, 0x65, 0x79, 0x48, 0x00, 0x52, 0x0f, 0x73, 0x70, 0x65,
	0x63, 0x69, 0x66, 0x69, 0x65, 0x64, 0x41, 0x6d, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x66, 0x0a, 0x12,
	0x6c, 0x61, 0x73, 0x74, 0x5f, 0x70, 0x65, 0x72, 0x69, 0x6f, 0x64, 0x5f, 0x61, 0x6d, 0x6f, 0x75,
	0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x2e,
	0x62, 0x75, 0x64, 0x67, 0x65, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x4c, 0x61, 0x73, 0x74, 0x50, 0x65, 0x72, 0x69, 0x6f, 0x64, 0x41, 0x6d, 0x6f, 0x75, 0x6e, 0x74,
	0x48, 0x00, 0x52, 0x10, 0x6c, 0x61, 0x73, 0x74, 0x50, 0x65, 0x72, 0x69, 0x6f, 0x64, 0x41, 0x6d,
	0x6f, 0x75, 0x6e, 0x74, 0x42, 0x0f, 0x0a, 0x0d, 0x62, 0x75, 0x64, 0x67, 0x65, 0x74, 0x5f, 0x61,
	0x6d, 0x6f, 0x75, 0x6e, 0x74, 0x22, 0x12, 0x0a, 0x10, 0x4c, 0x61, 0x73, 0x74, 0x50, 0x65, 0x72,
	0x69, 0x6f, 0x64, 0x41, 0x6d, 0x6f, 0x75, 0x6e, 0x74, 0x22, 0xeb, 0x01, 0x0a, 0x0d, 0x54, 0x68,
	0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64, 0x52, 0x75, 0x6c, 0x65, 0x12, 0x30, 0x0a, 0x11, 0x74,
	0x68, 0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64, 0x5f, 0x70, 0x65, 0x72, 0x63, 0x65, 0x6e, 0x74,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x01, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x10, 0x74, 0x68, 0x72,
	0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64, 0x50, 0x65, 0x72, 0x63, 0x65, 0x6e, 0x74, 0x12, 0x5f, 0x0a,
	0x0b, 0x73, 0x70, 0x65, 0x6e, 0x64, 0x5f, 0x62, 0x61, 0x73, 0x69, 0x73, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x62, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x2e, 0x62, 0x75, 0x64, 0x67, 0x65, 0x74,
	0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x54, 0x68, 0x72, 0x65, 0x73, 0x68,
	0x6f, 0x6c, 0x64, 0x52, 0x75, 0x6c, 0x65, 0x2e, 0x42, 0x61, 0x73, 0x69, 0x73, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x0a, 0x73, 0x70, 0x65, 0x6e, 0x64, 0x42, 0x61, 0x73, 0x69, 0x73, 0x22, 0x47,
	0x0a, 0x05, 0x42, 0x61, 0x73, 0x69, 0x73, 0x12, 0x15, 0x0a, 0x11, 0x42, 0x41, 0x53, 0x49, 0x53,
	0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x11,
	0x0a, 0x0d, 0x43, 0x55, 0x52, 0x52, 0x45, 0x4e, 0x54, 0x5f, 0x53, 0x50, 0x45, 0x4e, 0x44, 0x10,
	0x01, 0x12, 0x14, 0x0a, 0x10, 0x46, 0x4f, 0x52, 0x45, 0x43, 0x41, 0x53, 0x54, 0x45, 0x44, 0x5f,
	0x53, 0x50, 0x45, 0x4e, 0x44, 0x10, 0x02, 0x22, 0xc9, 0x02, 0x0a, 0x0e, 0x41, 0x6c, 0x6c, 0x55,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x73, 0x52, 0x75, 0x6c, 0x65, 0x12, 0x26, 0x0a, 0x0c, 0x70, 0x75,
	0x62, 0x73, 0x75, 0x62, 0x5f, 0x74, 0x6f, 0x70, 0x69, 0x63, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x54, 0x6f, 0x70,
	0x69, 0x63, 0x12, 0x2a, 0x0a, 0x0e, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x5f, 0x76, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x0d, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x4d,
	0x0a, 0x20, 0x6d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x5f, 0x6e, 0x6f, 0x74,
	0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65,
	0x6c, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x1e, 0x6d,
	0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x73, 0x12, 0x48, 0x0a,
	0x1e, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74,
	0x5f, 0x69, 0x61, 0x6d, 0x5f, 0x72, 0x65, 0x63, 0x69, 0x70, 0x69, 0x65, 0x6e, 0x74, 0x73, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x1b, 0x64, 0x69, 0x73, 0x61,
	0x62, 0x6c, 0x65, 0x44, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x49, 0x61, 0x6d, 0x52, 0x65, 0x63,
	0x69, 0x70, 0x69, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x4a, 0x0a, 0x1f, 0x65, 0x6e, 0x61, 0x62, 0x6c,
	0x65, 0x5f, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x6c, 0x65, 0x76, 0x65, 0x6c, 0x5f,
	0x72, 0x65, 0x63, 0x69, 0x70, 0x69, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x1c, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x50, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x52, 0x65, 0x63, 0x69, 0x70, 0x69, 0x65,
	0x6e, 0x74, 0x73, 0x22, 0xe1, 0x06, 0x0a, 0x06, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x1f,
	0x0a, 0x08, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x12,
	0x32, 0x0a, 0x12, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x61, 0x6e, 0x63, 0x65,
	0x73, 0x74, 0x6f, 0x72, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x11, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x41, 0x6e, 0x63, 0x65, 0x73, 0x74,
	0x6f, 0x72, 0x73, 0x12, 0x26, 0x0a, 0x0c, 0x63, 0x72, 0x65, 0x64, 0x69, 0x74, 0x5f, 0x74, 0x79,
	0x70, 0x65, 0x73, 0x18, 0x07, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b,
	0x63, 0x72, 0x65, 0x64, 0x69, 0x74, 0x54, 0x79, 0x70, 0x65, 0x73, 0x12, 0x7c, 0x0a, 0x16, 0x63,
	0x72, 0x65, 0x64, 0x69, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x5f, 0x74, 0x72, 0x65, 0x61,
	0x74, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x41, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x6c, 0x6c, 0x69,
	0x6e, 0x67, 0x2e, 0x62, 0x75, 0x64, 0x67, 0x65, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x2e, 0x43, 0x72, 0x65, 0x64, 0x69, 0x74,
	0x54, 0x79, 0x70, 0x65, 0x73, 0x54, 0x72, 0x65, 0x61, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x14, 0x63, 0x72, 0x65, 0x64, 0x69, 0x74, 0x54, 0x79, 0x70, 0x65, 0x73,
	0x54, 0x72, 0x65, 0x61, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x1f, 0x0a, 0x08, 0x73, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x08, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x12, 0x25, 0x0a, 0x0b, 0x73, 0x75,
	0x62, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x73, 0x75, 0x62, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74,
	0x73, 0x12, 0x55, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x62, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x2e, 0x62, 0x75, 0x64, 0x67, 0x65, 0x74, 0x73,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x2e,
	0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x64, 0x0a, 0x0f, 0x63, 0x61, 0x6c, 0x65,
	0x6e, 0x64, 0x61, 0x72, 0x5f, 0x70, 0x65, 0x72, 0x69, 0x6f, 0x64, 0x18, 0x08, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x62, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x2e, 0x62, 0x75, 0x64, 0x67, 0x65, 0x74, 0x73,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x61, 0x6c, 0x65, 0x6e, 0x64, 0x61,
	0x72, 0x50, 0x65, 0x72, 0x69, 0x6f, 0x64, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x0e,
	0x63, 0x61, 0x6c, 0x65, 0x6e, 0x64, 0x61, 0x72, 0x50, 0x65, 0x72, 0x69, 0x6f, 0x64, 0x12, 0x5e,
	0x0a, 0x0d, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x70, 0x65, 0x72, 0x69, 0x6f, 0x64, 0x18,
	0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x2e, 0x62, 0x75, 0x64,
	0x67, 0x65, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x75, 0x73,
	0x74, 0x6f, 0x6d, 0x50, 0x65, 0x72, 0x69, 0x6f, 0x64, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00,
	0x52, 0x0c, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x50, 0x65, 0x72, 0x69, 0x6f, 0x64, 0x1a, 0x55,
	0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a,
	0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12,
	0x30, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x4c, 0x69, 0x73, 0x74, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x8f, 0x01, 0x0a, 0x14, 0x43, 0x72, 0x65, 0x64, 0x69, 0x74,
	0x54, 0x79, 0x70, 0x65, 0x73, 0x54, 0x72, 0x65, 0x61, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x26,
	0x0a, 0x22, 0x43, 0x52, 0x45, 0x44, 0x49, 0x54, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x53, 0x5f, 0x54,
	0x52, 0x45, 0x41, 0x54, 0x4d, 0x45, 0x4e, 0x54, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49,
	0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x17, 0x0a, 0x13, 0x49, 0x4e, 0x43, 0x4c, 0x55, 0x44,
	0x45, 0x5f, 0x41, 0x4c, 0x4c, 0x5f, 0x43, 0x52, 0x45, 0x44, 0x49, 0x54, 0x53, 0x10, 0x01, 0x12,
	0x17, 0x0a, 0x13, 0x45, 0x58, 0x43, 0x4c, 0x55, 0x44, 0x45, 0x5f, 0x41, 0x4c, 0x4c, 0x5f, 0x43,
	0x52, 0x45, 0x44, 0x49, 0x54, 0x53, 0x10, 0x02, 0x12, 0x1d, 0x0a, 0x19, 0x49, 0x4e, 0x43, 0x4c,
	0x55, 0x44, 0x45, 0x5f, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x5f, 0x43, 0x52,
	0x45, 0x44, 0x49, 0x54, 0x53, 0x10, 0x03, 0x42, 0x0e, 0x0a, 0x0c, 0x75, 0x73, 0x61, 0x67, 0x65,
	0x5f, 0x70, 0x65, 0x72, 0x69, 0x6f, 0x64, 0x22, 0x78, 0x0a, 0x0c, 0x43, 0x75, 0x73, 0x74, 0x6f,
	0x6d, 0x50, 0x65, 0x72, 0x69, 0x6f, 0x64, 0x12, 0x35, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74,
	0x5f, 0x64, 0x61, 0x74, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x11, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x44, 0x61, 0x74, 0x65, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x09, 0x73, 0x74, 0x61, 0x72, 0x74, 0x44, 0x61, 0x74, 0x65, 0x12, 0x31,
	0x0a, 0x08, 0x65, 0x6e, 0x64, 0x5f, 0x64, 0x61, 0x74, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x11, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x44,
	0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x07, 0x65, 0x6e, 0x64, 0x44, 0x61, 0x74,
	0x65, 0x2a, 0x53, 0x0a, 0x0e, 0x43, 0x61, 0x6c, 0x65, 0x6e, 0x64, 0x61, 0x72, 0x50, 0x65, 0x72,
	0x69, 0x6f, 0x64, 0x12, 0x1f, 0x0a, 0x1b, 0x43, 0x41, 0x4c, 0x45, 0x4e, 0x44, 0x41, 0x52, 0x5f,
	0x50, 0x45, 0x52, 0x49, 0x4f, 0x44, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49,
	0x45, 0x44, 0x10, 0x00, 0x12, 0x09, 0x0a, 0x05, 0x4d, 0x4f, 0x4e, 0x54, 0x48, 0x10, 0x01, 0x12,
	0x0b, 0x0a, 0x07, 0x51, 0x55, 0x41, 0x52, 0x54, 0x45, 0x52, 0x10, 0x02, 0x12, 0x08, 0x0a, 0x04,
	0x59, 0x45, 0x41, 0x52, 0x10, 0x03, 0x42, 0x70, 0x0a, 0x28, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x6c, 0x6c, 0x69,
	0x6e, 0x67, 0x2e, 0x62, 0x75, 0x64, 0x67, 0x65, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x50, 0x01, 0x5a, 0x42, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x62, 0x69, 0x6c, 0x6c, 0x69, 0x6e,
	0x67, 0x2f, 0x62, 0x75, 0x64, 0x67, 0x65, 0x74, 0x73, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2f, 0x62, 0x75, 0x64, 0x67, 0x65, 0x74, 0x73, 0x70, 0x62, 0x3b, 0x62,
	0x75, 0x64, 0x67, 0x65, 0x74, 0x73, 0x70, 0x62, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_billing_budgets_v1beta1_budget_model_proto_rawDescOnce sync.Once
	file_google_cloud_billing_budgets_v1beta1_budget_model_proto_rawDescData = file_google_cloud_billing_budgets_v1beta1_budget_model_proto_rawDesc
)

func file_google_cloud_billing_budgets_v1beta1_budget_model_proto_rawDescGZIP() []byte {
	file_google_cloud_billing_budgets_v1beta1_budget_model_proto_rawDescOnce.Do(func() {
		file_google_cloud_billing_budgets_v1beta1_budget_model_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_billing_budgets_v1beta1_budget_model_proto_rawDescData)
	})
	return file_google_cloud_billing_budgets_v1beta1_budget_model_proto_rawDescData
}

var file_google_cloud_billing_budgets_v1beta1_budget_model_proto_enumTypes = make([]protoimpl.EnumInfo, 3)
var file_google_cloud_billing_budgets_v1beta1_budget_model_proto_msgTypes = make([]protoimpl.MessageInfo, 8)
var file_google_cloud_billing_budgets_v1beta1_budget_model_proto_goTypes = []interface{}{
	(CalendarPeriod)(0),              // 0: google.cloud.billing.budgets.v1beta1.CalendarPeriod
	(ThresholdRule_Basis)(0),         // 1: google.cloud.billing.budgets.v1beta1.ThresholdRule.Basis
	(Filter_CreditTypesTreatment)(0), // 2: google.cloud.billing.budgets.v1beta1.Filter.CreditTypesTreatment
	(*Budget)(nil),                   // 3: google.cloud.billing.budgets.v1beta1.Budget
	(*BudgetAmount)(nil),             // 4: google.cloud.billing.budgets.v1beta1.BudgetAmount
	(*LastPeriodAmount)(nil),         // 5: google.cloud.billing.budgets.v1beta1.LastPeriodAmount
	(*ThresholdRule)(nil),            // 6: google.cloud.billing.budgets.v1beta1.ThresholdRule
	(*AllUpdatesRule)(nil),           // 7: google.cloud.billing.budgets.v1beta1.AllUpdatesRule
	(*Filter)(nil),                   // 8: google.cloud.billing.budgets.v1beta1.Filter
	(*CustomPeriod)(nil),             // 9: google.cloud.billing.budgets.v1beta1.CustomPeriod
	nil,                              // 10: google.cloud.billing.budgets.v1beta1.Filter.LabelsEntry
	(*money.Money)(nil),              // 11: google.type.Money
	(*date.Date)(nil),                // 12: google.type.Date
	(*structpb.ListValue)(nil),       // 13: google.protobuf.ListValue
}
var file_google_cloud_billing_budgets_v1beta1_budget_model_proto_depIdxs = []int32{
	8,  // 0: google.cloud.billing.budgets.v1beta1.Budget.budget_filter:type_name -> google.cloud.billing.budgets.v1beta1.Filter
	4,  // 1: google.cloud.billing.budgets.v1beta1.Budget.amount:type_name -> google.cloud.billing.budgets.v1beta1.BudgetAmount
	6,  // 2: google.cloud.billing.budgets.v1beta1.Budget.threshold_rules:type_name -> google.cloud.billing.budgets.v1beta1.ThresholdRule
	7,  // 3: google.cloud.billing.budgets.v1beta1.Budget.all_updates_rule:type_name -> google.cloud.billing.budgets.v1beta1.AllUpdatesRule
	11, // 4: google.cloud.billing.budgets.v1beta1.BudgetAmount.specified_amount:type_name -> google.type.Money
	5,  // 5: google.cloud.billing.budgets.v1beta1.BudgetAmount.last_period_amount:type_name -> google.cloud.billing.budgets.v1beta1.LastPeriodAmount
	1,  // 6: google.cloud.billing.budgets.v1beta1.ThresholdRule.spend_basis:type_name -> google.cloud.billing.budgets.v1beta1.ThresholdRule.Basis
	2,  // 7: google.cloud.billing.budgets.v1beta1.Filter.credit_types_treatment:type_name -> google.cloud.billing.budgets.v1beta1.Filter.CreditTypesTreatment
	10, // 8: google.cloud.billing.budgets.v1beta1.Filter.labels:type_name -> google.cloud.billing.budgets.v1beta1.Filter.LabelsEntry
	0,  // 9: google.cloud.billing.budgets.v1beta1.Filter.calendar_period:type_name -> google.cloud.billing.budgets.v1beta1.CalendarPeriod
	9,  // 10: google.cloud.billing.budgets.v1beta1.Filter.custom_period:type_name -> google.cloud.billing.budgets.v1beta1.CustomPeriod
	12, // 11: google.cloud.billing.budgets.v1beta1.CustomPeriod.start_date:type_name -> google.type.Date
	12, // 12: google.cloud.billing.budgets.v1beta1.CustomPeriod.end_date:type_name -> google.type.Date
	13, // 13: google.cloud.billing.budgets.v1beta1.Filter.LabelsEntry.value:type_name -> google.protobuf.ListValue
	14, // [14:14] is the sub-list for method output_type
	14, // [14:14] is the sub-list for method input_type
	14, // [14:14] is the sub-list for extension type_name
	14, // [14:14] is the sub-list for extension extendee
	0,  // [0:14] is the sub-list for field type_name
}

func init() { file_google_cloud_billing_budgets_v1beta1_budget_model_proto_init() }
func file_google_cloud_billing_budgets_v1beta1_budget_model_proto_init() {
	if File_google_cloud_billing_budgets_v1beta1_budget_model_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_billing_budgets_v1beta1_budget_model_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Budget); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_billing_budgets_v1beta1_budget_model_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BudgetAmount); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_billing_budgets_v1beta1_budget_model_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LastPeriodAmount); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_billing_budgets_v1beta1_budget_model_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ThresholdRule); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_billing_budgets_v1beta1_budget_model_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AllUpdatesRule); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_billing_budgets_v1beta1_budget_model_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Filter); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_billing_budgets_v1beta1_budget_model_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CustomPeriod); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_billing_budgets_v1beta1_budget_model_proto_msgTypes[1].OneofWrappers = []interface{}{
		(*BudgetAmount_SpecifiedAmount)(nil),
		(*BudgetAmount_LastPeriodAmount)(nil),
	}
	file_google_cloud_billing_budgets_v1beta1_budget_model_proto_msgTypes[5].OneofWrappers = []interface{}{
		(*Filter_CalendarPeriod)(nil),
		(*Filter_CustomPeriod)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_billing_budgets_v1beta1_budget_model_proto_rawDesc,
			NumEnums:      3,
			NumMessages:   8,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_billing_budgets_v1beta1_budget_model_proto_goTypes,
		DependencyIndexes: file_google_cloud_billing_budgets_v1beta1_budget_model_proto_depIdxs,
		EnumInfos:         file_google_cloud_billing_budgets_v1beta1_budget_model_proto_enumTypes,
		MessageInfos:      file_google_cloud_billing_budgets_v1beta1_budget_model_proto_msgTypes,
	}.Build()
	File_google_cloud_billing_budgets_v1beta1_budget_model_proto = out.File
	file_google_cloud_billing_budgets_v1beta1_budget_model_proto_rawDesc = nil
	file_google_cloud_billing_budgets_v1beta1_budget_model_proto_goTypes = nil
	file_google_cloud_billing_budgets_v1beta1_budget_model_proto_depIdxs = nil
}
