/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.swing.plugins.file;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.diylc.common.DrawOption;
import org.diylc.common.IPlugInPort;
import org.diylc.common.PropertyWrapper;
import org.diylc.core.IView;
import org.diylc.core.Project;
import org.diylc.presenter.Presenter;
import org.diylc.swingframework.IFileChooserAccessory;

public class ProjectPreview
extends JPanel
implements PropertyChangeListener,
IFileChooserAccessory {
    private static final long serialVersionUID = 1L;
    private IPlugInPort presenter;
    private XStream xStream;
    private Project emptyProject;
    private RenderComponent renderComponent;
    private JLabel nameLabel;

    public ProjectPreview() {
        this.setPreferredSize(new Dimension(140, 128));
        this.presenter = new Presenter(new IView(){

            @Override
            public int showConfirmDialog(String string, String string2, int n, int n2) {
                return 0;
            }

            @Override
            public void showMessage(String string, String string2, int n) {
            }

            @Override
            public File promptFileSave() {
                return null;
            }

            @Override
            public boolean editProperties(List<PropertyWrapper> list, Set<PropertyWrapper> set) {
                return false;
            }
        });
        this.xStream = new XStream((HierarchicalStreamDriver)new DomDriver());
        this.emptyProject = new Project();
        this.emptyProject.setTitle("");
        this.renderComponent = new RenderComponent();
        this.nameLabel = new JLabel();
        this.add(this.renderComponent);
        this.add(this.nameLabel);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        boolean bl = false;
        String string = propertyChangeEvent.getPropertyName();
        Project project = this.emptyProject;
        if ("directoryChanged".equals(string)) {
            bl = true;
        } else if ("SelectedFileChangedProperty".equals(string)) {
            File file = (File)propertyChangeEvent.getNewValue();
            try {
                FileInputStream fileInputStream = new FileInputStream(file);
                project = (Project)this.xStream.fromXML((InputStream)fileInputStream);
                fileInputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            bl = true;
        }
        this.nameLabel.setText(project.getTitle());
        this.presenter.loadProject(project, true);
        if (bl && this.renderComponent.isShowing()) {
            this.renderComponent.repaint();
        }
    }

    public void install(JFileChooser jFileChooser) {
        jFileChooser.setAccessory(this);
        jFileChooser.addPropertyChangeListener(this);
    }

    class RenderComponent
    extends JComponent {
        private static final long serialVersionUID = 1L;

        public RenderComponent() {
            this.setPreferredSize(new Dimension(128, 96));
        }

        @Override
        public void paint(Graphics graphics) {
            super.paint(graphics);
            Graphics2D graphics2D = (Graphics2D)graphics;
            Dimension dimension = ProjectPreview.this.presenter.getCanvasDimensions(false);
            Rectangle rectangle = this.getBounds();
            double d = dimension.getWidth() / dimension.getHeight();
            double d2 = rectangle.getWidth() / rectangle.getHeight();
            double d3 = d > d2 ? rectangle.getWidth() / dimension.getWidth() : rectangle.getHeight() / dimension.getHeight();
            graphics2D.scale(d3, d3);
            ProjectPreview.this.presenter.draw(graphics2D, EnumSet.noneOf(DrawOption.class), null);
            graphics2D.setColor(Color.black);
            graphics2D.drawRect(0, 0, dimension.width - (int)(1.0 / d3), dimension.height - (int)(1.0 / d3));
        }
    }
}

