// +build go1.9

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.

// This code was auto-generated by:
// github.com/Azure/azure-sdk-for-go/tools/profileBuilder

package catalog

import (
	"context"

	original "github.com/Azure/azure-sdk-for-go/services/datalake/analytics/2016-11-01-preview/catalog"
)

const (
	DefaultAdlaCatalogDNSSuffix = original.DefaultAdlaCatalogDNSSuffix
)

type ACLType = original.ACLType

const (
	Group    ACLType = original.Group
	GroupObj ACLType = original.GroupObj
	Other    ACLType = original.Other
	User     ACLType = original.User
	UserObj  ACLType = original.UserObj
)

type FileType = original.FileType

const (
	Assembly FileType = original.Assembly
	Nodeploy FileType = original.Nodeploy
	Resource FileType = original.Resource
)

type PermissionType = original.PermissionType

const (
	All    PermissionType = original.All
	Alter  PermissionType = original.Alter
	Create PermissionType = original.Create
	Drop   PermissionType = original.Drop
	None   PermissionType = original.None
	Use    PermissionType = original.Use
	Write  PermissionType = original.Write
)

type ACL = original.ACL
type ACLCreateOrUpdateParameters = original.ACLCreateOrUpdateParameters
type ACLDeleteParameters = original.ACLDeleteParameters
type ACLList = original.ACLList
type ACLListIterator = original.ACLListIterator
type ACLListPage = original.ACLListPage
type BaseClient = original.BaseClient
type Client = original.Client
type DataLakeAnalyticsCatalogCredentialCreateParameters = original.DataLakeAnalyticsCatalogCredentialCreateParameters
type DataLakeAnalyticsCatalogCredentialDeleteParameters = original.DataLakeAnalyticsCatalogCredentialDeleteParameters
type DataLakeAnalyticsCatalogCredentialUpdateParameters = original.DataLakeAnalyticsCatalogCredentialUpdateParameters
type DataLakeAnalyticsCatalogSecretCreateOrUpdateParameters = original.DataLakeAnalyticsCatalogSecretCreateOrUpdateParameters
type DdlName = original.DdlName
type EntityID = original.EntityID
type ExternalTable = original.ExternalTable
type Item = original.Item
type ItemList = original.ItemList
type TypeFieldInfo = original.TypeFieldInfo
type USQLAssembly = original.USQLAssembly
type USQLAssemblyClr = original.USQLAssemblyClr
type USQLAssemblyDependencyInfo = original.USQLAssemblyDependencyInfo
type USQLAssemblyFileInfo = original.USQLAssemblyFileInfo
type USQLAssemblyList = original.USQLAssemblyList
type USQLAssemblyListIterator = original.USQLAssemblyListIterator
type USQLAssemblyListPage = original.USQLAssemblyListPage
type USQLCredential = original.USQLCredential
type USQLCredentialList = original.USQLCredentialList
type USQLCredentialListIterator = original.USQLCredentialListIterator
type USQLCredentialListPage = original.USQLCredentialListPage
type USQLDatabase = original.USQLDatabase
type USQLDatabaseList = original.USQLDatabaseList
type USQLDatabaseListIterator = original.USQLDatabaseListIterator
type USQLDatabaseListPage = original.USQLDatabaseListPage
type USQLDirectedColumn = original.USQLDirectedColumn
type USQLDistributionInfo = original.USQLDistributionInfo
type USQLExternalDataSource = original.USQLExternalDataSource
type USQLExternalDataSourceList = original.USQLExternalDataSourceList
type USQLExternalDataSourceListIterator = original.USQLExternalDataSourceListIterator
type USQLExternalDataSourceListPage = original.USQLExternalDataSourceListPage
type USQLIndex = original.USQLIndex
type USQLPackage = original.USQLPackage
type USQLPackageList = original.USQLPackageList
type USQLPackageListIterator = original.USQLPackageListIterator
type USQLPackageListPage = original.USQLPackageListPage
type USQLProcedure = original.USQLProcedure
type USQLProcedureList = original.USQLProcedureList
type USQLProcedureListIterator = original.USQLProcedureListIterator
type USQLProcedureListPage = original.USQLProcedureListPage
type USQLSchema = original.USQLSchema
type USQLSchemaList = original.USQLSchemaList
type USQLSchemaListIterator = original.USQLSchemaListIterator
type USQLSchemaListPage = original.USQLSchemaListPage
type USQLSecret = original.USQLSecret
type USQLTable = original.USQLTable
type USQLTableColumn = original.USQLTableColumn
type USQLTableFragment = original.USQLTableFragment
type USQLTableFragmentList = original.USQLTableFragmentList
type USQLTableFragmentListIterator = original.USQLTableFragmentListIterator
type USQLTableFragmentListPage = original.USQLTableFragmentListPage
type USQLTableList = original.USQLTableList
type USQLTableListIterator = original.USQLTableListIterator
type USQLTableListPage = original.USQLTableListPage
type USQLTablePartition = original.USQLTablePartition
type USQLTablePartitionList = original.USQLTablePartitionList
type USQLTablePartitionListIterator = original.USQLTablePartitionListIterator
type USQLTablePartitionListPage = original.USQLTablePartitionListPage
type USQLTablePreview = original.USQLTablePreview
type USQLTableStatistics = original.USQLTableStatistics
type USQLTableStatisticsList = original.USQLTableStatisticsList
type USQLTableStatisticsListIterator = original.USQLTableStatisticsListIterator
type USQLTableStatisticsListPage = original.USQLTableStatisticsListPage
type USQLTableType = original.USQLTableType
type USQLTableTypeList = original.USQLTableTypeList
type USQLTableTypeListIterator = original.USQLTableTypeListIterator
type USQLTableTypeListPage = original.USQLTableTypeListPage
type USQLTableValuedFunction = original.USQLTableValuedFunction
type USQLTableValuedFunctionList = original.USQLTableValuedFunctionList
type USQLTableValuedFunctionListIterator = original.USQLTableValuedFunctionListIterator
type USQLTableValuedFunctionListPage = original.USQLTableValuedFunctionListPage
type USQLType = original.USQLType
type USQLTypeList = original.USQLTypeList
type USQLTypeListIterator = original.USQLTypeListIterator
type USQLTypeListPage = original.USQLTypeListPage
type USQLView = original.USQLView
type USQLViewList = original.USQLViewList
type USQLViewListIterator = original.USQLViewListIterator
type USQLViewListPage = original.USQLViewListPage

func New() BaseClient {
	return original.New()
}
func NewACLListIterator(page ACLListPage) ACLListIterator {
	return original.NewACLListIterator(page)
}
func NewACLListPage(cur ACLList, getNextPage func(context.Context, ACLList) (ACLList, error)) ACLListPage {
	return original.NewACLListPage(cur, getNextPage)
}
func NewClient() Client {
	return original.NewClient()
}
func NewUSQLAssemblyListIterator(page USQLAssemblyListPage) USQLAssemblyListIterator {
	return original.NewUSQLAssemblyListIterator(page)
}
func NewUSQLAssemblyListPage(cur USQLAssemblyList, getNextPage func(context.Context, USQLAssemblyList) (USQLAssemblyList, error)) USQLAssemblyListPage {
	return original.NewUSQLAssemblyListPage(cur, getNextPage)
}
func NewUSQLCredentialListIterator(page USQLCredentialListPage) USQLCredentialListIterator {
	return original.NewUSQLCredentialListIterator(page)
}
func NewUSQLCredentialListPage(cur USQLCredentialList, getNextPage func(context.Context, USQLCredentialList) (USQLCredentialList, error)) USQLCredentialListPage {
	return original.NewUSQLCredentialListPage(cur, getNextPage)
}
func NewUSQLDatabaseListIterator(page USQLDatabaseListPage) USQLDatabaseListIterator {
	return original.NewUSQLDatabaseListIterator(page)
}
func NewUSQLDatabaseListPage(cur USQLDatabaseList, getNextPage func(context.Context, USQLDatabaseList) (USQLDatabaseList, error)) USQLDatabaseListPage {
	return original.NewUSQLDatabaseListPage(cur, getNextPage)
}
func NewUSQLExternalDataSourceListIterator(page USQLExternalDataSourceListPage) USQLExternalDataSourceListIterator {
	return original.NewUSQLExternalDataSourceListIterator(page)
}
func NewUSQLExternalDataSourceListPage(cur USQLExternalDataSourceList, getNextPage func(context.Context, USQLExternalDataSourceList) (USQLExternalDataSourceList, error)) USQLExternalDataSourceListPage {
	return original.NewUSQLExternalDataSourceListPage(cur, getNextPage)
}
func NewUSQLPackageListIterator(page USQLPackageListPage) USQLPackageListIterator {
	return original.NewUSQLPackageListIterator(page)
}
func NewUSQLPackageListPage(cur USQLPackageList, getNextPage func(context.Context, USQLPackageList) (USQLPackageList, error)) USQLPackageListPage {
	return original.NewUSQLPackageListPage(cur, getNextPage)
}
func NewUSQLProcedureListIterator(page USQLProcedureListPage) USQLProcedureListIterator {
	return original.NewUSQLProcedureListIterator(page)
}
func NewUSQLProcedureListPage(cur USQLProcedureList, getNextPage func(context.Context, USQLProcedureList) (USQLProcedureList, error)) USQLProcedureListPage {
	return original.NewUSQLProcedureListPage(cur, getNextPage)
}
func NewUSQLSchemaListIterator(page USQLSchemaListPage) USQLSchemaListIterator {
	return original.NewUSQLSchemaListIterator(page)
}
func NewUSQLSchemaListPage(cur USQLSchemaList, getNextPage func(context.Context, USQLSchemaList) (USQLSchemaList, error)) USQLSchemaListPage {
	return original.NewUSQLSchemaListPage(cur, getNextPage)
}
func NewUSQLTableFragmentListIterator(page USQLTableFragmentListPage) USQLTableFragmentListIterator {
	return original.NewUSQLTableFragmentListIterator(page)
}
func NewUSQLTableFragmentListPage(cur USQLTableFragmentList, getNextPage func(context.Context, USQLTableFragmentList) (USQLTableFragmentList, error)) USQLTableFragmentListPage {
	return original.NewUSQLTableFragmentListPage(cur, getNextPage)
}
func NewUSQLTableListIterator(page USQLTableListPage) USQLTableListIterator {
	return original.NewUSQLTableListIterator(page)
}
func NewUSQLTableListPage(cur USQLTableList, getNextPage func(context.Context, USQLTableList) (USQLTableList, error)) USQLTableListPage {
	return original.NewUSQLTableListPage(cur, getNextPage)
}
func NewUSQLTablePartitionListIterator(page USQLTablePartitionListPage) USQLTablePartitionListIterator {
	return original.NewUSQLTablePartitionListIterator(page)
}
func NewUSQLTablePartitionListPage(cur USQLTablePartitionList, getNextPage func(context.Context, USQLTablePartitionList) (USQLTablePartitionList, error)) USQLTablePartitionListPage {
	return original.NewUSQLTablePartitionListPage(cur, getNextPage)
}
func NewUSQLTableStatisticsListIterator(page USQLTableStatisticsListPage) USQLTableStatisticsListIterator {
	return original.NewUSQLTableStatisticsListIterator(page)
}
func NewUSQLTableStatisticsListPage(cur USQLTableStatisticsList, getNextPage func(context.Context, USQLTableStatisticsList) (USQLTableStatisticsList, error)) USQLTableStatisticsListPage {
	return original.NewUSQLTableStatisticsListPage(cur, getNextPage)
}
func NewUSQLTableTypeListIterator(page USQLTableTypeListPage) USQLTableTypeListIterator {
	return original.NewUSQLTableTypeListIterator(page)
}
func NewUSQLTableTypeListPage(cur USQLTableTypeList, getNextPage func(context.Context, USQLTableTypeList) (USQLTableTypeList, error)) USQLTableTypeListPage {
	return original.NewUSQLTableTypeListPage(cur, getNextPage)
}
func NewUSQLTableValuedFunctionListIterator(page USQLTableValuedFunctionListPage) USQLTableValuedFunctionListIterator {
	return original.NewUSQLTableValuedFunctionListIterator(page)
}
func NewUSQLTableValuedFunctionListPage(cur USQLTableValuedFunctionList, getNextPage func(context.Context, USQLTableValuedFunctionList) (USQLTableValuedFunctionList, error)) USQLTableValuedFunctionListPage {
	return original.NewUSQLTableValuedFunctionListPage(cur, getNextPage)
}
func NewUSQLTypeListIterator(page USQLTypeListPage) USQLTypeListIterator {
	return original.NewUSQLTypeListIterator(page)
}
func NewUSQLTypeListPage(cur USQLTypeList, getNextPage func(context.Context, USQLTypeList) (USQLTypeList, error)) USQLTypeListPage {
	return original.NewUSQLTypeListPage(cur, getNextPage)
}
func NewUSQLViewListIterator(page USQLViewListPage) USQLViewListIterator {
	return original.NewUSQLViewListIterator(page)
}
func NewUSQLViewListPage(cur USQLViewList, getNextPage func(context.Context, USQLViewList) (USQLViewList, error)) USQLViewListPage {
	return original.NewUSQLViewListPage(cur, getNextPage)
}
func NewWithoutDefaults(adlaCatalogDNSSuffix string) BaseClient {
	return original.NewWithoutDefaults(adlaCatalogDNSSuffix)
}
func PossibleACLTypeValues() []ACLType {
	return original.PossibleACLTypeValues()
}
func PossibleFileTypeValues() []FileType {
	return original.PossibleFileTypeValues()
}
func PossiblePermissionTypeValues() []PermissionType {
	return original.PossiblePermissionTypeValues()
}
func UserAgent() string {
	return original.UserAgent() + " profiles/preview"
}
func Version() string {
	return original.Version()
}
