package notificationhubs

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// AccessRights enumerates the values for access rights.
type AccessRights string

const (
	// AccessRightsListen ...
	AccessRightsListen AccessRights = "Listen"
	// AccessRightsManage ...
	AccessRightsManage AccessRights = "Manage"
	// AccessRightsSend ...
	AccessRightsSend AccessRights = "Send"
)

// PossibleAccessRightsValues returns an array of possible values for the AccessRights const type.
func PossibleAccessRightsValues() []AccessRights {
	return []AccessRights{AccessRightsListen, AccessRightsManage, AccessRightsSend}
}

// NamespaceType enumerates the values for namespace type.
type NamespaceType string

const (
	// NamespaceTypeMessaging ...
	NamespaceTypeMessaging NamespaceType = "Messaging"
	// NamespaceTypeNotificationHub ...
	NamespaceTypeNotificationHub NamespaceType = "NotificationHub"
)

// PossibleNamespaceTypeValues returns an array of possible values for the NamespaceType const type.
func PossibleNamespaceTypeValues() []NamespaceType {
	return []NamespaceType{NamespaceTypeMessaging, NamespaceTypeNotificationHub}
}

// SkuName enumerates the values for sku name.
type SkuName string

const (
	// SkuNameBasic ...
	SkuNameBasic SkuName = "Basic"
	// SkuNameFree ...
	SkuNameFree SkuName = "Free"
	// SkuNameStandard ...
	SkuNameStandard SkuName = "Standard"
)

// PossibleSkuNameValues returns an array of possible values for the SkuName const type.
func PossibleSkuNameValues() []SkuName {
	return []SkuName{SkuNameBasic, SkuNameFree, SkuNameStandard}
}
