package alidns

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribePdnsThreatStatistic invokes the alidns.DescribePdnsThreatStatistic API synchronously
func (client *Client) DescribePdnsThreatStatistic(request *DescribePdnsThreatStatisticRequest) (response *DescribePdnsThreatStatisticResponse, err error) {
	response = CreateDescribePdnsThreatStatisticResponse()
	err = client.DoAction(request, response)
	return
}

// DescribePdnsThreatStatisticWithChan invokes the alidns.DescribePdnsThreatStatistic API asynchronously
func (client *Client) DescribePdnsThreatStatisticWithChan(request *DescribePdnsThreatStatisticRequest) (<-chan *DescribePdnsThreatStatisticResponse, <-chan error) {
	responseChan := make(chan *DescribePdnsThreatStatisticResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribePdnsThreatStatistic(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribePdnsThreatStatisticWithCallback invokes the alidns.DescribePdnsThreatStatistic API asynchronously
func (client *Client) DescribePdnsThreatStatisticWithCallback(request *DescribePdnsThreatStatisticRequest, callback func(response *DescribePdnsThreatStatisticResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribePdnsThreatStatisticResponse
		var err error
		defer close(result)
		response, err = client.DescribePdnsThreatStatistic(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribePdnsThreatStatisticRequest is the request struct for api DescribePdnsThreatStatistic
type DescribePdnsThreatStatisticRequest struct {
	*requests.RpcRequest
	ThreatSourceIp string `position:"Query" name:"ThreatSourceIp"`
	Type           string `position:"Query" name:"Type"`
	StartDate      string `position:"Query" name:"StartDate"`
	EndDate        string `position:"Query" name:"EndDate"`
	Lang           string `position:"Query" name:"Lang"`
}

// DescribePdnsThreatStatisticResponse is the response struct for api DescribePdnsThreatStatistic
type DescribePdnsThreatStatisticResponse struct {
	*responses.BaseResponse
	RequestId string          `json:"RequestId" xml:"RequestId"`
	Data      []StatisticItem `json:"Data" xml:"Data"`
}

// CreateDescribePdnsThreatStatisticRequest creates a request to invoke DescribePdnsThreatStatistic API
func CreateDescribePdnsThreatStatisticRequest() (request *DescribePdnsThreatStatisticRequest) {
	request = &DescribePdnsThreatStatisticRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Alidns", "2015-01-09", "DescribePdnsThreatStatistic", "alidns", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribePdnsThreatStatisticResponse creates a response to parse from DescribePdnsThreatStatistic response
func CreateDescribePdnsThreatStatisticResponse() (response *DescribePdnsThreatStatisticResponse) {
	response = &DescribePdnsThreatStatisticResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
